/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import paraselene.HTMLPart;
import paraselene.Page;
import paraselene.Text;
import paraselene.tag.Attribute;
import paraselene.tag.AttributeValuable;

public class Tag
extends HTMLPart {
    private static final long serialVersionUID = 2L;
    private String name;
    protected HashMap<String, Attribute> attr = new HashMap();
    private ArrayList<HTMLPart> doc = new ArrayList();
    private ArrayList<Tag> tag_only = new ArrayList();
    private Tag parent = null;
    private boolean nest_f = false;
    private boolean visible_f = true;
    private static String VALUE = "value";
    private static final String[] plain_tag = new String[]{"code", "comment", "plaintext", "xmp", "script", "style", "listing"};
    private static HashMap<String, String> plain_map = new HashMap();
    private static volatile short tag_id;
    private static final String PARASELENE_ID = "paraselene$id$";

    public Tag getOuterTag() {
        return this.parent;
    }

    private synchronized Tag[] getOverUnder() {
        Tag[] ret = new Tag[]{null, null};
        if (this.parent == null) {
            return ret;
        }
        int cnt = this.parent.tag_only.size();
        for (int i = 0; i < cnt; ++i) {
            if (this.parent.tag_only.get(i) != this) continue;
            if (i > 0) {
                ret[0] = this.parent.tag_only.get(i - 1);
            }
            if (i >= cnt - 1) break;
            ret[1] = this.parent.tag_only.get(i + 1);
            break;
        }
        return ret;
    }

    public Tag getOverTag() {
        return this.getOverUnder()[0];
    }

    public Tag getUnderTag() {
        return this.getOverUnder()[1];
    }

    protected Tag() {
    }

    public static boolean isPlainTag(String name) {
        return plain_map.get(name.toLowerCase(Locale.ENGLISH)) != null;
    }

    public boolean isSimpleTag() {
        return !this.nest_f;
    }

    public boolean isVisible() {
        return this.visible_f;
    }

    public void setVisible(boolean flag) {
        this.visible_f = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeID() {
        if (this.getAttribute("id") != null) {
            return;
        }
        long now = 0L;
        String string = VALUE;
        synchronized (string) {
            now = tag_id;
            tag_id = (short)(tag_id + 1);
        }
        long time = now << 56 | new Date().getTime() & 0xFFFFFFFFFFFFFFL;
        StringBuilder buf = new StringBuilder(PARASELENE_ID);
        buf = buf.append(Long.toString(time, 36));
        this.setAttribute(new Attribute("id", buf.toString()));
    }

    public Tag(String n, boolean simple_f) {
        this.name = n.toLowerCase(Locale.ENGLISH);
        boolean bl = this.nest_f = !simple_f;
        if ("body".equals(this.name)) {
            this.makeID();
        }
    }

    public String getNameAttribute() {
        try {
            Attribute n = this.getAttribute("name");
            if (n == null) {
                return null;
            }
            AttributeValuable t = n.get();
            if (t == null) {
                return null;
            }
            return t.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute[] getAllAttribute() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        Tag tag = this;
        synchronized (tag) {
            for (String k : this.attr.keySet()) {
                list.add(this.attr.get(k));
            }
        }
        return list.toArray(new Attribute[0]);
    }

    @Override
    public synchronized HTMLPart getReplica() {
        Tag tag = this.newReplica();
        tag.visible_f = this.visible_f;
        for (String k : this.attr.keySet()) {
            tag.setAttribute(this.attr.get(k).getReplica());
        }
        int size = this.doc.size();
        for (int i = 0; i < size; ++i) {
            tag.addHTMLPart(this.doc.get(i).getReplica());
        }
        return tag;
    }

    protected Tag newReplica() {
        return new Tag(this.name, !this.nest_f);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(Attribute at) {
        Tag out;
        Object val;
        String at_name = at.getName();
        if ("id".equals(at_name) && this.getAttribute("id") != null && (val = at.getString()) != null && ((String)val).indexOf(PARASELENE_ID) == 0) {
            return;
        }
        val = this;
        synchronized (val) {
            this.attr.put(at.getName(), at);
        }
        if ("name".equals(at_name) && (out = this.getOuterTag()) != null) {
            out.makeID();
        }
    }

    public void setAttribute(Attribute ... at) {
        for (int i = 0; i < at.length; ++i) {
            this.setAttribute(at[i]);
        }
    }

    public synchronized void removeAttribute(String at_name) {
        this.attr.remove(at_name.toLowerCase(Locale.ENGLISH));
    }

    public synchronized Attribute getAttribute(String at_name) {
        return this.attr.get(at_name.toLowerCase(Locale.ENGLISH));
    }

    public void addHTMLPart(HTMLPart d) {
        this.addHTMLPart(this.doc.size(), d);
    }

    public synchronized void addHTMLPart(int idx, HTMLPart d) {
        this.doc.add(idx, d);
        if (d instanceof Tag) {
            HTMLPart p;
            Tag tag = (Tag)d;
            if (this.embed != null) {
                this.embed.nameTag((Tag)d);
            }
            int cnt = this.doc.size();
            idx = 0;
            for (int i = 0; i < cnt && (p = this.doc.get(i)) != d; ++i) {
                if (!(p instanceof Tag)) continue;
                ++idx;
            }
            this.tag_only.add(idx, tag);
            tag.parent = this;
            if (tag.getAttribute("name") != null) {
                this.makeID();
            }
        } else {
            d.setPage(this.embed);
        }
    }

    public void addHTMLPart(HTMLPart ... d) {
        for (int i = 0; i < d.length; ++i) {
            this.addHTMLPart(d[i]);
        }
    }

    public void addHTMLPart(int idx, HTMLPart ... d) {
        for (int i = 0; i < d.length; ++i) {
            this.addHTMLPart(idx + i, d[i]);
        }
    }

    public synchronized void include(Tag tag) {
        if (tag == null) {
            return;
        }
        int cnt = tag.getHTMLPartCount();
        for (int i = 0; i < cnt; ++i) {
            this.addHTMLPart(tag.getHTMLPart(i));
        }
    }

    public synchronized void include(Page page) {
        Tag tag = page.getFirstTagByType("body");
        if (tag == null) {
            return;
        }
        this.include(tag);
    }

    public synchronized HTMLPart getHTMLPart(int idx) {
        return this.doc.get(idx);
    }

    public synchronized int getHTMLPartCount() {
        return this.doc.size();
    }

    public synchronized void removeHTMLPart(int idx) {
        HTMLPart p = this.doc.remove(idx);
        if (p == null) {
            return;
        }
        this.removeHTMLPart(p);
    }

    public synchronized void removeHTMLPart(HTMLPart part) {
        if (part == null) {
            return;
        }
        if (part instanceof Tag) {
            Tag tag = (Tag)part;
            this.tag_only.remove(tag);
            tag.parent = null;
            if (this.embed != null) {
                this.embed.removeNameEntry(tag);
            }
        } else {
            part.setPage(null);
        }
        this.doc.remove(part);
    }

    public synchronized void removeHTMLPart() {
        int cnt = this.doc.size();
        --cnt;
        while (cnt >= 0) {
            this.removeHTMLPart(cnt);
            --cnt;
        }
    }

    public synchronized void exclude(Tag tag) {
        int idx = this.indexOf(tag);
        this.removeHTMLPart(tag);
        int cnt = tag.getHTMLPartCount();
        for (int i = cnt - 1; i >= 0; --i) {
            this.addHTMLPart(idx, tag.getHTMLPart(i));
        }
    }

    public synchronized int indexOf(HTMLPart part) {
        if (part == null) {
            return -1;
        }
        return this.doc.indexOf(part);
    }

    protected synchronized String getFirstTag() {
        boolean xml = false;
        if (this.embed != null) {
            xml = this.embed.isXML();
        }
        StringBuilder buf = new StringBuilder("<");
        buf = buf.append(this.getName());
        for (String k : this.attr.keySet()) {
            buf = buf.append(" ");
            buf = buf.append(this.attr.get(k).toHtmlString(xml));
        }
        if (xml && this.isSimpleTag()) {
            buf = buf.append(" /");
        }
        buf = buf.append(">");
        return buf.toString();
    }

    protected String getLastTag() {
        StringBuilder buf = new StringBuilder("</");
        buf = buf.append(this.name);
        buf = buf.append(">");
        return buf.toString();
    }

    public static HTMLPart.StringMode selectMode(String tag_name) {
        tag_name = tag_name.toLowerCase(Locale.ENGLISH);
        HTMLPart.StringMode mode = HTMLPart.StringMode.BODY;
        if ("textarea".equals(tag_name) || "pre".equals(tag_name)) {
            mode = HTMLPart.StringMode.TEXTAREA;
        } else if (Tag.isPlainTag(tag_name)) {
            mode = HTMLPart.StringMode.PLAIN;
        }
        return mode;
    }

    private HTMLPart.StringMode selectMode() {
        return Tag.selectMode(this.name);
    }

    private synchronized String getHTMLParts(HTMLPart.StringMode mode) {
        int cnt = this.getHTMLPartCount();
        StringBuilder buf = new StringBuilder();
        if (mode != HTMLPart.StringMode.TEXTAREA) {
            mode = this.selectMode();
        }
        for (int i = 0; i < cnt; ++i) {
            buf = buf.append(this.getHTMLPart(i).toString(mode));
        }
        return buf.toString();
    }

    @Override
    public String toString(HTMLPart.StringMode mode) {
        if (!this.visible_f) {
            return "";
        }
        StringBuilder buf = new StringBuilder("\n");
        buf = buf.append(this.getFirstTag());
        buf = buf.append(this.getHTMLParts(mode));
        if (this.nest_f) {
            buf = buf.append(this.getLastTag());
        }
        return buf.toString();
    }

    @Override
    public void write(PrintWriter w, HTMLPart.StringMode mode) {
        if (!this.visible_f) {
            return;
        }
        w.print(this.getFirstTag());
        int cnt = this.getHTMLPartCount();
        if (mode != HTMLPart.StringMode.TEXTAREA) {
            mode = this.selectMode();
        }
        for (int i = 0; i < cnt; ++i) {
            this.getHTMLPart(i).write(w, mode);
        }
        if (this.nest_f) {
            w.print(this.getLastTag());
        }
    }

    protected String getValueAttribute() {
        Attribute attr = this.getAttribute(VALUE);
        if (attr == null) {
            return null;
        }
        AttributeValuable text = attr.get();
        if (text == null) {
            return null;
        }
        return text.toString(HTMLPart.StringMode.PLAIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValueString() {
        if (this.nest_f) {
            Tag tag = this;
            synchronized (tag) {
                int cnt = this.getHTMLPartCount();
                for (int i = 0; i < cnt; ++i) {
                    HTMLPart pt = this.getHTMLPart(i);
                    if (!(pt instanceof Text)) continue;
                    return ((Text)pt).toString(HTMLPart.StringMode.PLAIN);
                }
            }
            return null;
        }
        return this.getValueAttribute();
    }

    protected void setValueAttribute(String v) {
        Attribute attr = this.getAttribute(VALUE);
        if (attr == null) {
            try {
                this.setAttribute(new Attribute(VALUE, v));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        attr.set(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueString(String v) {
        if (this.nest_f) {
            Tag tag = this;
            synchronized (tag) {
                int cnt = this.getHTMLPartCount();
                for (int i = 0; i < cnt; ++i) {
                    HTMLPart pt = this.getHTMLPart(i);
                    if (!(pt instanceof Text)) continue;
                    ((Text)pt).setText(v, HTMLPart.StringMode.PLAIN);
                    return;
                }
                this.addHTMLPart((HTMLPart)new Text(v));
            }
            return;
        }
        this.setValueAttribute(v);
    }

    public boolean isEmptyValue() {
        String str = this.getValueString();
        if (str == null) {
            return true;
        }
        return str.isEmpty();
    }

    public synchronized Tag[] getTagArray() {
        return this.tag_only.toArray(new Tag[0]);
    }

    public Tag[] getAllTagByClass(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        ArrayList<Tag> list = new ArrayList<Tag>();
        Tag[] crt = this.getTagArray();
        for (int i = 0; i < crt.length; ++i) {
            Tag[] sub = crt[i].getAllTagByClass(cls);
            for (int j = 0; j < sub.length; ++j) {
                list.add(sub[j]);
            }
            if (!cls.isAssignableFrom(crt[i].getClass())) continue;
            list.add(crt[i]);
        }
        return list.toArray(new Tag[0]);
    }

    public Tag[] getAllTagByType(String name) {
        if (name == null) {
            return null;
        }
        name = name.toLowerCase(Locale.ENGLISH);
        ArrayList<Tag> list = new ArrayList<Tag>();
        Tag[] crt = this.getTagArray();
        for (int i = 0; i < crt.length; ++i) {
            Tag[] sub = crt[i].getAllTagByType(name);
            for (int j = 0; j < sub.length; ++j) {
                list.add(sub[j]);
            }
            if (!name.equals(crt[i].getName())) continue;
            list.add(crt[i]);
        }
        return list.toArray(new Tag[0]);
    }

    public Tag getFirstTagByType(String name) {
        if (name == null) {
            return null;
        }
        name = name.toLowerCase(Locale.ENGLISH);
        Tag[] crt = this.getTagArray();
        for (int i = 0; i < crt.length; ++i) {
            if (name.equals(crt[i].getName())) {
                return crt[i];
            }
            Tag sub = crt[i].getFirstTagByType(name);
            if (sub == null) continue;
            return sub;
        }
        return null;
    }

    public boolean isInner(HTMLPart target) {
        return this.getDirectInnerTag(target) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag getDirectInnerTag(HTMLPart target) {
        if (this == target) {
            return null;
        }
        if (target instanceof Tag) {
            return ((Tag)target).getOuterTag();
        }
        Tag tag = this;
        synchronized (tag) {
            int cnt = this.doc.size();
            for (int i = 0; i < cnt; ++i) {
                Tag tag2;
                HTMLPart part = this.doc.get(i);
                if (part == target) {
                    return this;
                }
                if (!(part instanceof Tag) || (tag2 = ((Tag)part).getDirectInnerTag(target)) == null) continue;
                return tag2;
            }
        }
        return null;
    }

    public boolean isContain(Tag[] tag) {
        if (tag == null) {
            return false;
        }
        for (int i = 0; i < tag.length; ++i) {
            if (this != tag[i]) continue;
            return true;
        }
        return false;
    }

    protected Text makeText(String str) {
        return new Text(str);
    }

    public synchronized void replaceBR() {
        HTMLPart p;
        int i;
        int cnt = this.getHTMLPartCount();
        for (i = 0; i < cnt; ++i) {
            Tag tag;
            p = this.getHTMLPart(i);
            if (!(p instanceof Tag) || !"br".equals((tag = (Tag)p).getName()) || tag.getAllAttribute().length > 0) continue;
            this.removeHTMLPart(i);
            this.addHTMLPart(i, (HTMLPart)this.makeText("\n"));
        }
        for (i = cnt - 1; i > 0; --i) {
            HTMLPart p2;
            p = this.getHTMLPart(i);
            if (!(p instanceof Text) || !((p2 = this.getHTMLPart(i - 1)) instanceof Text)) continue;
            Text next = (Text)p;
            Text pre = (Text)p2;
            pre.append(next);
            this.removeHTMLPart(i);
        }
    }

    @Override
    public synchronized void setPage(Page p) {
        super.setPage(p);
        Attribute[] attr = this.getAllAttribute();
        for (int i = 0; i < attr.length; ++i) {
            attr[i].setPage(p);
        }
    }

    static {
        for (int i = 0; i < plain_tag.length; ++i) {
            plain_map.put(plain_tag[i], plain_tag[i]);
        }
    }
}

