/*
 * Decompiled with CFR 0.152.
 */
package paraselene.css;

import java.util.ArrayList;
import java.util.HashMap;
import paraselene.HTMLPart;
import paraselene.Valuable;
import paraselene.css.Property;
import paraselene.css.Selector;
import paraselene.tag.AttributeValuable;
import paraselene.tag.Tag;

public class Style
extends HTMLPart
implements AttributeValuable {
    private static final long serialVersionUID = 2L;
    private ArrayList<Selector> selector = new ArrayList();
    private ArrayList<Property> prop = new ArrayList();
    private HashMap<String, Property> map = new HashMap();

    private Style() {
    }

    public Style(Property ... p) {
        this.setProperty(p);
    }

    @Override
    public void setAssignedTag(Tag t) {
        super.setAssignedTag(t);
        if (this.prop == null) {
            return;
        }
        int cnt = this.prop.size();
        for (int i = 0; i < cnt; ++i) {
            this.prop.get(i).setAssignedTag(t);
        }
    }

    @Override
    public HTMLPart getReplica() {
        return (HTMLPart)((Object)this.getValuableReplica());
    }

    @Override
    public Valuable getValuableReplica() {
        int cnt = this.prop.size();
        Property[] p = new Property[cnt];
        for (int i = 0; i < cnt; ++i) {
            p[i] = this.prop.get(i).getReplica();
        }
        Style style = new Style(p);
        cnt = this.selector.size();
        Selector[] s = new Selector[cnt];
        for (int i = 0; i < cnt; ++i) {
            s[i] = this.selector.get(i).getReplica();
        }
        style.setSelector(s);
        return style;
    }

    public void setSelector(Selector ... s) {
        for (int i = 0; i < s.length; ++i) {
            this.selector.add(s[i]);
        }
        this.getAssignedTag().setModify();
    }

    public void setProperty(Property ... p) {
        for (int i = 0; i < p.length; ++i) {
            this.prop.add(p[i]);
            this.prop.remove(this.map.put(p[i].getName(), p[i]));
        }
        this.getAssignedTag().setModify();
    }

    public void removeProperty(String name) {
        this.prop.remove(this.map.remove(name));
        this.getAssignedTag().setModify();
    }

    public Property getProperty(String name) {
        return this.map.get(name);
    }

    public Property[] getAllProperty() {
        return this.prop.toArray(new Property[0]);
    }

    @Override
    public String toString(HTMLPart.StringMode mode) {
        int i;
        int cnt;
        StringBuilder buf = new StringBuilder();
        if (mode != HTMLPart.StringMode.ATTRIBUTE) {
            cnt = this.selector.size();
            for (i = 0; i < cnt; ++i) {
                buf = buf.append(this.selector.get(i).toString());
            }
            buf = buf.append('{');
        }
        cnt = this.prop.size();
        for (i = 0; i < cnt; ++i) {
            buf = buf.append(this.prop.get(i).toString());
        }
        if (mode != HTMLPart.StringMode.ATTRIBUTE) {
            buf = buf.append('}');
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        return this.toString(HTMLPart.StringMode.PLAIN);
    }
}

