/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;

/**
 * サーバー情報。
 */
public class PageServerInformation implements ServerInformation {
	private String	server;
	private String	context;
	private TransactionSequencer	seq;
	private boolean	search_flag;
	private HistorySet	hist;
	private PageFactory	fact;

	PageServerInformation( DataHolder holder ) {
		server = holder.getServerName();
		context = holder.getContextPath();
		seq = getTransactionSequencer();
		search_flag = holder.isSearchEngine();
		hist = holder.getHistorySet();
		fact = holder.getPageFactory();
	}

	public String getServerName() { return server; }
	public String getContextPath() { return context; }
	public TransactionSequencer getTransactionSequencer() { return seq; }
	public boolean isSearchEngine() { return search_flag; }
	public HistorySet getHistorySet() { return hist; }
	public PageFactory getPageFactory() { return fact; }
}

