/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.table;

import java.util.ArrayList;
import paraselene.HTMLPart;
import paraselene.tag.Tag;
import paraselene.tag.table.Column;
import paraselene.tag.table.Line;

public class Table
extends Tag {
    private static final long serialVersionUID = 2L;
    static final String COLSPAN = "colspan";
    static final String TR = "tr";
    private boolean tabe_dirty_f = true;
    private int map_x;
    private int map_y;
    private Column[][] map = null;

    private int seekFree(Column[] dim, int start, int y) throws TableException {
        while (true) {
            if (start >= dim.length) {
                throw new TableException(String.format("%d\u884c\u304c\u4e0d\u6b63", y));
            }
            if (this.map[y][start] == null) {
                return start;
            }
            ++start;
        }
    }

    private void makeMap() throws TableException {
        int i;
        if (!this.tabe_dirty_f) {
            return;
        }
        this.tabe_dirty_f = false;
        Line[] line = this.getLineArray();
        int xsize = 0;
        for (i = 0; i < line.length; ++i) {
            int cnt = line[i].getColumnRowCount();
            if (cnt <= xsize) continue;
            xsize = cnt;
        }
        this.map = new Column[line.length][];
        for (i = 0; i < line.length; ++i) {
            this.map[i] = new Column[xsize];
        }
        for (i = 0; i < line.length; ++i) {
            Column[] clm = line[i].getColumnArray();
            int x = 0;
            for (int j = 0; j < clm.length; ++j) {
                int col = clm[j].getColspan();
                int row = clm[j].getRowspan();
                for (int x_cnt = 0; x_cnt < col; ++x_cnt) {
                    x = this.seekFree(this.map[i], x, i);
                    this.map[i][x] = clm[j];
                    ++x;
                }
                for (int y_cnt = 1; y_cnt < row; ++y_cnt) {
                    int sub_x = 0;
                    for (int x_cnt = 0; x_cnt < col; ++x_cnt) {
                        sub_x = this.seekFree(this.map[i + y_cnt], sub_x, i + y_cnt);
                        this.map[i + y_cnt][sub_x] = clm[j];
                        ++sub_x;
                    }
                }
            }
        }
        this.map_x = xsize;
        this.map_y = line.length;
        for (i = 0; i < this.map_y; ++i) {
            for (int j = 0; j < this.map_x; ++j) {
                if (this.map[i][j] != null) continue;
                throw new TableException(String.format("\u4e0d\u6b63\u306a\u884c\u3042\u308a[%d,%d]=null", j, i));
            }
        }
    }

    public int getXsize() throws TableException {
        this.makeMap();
        return this.map_x;
    }

    public int getYsize() throws TableException {
        this.makeMap();
        return this.map_y;
    }

    public boolean isJoinedColumn(int x, int y) throws TableException {
        Column clm = this.getColumn(x, y);
        if (x > 0 && this.getColumn(x - 1, y) == clm) {
            return true;
        }
        return y > 0 && this.getColumn(x, y - 1) == clm;
    }

    public Column getColumn(int x, int y) throws TableException {
        this.makeMap();
        if (x < 0 || y < 0 || x >= this.map_x || y >= this.map_y) {
            throw new TableException(String.format("x=%d, y=%d \u756a\u53f7\u304c\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002", x, y));
        }
        return this.map[y][x];
    }

    public HTMLPart[] getInnerHTMLPart(int y, HTMLPart[] d) throws TableException {
        this.makeMap();
        ArrayList<HTMLPart> list = new ArrayList<HTMLPart>();
        if (y < 0 || y >= this.map_y) {
            throw new TableException(String.format("y=%d \u756a\u53f7\u304c\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002", y));
        }
        for (int x = 0; x < this.map_x; ++x) {
            HTMLPart[] hit = this.getColumn(x, y).getInnerHTMLPart(d);
            for (int i = 0; i < hit.length; ++i) {
                if (list.contains(hit[i])) continue;
                list.add(hit[i]);
            }
        }
        return list.toArray(new HTMLPart[0]);
    }

    public HTMLPart getFirstInnerHTMLPart(int y, HTMLPart[] d) throws TableException {
        this.makeMap();
        if (y < 0 || y >= this.map_y) {
            throw new TableException(String.format("y=%d \u756a\u53f7\u304c\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002", y));
        }
        for (int x = 0; x < this.map_x; ++x) {
            HTMLPart hit = this.getColumn(x, y).getFirstInnerHTMLPart(d);
            if (hit == null) continue;
            return hit;
        }
        return null;
    }

    public void joinColumn(int x, int y, int xsize, int ysize) throws TableException {
        Column clm;
        this.makeMap();
        if (xsize < 1) {
            xsize = 1;
        }
        if (ysize < 1) {
            ysize = 1;
        }
        int max_xsize = this.map_x - x;
        int max_ysize = this.map_y - y;
        if (xsize > max_xsize) {
            xsize = max_xsize;
        }
        if (ysize > max_ysize) {
            ysize = max_ysize;
        }
        if (xsize == (clm = this.getColumn(x, y)).getColspan() && ysize == clm.getRowspan()) {
            return;
        }
        boolean flag = false;
        for (int chk_y = 0; chk_y < this.map_y; ++chk_y) {
            for (int chk_x = 0; chk_x < this.map_x; ++chk_x) {
                if (this.map[chk_y][chk_x] != clm) continue;
                x = chk_x;
                y = chk_y;
                flag = true;
                break;
            }
            if (flag) break;
        }
        clm = this.getColumn(x, y);
        int org_x = clm.getColspan();
        clm.setColspan(xsize);
        int org_y = clm.getRowspan();
        clm.setRowspan(ysize);
        int all_x = org_x;
        int all_y = org_y;
        if (all_x < xsize) {
            all_x = xsize;
        }
        all_x += x;
        if (all_y < ysize) {
            all_y = ysize;
        }
        all_y += y;
        int xx = x + xsize - 1;
        int yy = y + ysize - 1;
        Line[] l = this.getLineArray();
        for (int ycnt = y; ycnt < all_y; ++ycnt) {
            for (int xcnt = x; xcnt < all_x; ++xcnt) {
                if (ycnt > yy && this.map[ycnt][xcnt] == clm || xcnt > xx && this.map[ycnt][xcnt] == clm) {
                    this.map[ycnt][xcnt] = new Column(clm.getType());
                    int idx = 0;
                    for (int tmp = 0; tmp < xcnt; ++tmp) {
                        if (this.isJoinedColumn(tmp, ycnt)) continue;
                        ++idx;
                    }
                    l[ycnt].addColumn(idx, this.map[ycnt][xcnt]);
                    this.tabe_dirty_f = false;
                    continue;
                }
                if ((ycnt > yy || this.map[ycnt][xcnt] == clm) && (xcnt > xx || this.map[ycnt][xcnt] == clm)) continue;
                if (this.map[ycnt][xcnt].getColspan() > 1 || this.map[ycnt][xcnt].getRowspan() > 1) {
                    this.joinColumn(xcnt, ycnt, 1, 1);
                }
                l[ycnt].removeColumn(this.map[ycnt][xcnt]);
                this.tabe_dirty_f = false;
                this.map[ycnt][xcnt] = clm;
            }
        }
    }

    void setDirty() {
        this.tabe_dirty_f = true;
    }

    public Table() {
        this("table");
    }

    Table(String s) {
        super(s, false);
    }

    @Override
    protected Tag newReplica() {
        return new Table();
    }

    public Line[] getLineArray() {
        Tag[] tag = this.getTagArray();
        ArrayList<Line> line = new ArrayList<Line>();
        for (int i = 0; i < tag.length; ++i) {
            if (!(tag[i] instanceof Line)) continue;
            line.add((Line)tag[i]);
        }
        return line.toArray(new Line[0]);
    }

    public Line getLine(int no) {
        if (no < 0) {
            return null;
        }
        Line[] tag = this.getLineArray();
        if (no >= tag.length) {
            return null;
        }
        return tag[no];
    }

    public void addLine(Line line) {
        this.addLine(this.getLineCount(), line);
    }

    public void addLine(int idx, Line line) {
        Line[] l = this.getLineArray();
        this.setDirty();
        if (l.length <= idx) {
            this.addHTMLPart((HTMLPart)line);
            return;
        }
        this.addHTMLPart(this.indexOf(l[idx]), (HTMLPart)line);
    }

    public int indexOfLine(Line line) {
        Line[] l = this.getLineArray();
        for (int i = 0; i < l.length; ++i) {
            if (l[i] != line) continue;
            return i;
        }
        return -1;
    }

    public void removeLine(int idx) {
        if (idx < 0) {
            return;
        }
        Line[] l = this.getLineArray();
        if (l.length <= idx) {
            return;
        }
        this.setDirty();
        if (idx > 0) {
            Column[] clm = l[idx - 1].getColumnArray();
            for (int i = 0; i < clm.length; ++i) {
                int row = clm[i].getRowspan();
                if (--row <= 1) continue;
                clm[i].setRowspan(row);
            }
        }
        this.removeHTMLPart(l[idx]);
    }

    public void removeLine(Line line) {
        this.removeHTMLPart(this.indexOfLine(line));
    }

    public void removeLine(int start, int end) {
        Line[] l = this.getLineArray();
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = l.length - 1;
        }
        for (int i = end; i >= start; --i) {
            this.removeLine(i);
        }
    }

    public void removeLine() {
        this.removeLine(0, -1);
    }

    public Line getLineReplica(int idx) {
        Line[] l = this.getLineArray();
        if (l.length == 0) {
            return null;
        }
        if (idx < 0 || idx >= l.length) {
            return null;
        }
        return (Line)l[idx].getReplica();
    }

    public int getLineCount() {
        Line[] l = this.getLineArray();
        return l.length;
    }

    public class TableException
    extends Exception {
        TableException(String mes) {
            super(mes);
        }
    }
}

