/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.ajax.data;

import paraselene.*;

public class JavaScript extends PlainText {
	private static final long serialVersionUID = 2L;
	private JavaScript(){}
	public JavaScript( String ... script ) {
		super( "" );
		append( script );
	}

	public void append( String ... script ) {
		StringBuilder	buf = new StringBuilder( super.toString( StringMode.PLAIN ) );
		for ( int i = 0; i < script.length; i++ ) {
			buf = buf.append( script[i] );
			buf = buf.append( "\r\n" );
		}
		setText( buf.toString() );
	}

	public String toString( StringMode mode ) {
		StringBuilder	buf = new StringBuilder( "<!--//--><![CDATA[//><!--\r\n" );
		buf = buf.append( toString() );
		buf = buf.append( "//--><!]]>\r\n" );
		return buf.toString();
	}

	public String toString() {
		return super.toString( StringMode.PLAIN );
	}
}

