/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;

import java.io.*;

/**
 * サーバー情報。
 */
public interface ServerInformation extends Serializable {
	/**
	 * ホスト名の取得。
	 * @return ホスト名。
	 */
	String getServerName();
	/**
	 * コンテキストパスの取得。
	 * @return コンテキストパス。
	 */
	String getContextPath();
	/**
	 * トランザクションシーケンサの取得。
	 * @return トランザクションシーケンサ。
	 */
	TransactionSequencer getTransactionSequencer();
	/**
	 * サーチエンジンアクセス。
	 * @return true:サーチエンジンクローラからのアクセス、false:それ以外。
	 */
	boolean isSearchEngine();
	/**
	 * 履歴セットの取得。
	 * @return 履歴セット。
	 */
	HistorySet getHistorySet();
	/**
	 * ページファクトリーの取得。
	 * @return ページファクトリー。
	 */
	PageFactory getPageFactory();
}

