/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されている License.txt に定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
import java.io.*;
import java.util.*;


public class MimeMake {
	private static ArrayList<String[]>	table = new ArrayList<String[]>();

	private static void echo1_2( BufferedWriter w, String[] data ) throws Exception {
		String[]	type = data[0].split( "/" );
		StringBuilder	ext = new StringBuilder( "new String[]{" );
		for ( int  i = 1; i < data.length; i++ ) {
			if ( i > 1 ) {
				ext = ext.append( "," );
			}
			ext = ext.append( "\"" );
			ext = ext.append( data[i] );
			ext = ext.append( "\"" );
		}
		ext = ext.append( "}" );

		w.write( "set_rev(\"" );
		w.write( type[0] );
		w.write( "\",\"" );
		w.write( type[1] );
		w.write( "\"," );
		w.write( ext.toString() );
		w.write( ");\n" );
	}

	private static void echo1( BufferedWriter w ) throws Exception {
		int	cnt = table.size();
		for ( int i = 0; i < cnt; i++ ) {
			echo1_2( w, table.get( i ) );
		}
	}

	private static void echo0( BufferedWriter w, String[] data ) throws Exception {
		w.write( " * <tr>" );
		w.write( "<td>" );
		w.write( data[0] );
		w.write( "</td>" );
		w.write( "<td>" );
		for ( int i = 1; i < data.length; i++ ) {
			w.write( data[i] );
			w.write( "&nbsp;" );
		}
		w.write( "</td>" );
		w.write( "</tr>\n" );
	}

	private static void echo0( BufferedWriter w ) throws Exception {
		int	cnt = table.size();
		for ( int i = 0; i < cnt; i++ ) {
			echo0( w, table.get( i ) );
		}
	}

	public static void main( String[] argv ) throws Exception {
		BufferedReader	br = new BufferedReader(
			new InputStreamReader(
				new FileInputStream( "../template/mime.types" )
			)
		);
		while( true ) {
			String	line = br.readLine();
			if ( line == null )	break;
			line = line.trim();
			if ( line.isEmpty() )	continue;
			if ( line.charAt( 0 ) == '#' )	continue;
			String[]	l = line.split( "\\p{Space}" );
			if ( l.length < 2 )	continue;
			ArrayList<String>	data = new ArrayList<String>();
			data.add( l[0] );
			for ( int i = 1; i < l.length; i++ ) {
				if ( l[i].isEmpty() )	continue;
				data.add( l[i] );
			}
			if ( data.size() > 1 ) {
				table.add( data.toArray( new String[0] ) );
			}
		}
		br.close();

		br = new BufferedReader(
			new InputStreamReader(
				new FileInputStream( "../template/MimeType.java" )
			)
		);
		BufferedWriter	bw = new BufferedWriter(
			new OutputStreamWriter(
				new FileOutputStream( "../paraselene/MimeType.java" )
			)
		);
		while( true ) {
			String	line = br.readLine();
			if ( line == null )	break;
			if ( "#0".equals( line ) ) {
				echo0( bw );
				continue;
			}
			if ( "#1".equals( line ) ) {
				echo1( bw );
				continue;
			}
			bw.write( line );
			bw.write( "\n" );
		}
		bw.close();
		br.close();
	}
}

