/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されている License.txt に定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import java.util.*;

/**
 * 文字参照。toString()の戻り値を、文字列として扱う事ができます。<br>
 * ブラウザへの応答や、JAVA実行中のString値として使用する場合は問題ありませんが、
 * 例えばデータベースへこのtoString()文字列を格納する場合には注意が必要です。
 * データベースがUTF-8であればほぼ問題ありませんが、例えばEUC-JP等の場合、
 * 文字によっては対応する文字コードが存在しない可能性があります。
 */
public enum WebChar {
	/**
	 * &nbsp; no-break space = non-breaking space
	 */
	_nbsp( '\u00a0', "&nbsp;" ),
	/**
	 * &iexcl; inverted exclamation mark
	 */
	_iexcl( '\u00a1', "&iexcl;" ),
	/**
	 * &cent; cent sign
	 */
	_cent( '\u00a2', "&cent;" ),
	/**
	 * &pound; pound sign
	 */
	_pound( '\u00a3', "&pound;" ),
	/**
	 * &curren; currency sign
	 */
	_curren( '\u00a4', "&curren;" ),
	/**
	 * &yen; yen sign = yuan sign
	 */
	_yen( '\u00a5', "&yen;" ),
	/**
	 * &brvbar; broken bar = broken vertical bar
	 */
	_brvbar( '\u00a6', "&brvbar;" ),
	/**
	 * &sect; section sign
	 */
	_sect( '\u00a7', "&sect;" ),
	/**
	 * &uml; diaeresis = spacing diaeresis
	 */
	_uml( '\u00a8', "&uml;" ),
	/**
	 * &copy; copyright sign
	 */
	_copy( '\u00a9', "&copy;" ),
	/**
	 * &ordf; feminine ordinal indicator
	 */
	_ordf( '\u00aa', "&ordf;" ),
	/**
	 * &laquo; left-pointing double angle quotation mark = left pointing guillemet
	 */
	_laquo( '\u00ab', "&laquo;" ),
	/**
	 * &not; not sign
	 */
	_not( '\u00ac', "&not;" ),
	/**
	 * &shy; soft hyphen = discretionary hyphen
	 */
	_shy( '\u00ad', "&shy;" ),
	/**
	 * &reg; registered sign = registered trade mark sign
	 */
	_reg( '\u00ae', "&reg;" ),
	/**
	 * &macr; macron = spacing macron = overline = APL overbar
	 */
	_macr( '\u00af', "&macr;" ),
	/**
	 * &deg; degree sign
	 */
	_deg( '\u00b0', "&deg;" ),
	/**
	 * &plusmn; plus-minus sign = plus-or-minus sign
	 */
	_plusmn( '\u00b1', "&plusmn;" ),
	/**
	 * &sup2; superscript two = superscript digit two = squared
	 */
	_sup2( '\u00b2', "&sup2;" ),
	/**
	 * &sup3; superscript three = superscript digit three = cubed
	 */
	_sup3( '\u00b3', "&sup3;" ),
	/**
	 * &acute; acute accent = spacing acute
	 */
	_acute( '\u00b4', "&acute;" ),
	/**
	 * &micro; micro sign
	 */
	_micro( '\u00b5', "&micro;" ),
	/**
	 * &para; pilcrow sign = paragraph sign
	 */
	_para( '\u00b6', "&para;" ),
	/**
	 * &middot; middle dot = Georgian comma = Greek middle dot
	 */
	_middot( '\u00b7', "&middot;" ),
	/**
	 * &cedil; cedilla = spacing cedilla
	 */
	_cedil( '\u00b8', "&cedil;" ),
	/**
	 * &sup1; superscript one = superscript digit one
	 */
	_sup1( '\u00b9', "&sup1;" ),
	/**
	 * &ordm; masculine ordinal indicator
	 */
	_ordm( '\u00ba', "&ordm;" ),
	/**
	 * &raquo; right-pointing double angle quotation mark = right pointing guillemet
	 */
	_raquo( '\u00bb', "&raquo;" ),
	/**
	 * &frac14; vulgar fraction one quarter = fraction one quarter
	 */
	_frac14( '\u00bc', "&frac14;" ),
	/**
	 * &frac12; vulgar fraction one half = fraction one half
	 */
	_frac12( '\u00bd', "&frac12;" ),
	/**
	 * &frac34; vulgar fraction three quarters = fraction three quarters
	 */
	_frac34( '\u00be', "&frac34;" ),
	/**
	 * &iquest; inverted question mark = turned question mark
	 */
	_iquest( '\u00bf', "&iquest;" ),
	/**
	 * &Agrave; latin capital letter A with grave = latin capital letter A grave
	 */
	_Agrave( '\u00c0', "&Agrave;" ),
	/**
	 * &Aacute; latin capital letter A with acute
	 */
	_Aacute( '\u00c1', "&Aacute;" ),
	/**
	 * &Acirc; latin capital letter A with circumflex
	 */
	_Acirc( '\u00c2', "&Acirc;" ),
	/**
	 * &Atilde; latin capital letter A with tilde
	 */
	_Atilde( '\u00c3', "&Atilde;" ),
	/**
	 * &Auml; latin capital letter A with diaeresis
	 */
	_Auml( '\u00c4', "&Auml;" ),
	/**
	 * &Aring; latin capital letter A with ring above = latin capital letter A ring
	 */
	_Aring( '\u00c5', "&Aring;" ),
	/**
	 * &AElig; latin capital letter AE = latin capital ligature AE
	 */
	_AElig( '\u00c6', "&AElig;" ),
	/**
	 * &Ccedil; latin capital letter C with cedilla
	 */
	_Ccedil( '\u00c7', "&Ccedil;" ),
	/**
	 * &Egrave; latin capital letter E with grave
	 */
	_Egrave( '\u00c8', "&Egrave;" ),
	/**
	 * &Eacute; latin capital letter E with acute
	 */
	_Eacute( '\u00c9', "&Eacute;" ),
	/**
	 * &Ecirc; latin capital letter E with circumflex
	 */
	_Ecirc( '\u00ca', "&Ecirc;" ),
	/**
	 * &Euml; latin capital letter E with diaeresis
	 */
	_Euml( '\u00cb', "&Euml;" ),
	/**
	 * &Igrave; latin capital letter I with grave
	 */
	_Igrave( '\u00cc', "&Igrave;" ),
	/**
	 * &Iacute; latin capital letter I with acute
	 */
	_Iacute( '\u00cd', "&Iacute;" ),
	/**
	 * &Icirc; latin capital letter I with circumflex
	 */
	_Icirc( '\u00ce', "&Icirc;" ),
	/**
	 * &Iuml; latin capital letter I with diaeresis
	 */
	_Iuml( '\u00cf', "&Iuml;" ),
	/**
	 * &ETH; latin capital letter ETH
	 */
	_ETH( '\u00d0', "&ETH;" ),
	/**
	 * &Ntilde; latin capital letter N with tilde
	 */
	_Ntilde( '\u00d1', "&Ntilde;" ),
	/**
	 * &Ograve; latin capital letter O with grave
	 */
	_Ograve( '\u00d2', "&Ograve;" ),
	/**
	 * &Oacute; latin capital letter O with acute
	 */
	_Oacute( '\u00d3', "&Oacute;" ),
	/**
	 * &Ocirc; latin capital letter O with circumflex
	 */
	_Ocirc( '\u00d4', "&Ocirc;" ),
	/**
	 * &Otilde; latin capital letter O with tilde
	 */
	_Otilde( '\u00d5', "&Otilde;" ),
	/**
	 * &Ouml; latin capital letter O with diaeresis
	 */
	_Ouml( '\u00d6', "&Ouml;" ),
	/**
	 * &times; multiplication sign
	 */
	_times( '\u00d7', "&times;" ),
	/**
	 * &Oslash; latin capital letter O with stroke = latin capital letter O slash
	 */
	_Oslash( '\u00d8', "&Oslash;" ),
	/**
	 * &Ugrave; latin capital letter U with grave
	 */
	_Ugrave( '\u00d9', "&Ugrave;" ),
	/**
	 * &Uacute; latin capital letter U with acute
	 */
	_Uacute( '\u00da', "&Uacute;" ),
	/**
	 * &Ucirc; latin capital letter U with circumflex
	 */
	_Ucirc( '\u00db', "&Ucirc;" ),
	/**
	 * &Uuml; latin capital letter U with diaeresis
	 */
	_Uuml( '\u00dc', "&Uuml;" ),
	/**
	 * &Yacute; latin capital letter Y with acute
	 */
	_Yacute( '\u00dd', "&Yacute;" ),
	/**
	 * &THORN; latin capital letter THORN
	 */
	_THORN( '\u00de', "&THORN;" ),
	/**
	 * &szlig; latin small letter sharp s = ess-zed
	 */
	_szlig( '\u00df', "&szlig;" ),
	/**
	 * &agrave; latin small letter a with grave = latin small letter a grave
	 */
	_agrave( '\u00e0', "&agrave;" ),
	/**
	 * &aacute; latin small letter a with acute
	 */
	_aacute( '\u00e1', "&aacute;" ),
	/**
	 * &acirc; latin small letter a with circumflex
	 */
	_acirc( '\u00e2', "&acirc;" ),
	/**
	 * &atilde; latin small letter a with tilde
	 */
	_atilde( '\u00e3', "&atilde;" ),
	/**
	 * &auml; latin small letter a with diaeresis
	 */
	_auml( '\u00e4', "&auml;" ),
	/**
	 * &aring; latin small letter a with ring above = latin small letter a ring
	 */
	_aring( '\u00e5', "&aring;" ),
	/**
	 * &aelig; latin small letter ae = latin small ligature ae
	 */
	_aelig( '\u00e6', "&aelig;" ),
	/**
	 * &ccedil; latin small letter c with cedilla
	 */
	_ccedil( '\u00e7', "&ccedil;" ),
	/**
	 * &egrave; latin small letter e with grave
	 */
	_egrave( '\u00e8', "&egrave;" ),
	/**
	 * &eacute; latin small letter e with acute
	 */
	_eacute( '\u00e9', "&eacute;" ),
	/**
	 * &ecirc; latin small letter e with circumflex
	 */
	_ecirc( '\u00ea', "&ecirc;" ),
	/**
	 * &euml; latin small letter e with diaeresis
	 */
	_euml( '\u00eb', "&euml;" ),
	/**
	 * &igrave; latin small letter i with grave
	 */
	_igrave( '\u00ec', "&igrave;" ),
	/**
	 * &iacute; latin small letter i with acute
	 */
	_iacute( '\u00ed', "&iacute;" ),
	/**
	 * &icirc; latin small letter i with circumflex
	 */
	_icirc( '\u00ee', "&icirc;" ),
	/**
	 * &iuml; latin small letter i with diaeresis
	 */
	_iuml( '\u00ef', "&iuml;" ),
	/**
	 * &eth; latin small letter eth
	 */
	_eth( '\u00f0', "&eth;" ),
	/**
	 * &ntilde; latin small letter n with tilde
	 */
	_ntilde( '\u00f1', "&ntilde;" ),
	/**
	 * &ograve; latin small letter o with grave
	 */
	_ograve( '\u00f2', "&ograve;" ),
	/**
	 * &oacute; latin small letter o with acute
	 */
	_oacute( '\u00f3', "&oacute;" ),
	/**
	 * &ocirc; latin small letter o with circumflex
	 */
	_ocirc( '\u00f4', "&ocirc;" ),
	/**
	 * &otilde; latin small letter o with tilde
	 */
	_otilde( '\u00f5', "&otilde;" ),
	/**
	 * &ouml; latin small letter o with diaeresis
	 */
	_ouml( '\u00f6', "&ouml;" ),
	/**
	 * &divide; division sign
	 */
	_divide( '\u00f7', "&divide;" ),
	/**
	 * &oslash; latin small letter o with stroke, = latin small letter o slash
	 */
	_oslash( '\u00f8', "&oslash;" ),
	/**
	 * &ugrave; latin small letter u with grave
	 */
	_ugrave( '\u00f9', "&ugrave;" ),
	/**
	 * &uacute; latin small letter u with acute
	 */
	_uacute( '\u00fa', "&uacute;" ),
	/**
	 * &ucirc; latin small letter u with circumflex
	 */
	_ucirc( '\u00fb', "&ucirc;" ),
	/**
	 * &uuml; latin small letter u with diaeresis
	 */
	_uuml( '\u00fc', "&uuml;" ),
	/**
	 * &yacute; latin small letter y with acute
	 */
	_yacute( '\u00fd', "&yacute;" ),
	/**
	 * &thorn; latin small letter thorn
	 */
	_thorn( '\u00fe', "&thorn;" ),
	/**
	 * &yuml; latin small letter y with diaeresis
	 */
	_yuml( '\u00ff', "&yuml;" ),
	/**
	 * &fnof; latin small f with hook = function = florin
	 */
	_fnof( '\u0192', "&fnof;" ),
	/**
	 * &Alpha; greek capital letter alpha
	 */
	_Alpha( '\u0391', "&Alpha;" ),
	/**
	 * &Beta; greek capital letter beta
	 */
	_Beta( '\u0392', "&Beta;" ),
	/**
	 * &Gamma; greek capital letter gamma
	 */
	_Gamma( '\u0393', "&Gamma;" ),
	/**
	 * &Delta; greek capital letter delta
	 */
	_Delta( '\u0394', "&Delta;" ),
	/**
	 * &Epsilon; greek capital letter epsilon
	 */
	_Epsilon( '\u0395', "&Epsilon;" ),
	/**
	 * &Zeta; greek capital letter zeta
	 */
	_Zeta( '\u0396', "&Zeta;" ),
	/**
	 * &Eta; greek capital letter eta
	 */
	_Eta( '\u0397', "&Eta;" ),
	/**
	 * &Theta; greek capital letter theta
	 */
	_Theta( '\u0398', "&Theta;" ),
	/**
	 * &Iota; greek capital letter iota
	 */
	_Iota( '\u0399', "&Iota;" ),
	/**
	 * &Kappa; greek capital letter kappa
	 */
	_Kappa( '\u039a', "&Kappa;" ),
	/**
	 * &Lambda; greek capital letter lambda
	 */
	_Lambda( '\u039b', "&Lambda;" ),
	/**
	 * &Mu; greek capital letter mu
	 */
	_Mu( '\u039c', "&Mu;" ),
	/**
	 * &Nu; greek capital letter nu
	 */
	_Nu( '\u039d', "&Nu;" ),
	/**
	 * &Xi; greek capital letter xi
	 */
	_Xi( '\u039e', "&Xi;" ),
	/**
	 * &Omicron; greek capital letter omicron
	 */
	_Omicron( '\u039f', "&Omicron;" ),
	/**
	 * &Pi; greek capital letter pi
	 */
	_Pi( '\u03a0', "&Pi;" ),
	/**
	 * &Rho; greek capital letter rho
	 */
	_Rho( '\u03a1', "&Rho;" ),
	/**
	 * &Sigma; greek capital letter sigma
	 */
	_Sigma( '\u03a3', "&Sigma;" ),
	/**
	 * &Tau; greek capital letter tau
	 */
	_Tau( '\u03a4', "&Tau;" ),
	/**
	 * &Upsilon; greek capital letter upsilon
	 */
	_Upsilon( '\u03a5', "&Upsilon;" ),
	/**
	 * &Phi; greek capital letter phi
	 */
	_Phi( '\u03a6', "&Phi;" ),
	/**
	 * &Chi; greek capital letter chi
	 */
	_Chi( '\u03a7', "&Chi;" ),
	/**
	 * &Psi; greek capital letter psi
	 */
	_Psi( '\u03a8', "&Psi;" ),
	/**
	 * &Omega; greek capital letter omega
	 */
	_Omega( '\u03a9', "&Omega;" ),
	/**
	 * &alpha; greek small letter alpha
	 */
	_alpha( '\u03b1', "&alpha;" ),
	/**
	 * &beta; greek small letter beta
	 */
	_beta( '\u03b2', "&beta;" ),
	/**
	 * &gamma; greek small letter gamma
	 */
	_gamma( '\u03b3', "&gamma;" ),
	/**
	 * &delta; greek small letter delta
	 */
	_delta( '\u03b4', "&delta;" ),
	/**
	 * &epsilon; greek small letter epsilon
	 */
	_epsilon( '\u03b5', "&epsilon;" ),
	/**
	 * &zeta; greek small letter zeta
	 */
	_zeta( '\u03b6', "&zeta;" ),
	/**
	 * &eta; greek small letter eta
	 */
	_eta( '\u03b7', "&eta;" ),
	/**
	 * &theta; greek small letter theta
	 */
	_theta( '\u03b8', "&theta;" ),
	/**
	 * &iota; greek small letter iota
	 */
	_iota( '\u03b9', "&iota;" ),
	/**
	 * &kappa; greek small letter kappa
	 */
	_kappa( '\u03ba', "&kappa;" ),
	/**
	 * &lambda; greek small letter lambda
	 */
	_lambda( '\u03bb', "&lambda;" ),
	/**
	 * &mu; greek small letter mu
	 */
	_mu( '\u03bc', "&mu;" ),
	/**
	 * &nu; greek small letter nu
	 */
	_nu( '\u03bd', "&nu;" ),
	/**
	 * &xi; greek small letter xi
	 */
	_xi( '\u03be', "&xi;" ),
	/**
	 * &omicron; greek small letter omicron
	 */
	_omicron( '\u03bf', "&omicron;" ),
	/**
	 * &pi; greek small letter pi
	 */
	_pi( '\u03c0', "&pi;" ),
	/**
	 * &rho; greek small letter rho
	 */
	_rho( '\u03c1', "&rho;" ),
	/**
	 * &sigmaf; greek small letter final sigma
	 */
	_sigmaf( '\u03c2', "&sigmaf;" ),
	/**
	 * &sigma; greek small letter sigma
	 */
	_sigma( '\u03c3', "&sigma;" ),
	/**
	 * &tau; greek small letter tau
	 */
	_tau( '\u03c4', "&tau;" ),
	/**
	 * &upsilon; greek small letter upsilon
	 */
	_upsilon( '\u03c5', "&upsilon;" ),
	/**
	 * &phi; greek small letter phi
	 */
	_phi( '\u03c6', "&phi;" ),
	/**
	 * &chi; greek small letter chi
	 */
	_chi( '\u03c7', "&chi;" ),
	/**
	 * &psi; greek small letter psi
	 */
	_psi( '\u03c8', "&psi;" ),
	/**
	 * &omega; greek small letter omega
	 */
	_omega( '\u03c9', "&omega;" ),
	/**
	 * &thetasym; greek small letter theta symbol
	 */
	_thetasym( '\u03d1', "&thetasym;" ),
	/**
	 * &upsih; greek upsilon with hook symbol
	 */
	_upsih( '\u03d2', "&upsih;" ),
	/**
	 * &piv; greek pi symbol
	 */
	_piv( '\u03d6', "&piv;" ),
	/**
	 * &bull; bullet = black small circle
	 */
	_bull( '\u2022', "&bull;" ),
	/**
	 * &hellip; horizontal ellipsis = three dot leader
	 */
	_hellip( '\u2026', "&hellip;" ),
	/**
	 * &prime; prime = minutes = feet
	 */
	_prime( '\u2032', "&prime;" ),
	/**
	 * &Prime; double prime = seconds = inches
	 */
	_Prime( '\u2033', "&Prime;" ),
	/**
	 * &oline; overline = spacing overscore
	 */
	_oline( '\u203e', "&oline;" ),
	/**
	 * &frasl; fraction slash
	 */
	_frasl( '\u2044', "&frasl;" ),
	/**
	 * &weierp; script capital P = power set = Weierstrass p
	 */
	_weierp( '\u2118', "&weierp;" ),
	/**
	 * &image; blackletter capital I = imaginary part
	 */
	_image( '\u2111', "&image;" ),
	/**
	 * &real; blackletter capital R = real part symbol
	 */
	_real( '\u211c', "&real;" ),
	/**
	 * &trade; trade mark sign
	 */
	_trade( '\u2122', "&trade;" ),
	/**
	 * &alefsym; alef symbol = first transfinite cardinal
	 */
	_alefsym( '\u2135', "&alefsym;" ),
	/**
	 * &larr; leftwards arrow
	 */
	_larr( '\u2190', "&larr;" ),
	/**
	 * &rarr; rightwards arrow
	 */
	_rarr( '\u2192', "&rarr;" ),
	/**
	 * &darr; downwards arrow
	 */
	_darr( '\u2193', "&darr;" ),
	/**
	 * &harr; left right arrow
	 */
	_harr( '\u2194', "&harr;" ),
	/**
	 * &crarr; downwards arrow with corner leftwards = carriage return
	 */
	_crarr( '\u21b5', "&crarr;" ),
	/**
	 * &lArr; leftwards double arrow
	 */
	_lArr( '\u21d0', "&lArr;" ),
	/**
	 * &uArr; upwards double arrow
	 */
	_uArr( '\u21d1', "&uArr;" ),
	/**
	 * &rArr; rightwards double arrow
	 */
	_rArr( '\u21d2', "&rArr;" ),
	/**
	 * &dArr; downwards double arrow
	 */
	_dArr( '\u21d3', "&dArr;" ),
	/**
	 * &hArr; left right double arrow
	 */
	_hArr( '\u21d4', "&hArr;" ),
	/**
	 * &forall; for all
	 */
	_forall( '\u2200', "&forall;" ),
	/**
	 * &part; partial differential
	 */
	_part( '\u2202', "&part;" ),
	/**
	 * &exist; there exists
	 */
	_exist( '\u2203', "&exist;" ),
	/**
	 * &empty; empty set = null set = diameter
	 */
	_empty( '\u2205', "&empty;" ),
	/**
	 * &nabla; nabla = backward difference
	 */
	_nabla( '\u2207', "&nabla;" ),
	/**
	 * &isin; element of
	 */
	_isin( '\u2208', "&isin;" ),
	/**
	 * &notin; not an element of
	 */
	_notin( '\u2209', "&notin;" ),
	/**
	 * &ni; contains as member
	 */
	_ni( '\u220b', "&ni;" ),
	/**
	 * &prod; n-ary product = product sign
	 */
	_prod( '\u220f', "&prod;" ),
	/**
	 * &sum; n-ary sumation
	 */
	_sum( '\u2211', "&sum;" ),
	/**
	 * &minus; minus sign
	 */
	_minus( '\u2212', "&minus;" ),
	/**
	 * &lowast; asterisk operator
	 */
	_lowast( '\u2217', "&lowast;" ),
	/**
	 * &radic; square root = radical sign
	 */
	_radic( '\u221a', "&radic;" ),
	/**
	 * &prop; proportional to
	 */
	_prop( '\u221d', "&prop;" ),
	/**
	 * &infin; infinity
	 */
	_infin( '\u221e', "&infin;" ),
	/**
	 * &ang; angle
	 */
	_ang( '\u2220', "&ang;" ),
	/**
	 * &and; logical and = wedge
	 */
	_and( '\u2227', "&and;" ),
	/**
	 * &or; logical or = vee
	 */
	_or( '\u2228', "&or;" ),
	/**
	 * &cap; intersection = cap
	 */
	_cap( '\u2229', "&cap;" ),
	/**
	 * &cup; union = cup
	 */
	_cup( '\u222a', "&cup;" ),
	/**
	 * &int; integral
	 */
	_int( '\u222b', "&int;" ),
	/**
	 * &there4; therefore
	 */
	_there4( '\u2234', "&there4;" ),
	/**
	 * &sim; tilde operator = varies with = similar to
	 */
	_sim( '\u223c', "&sim;" ),
	/**
	 * &cong; approximately equal to
	 */
	_cong( '\u2245', "&cong;" ),
	/**
	 * &asymp; almost equal to = asymptotic to
	 */
	_asymp( '\u2248', "&asymp;" ),
	/**
	 * &ne; not equal to
	 */
	_ne( '\u2260', "&ne;" ),
	/**
	 * &equiv; identical to
	 */
	_equiv( '\u2261', "&equiv;" ),
	/**
	 * &le; less-than or equal to
	 */
	_le( '\u2264', "&le;" ),
	/**
	 * &ge; greater-than or equal to
	 */
	_ge( '\u2265', "&ge;" ),
	/**
	 * &sub; subset of
	 */
	_sub( '\u2282', "&sub;" ),
	/**
	 * &sup; superset of
	 */
	_sup( '\u2283', "&sup;" ),
	/**
	 * &nsub; not a subset of
	 */
	_nsub( '\u2284', "&nsub;" ),
	/**
	 * &sube; subset of or equal to
	 */
	_sube( '\u2286', "&sube;" ),
	/**
	 * &supe; superset of or equal to
	 */
	_supe( '\u2287', "&supe;" ),
	/**
	 * &oplus; circled plus = direct sum
	 */
	_oplus( '\u2295', "&oplus;" ),
	/**
	 * &otimes; circled times = vector product
	 */
	_otimes( '\u2297', "&otimes;" ),
	/**
	 * &perp; up tack = orthogonal to = perpendicular
	 */
	_perp( '\u22a5', "&perp;" ),
	/**
	 * &sdot; dot operator
	 */
	_sdot( '\u22c5', "&sdot;" ),
	/**
	 * &lceil; left ceiling = apl upstile
	 */
	_lceil( '\u2308', "&lceil;" ),
	/**
	 * &rceil; right ceiling
	 */
	_rceil( '\u2309', "&rceil;" ),
	/**
	 * &lfloor; left floor = apl downstile
	 */
	_lfloor( '\u230a', "&lfloor;" ),
	/**
	 * &rfloor; right floor
	 */
	_rfloor( '\u230b', "&rfloor;" ),
	/**
	 * &lang; left-pointing angle bracket = bra
	 */
	_lang( '\u2329', "&lang;" ),
	/**
	 * &rang; right-pointing angle bracket = ket
	 */
	_rang( '\u232a', "&rang;" ),
	/**
	 * &loz; lozenge
	 */
	_loz( '\u25ca', "&loz;" ),
	/**
	 * &spades; black spade suit
	 */
	_spades( '\u2660', "&spades;" ),
	/**
	 * &clubs; black club suit = shamrock
	 */
	_clubs( '\u2663', "&clubs;" ),
	/**
	 * &hearts; black heart suit = valentine
	 */
	_hearts( '\u2665', "&hearts;" ),
	/**
	 * &diams; black diamond suit
	 */
	_diams( '\u2666', "&diams;" ),
	/**
	 * &quot; quotation mark = APL quote
	 */
	_quot( '\u0022', "&quot;" ),
	/**
	 * &amp; ampersand
	 */
	_amp( '\u0026', "&amp;" ),
	/**
	 * &lt; less-than sign
	 */
	_lt( '\u003c', "&lt;" ),
	/**
	 * &gt; greater-than sign
	 */
	_gt( '\u003e', "&gt;" ),
	/**
	 * &OElig; latin capital ligature OE
	 */
	_OElig( '\u0152', "&OElig;" ),
	/**
	 * &oelig; latin small ligature oe
	 */
	_oelig( '\u0153', "&oelig;" ),
	/**
	 * &Scaron; latin capital letter S with caron
	 */
	_Scaron( '\u0160', "&Scaron;" ),
	/**
	 * &scaron; latin small letter s with caron
	 */
	_scaron( '\u0161', "&scaron;" ),
	/**
	 * &Yuml; latin capital letter Y with diaeresis
	 */
	_Yuml( '\u0178', "&Yuml;" ),
	/**
	 * &circ; modifier letter circumflex accent
	 */
	_circ( '\u02c6', "&circ;" ),
	/**
	 * &tilde; small tilde
	 */
	_tilde( '\u02dc', "&tilde;" ),
	/**
	 * &ensp; en space
	 */
	_ensp( '\u2002', "&ensp;" ),
	/**
	 * &emsp; em space
	 */
	_emsp( '\u2003', "&emsp;" ),
	/**
	 * &thinsp; thin space
	 */
	_thinsp( '\u2009', "&thinsp;" ),
	/**
	 * &zwnj; zero width non-joiner
	 */
	_zwnj( '\u200c', "&zwnj;" ),
	/**
	 * &zwj; zero width joiner
	 */
	_zwj( '\u200d', "&zwj;" ),
	/**
	 * &lrm; left-to-right mark
	 */
	_lrm( '\u200e', "&lrm;" ),
	/**
	 * &rlm; right-to-left mark
	 */
	_rlm( '\u200f', "&rlm;" ),
	/**
	 * &ndash; en dash
	 */
	_ndash( '\u2013', "&ndash;" ),
	/**
	 * &mdash; em dash
	 */
	_mdash( '\u2014', "&mdash;" ),
	/**
	 * &lsquo; left single quotation mark
	 */
	_lsquo( '\u2018', "&lsquo;" ),
	/**
	 * &rsquo; right single quotation mark
	 */
	_rsquo( '\u2019', "&rsquo;" ),
	/**
	 * &sbquo; single low-9 quotation mark
	 */
	_sbquo( '\u201a', "&sbquo;" ),
	/**
	 * &ldquo; left double quotation mark
	 */
	_ldquo( '\u201c', "&ldquo;" ),
	/**
	 * &rdquo; right double quotation mark
	 */
	_rdquo( '\u201d', "&rdquo;" ),
	/**
	 * &bdquo; double low-9 quotation mark
	 */
	_bdquo( '\u201e', "&bdquo;" ),
	/**
	 * &dagger; dagger
	 */
	_dagger( '\u2020', "&dagger;" ),
	/**
	 * &Dagger; double dagger
	 */
	_Dagger( '\u2021', "&Dagger;" ),
	/**
	 * &permil; per mille sign
	 */
	_permil( '\u2030', "&permil;" ),
	/**
	 * &lsaquo; single left-pointing angle quotation mark
	 */
	_lsaquo( '\u2039', "&lsaquo;" ),
	/**
	 * &rsaquo; single right-pointing angle quotation mark
	 */
	_rsaquo( '\u203a', "&rsaquo;" ),
	/**
	 * &euro; euro sign
	 */
	_euro( '\u20ac', "&euro;" );
	private static final long serialVersionUID = 1260367499606L;
	private static HashMap<Character, WebChar>	map = new HashMap<Character, WebChar>();
	static {
		WebChar[]	wc = values();
		for ( int i = 0; i < wc.length; i++ ) {
			map.put( wc[i].ch, wc[i] );
		}
		map.put( ' ', _nbsp );
	}

	private char ch;
	private String ref;
	private WebChar( char c, String s ) {
		ch = c;
		ref = s;
	}

	static WebChar getWebChar( char c ) {
		return map.get( c );
	}

	/**
	 * 文字列化。１文字のStringとして扱う事ができます。
	 * @return 文字列。
	 */
	public String toString() {
		return new String( new char[]{ ch } );
	}

	/**
	 * 文字化。１文字のcharとして扱う事ができます。
	 * @return 文字。
	 */
	public char toChar() {
		return ch;
	}

	/**
	 * 文字参照の取得。&amp;nbsp; のような文字列を返します。
	 * @return 文字参照。
	 */
	public String getReference() {
		return ref;
	}
}

