/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import paraselene.Page;
import paraselene.supervisor.AjaxForward;
import paraselene.supervisor.CometCall;
import paraselene.supervisor.Forward;
import paraselene.supervisor.History;
import paraselene.supervisor.OpenCometCall;
import paraselene.supervisor.OpenOutput;
import paraselene.supervisor.Option;
import paraselene.supervisor.OutputCall;
import paraselene.supervisor.PageID;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.SandBox;
import paraselene.supervisor.SessionData;

public class Popup
extends Forward
implements AjaxForward {
    private static final long serialVersionUID = 2L;
    Page active_page = null;
    Page view_page = null;
    private Type type;

    @Override
    boolean is_refresh() {
        return this.view_page != null;
    }

    public Popup(PageID id, Type dialog_type) {
        super(id);
        this.type = dialog_type;
        if (SandBox.isCurrentDaemon()) {
            return;
        }
        this.initType(SandBox.getCurrentRequestParameter().getHistory());
    }

    void initType(History hist) {
        if (Popup.isModelessAlert(this.type, hist, false)) {
            this.overwriteType(Type.MODAL);
        }
    }

    public Popup(Page page, Type dialog_type) {
        this(page.getParentPage().getID(), dialog_type);
        page = page.getParentPage();
        if (page.getPopupType() != null) {
            this.active_page = page;
        } else {
            this.view_page = page;
        }
    }

    static boolean isModeless(Type mine) {
        if (mine == null) {
            return false;
        }
        return !mine.isMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isModelessAlert(Type mine, History hist, boolean unlock_f) {
        if (hist == null) {
            return false;
        }
        if (mine == null) {
            return false;
        }
        if (mine.isMode()) {
            return false;
        }
        try {
            Page[] page = hist.getBrowsingPage();
            for (int i = 0; i < page.length; ++i) {
                Type ptype = page[i].getPopupType();
                if (ptype == null || !ptype.isMode()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (unlock_f) {
                hist.unlock();
            }
        }
        return false;
    }

    public Popup(Page page) {
        this(page, Type.MODELESS);
    }

    @Override
    Page getPage(Page from) {
        if (this.active_page != null) {
            Option.trace("Popup#getPage -> %s", this.active_page.getUniqueKey());
            return this.active_page;
        }
        if (this.out_page == null) {
            Option.trace("Popup#getPage -> null", new Object[0]);
            return null;
        }
        if (this.view_page != null) {
            Option.trace("Popup#getPage -> %s", this.view_page.getUniqueKey());
            return this.view_page;
        }
        Page p = this.out_page.getPageFactory().getPage(this.out_page.getID());
        Option.trace("Popup#getPage -> %s", p.getUniqueKey());
        return p;
    }

    void overwriteType(Type t) {
        if (this.type == null) {
            return;
        }
        if (t == Type.MODELESS) {
            return;
        }
        this.type = t;
    }

    Type getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("Popup ");
        if (this.active_page != null) {
            buf = buf.append("active:");
            buf = buf.append(this.active_page.getID().toString());
            buf = buf.append("/").append(this.active_page.getUniqueKey());
        } else {
            buf = buf.append("open:");
            if (this.view_page == null) {
                buf = buf.append(this.getPageID().toString());
            } else {
                buf = buf.append(this.view_page.getID().toString());
                buf = buf.append("/").append(this.view_page.getUniqueKey());
            }
            buf = buf.append("/").append(this.type.toString());
        }
        return buf.toString();
    }

    @Override
    OutputCall makeOutput(int nk, Page lp, RequestParameter r, SessionData sd) {
        Option.trace("new OpenOutput <- %s", this);
        return new OpenOutput(nk, lp, this, this.getType(), r, sd);
    }

    @Override
    CometCall makeCometCall(History h) {
        Option.trace("new OpenCometCall <- %s", this);
        return new OpenCometCall(h, this, this.getType());
    }

    public static enum Type {
        MODELESS(false, true),
        MODAL(true, true),
        LITE_MODAL(true, false);

        private boolean modal_f;
        private boolean move_f;

        private Type(boolean md_f, boolean mv_f) {
            this.modal_f = md_f;
            this.move_f = mv_f;
        }

        public boolean isTitle() {
            return this.move_f;
        }

        public boolean isMode() {
            return this.modal_f;
        }

        public static boolean isMode(Page page) {
            Type ptype = page.getPopupType();
            if (ptype == null) {
                return false;
            }
            return ptype.isMode();
        }
    }
}

