/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.table;

import java.io.PrintWriter;
import paraselene.HTMLPart;
import paraselene.Text;
import paraselene.tag.Attribute;
import paraselene.tag.Tag;

public class Column
extends Tag {
    private static final long serialVersionUID = 2L;
    private Type const_type;
    private static final String COLSPAN = "colspan";
    private static final String ROWSPAN = "rowspan";

    public Type getType() {
        return this.const_type;
    }

    public Column(Type type) {
        super(type.str, false);
        this.const_type = type;
    }

    @Override
    protected Tag newReplica() {
        return new Column(this.const_type);
    }

    public int getColspan() {
        Integer v = this.getAttributeToInteger(COLSPAN);
        if (v == null) {
            return 1;
        }
        int ret = v;
        if (ret < 1) {
            this.removeAttribute(COLSPAN);
            return 1;
        }
        return ret;
    }

    public int getRowspan() {
        Integer v = this.getAttributeToInteger(ROWSPAN);
        if (v == null) {
            return 1;
        }
        int ret = v;
        if (ret < 1) {
            this.removeAttribute(ROWSPAN);
            return 1;
        }
        return ret;
    }

    void setColspan(int s) {
        if (s < 2) {
            this.removeAttribute(COLSPAN);
        } else {
            this.setAttribute(new Attribute(COLSPAN, s));
        }
    }

    void setRowspan(int s) {
        if (s < 2) {
            this.removeAttribute(ROWSPAN);
        } else {
            this.setAttribute(new Attribute(ROWSPAN, s));
        }
    }

    @Override
    public void write(PrintWriter w, HTMLPart.StringMode mode) {
        int cnt = this.getHTMLPartCount();
        if (cnt == 0) {
            this.addHTMLPart((HTMLPart)new Text(" "));
        }
        super.write(w, mode);
        if (cnt == 0) {
            this.removeHTMLPart();
        }
    }

    public static enum Type {
        HEADER("th"),
        DATA("td");

        private static final long serialVersionUID = 1L;
        String str;

        private Type(String s) {
            this.str = s;
        }
    }
}

