/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class MimeType {
    private static HashMap<String, String> map = new HashMap();
    private static HashMap<String, HashMap<String, String[]>> rev = new HashMap();

    private MimeType() {
    }

    private static void set_rev(String cat, String type, String[] ext) {
        HashMap<String, Object> sub = rev.get(cat);
        if (sub == null) {
            sub = new HashMap();
            rev.put(cat, sub);
        }
        sub.put(type, ext);
        StringBuilder buf = new StringBuilder(cat);
        buf = buf.append("/");
        buf = buf.append(type);
        type = buf.toString();
        for (int i = 0; i < ext.length; ++i) {
            map.put(ext[i], type);
        }
    }

    public static String getMimeType(String file) {
        String[] ext = file.split("\\.");
        String seek = ext[ext.length - 1].toLowerCase(Locale.ENGLISH);
        String ret = map.get(seek);
        if (ret == null) {
            return "application/octet-stream";
        }
        return ret;
    }

    public static String getMimeType(File file) {
        return MimeType.getMimeType(file.getName());
    }

    public static String[] getExtension(String mime) {
        String[] type = mime.split("/");
        HashMap<String, String[]> sub = rev.get(type[0]);
        if (sub == null) {
            return null;
        }
        if (type.length > 1) {
            return sub.get(type[1]);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String key : sub.keySet()) {
            String[] ext = sub.get(key);
            for (int i = 0; i < ext.length; ++i) {
                list.add(ext[i]);
            }
        }
        return list.toArray(new String[0]);
    }

    static {
        MimeType.set_rev("application", "andrew-inset", new String[]{"ez"});
        MimeType.set_rev("application", "annodex", new String[]{"anx"});
        MimeType.set_rev("application", "atom+xml", new String[]{"atom"});
        MimeType.set_rev("application", "atomcat+xml", new String[]{"atomcat"});
        MimeType.set_rev("application", "atomserv+xml", new String[]{"atomsrv"});
        MimeType.set_rev("application", "atomsvc+xml", new String[]{"atomsvc"});
        MimeType.set_rev("application", "auth-policy+xml", new String[]{"apxml"});
        MimeType.set_rev("application", "bbolin", new String[]{"lin"});
        MimeType.set_rev("application", "cap", new String[]{"pcap", "cap"});
        MimeType.set_rev("application", "ccxml+xml", new String[]{"ccxml"});
        MimeType.set_rev("application", "cellml+xml", new String[]{"cml", "cellml"});
        MimeType.set_rev("application", "cpl+xml", new String[]{"cpl"});
        MimeType.set_rev("application", "cu-seeme", new String[]{"cu"});
        MimeType.set_rev("application", "davmount+xml", new String[]{"davmount"});
        MimeType.set_rev("application", "dicom", new String[]{"dcm"});
        MimeType.set_rev("application", "dsptype", new String[]{"tsp"});
        MimeType.set_rev("application", "dssc+der", new String[]{"dssc"});
        MimeType.set_rev("application", "dssc+xml", new String[]{"xdssc"});
        MimeType.set_rev("application", "dvcs", new String[]{"dvc"});
        MimeType.set_rev("application", "ecmascript", new String[]{"es"});
        MimeType.set_rev("application", "emma+xml", new String[]{"emma"});
        MimeType.set_rev("application", "fastinfoset", new String[]{"finf"});
        MimeType.set_rev("application", "font-tdpfr", new String[]{"pfr"});
        MimeType.set_rev("application", "futuresplash", new String[]{"spl"});
        MimeType.set_rev("application", "hta", new String[]{"hta"});
        MimeType.set_rev("application", "hyperstudio", new String[]{"stk"});
        MimeType.set_rev("application", "ipfix", new String[]{"ipfix"});
        MimeType.set_rev("application", "java-archive", new String[]{"jar"});
        MimeType.set_rev("application", "java-serialized-object", new String[]{"ser"});
        MimeType.set_rev("application", "java-vm", new String[]{"class"});
        MimeType.set_rev("application", "javascript", new String[]{"js"});
        MimeType.set_rev("application", "json", new String[]{"json"});
        MimeType.set_rev("application", "lost+xml", new String[]{"lostxml"});
        MimeType.set_rev("application", "m3g", new String[]{"m3g"});
        MimeType.set_rev("application", "mac-binhex40", new String[]{"hqx"});
        MimeType.set_rev("application", "mac-compactpro", new String[]{"cpt"});
        MimeType.set_rev("application", "marc", new String[]{"mrc"});
        MimeType.set_rev("application", "mathematica", new String[]{"nb", "nbp", "ma", "mb"});
        MimeType.set_rev("application", "mathml+xml", new String[]{"mml"});
        MimeType.set_rev("application", "mbox", new String[]{"mbox"});
        MimeType.set_rev("application", "metalink+xml", new String[]{"metalink"});
        MimeType.set_rev("application", "mp21", new String[]{"mp21", "m21"});
        MimeType.set_rev("application", "msaccess", new String[]{"mdb"});
        MimeType.set_rev("application", "msword", new String[]{"doc", "dot"});
        MimeType.set_rev("application", "mxf", new String[]{"mxf"});
        MimeType.set_rev("application", "ocsp-request", new String[]{"orq"});
        MimeType.set_rev("application", "ocsp-response", new String[]{"ors"});
        MimeType.set_rev("application", "octet-stream", new String[]{"lzh", "iso", "so", "img", "class", "dll", "bin", "lha", "exe"});
        MimeType.set_rev("application", "oda", new String[]{"oda"});
        MimeType.set_rev("application", "oebps-package+xml", new String[]{"opf"});
        MimeType.set_rev("application", "ogg", new String[]{"ogx"});
        MimeType.set_rev("application", "pdf", new String[]{"pdf"});
        MimeType.set_rev("application", "pgp-keys", new String[]{"key"});
        MimeType.set_rev("application", "pgp-signature", new String[]{"pgp", "sig"});
        MimeType.set_rev("application", "pics-rules", new String[]{"prf"});
        MimeType.set_rev("application", "pkcs10", new String[]{"p10"});
        MimeType.set_rev("application", "pkcs7-mime", new String[]{"p7m", "p7c"});
        MimeType.set_rev("application", "pkcs7-signature", new String[]{"p7s"});
        MimeType.set_rev("application", "pkix-cert", new String[]{"cer"});
        MimeType.set_rev("application", "pkix-crl", new String[]{"crl"});
        MimeType.set_rev("application", "pkix-pkipath", new String[]{"pkipath"});
        MimeType.set_rev("application", "pls+xml", new String[]{"pls"});
        MimeType.set_rev("application", "postscript", new String[]{"eps", "eps3", "ai", "eps2", "epsf", "epsi", "ps"});
        MimeType.set_rev("application", "prs.cww", new String[]{"cww", "cw"});
        MimeType.set_rev("application", "prs.nprend", new String[]{"rnd", "rct"});
        MimeType.set_rev("application", "rar", new String[]{"rar"});
        MimeType.set_rev("application", "rdf+xml", new String[]{"rdf"});
        MimeType.set_rev("application", "reginfo+xml", new String[]{"rif"});
        MimeType.set_rev("application", "relax-ng-compact-syntax", new String[]{"rnc"});
        MimeType.set_rev("application", "resource-lists+xml", new String[]{"rl"});
        MimeType.set_rev("application", "resource-lists-diff+xml", new String[]{"rld"});
        MimeType.set_rev("application", "rls-services+xml", new String[]{"rs"});
        MimeType.set_rev("application", "rss+xml", new String[]{"rss"});
        MimeType.set_rev("application", "rtf", new String[]{"rtf"});
        MimeType.set_rev("application", "scvp-cv-request", new String[]{"scq"});
        MimeType.set_rev("application", "scvp-cv-response", new String[]{"scs"});
        MimeType.set_rev("application", "scvp-vp-request", new String[]{"spq"});
        MimeType.set_rev("application", "scvp-vp-response", new String[]{"spp"});
        MimeType.set_rev("application", "sdp", new String[]{"sdp"});
        MimeType.set_rev("application", "sgml-open-catalog", new String[]{"soc"});
        MimeType.set_rev("application", "shf+xml", new String[]{"shf"});
        MimeType.set_rev("application", "sieve", new String[]{"sieve", "siv"});
        MimeType.set_rev("application", "simple-filter+xml", new String[]{"cl"});
        MimeType.set_rev("application", "smil", new String[]{"smil", "sml", "smi"});
        MimeType.set_rev("application", "sparql-query", new String[]{"rq"});
        MimeType.set_rev("application", "sparql-results+xml", new String[]{"srx"});
        MimeType.set_rev("application", "srgs", new String[]{"gram"});
        MimeType.set_rev("application", "srgs+xml", new String[]{"grxml"});
        MimeType.set_rev("application", "ssml+xml", new String[]{"ssml"});
        MimeType.set_rev("application", "timestamp-query", new String[]{"tsq"});
        MimeType.set_rev("application", "timestamp-reply", new String[]{"tsr"});
        MimeType.set_rev("application", "vnd.3M.Post-it-Notes", new String[]{"pwn"});
        MimeType.set_rev("application", "vnd.3gpp.pic-bw-large", new String[]{"plb"});
        MimeType.set_rev("application", "vnd.3gpp.pic-bw-small", new String[]{"psb"});
        MimeType.set_rev("application", "vnd.3gpp.pic-bw-var", new String[]{"pvb"});
        MimeType.set_rev("application", "vnd.3gpp2.sms", new String[]{"sms"});
        MimeType.set_rev("application", "vnd.3gpp2.tcap", new String[]{"tcap"});
        MimeType.set_rev("application", "vnd.FloGraphIt", new String[]{"gph"});
        MimeType.set_rev("application", "vnd.HandHeld-Entertainment+xml", new String[]{"zmm"});
        MimeType.set_rev("application", "vnd.Kinar", new String[]{"kne", "sdf", "knp"});
        MimeType.set_rev("application", "vnd.MFER", new String[]{"mwf"});
        MimeType.set_rev("application", "vnd.Mobius.DAF", new String[]{"daf"});
        MimeType.set_rev("application", "vnd.Mobius.DIS", new String[]{"dis"});
        MimeType.set_rev("application", "vnd.Mobius.MBK", new String[]{"mbk"});
        MimeType.set_rev("application", "vnd.Mobius.MQY", new String[]{"mqy"});
        MimeType.set_rev("application", "vnd.Mobius.MSL", new String[]{"msl"});
        MimeType.set_rev("application", "vnd.Mobius.PLC", new String[]{"plc"});
        MimeType.set_rev("application", "vnd.Mobius.TXF", new String[]{"txf"});
        MimeType.set_rev("application", "vnd.Quark.QuarkXPress", new String[]{"qxl", "qwd", "qxd", "qwt", "qxt", "qxb"});
        MimeType.set_rev("application", "vnd.SimTech-MindMapper", new String[]{"twds", "twd"});
        MimeType.set_rev("application", "vnd.accpac.simply.aso", new String[]{"aso"});
        MimeType.set_rev("application", "vnd.accpac.simply.imp", new String[]{"imp"});
        MimeType.set_rev("application", "vnd.acucobol", new String[]{"acu"});
        MimeType.set_rev("application", "vnd.acucorp", new String[]{"acutc", "atc"});
        MimeType.set_rev("application", "vnd.adobe.xdp+xml", new String[]{"xdp"});
        MimeType.set_rev("application", "vnd.adobe.xfdf", new String[]{"xfdf"});
        MimeType.set_rev("application", "vnd.airzip.filesecure.azf", new String[]{"azf"});
        MimeType.set_rev("application", "vnd.airzip.filesecure.azs", new String[]{"azs"});
        MimeType.set_rev("application", "vnd.americandynamics.acc", new String[]{"acc"});
        MimeType.set_rev("application", "vnd.amiga.ami", new String[]{"ami"});
        MimeType.set_rev("application", "vnd.android.package-archive", new String[]{"apk"});
        MimeType.set_rev("application", "vnd.anser-web-certificate-issue-initiation", new String[]{"cii"});
        MimeType.set_rev("application", "vnd.anser-web-funds-transfer-initiation", new String[]{"fti"});
        MimeType.set_rev("application", "vnd.apple.installer+xml", new String[]{"distz", "mpkg", "pkg", "dist"});
        MimeType.set_rev("application", "vnd.apple.mpegurl", new String[]{"m3u8"});
        MimeType.set_rev("application", "vnd.aristanetworks.swi", new String[]{"swi"});
        MimeType.set_rev("application", "vnd.audiograph", new String[]{"aep"});
        MimeType.set_rev("application", "vnd.autopackage", new String[]{"package"});
        MimeType.set_rev("application", "vnd.blueice.multipass", new String[]{"mpm"});
        MimeType.set_rev("application", "vnd.bluetooth.ep.oob", new String[]{"ep"});
        MimeType.set_rev("application", "vnd.bmi", new String[]{"bmi"});
        MimeType.set_rev("application", "vnd.businessobjects", new String[]{"rep"});
        MimeType.set_rev("application", "vnd.cendio.thinlinc.clientconf", new String[]{"tlclient"});
        MimeType.set_rev("application", "vnd.chemdraw+xml", new String[]{"cdxml"});
        MimeType.set_rev("application", "vnd.chipnuts.karaoke-mmd", new String[]{"mmd"});
        MimeType.set_rev("application", "vnd.cinderella", new String[]{"cdy"});
        MimeType.set_rev("application", "vnd.claymore", new String[]{"cla"});
        MimeType.set_rev("application", "vnd.cloanto.rp9", new String[]{"rp9"});
        MimeType.set_rev("application", "vnd.clonk.c4group", new String[]{"c4u", "c4g", "c4f", "c4d", "c4p"});
        MimeType.set_rev("application", "vnd.commerce-battelle", new String[]{"icf", "ic1", "ic0", "icd", "ic3", "ic2", "ic5", "ica", "ic4", "ic7", "ic6", "ic8"});
        MimeType.set_rev("application", "vnd.commonspace", new String[]{"cst", "csp"});
        MimeType.set_rev("application", "vnd.contact.cmsg", new String[]{"cdbcmsg"});
        MimeType.set_rev("application", "vnd.cosmocaller", new String[]{"cmc"});
        MimeType.set_rev("application", "vnd.crick.clicker", new String[]{"clkx"});
        MimeType.set_rev("application", "vnd.crick.clicker.keyboard", new String[]{"clkk"});
        MimeType.set_rev("application", "vnd.crick.clicker.palette", new String[]{"clkp"});
        MimeType.set_rev("application", "vnd.crick.clicker.template", new String[]{"clkt"});
        MimeType.set_rev("application", "vnd.crick.clicker.wordbank", new String[]{"clkw"});
        MimeType.set_rev("application", "vnd.criticaltools.wbs+xml", new String[]{"wbs"});
        MimeType.set_rev("application", "vnd.ctc-posml", new String[]{"pml"});
        MimeType.set_rev("application", "vnd.cups-ppd", new String[]{"ppd"});
        MimeType.set_rev("application", "vnd.curl", new String[]{"curl"});
        MimeType.set_rev("application", "vnd.data-vision.rdz", new String[]{"rdz"});
        MimeType.set_rev("application", "vnd.denovo.fcselayout-link", new String[]{"fe_launch"});
        MimeType.set_rev("application", "vnd.dna", new String[]{"dna"});
        MimeType.set_rev("application", "vnd.dpgraph", new String[]{"mwc", "dpgraph", "dpg"});
        MimeType.set_rev("application", "vnd.dreamfactory", new String[]{"dfac"});
        MimeType.set_rev("application", "vnd.dynageo", new String[]{"geo"});
        MimeType.set_rev("application", "vnd.ecowin.chart", new String[]{"mag"});
        MimeType.set_rev("application", "vnd.enliven", new String[]{"nml"});
        MimeType.set_rev("application", "vnd.epson.esf", new String[]{"esf"});
        MimeType.set_rev("application", "vnd.epson.msf", new String[]{"msf"});
        MimeType.set_rev("application", "vnd.epson.quickanime", new String[]{"qam"});
        MimeType.set_rev("application", "vnd.epson.salt", new String[]{"slt"});
        MimeType.set_rev("application", "vnd.epson.ssf", new String[]{"ssf"});
        MimeType.set_rev("application", "vnd.ericsson.quickcall", new String[]{"qca", "qcall"});
        MimeType.set_rev("application", "vnd.eszigno3+xml", new String[]{"et3", "es3"});
        MimeType.set_rev("application", "vnd.ezpix-album", new String[]{"ez2"});
        MimeType.set_rev("application", "vnd.ezpix-package", new String[]{"ez3"});
        MimeType.set_rev("application", "vnd.fdf", new String[]{"fdf"});
        MimeType.set_rev("application", "vnd.fdsn.mseed", new String[]{"mseed", "msd"});
        MimeType.set_rev("application", "vnd.fluxtime.clip", new String[]{"ftc"});
        MimeType.set_rev("application", "vnd.font-fontforge-sfd", new String[]{"sfd"});
        MimeType.set_rev("application", "vnd.framemaker", new String[]{"fm"});
        MimeType.set_rev("application", "vnd.frogans.fnc", new String[]{"fnc"});
        MimeType.set_rev("application", "vnd.frogans.ltf", new String[]{"ltf"});
        MimeType.set_rev("application", "vnd.fsc.weblaunch", new String[]{"fsc"});
        MimeType.set_rev("application", "vnd.fsdn.seed", new String[]{"dataless", "seed"});
        MimeType.set_rev("application", "vnd.fujitsu.oasys", new String[]{"oas"});
        MimeType.set_rev("application", "vnd.fujitsu.oasys2", new String[]{"oa2"});
        MimeType.set_rev("application", "vnd.fujitsu.oasys3", new String[]{"oa3"});
        MimeType.set_rev("application", "vnd.fujitsu.oasysgp", new String[]{"fg5"});
        MimeType.set_rev("application", "vnd.fujitsu.oasysprs", new String[]{"bh2"});
        MimeType.set_rev("application", "vnd.fujixerox.ddd", new String[]{"ddd"});
        MimeType.set_rev("application", "vnd.fujixerox.docuworks", new String[]{"xdw"});
        MimeType.set_rev("application", "vnd.fujixerox.docuworks.binder", new String[]{"xbd"});
        MimeType.set_rev("application", "vnd.fuzzysheet", new String[]{"fzs"});
        MimeType.set_rev("application", "vnd.genomatix.tuxedo", new String[]{"txd"});
        MimeType.set_rev("application", "vnd.geogebra.file", new String[]{"ggb"});
        MimeType.set_rev("application", "vnd.geogebra.tool", new String[]{"ggt"});
        MimeType.set_rev("application", "vnd.geometry-explorer", new String[]{"gex", "gre"});
        MimeType.set_rev("application", "vnd.geonext", new String[]{"gxt"});
        MimeType.set_rev("application", "vnd.geoplan", new String[]{"g2w"});
        MimeType.set_rev("application", "vnd.geospace", new String[]{"g3w"});
        MimeType.set_rev("application", "vnd.google-earth.kml+xml", new String[]{"kml"});
        MimeType.set_rev("application", "vnd.google-earth.kmz", new String[]{"kmz"});
        MimeType.set_rev("application", "vnd.grafeq", new String[]{"gqs", "gqf"});
        MimeType.set_rev("application", "vnd.groove-account", new String[]{"gac"});
        MimeType.set_rev("application", "vnd.groove-help", new String[]{"ghf"});
        MimeType.set_rev("application", "vnd.groove-identity-message", new String[]{"gim"});
        MimeType.set_rev("application", "vnd.groove-injector", new String[]{"grv"});
        MimeType.set_rev("application", "vnd.groove-tool-message", new String[]{"gtm"});
        MimeType.set_rev("application", "vnd.groove-tool-template", new String[]{"tpl"});
        MimeType.set_rev("application", "vnd.groove-vcard", new String[]{"vcg"});
        MimeType.set_rev("application", "vnd.hbci", new String[]{"hbci", "upa", "bpd", "kom", "pkd", "hbc"});
        MimeType.set_rev("application", "vnd.hhe.lesson-player", new String[]{"les"});
        MimeType.set_rev("application", "vnd.hp-HPGL", new String[]{"hpgl"});
        MimeType.set_rev("application", "vnd.hp-PCL", new String[]{"pcl"});
        MimeType.set_rev("application", "vnd.hp-hpid", new String[]{"hpi", "hpid"});
        MimeType.set_rev("application", "vnd.hp-hps", new String[]{"hps"});
        MimeType.set_rev("application", "vnd.hp-jlyt", new String[]{"jlt"});
        MimeType.set_rev("application", "vnd.hydrostatix.sof-data", new String[]{"sfd-hdstx"});
        MimeType.set_rev("application", "vnd.hzn-3d-crossword", new String[]{"x3d"});
        MimeType.set_rev("application", "vnd.ibm.MiniPay", new String[]{"mpy"});
        MimeType.set_rev("application", "vnd.ibm.electronic-media", new String[]{"emm"});
        MimeType.set_rev("application", "vnd.ibm.modcap", new String[]{"afp", "list3820", "pseg3820", "listafp"});
        MimeType.set_rev("application", "vnd.ibm.rights-management", new String[]{"irm"});
        MimeType.set_rev("application", "vnd.ibm.secure-container", new String[]{"sc"});
        MimeType.set_rev("application", "vnd.iccprofile", new String[]{"icc", "icm"});
        MimeType.set_rev("application", "vnd.igloader", new String[]{"igl"});
        MimeType.set_rev("application", "vnd.immervision-ivp", new String[]{"ivp"});
        MimeType.set_rev("application", "vnd.immervision-ivu", new String[]{"ivu"});
        MimeType.set_rev("application", "vnd.intercon.formnet", new String[]{"xpw", "xpx"});
        MimeType.set_rev("application", "vnd.intu.qbo", new String[]{"qbo"});
        MimeType.set_rev("application", "vnd.intu.qfx", new String[]{"qfx"});
        MimeType.set_rev("application", "vnd.ipunplugged.rcprofile", new String[]{"rcprofile"});
        MimeType.set_rev("application", "vnd.irepository.package+xml", new String[]{"irp"});
        MimeType.set_rev("application", "vnd.is-xpr", new String[]{"xpr"});
        MimeType.set_rev("application", "vnd.jam", new String[]{"jam"});
        MimeType.set_rev("application", "vnd.jcp.javame.midlet-rms", new String[]{"rms"});
        MimeType.set_rev("application", "vnd.jisp", new String[]{"jisp"});
        MimeType.set_rev("application", "vnd.joost.joda-archive", new String[]{"joda"});
        MimeType.set_rev("application", "vnd.kahootz", new String[]{"ktr", "ktz"});
        MimeType.set_rev("application", "vnd.kde.karbon", new String[]{"karbon"});
        MimeType.set_rev("application", "vnd.kde.kchart", new String[]{"chrt"});
        MimeType.set_rev("application", "vnd.kde.kformula", new String[]{"kfo"});
        MimeType.set_rev("application", "vnd.kde.kivio", new String[]{"flw"});
        MimeType.set_rev("application", "vnd.kde.kontour", new String[]{"kon"});
        MimeType.set_rev("application", "vnd.kde.kpresenter", new String[]{"kpr", "kpt"});
        MimeType.set_rev("application", "vnd.kde.kspread", new String[]{"ksp"});
        MimeType.set_rev("application", "vnd.kde.kword", new String[]{"kwd", "kwt"});
        MimeType.set_rev("application", "vnd.kenameaapp", new String[]{"htke"});
        MimeType.set_rev("application", "vnd.kidspiration", new String[]{"kia"});
        MimeType.set_rev("application", "vnd.koan", new String[]{"skm", "skp", "skd", "skt"});
        MimeType.set_rev("application", "vnd.kodak-descriptor", new String[]{"sse"});
        MimeType.set_rev("application", "vnd.llamagraphics.life-balance.desktop", new String[]{"lbd"});
        MimeType.set_rev("application", "vnd.llamagraphics.life-balance.exchange+xml", new String[]{"lbe"});
        MimeType.set_rev("application", "vnd.lotus-1-2-3", new String[]{"wk4", "123", "wk3", "wk1"});
        MimeType.set_rev("application", "vnd.lotus-approach", new String[]{"vew", "apr"});
        MimeType.set_rev("application", "vnd.lotus-freelance", new String[]{"pre", "prz"});
        MimeType.set_rev("application", "vnd.lotus-notes", new String[]{"ns2", "ns4", "ns3", "ndl", "nsf", "nsh", "nsg", "ntf"});
        MimeType.set_rev("application", "vnd.lotus-organizer", new String[]{"or2", "org", "or3"});
        MimeType.set_rev("application", "vnd.lotus-screencam", new String[]{"scm"});
        MimeType.set_rev("application", "vnd.lotus-wordpro", new String[]{"lwp", "sam"});
        MimeType.set_rev("application", "vnd.macports.portpkg", new String[]{"portpkg"});
        MimeType.set_rev("application", "vnd.marlin.drm.mdcf", new String[]{"mdc"});
        MimeType.set_rev("application", "vnd.mcd", new String[]{"mcd"});
        MimeType.set_rev("application", "vnd.medcalcdata", new String[]{"mc1"});
        MimeType.set_rev("application", "vnd.mediastation.cdkey", new String[]{"cdkey"});
        MimeType.set_rev("application", "vnd.mfmp", new String[]{"mfm"});
        MimeType.set_rev("application", "vnd.micrografx.flo", new String[]{"flo"});
        MimeType.set_rev("application", "vnd.micrografx.igx", new String[]{"igx"});
        MimeType.set_rev("application", "vnd.mif", new String[]{"mif"});
        MimeType.set_rev("application", "vnd.mophun.application", new String[]{"mpn"});
        MimeType.set_rev("application", "vnd.mophun.certificate", new String[]{"mpc"});
        MimeType.set_rev("application", "vnd.mozilla.xul+xml", new String[]{"xul"});
        MimeType.set_rev("application", "vnd.ms-artgalry", new String[]{"cil"});
        MimeType.set_rev("application", "vnd.ms-asf", new String[]{"asf"});
        MimeType.set_rev("application", "vnd.ms-cab-compressed", new String[]{"cab"});
        MimeType.set_rev("application", "vnd.ms-excel", new String[]{"xlb", "xls", "xlt"});
        MimeType.set_rev("application", "vnd.ms-excel.addin.macroEnabled.12", new String[]{"xlam"});
        MimeType.set_rev("application", "vnd.ms-excel.sheet.binary.macroEnabled.12", new String[]{"xlsb"});
        MimeType.set_rev("application", "vnd.ms-excel.sheet.macroEnabled.12", new String[]{"xlsm"});
        MimeType.set_rev("application", "vnd.ms-excel.template.macroEnabled.12", new String[]{"xltm"});
        MimeType.set_rev("application", "vnd.ms-fontobject", new String[]{"eot"});
        MimeType.set_rev("application", "vnd.ms-htmlhelp", new String[]{"chm"});
        MimeType.set_rev("application", "vnd.ms-ims", new String[]{"ims"});
        MimeType.set_rev("application", "vnd.ms-lrm", new String[]{"lrm"});
        MimeType.set_rev("application", "vnd.ms-pki.seccat", new String[]{"cat"});
        MimeType.set_rev("application", "vnd.ms-pki.stl", new String[]{"stl"});
        MimeType.set_rev("application", "vnd.ms-powerpoint", new String[]{"pps", "ppt"});
        MimeType.set_rev("application", "vnd.ms-powerpoint.addin.macroEnabled.12", new String[]{"ppam"});
        MimeType.set_rev("application", "vnd.ms-powerpoint.presentation.macroEnabled.12", new String[]{"pptm"});
        MimeType.set_rev("application", "vnd.ms-powerpoint.slide.macroEnabled.12", new String[]{"sldm"});
        MimeType.set_rev("application", "vnd.ms-powerpoint.slideshow.macroEnabled.12", new String[]{"ppsm"});
        MimeType.set_rev("application", "vnd.ms-powerpoint.template.macroEnabled.12", new String[]{"potm"});
        MimeType.set_rev("application", "vnd.ms-project", new String[]{"mpp"});
        MimeType.set_rev("application", "vnd.ms-tnef", new String[]{"tnf", "tnef"});
        MimeType.set_rev("application", "vnd.ms-word.document.macroEnabled.12", new String[]{"docm"});
        MimeType.set_rev("application", "vnd.ms-word.template.macroEnabled.12", new String[]{"dotm"});
        MimeType.set_rev("application", "vnd.ms-works", new String[]{"wps", "wcm", "wks", "wdb"});
        MimeType.set_rev("application", "vnd.ms-wpl", new String[]{"wpl"});
        MimeType.set_rev("application", "vnd.ms-xpsdocument", new String[]{"xps"});
        MimeType.set_rev("application", "vnd.mseq", new String[]{"mseq"});
        MimeType.set_rev("application", "vnd.multiad.creator", new String[]{"crtr"});
        MimeType.set_rev("application", "vnd.multiad.creator.cif", new String[]{"cif"});
        MimeType.set_rev("application", "vnd.musician", new String[]{"mus"});
        MimeType.set_rev("application", "vnd.muvee.style", new String[]{"msty"});
        MimeType.set_rev("application", "vnd.nervana", new String[]{"kcm", "request", "entity", "bkm"});
        MimeType.set_rev("application", "vnd.neurolanguage.nlu", new String[]{"nlu"});
        MimeType.set_rev("application", "vnd.noblenet-directory", new String[]{"nnd"});
        MimeType.set_rev("application", "vnd.noblenet-sealer", new String[]{"nns"});
        MimeType.set_rev("application", "vnd.noblenet-web", new String[]{"nnw"});
        MimeType.set_rev("application", "vnd.nokia.n-gage.ac+xml", new String[]{"ac"});
        MimeType.set_rev("application", "vnd.nokia.n-gage.data", new String[]{"ngdat"});
        MimeType.set_rev("application", "vnd.nokia.n-gage.symbian.install", new String[]{"n-gage"});
        MimeType.set_rev("application", "vnd.nokia.radio-preset", new String[]{"rpst"});
        MimeType.set_rev("application", "vnd.nokia.radio-presets", new String[]{"rpss"});
        MimeType.set_rev("application", "vnd.novadigm.EDM", new String[]{"edm"});
        MimeType.set_rev("application", "vnd.novadigm.EDX", new String[]{"edx"});
        MimeType.set_rev("application", "vnd.novadigm.EXT", new String[]{"ext"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.chart", new String[]{"odc"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.chart-template", new String[]{"otc"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.database", new String[]{"odb"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.formula", new String[]{"odf"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.formula-template", new String[]{"otf"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.graphics", new String[]{"odg"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.graphics-template", new String[]{"otg"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.image", new String[]{"odi"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.image-template", new String[]{"oti"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.presentation", new String[]{"odp"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.presentation-template", new String[]{"otp"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.spreadsheet", new String[]{"ods"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.spreadsheet-template", new String[]{"ots"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.text", new String[]{"odt"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.text-master", new String[]{"odm"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.text-template", new String[]{"ott"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.text-web", new String[]{"oth"});
        MimeType.set_rev("application", "vnd.olpc-sugar", new String[]{"xo"});
        MimeType.set_rev("application", "vnd.oma.dd+xml", new String[]{"dd"});
        MimeType.set_rev("application", "vnd.oma.dd2+xml", new String[]{"dd2"});
        MimeType.set_rev("application", "vnd.oma.drm.content", new String[]{"dcf"});
        MimeType.set_rev("application", "vnd.oma.drm.dcf", new String[]{"o4v", "o4a"});
        MimeType.set_rev("application", "vnd.oma.drm.message", new String[]{"dm"});
        MimeType.set_rev("application", "vnd.oma.drm.rights+wbxml", new String[]{"drc"});
        MimeType.set_rev("application", "vnd.oma.drm.rights+xml", new String[]{"dr"});
        MimeType.set_rev("application", "vnd.openofficeorg.extension", new String[]{"oxt"});
        MimeType.set_rev("application", "vnd.openxmlformats-officedocument.presentationml.presentation", new String[]{"pptx"});
        MimeType.set_rev("application", "vnd.openxmlformats-officedocument.presentationml.slide", new String[]{"sldx"});
        MimeType.set_rev("application", "vnd.openxmlformats-officedocument.presentationml.slideshow", new String[]{"ppsx"});
        MimeType.set_rev("application", "vnd.openxmlformats-officedocument.presentationml.template", new String[]{"potx"});
        MimeType.set_rev("application", "vnd.openxmlformats-officedocument.spreadsheetml.sheet", new String[]{"xlsx"});
        MimeType.set_rev("application", "vnd.openxmlformats-officedocument.spreadsheetml.template", new String[]{"xltx"});
        MimeType.set_rev("application", "vnd.openxmlformats-officedocument.wordprocessingml.document", new String[]{"docx"});
        MimeType.set_rev("application", "vnd.openxmlformats-officedocument.wordprocessingml.template", new String[]{"dotx"});
        MimeType.set_rev("application", "vnd.osa.netdeploy", new String[]{"ndc"});
        MimeType.set_rev("application", "vnd.osgi.dp", new String[]{"dp"});
        MimeType.set_rev("application", "vnd.palm", new String[]{"oprc", "prc", "pqa", "pdb"});
        MimeType.set_rev("application", "vnd.pg.format", new String[]{"str"});
        MimeType.set_rev("application", "vnd.pg.osasli", new String[]{"ei6"});
        MimeType.set_rev("application", "vnd.piaccess.application-license", new String[]{"pil"});
        MimeType.set_rev("application", "vnd.picsel", new String[]{"efif"});
        MimeType.set_rev("application", "vnd.pocketlearn", new String[]{"plf"});
        MimeType.set_rev("application", "vnd.powerbuilder6", new String[]{"pbd"});
        MimeType.set_rev("application", "vnd.preminet", new String[]{"preminet"});
        MimeType.set_rev("application", "vnd.previewsystems.box", new String[]{"box", "vbox"});
        MimeType.set_rev("application", "vnd.proteus.magazine", new String[]{"mgz"});
        MimeType.set_rev("application", "vnd.publishare-delta-tree", new String[]{"qps"});
        MimeType.set_rev("application", "vnd.pvi.ptid1", new String[]{"ptid"});
        MimeType.set_rev("application", "vnd.qualcomm.brew-app-res", new String[]{"bar"});
        MimeType.set_rev("application", "vnd.realvnc.bed", new String[]{"bed"});
        MimeType.set_rev("application", "vnd.recordare.musicxml", new String[]{"mxl"});
        MimeType.set_rev("application", "vnd.rim.cod", new String[]{"cod"});
        MimeType.set_rev("application", "vnd.route66.link66+xml", new String[]{"link66"});
        MimeType.set_rev("application", "vnd.sailingtracker.track", new String[]{"st"});
        MimeType.set_rev("application", "vnd.scribus", new String[]{"scd", "slaz", "sla"});
        MimeType.set_rev("application", "vnd.sealed.3df", new String[]{"s3df"});
        MimeType.set_rev("application", "vnd.sealed.csf", new String[]{"scsf"});
        MimeType.set_rev("application", "vnd.sealed.doc", new String[]{"sdoc", "s1w", "sdo"});
        MimeType.set_rev("application", "vnd.sealed.eml", new String[]{"seml", "sem"});
        MimeType.set_rev("application", "vnd.sealed.mht", new String[]{"smh", "smht"});
        MimeType.set_rev("application", "vnd.sealed.ppt", new String[]{"s1p", "sppt"});
        MimeType.set_rev("application", "vnd.sealed.tiff", new String[]{"stif"});
        MimeType.set_rev("application", "vnd.sealed.xls", new String[]{"s1e", "sxls", "sxl"});
        MimeType.set_rev("application", "vnd.sealedmedia.softseal.html", new String[]{"stml", "s1h"});
        MimeType.set_rev("application", "vnd.sealedmedia.softseal.pdf", new String[]{"s1a", "spdf", "spd"});
        MimeType.set_rev("application", "vnd.seemail", new String[]{"see"});
        MimeType.set_rev("application", "vnd.sema", new String[]{"sema"});
        MimeType.set_rev("application", "vnd.semd", new String[]{"semd"});
        MimeType.set_rev("application", "vnd.semf", new String[]{"semf"});
        MimeType.set_rev("application", "vnd.shana.informed.formdata", new String[]{"ifm"});
        MimeType.set_rev("application", "vnd.shana.informed.formtemplate", new String[]{"itp"});
        MimeType.set_rev("application", "vnd.shana.informed.interchange", new String[]{"iif"});
        MimeType.set_rev("application", "vnd.shana.informed.package", new String[]{"ipk"});
        MimeType.set_rev("application", "vnd.smaf", new String[]{"mmf"});
        MimeType.set_rev("application", "vnd.smart.teacher", new String[]{"teacher"});
        MimeType.set_rev("application", "vnd.software602.filler.form+xml", new String[]{"fo"});
        MimeType.set_rev("application", "vnd.software602.filler.form-xml-zip", new String[]{"zfo"});
        MimeType.set_rev("application", "vnd.solent.sdkm+xml", new String[]{"sdkd", "sdkm"});
        MimeType.set_rev("application", "vnd.spotfire.dxp", new String[]{"dxp"});
        MimeType.set_rev("application", "vnd.spotfire.sfs", new String[]{"sfs"});
        MimeType.set_rev("application", "vnd.stardivision.calc", new String[]{"sdc"});
        MimeType.set_rev("application", "vnd.stardivision.chart", new String[]{"sds"});
        MimeType.set_rev("application", "vnd.stardivision.draw", new String[]{"sda"});
        MimeType.set_rev("application", "vnd.stardivision.impress", new String[]{"sdd"});
        MimeType.set_rev("application", "vnd.stardivision.math", new String[]{"sdf"});
        MimeType.set_rev("application", "vnd.stardivision.writer", new String[]{"sdw"});
        MimeType.set_rev("application", "vnd.stardivision.writer-global", new String[]{"sgl"});
        MimeType.set_rev("application", "vnd.sun.wadl+xml", new String[]{"wadl"});
        MimeType.set_rev("application", "vnd.sun.xml.calc", new String[]{"sxc"});
        MimeType.set_rev("application", "vnd.sun.xml.calc.template", new String[]{"stc"});
        MimeType.set_rev("application", "vnd.sun.xml.draw", new String[]{"sxd"});
        MimeType.set_rev("application", "vnd.sun.xml.draw.template", new String[]{"std"});
        MimeType.set_rev("application", "vnd.sun.xml.impress", new String[]{"sxi"});
        MimeType.set_rev("application", "vnd.sun.xml.impress.template", new String[]{"sti"});
        MimeType.set_rev("application", "vnd.sun.xml.math", new String[]{"sxm"});
        MimeType.set_rev("application", "vnd.sun.xml.writer", new String[]{"sxw"});
        MimeType.set_rev("application", "vnd.sun.xml.writer.global", new String[]{"sxg"});
        MimeType.set_rev("application", "vnd.sun.xml.writer.template", new String[]{"stw"});
        MimeType.set_rev("application", "vnd.sus-calendar", new String[]{"sus", "susp"});
        MimeType.set_rev("application", "vnd.symbian.install", new String[]{"sis"});
        MimeType.set_rev("application", "vnd.syncml+xml", new String[]{"xsm"});
        MimeType.set_rev("application", "vnd.syncml.dm+wbxml", new String[]{"bdm"});
        MimeType.set_rev("application", "vnd.syncml.dm+xml", new String[]{"xdm"});
        MimeType.set_rev("application", "vnd.tao.intent-module-archive", new String[]{"tao"});
        MimeType.set_rev("application", "vnd.tmobile-livetv", new String[]{"tmo"});
        MimeType.set_rev("application", "vnd.trid.tpt", new String[]{"tpt"});
        MimeType.set_rev("application", "vnd.triscape.mxs", new String[]{"mxs"});
        MimeType.set_rev("application", "vnd.trueapp", new String[]{"tra"});
        MimeType.set_rev("application", "vnd.ufdl", new String[]{"frm", "ufd", "ufdl"});
        MimeType.set_rev("application", "vnd.uiq.theme", new String[]{"utz"});
        MimeType.set_rev("application", "vnd.umajin", new String[]{"umj"});
        MimeType.set_rev("application", "vnd.unity", new String[]{"unityweb"});
        MimeType.set_rev("application", "vnd.uoml+xml", new String[]{"uoml", "uo"});
        MimeType.set_rev("application", "vnd.vcx", new String[]{"vcx"});
        MimeType.set_rev("application", "vnd.vd-study", new String[]{"mxi", "model-inter", "study-inter"});
        MimeType.set_rev("application", "vnd.vectorworks", new String[]{"vwx"});
        MimeType.set_rev("application", "vnd.vidsoft.vidconference", new String[]{"vsc"});
        MimeType.set_rev("application", "vnd.visio", new String[]{"vsw", "vsd", "vss", "vst"});
        MimeType.set_rev("application", "vnd.visionary", new String[]{"vis"});
        MimeType.set_rev("application", "vnd.vsf", new String[]{"vsf"});
        MimeType.set_rev("application", "vnd.wap.mms-message", new String[]{"mms"});
        MimeType.set_rev("application", "vnd.wap.sic", new String[]{"sic"});
        MimeType.set_rev("application", "vnd.wap.slc", new String[]{"slc"});
        MimeType.set_rev("application", "vnd.wap.wbxml", new String[]{"wbxml"});
        MimeType.set_rev("application", "vnd.wap.wmlc", new String[]{"wmlc"});
        MimeType.set_rev("application", "vnd.wap.wmlscriptc", new String[]{"wmlsc"});
        MimeType.set_rev("application", "vnd.webturbo", new String[]{"wtb"});
        MimeType.set_rev("application", "vnd.wfa.wsc", new String[]{"wsc"});
        MimeType.set_rev("application", "vnd.wmc", new String[]{"wmc"});
        MimeType.set_rev("application", "vnd.wolfram.mathematica.package", new String[]{"m"});
        MimeType.set_rev("application", "vnd.wolfram.player", new String[]{"nbp"});
        MimeType.set_rev("application", "vnd.wordperfect", new String[]{"wpd"});
        MimeType.set_rev("application", "vnd.wordperfect5.1", new String[]{"wp5"});
        MimeType.set_rev("application", "vnd.wqd", new String[]{"wqd"});
        MimeType.set_rev("application", "vnd.wt.stf", new String[]{"stf"});
        MimeType.set_rev("application", "vnd.wv.csp+wbxml", new String[]{"wv"});
        MimeType.set_rev("application", "vnd.xara", new String[]{"xar"});
        MimeType.set_rev("application", "vnd.xfdl", new String[]{"xfd", "xfdl"});
        MimeType.set_rev("application", "vnd.xmpie.cpkg", new String[]{"cpkg"});
        MimeType.set_rev("application", "vnd.xmpie.dpkg", new String[]{"dpkg"});
        MimeType.set_rev("application", "vnd.xmpie.ppkg", new String[]{"ppkg"});
        MimeType.set_rev("application", "vnd.xmpie.xlim", new String[]{"xlim"});
        MimeType.set_rev("application", "vnd.yamaha.hv-dic", new String[]{"hvd"});
        MimeType.set_rev("application", "vnd.yamaha.hv-script", new String[]{"hvs"});
        MimeType.set_rev("application", "vnd.yamaha.hv-voice", new String[]{"hvp"});
        MimeType.set_rev("application", "vnd.yamaha.openscoreformat", new String[]{"osf"});
        MimeType.set_rev("application", "vnd.yamaha.smaf-audio", new String[]{"saf"});
        MimeType.set_rev("application", "vnd.yamaha.smaf-phrase", new String[]{"spf"});
        MimeType.set_rev("application", "vnd.yellowriver-custom-menu", new String[]{"cmp"});
        MimeType.set_rev("application", "vnd.zul", new String[]{"zir", "zirz"});
        MimeType.set_rev("application", "vnd.zzazz.deck+xml", new String[]{"zaz"});
        MimeType.set_rev("application", "voicexml+xml", new String[]{"vxml"});
        MimeType.set_rev("application", "watcherinfo+xml", new String[]{"wif"});
        MimeType.set_rev("application", "wsdl+xml", new String[]{"wsdl"});
        MimeType.set_rev("application", "wspolicy+xml", new String[]{"wspolicy"});
        MimeType.set_rev("application", "x-123", new String[]{"wk"});
        MimeType.set_rev("application", "x-7z-compressed", new String[]{"7z"});
        MimeType.set_rev("application", "x-abiword", new String[]{"abw"});
        MimeType.set_rev("application", "x-apple-diskimage", new String[]{"dmg"});
        MimeType.set_rev("application", "x-bcpio", new String[]{"bcpio"});
        MimeType.set_rev("application", "x-bittorrent", new String[]{"torrent"});
        MimeType.set_rev("application", "x-bzip2", new String[]{"bz2"});
        MimeType.set_rev("application", "x-cab", new String[]{"cab"});
        MimeType.set_rev("application", "x-cbr", new String[]{"cbr"});
        MimeType.set_rev("application", "x-cbz", new String[]{"cbz"});
        MimeType.set_rev("application", "x-cdf", new String[]{"cda", "cdf"});
        MimeType.set_rev("application", "x-cdlink", new String[]{"vcd"});
        MimeType.set_rev("application", "x-chess-pgn", new String[]{"pgn"});
        MimeType.set_rev("application", "x-cpio", new String[]{"cpio"});
        MimeType.set_rev("application", "x-csh", new String[]{"csh"});
        MimeType.set_rev("application", "x-debian-package", new String[]{"deb", "udeb"});
        MimeType.set_rev("application", "x-director", new String[]{"dcr", "dir", "dxr"});
        MimeType.set_rev("application", "x-dms", new String[]{"dms"});
        MimeType.set_rev("application", "x-doom", new String[]{"wad"});
        MimeType.set_rev("application", "x-dvi", new String[]{"dvi"});
        MimeType.set_rev("application", "x-font", new String[]{"pfa", "pcf", "pfb", "pcf.Z", "gsf"});
        MimeType.set_rev("application", "x-freemind", new String[]{"mm"});
        MimeType.set_rev("application", "x-futuresplash", new String[]{"spl"});
        MimeType.set_rev("application", "x-gnumeric", new String[]{"gnumeric"});
        MimeType.set_rev("application", "x-go-sgf", new String[]{"sgf"});
        MimeType.set_rev("application", "x-graphing-calculator", new String[]{"gcf"});
        MimeType.set_rev("application", "x-gtar", new String[]{"taz", "tgz", "gtar"});
        MimeType.set_rev("application", "x-gzip", new String[]{"gz", "tgz"});
        MimeType.set_rev("application", "x-hdf", new String[]{"hdf"});
        MimeType.set_rev("application", "x-httpd-eruby", new String[]{"rhtml"});
        MimeType.set_rev("application", "x-httpd-php", new String[]{"pht", "php", "phtml"});
        MimeType.set_rev("application", "x-httpd-php-source", new String[]{"phps"});
        MimeType.set_rev("application", "x-httpd-php3", new String[]{"php3"});
        MimeType.set_rev("application", "x-httpd-php3-preprocessed", new String[]{"php3p"});
        MimeType.set_rev("application", "x-httpd-php4", new String[]{"php4"});
        MimeType.set_rev("application", "x-httpd-php5", new String[]{"php5"});
        MimeType.set_rev("application", "x-ica", new String[]{"ica"});
        MimeType.set_rev("application", "x-info", new String[]{"info"});
        MimeType.set_rev("application", "x-internet-signup", new String[]{"isp", "ins"});
        MimeType.set_rev("application", "x-iphone", new String[]{"iii"});
        MimeType.set_rev("application", "x-iso9660-image", new String[]{"iso"});
        MimeType.set_rev("application", "x-jam", new String[]{"jam"});
        MimeType.set_rev("application", "x-java-archive", new String[]{"jar"});
        MimeType.set_rev("application", "x-java-jnlp-file", new String[]{"jnlp"});
        MimeType.set_rev("application", "x-java-pack200", new String[]{"pack"});
        MimeType.set_rev("application", "x-jmol", new String[]{"jmz"});
        MimeType.set_rev("application", "x-kchart", new String[]{"chrt"});
        MimeType.set_rev("application", "x-killustrator", new String[]{"kil"});
        MimeType.set_rev("application", "x-koan", new String[]{"skm", "skp", "skd", "skt"});
        MimeType.set_rev("application", "x-kpresenter", new String[]{"kpr", "kpt"});
        MimeType.set_rev("application", "x-kspread", new String[]{"ksp"});
        MimeType.set_rev("application", "x-kword", new String[]{"kwd", "kwt"});
        MimeType.set_rev("application", "x-latex", new String[]{"latex"});
        MimeType.set_rev("application", "x-lha", new String[]{"lha"});
        MimeType.set_rev("application", "x-lyx", new String[]{"lyx"});
        MimeType.set_rev("application", "x-lzh", new String[]{"lzh"});
        MimeType.set_rev("application", "x-lzx", new String[]{"lzx"});
        MimeType.set_rev("application", "x-maker", new String[]{"frm", "fm", "fbdoc", "frame", "maker", "book", "fb"});
        MimeType.set_rev("application", "x-mif", new String[]{"mif"});
        MimeType.set_rev("application", "x-ms-wmd", new String[]{"wmd"});
        MimeType.set_rev("application", "x-ms-wmz", new String[]{"wmz"});
        MimeType.set_rev("application", "x-msdos-program", new String[]{"com", "dll", "bat", "exe"});
        MimeType.set_rev("application", "x-msi", new String[]{"msi"});
        MimeType.set_rev("application", "x-netcdf", new String[]{"nc", "cdf"});
        MimeType.set_rev("application", "x-ns-proxy-autoconfig", new String[]{"dat", "pac"});
        MimeType.set_rev("application", "x-nwc", new String[]{"nwc"});
        MimeType.set_rev("application", "x-object", new String[]{"o"});
        MimeType.set_rev("application", "x-oz-application", new String[]{"oza"});
        MimeType.set_rev("application", "x-perl", new String[]{"pl"});
        MimeType.set_rev("application", "x-pkcs7-certreqresp", new String[]{"p7r"});
        MimeType.set_rev("application", "x-pkcs7-crl", new String[]{"crl"});
        MimeType.set_rev("application", "x-python-code", new String[]{"pyc", "pyo"});
        MimeType.set_rev("application", "x-qgis", new String[]{"shp", "shx", "qgs"});
        MimeType.set_rev("application", "x-quicktimeplayer", new String[]{"qtl"});
        MimeType.set_rev("application", "x-redhat-package-manager", new String[]{"rpm"});
        MimeType.set_rev("application", "x-rpm", new String[]{"rpm"});
        MimeType.set_rev("application", "x-ruby", new String[]{"rb"});
        MimeType.set_rev("application", "x-sh", new String[]{"sh"});
        MimeType.set_rev("application", "x-shar", new String[]{"shar"});
        MimeType.set_rev("application", "x-shockwave-flash", new String[]{"swf", "swfl"});
        MimeType.set_rev("application", "x-silverlight", new String[]{"scr"});
        MimeType.set_rev("application", "x-stuffit", new String[]{"sit", "sitx"});
        MimeType.set_rev("application", "x-sv4cpio", new String[]{"sv4cpio"});
        MimeType.set_rev("application", "x-sv4crc", new String[]{"sv4crc"});
        MimeType.set_rev("application", "x-tar", new String[]{"tar"});
        MimeType.set_rev("application", "x-tcl", new String[]{"tcl"});
        MimeType.set_rev("application", "x-tex", new String[]{"tex"});
        MimeType.set_rev("application", "x-tex-gf", new String[]{"gf"});
        MimeType.set_rev("application", "x-tex-pk", new String[]{"pk"});
        MimeType.set_rev("application", "x-texinfo", new String[]{"texinfo", "texi"});
        MimeType.set_rev("application", "x-trash", new String[]{"old", "bak", "%", "~", "sik"});
        MimeType.set_rev("application", "x-troff", new String[]{"t", "tr", "roff"});
        MimeType.set_rev("application", "x-troff-man", new String[]{"3", "2", "1", "7", "6", "5", "4", "8", "man"});
        MimeType.set_rev("application", "x-troff-me", new String[]{"me"});
        MimeType.set_rev("application", "x-troff-ms", new String[]{"ms"});
        MimeType.set_rev("application", "x-ustar", new String[]{"ustar"});
        MimeType.set_rev("application", "x-wais-source", new String[]{"src"});
        MimeType.set_rev("application", "x-wingz", new String[]{"wz"});
        MimeType.set_rev("application", "x-x509-ca-cert", new String[]{"crt"});
        MimeType.set_rev("application", "x-xcf", new String[]{"xcf"});
        MimeType.set_rev("application", "x-xfig", new String[]{"fig"});
        MimeType.set_rev("application", "x-xpinstall", new String[]{"xpi"});
        MimeType.set_rev("application", "x-xz", new String[]{"xz"});
        MimeType.set_rev("application", "xcap-att+xml", new String[]{"xav"});
        MimeType.set_rev("application", "xcap-caps+xml", new String[]{"xca"});
        MimeType.set_rev("application", "xcap-el+xml", new String[]{"xel"});
        MimeType.set_rev("application", "xcap-error+xml", new String[]{"xer"});
        MimeType.set_rev("application", "xcap-ns+xml", new String[]{"xns"});
        MimeType.set_rev("application", "xhtml+xml", new String[]{"xhtm", "xhtml", "xht"});
        MimeType.set_rev("application", "xml", new String[]{"xsl", "xsd", "xml"});
        MimeType.set_rev("application", "xml-dtd", new String[]{"dtd"});
        MimeType.set_rev("application", "xop+xml", new String[]{"xop"});
        MimeType.set_rev("application", "xslt+xml", new String[]{"xsl", "xslt"});
        MimeType.set_rev("application", "xspf+xml", new String[]{"xspf"});
        MimeType.set_rev("application", "xv+xml", new String[]{"xvm", "xhvml", "mxml", "xvml"});
        MimeType.set_rev("application", "zip", new String[]{"zip"});
        MimeType.set_rev("audio", "32kadpcm", new String[]{"726"});
        MimeType.set_rev("audio", "AMR", new String[]{"amr"});
        MimeType.set_rev("audio", "AMR-WB", new String[]{"awb"});
        MimeType.set_rev("audio", "ATRAC-ADVANCED-LOSSLESS", new String[]{"aal"});
        MimeType.set_rev("audio", "ATRAC-X", new String[]{"atx"});
        MimeType.set_rev("audio", "ATRAC3", new String[]{"aa3", "at3", "omg"});
        MimeType.set_rev("audio", "EVRC", new String[]{"evc"});
        MimeType.set_rev("audio", "EVRCB", new String[]{"evb"});
        MimeType.set_rev("audio", "EVRCWB", new String[]{"evw"});
        MimeType.set_rev("audio", "L16", new String[]{"l16"});
        MimeType.set_rev("audio", "SMV", new String[]{"smv"});
        MimeType.set_rev("audio", "ac3", new String[]{"ac3"});
        MimeType.set_rev("audio", "amr", new String[]{"amr"});
        MimeType.set_rev("audio", "amr-wb", new String[]{"awb"});
        MimeType.set_rev("audio", "annodex", new String[]{"axa"});
        MimeType.set_rev("audio", "basic", new String[]{"au", "snd"});
        MimeType.set_rev("audio", "dls", new String[]{"dls"});
        MimeType.set_rev("audio", "flac", new String[]{"flac"});
        MimeType.set_rev("audio", "iLBC", new String[]{"lbc"});
        MimeType.set_rev("audio", "midi", new String[]{"midi", "kar", "mid"});
        MimeType.set_rev("audio", "mobile-xmf", new String[]{"mxmf"});
        MimeType.set_rev("audio", "mpeg", new String[]{"m4a", "mp1", "mp2", "mpga", "mp3", "mpega"});
        MimeType.set_rev("audio", "mpegurl", new String[]{"m3u"});
        MimeType.set_rev("audio", "ogg", new String[]{"oga", "spx", "ogg"});
        MimeType.set_rev("audio", "prs.sid", new String[]{"sid", "psid"});
        MimeType.set_rev("audio", "qcelp", new String[]{"qcp"});
        MimeType.set_rev("audio", "vnd.audikoz", new String[]{"koz"});
        MimeType.set_rev("audio", "vnd.digital-winds", new String[]{"eol"});
        MimeType.set_rev("audio", "vnd.dolby.mlp", new String[]{"mlp"});
        MimeType.set_rev("audio", "vnd.dts", new String[]{"dts"});
        MimeType.set_rev("audio", "vnd.dts.hd", new String[]{"dtshd"});
        MimeType.set_rev("audio", "vnd.everad.plj", new String[]{"plj"});
        MimeType.set_rev("audio", "vnd.lucent.voice", new String[]{"lvp"});
        MimeType.set_rev("audio", "vnd.ms-playready.media.pya", new String[]{"pya"});
        MimeType.set_rev("audio", "vnd.nortel.vbk", new String[]{"vbk"});
        MimeType.set_rev("audio", "vnd.nuera.ecelp4800", new String[]{"ecelp4800"});
        MimeType.set_rev("audio", "vnd.nuera.ecelp7470", new String[]{"ecelp7470"});
        MimeType.set_rev("audio", "vnd.nuera.ecelp9600", new String[]{"ecelp9600"});
        MimeType.set_rev("audio", "vnd.sealedmedia.softseal.mpeg", new String[]{"smp3", "smp", "s1m"});
        MimeType.set_rev("audio", "x-aiff", new String[]{"aifc", "aif", "aiff"});
        MimeType.set_rev("audio", "x-gsm", new String[]{"gsm"});
        MimeType.set_rev("audio", "x-mod", new String[]{"med", "669", "m15", "ult", "mod", "mtm", "uni"});
        MimeType.set_rev("audio", "x-mpegurl", new String[]{"m3u"});
        MimeType.set_rev("audio", "x-ms-wax", new String[]{"wax"});
        MimeType.set_rev("audio", "x-ms-wma", new String[]{"wma"});
        MimeType.set_rev("audio", "x-pn-realaudio", new String[]{"ra", "rm", "ram"});
        MimeType.set_rev("audio", "x-realaudio", new String[]{"ra"});
        MimeType.set_rev("audio", "x-s3m", new String[]{"s3m"});
        MimeType.set_rev("audio", "x-scpls", new String[]{"pls"});
        MimeType.set_rev("audio", "x-sd2", new String[]{"sd2"});
        MimeType.set_rev("audio", "x-stm", new String[]{"stm"});
        MimeType.set_rev("audio", "x-wav", new String[]{"wav"});
        MimeType.set_rev("chemical", "x-alchemy", new String[]{"alc"});
        MimeType.set_rev("chemical", "x-cache", new String[]{"cac", "cache"});
        MimeType.set_rev("chemical", "x-cache-csf", new String[]{"csf"});
        MimeType.set_rev("chemical", "x-cactvs-binary", new String[]{"ctab", "cascii", "cbin"});
        MimeType.set_rev("chemical", "x-cdx", new String[]{"cdx"});
        MimeType.set_rev("chemical", "x-cerius", new String[]{"cer"});
        MimeType.set_rev("chemical", "x-chem3d", new String[]{"c3d"});
        MimeType.set_rev("chemical", "x-chemdraw", new String[]{"chm"});
        MimeType.set_rev("chemical", "x-cif", new String[]{"cif"});
        MimeType.set_rev("chemical", "x-cmdf", new String[]{"cmdf"});
        MimeType.set_rev("chemical", "x-cml", new String[]{"cml"});
        MimeType.set_rev("chemical", "x-compass", new String[]{"cpa"});
        MimeType.set_rev("chemical", "x-crossfire", new String[]{"bsd"});
        MimeType.set_rev("chemical", "x-csml", new String[]{"csml", "csm"});
        MimeType.set_rev("chemical", "x-ctx", new String[]{"ctx"});
        MimeType.set_rev("chemical", "x-cxf", new String[]{"cxf", "cef"});
        MimeType.set_rev("chemical", "x-embl-dl-nucleotide", new String[]{"embl", "emb"});
        MimeType.set_rev("chemical", "x-galactic-spc", new String[]{"spc"});
        MimeType.set_rev("chemical", "x-gamess-input", new String[]{"inp", "gamin", "gam"});
        MimeType.set_rev("chemical", "x-gaussian-checkpoint", new String[]{"fchk", "fch"});
        MimeType.set_rev("chemical", "x-gaussian-cube", new String[]{"cub"});
        MimeType.set_rev("chemical", "x-gaussian-input", new String[]{"gau", "gjc", "gjf"});
        MimeType.set_rev("chemical", "x-gaussian-log", new String[]{"gal"});
        MimeType.set_rev("chemical", "x-gcg8-sequence", new String[]{"gcg"});
        MimeType.set_rev("chemical", "x-genbank", new String[]{"gen"});
        MimeType.set_rev("chemical", "x-hin", new String[]{"hin"});
        MimeType.set_rev("chemical", "x-isostar", new String[]{"ist", "istr"});
        MimeType.set_rev("chemical", "x-jcamp-dx", new String[]{"dx", "jdx"});
        MimeType.set_rev("chemical", "x-kinemage", new String[]{"kin"});
        MimeType.set_rev("chemical", "x-macmolecule", new String[]{"mcm"});
        MimeType.set_rev("chemical", "x-macromodel-input", new String[]{"mmod", "mmd"});
        MimeType.set_rev("chemical", "x-mdl-molfile", new String[]{"mol"});
        MimeType.set_rev("chemical", "x-mdl-rdfile", new String[]{"rd"});
        MimeType.set_rev("chemical", "x-mdl-rxnfile", new String[]{"rxn"});
        MimeType.set_rev("chemical", "x-mdl-sdfile", new String[]{"sdf", "sd"});
        MimeType.set_rev("chemical", "x-mdl-tgf", new String[]{"tgf"});
        MimeType.set_rev("chemical", "x-mmcif", new String[]{"mcif"});
        MimeType.set_rev("chemical", "x-mol2", new String[]{"mol2"});
        MimeType.set_rev("chemical", "x-molconn-Z", new String[]{"b"});
        MimeType.set_rev("chemical", "x-mopac-graph", new String[]{"gpt"});
        MimeType.set_rev("chemical", "x-mopac-input", new String[]{"mpc", "zmt", "mop", "mopcrt"});
        MimeType.set_rev("chemical", "x-mopac-out", new String[]{"moo"});
        MimeType.set_rev("chemical", "x-mopac-vib", new String[]{"mvb"});
        MimeType.set_rev("chemical", "x-ncbi-asn1", new String[]{"asn"});
        MimeType.set_rev("chemical", "x-ncbi-asn1-ascii", new String[]{"prt", "ent"});
        MimeType.set_rev("chemical", "x-ncbi-asn1-binary", new String[]{"val", "aso"});
        MimeType.set_rev("chemical", "x-ncbi-asn1-spec", new String[]{"asn"});
        MimeType.set_rev("chemical", "x-pdb", new String[]{"pdb", "ent"});
        MimeType.set_rev("chemical", "x-rosdal", new String[]{"ros"});
        MimeType.set_rev("chemical", "x-swissprot", new String[]{"sw"});
        MimeType.set_rev("chemical", "x-vamas-iso14976", new String[]{"vms"});
        MimeType.set_rev("chemical", "x-vmd", new String[]{"vmd"});
        MimeType.set_rev("chemical", "x-xtel", new String[]{"xtel"});
        MimeType.set_rev("chemical", "x-xyz", new String[]{"xyz"});
        MimeType.set_rev("image", "bmp", new String[]{"bmp"});
        MimeType.set_rev("image", "fits", new String[]{"fts", "fits", "fit"});
        MimeType.set_rev("image", "gif", new String[]{"gif"});
        MimeType.set_rev("image", "ief", new String[]{"ief"});
        MimeType.set_rev("image", "jp2", new String[]{"jp2", "jpg2"});
        MimeType.set_rev("image", "jpeg", new String[]{"jpg", "jpeg", "jfif", "jpe"});
        MimeType.set_rev("image", "jpm", new String[]{"jpm", "jpgm"});
        MimeType.set_rev("image", "jpx", new String[]{"jpf", "jpx"});
        MimeType.set_rev("image", "pcx", new String[]{"pcx"});
        MimeType.set_rev("image", "png", new String[]{"png"});
        MimeType.set_rev("image", "prs.btif", new String[]{"btif", "btf"});
        MimeType.set_rev("image", "prs.pti", new String[]{"pti"});
        MimeType.set_rev("image", "svg+xml", new String[]{"svgz", "svg"});
        MimeType.set_rev("image", "t38", new String[]{"t38"});
        MimeType.set_rev("image", "tiff", new String[]{"tif", "tiff"});
        MimeType.set_rev("image", "tiff-fx", new String[]{"tfx"});
        MimeType.set_rev("image", "vnd.adobe.photoshop", new String[]{"psd"});
        MimeType.set_rev("image", "vnd.djvu", new String[]{"djvu", "djv"});
        MimeType.set_rev("image", "vnd.dxf", new String[]{"dxf"});
        MimeType.set_rev("image", "vnd.fastbidsheet", new String[]{"fbs"});
        MimeType.set_rev("image", "vnd.fpx", new String[]{"fpx"});
        MimeType.set_rev("image", "vnd.fst", new String[]{"fst"});
        MimeType.set_rev("image", "vnd.fujixerox.edmics-mmr", new String[]{"mmr"});
        MimeType.set_rev("image", "vnd.fujixerox.edmics-rlc", new String[]{"rlc"});
        MimeType.set_rev("image", "vnd.globalgraphics.pgb", new String[]{"pgb"});
        MimeType.set_rev("image", "vnd.microsoft.icon", new String[]{"ico"});
        MimeType.set_rev("image", "vnd.ms-modi", new String[]{"mdi"});
        MimeType.set_rev("image", "vnd.radiance", new String[]{"hdr", "xyze", "rgbe"});
        MimeType.set_rev("image", "vnd.sealed.png", new String[]{"spng", "s1n", "spn"});
        MimeType.set_rev("image", "vnd.sealedmedia.softseal.gif", new String[]{"sgif", "s1g", "sgi"});
        MimeType.set_rev("image", "vnd.sealedmedia.softseal.jpg", new String[]{"sjp", "s1j", "sjpg"});
        MimeType.set_rev("image", "vnd.wap.wbmp", new String[]{"wbmp"});
        MimeType.set_rev("image", "vnd.xiff", new String[]{"xif"});
        MimeType.set_rev("image", "x-canon-cr2", new String[]{"cr2"});
        MimeType.set_rev("image", "x-canon-crw", new String[]{"crw"});
        MimeType.set_rev("image", "x-cmu-raster", new String[]{"ras"});
        MimeType.set_rev("image", "x-coreldraw", new String[]{"cdr"});
        MimeType.set_rev("image", "x-coreldrawpattern", new String[]{"pat"});
        MimeType.set_rev("image", "x-coreldrawtemplate", new String[]{"cdt"});
        MimeType.set_rev("image", "x-corelphotopaint", new String[]{"cpt"});
        MimeType.set_rev("image", "x-epson-erf", new String[]{"erf"});
        MimeType.set_rev("image", "x-icon", new String[]{"ico"});
        MimeType.set_rev("image", "x-jg", new String[]{"art"});
        MimeType.set_rev("image", "x-jng", new String[]{"jng"});
        MimeType.set_rev("image", "x-ms-bmp", new String[]{"bmp"});
        MimeType.set_rev("image", "x-nikon-nef", new String[]{"nef"});
        MimeType.set_rev("image", "x-olympus-orf", new String[]{"orf"});
        MimeType.set_rev("image", "x-photoshop", new String[]{"psd"});
        MimeType.set_rev("image", "x-portable-anymap", new String[]{"pnm"});
        MimeType.set_rev("image", "x-portable-bitmap", new String[]{"pbm"});
        MimeType.set_rev("image", "x-portable-graymap", new String[]{"pgm"});
        MimeType.set_rev("image", "x-portable-pixmap", new String[]{"ppm"});
        MimeType.set_rev("image", "x-rgb", new String[]{"rgb"});
        MimeType.set_rev("image", "x-targa", new String[]{"tga"});
        MimeType.set_rev("image", "x-xbitmap", new String[]{"xbm"});
        MimeType.set_rev("image", "x-xpixmap", new String[]{"xpm"});
        MimeType.set_rev("image", "x-xwindowdump", new String[]{"xwd"});
        MimeType.set_rev("message", "global", new String[]{"u8msg"});
        MimeType.set_rev("message", "global-delivery-status", new String[]{"u8dsn"});
        MimeType.set_rev("message", "global-disposition-notification", new String[]{"u8mdn"});
        MimeType.set_rev("message", "global-headers", new String[]{"u8hdr"});
        MimeType.set_rev("message", "rfc822", new String[]{"eml", "mail", "art"});
        MimeType.set_rev("model", "iges", new String[]{"igs", "iges"});
        MimeType.set_rev("model", "mesh", new String[]{"silo", "msh", "mesh"});
        MimeType.set_rev("model", "vnd.dwf", new String[]{"dwf"});
        MimeType.set_rev("model", "vnd.gdl", new String[]{"dor", "ism", "lmp", "rsm", "gdl", "msm", "win", "gsm"});
        MimeType.set_rev("model", "vnd.gtw", new String[]{"gtw"});
        MimeType.set_rev("model", "vnd.moml+xml", new String[]{"moml"});
        MimeType.set_rev("model", "vnd.mts", new String[]{"mts"});
        MimeType.set_rev("model", "vnd.parasolid.transmit.binary", new String[]{"xmt_bin", "x_b"});
        MimeType.set_rev("model", "vnd.parasolid.transmit.text", new String[]{"xmt_txt", "x_t"});
        MimeType.set_rev("model", "vnd.vtu", new String[]{"vtu"});
        MimeType.set_rev("model", "vrml", new String[]{"vrml", "wrl"});
        MimeType.set_rev("model", "x3d+binary", new String[]{"x3db"});
        MimeType.set_rev("model", "x3d+vrml", new String[]{"x3dv"});
        MimeType.set_rev("model", "x3d+xml", new String[]{"x3d"});
        MimeType.set_rev("multipart", "voice-message", new String[]{"vpm"});
        MimeType.set_rev("text", "cache-manifest", new String[]{"manifest"});
        MimeType.set_rev("text", "calendar", new String[]{"ics", "ifb", "icz"});
        MimeType.set_rev("text", "css", new String[]{"css"});
        MimeType.set_rev("text", "csv", new String[]{"csv"});
        MimeType.set_rev("text", "dns", new String[]{"soa", "zone"});
        MimeType.set_rev("text", "h323", new String[]{"323"});
        MimeType.set_rev("text", "html", new String[]{"shtml", "html", "htm"});
        MimeType.set_rev("text", "iuls", new String[]{"uls"});
        MimeType.set_rev("text", "javascript", new String[]{"js"});
        MimeType.set_rev("text", "mathml", new String[]{"mml"});
        MimeType.set_rev("text", "plain", new String[]{"text", "c", "hh", "hxx", "h", "txt", "pot", "f90", "el", "asc", "cxx", "pm", "brf", "cc"});
        MimeType.set_rev("text", "prs.fallenstein.rst", new String[]{"rst"});
        MimeType.set_rev("text", "prs.lines.tag", new String[]{"tag", "dsc"});
        MimeType.set_rev("text", "richtext", new String[]{"rtx"});
        MimeType.set_rev("text", "scriptlet", new String[]{"wsc", "sct"});
        MimeType.set_rev("text", "sgml", new String[]{"sgm", "sgml"});
        MimeType.set_rev("text", "tab-separated-values", new String[]{"tsv"});
        MimeType.set_rev("text", "texmacs", new String[]{"tm", "ts"});
        MimeType.set_rev("text", "uri-list", new String[]{"uris", "uri"});
        MimeType.set_rev("text", "vnd.DMClientScript", new String[]{"dms"});
        MimeType.set_rev("text", "vnd.abc", new String[]{"abc"});
        MimeType.set_rev("text", "vnd.esmertec.theme-descriptor", new String[]{"jtd"});
        MimeType.set_rev("text", "vnd.fly", new String[]{"fly"});
        MimeType.set_rev("text", "vnd.fmi.flexstor", new String[]{"flx"});
        MimeType.set_rev("text", "vnd.graphviz", new String[]{"gv", "dot"});
        MimeType.set_rev("text", "vnd.in3d.3dml", new String[]{"3dm", "3dml"});
        MimeType.set_rev("text", "vnd.in3d.spot", new String[]{"spo", "spot"});
        MimeType.set_rev("text", "vnd.ms-mediapackage", new String[]{"mpf"});
        MimeType.set_rev("text", "vnd.net2phone.commcenter.command", new String[]{"ccc"});
        MimeType.set_rev("text", "vnd.si.uricatalogue", new String[]{"uric"});
        MimeType.set_rev("text", "vnd.sun.j2me.app-descriptor", new String[]{"jad"});
        MimeType.set_rev("text", "vnd.trolltech.linguist", new String[]{"ts"});
        MimeType.set_rev("text", "vnd.wap.si", new String[]{"si"});
        MimeType.set_rev("text", "vnd.wap.sl", new String[]{"sl"});
        MimeType.set_rev("text", "vnd.wap.wml", new String[]{"wml"});
        MimeType.set_rev("text", "vnd.wap.wmlscript", new String[]{"wmls"});
        MimeType.set_rev("text", "x-bibtex", new String[]{"bib"});
        MimeType.set_rev("text", "x-boo", new String[]{"boo"});
        MimeType.set_rev("text", "x-c++hdr", new String[]{"hh", "h++", "hxx", "hpp"});
        MimeType.set_rev("text", "x-c++src", new String[]{"cpp", "cxx", "c++", "cc"});
        MimeType.set_rev("text", "x-chdr", new String[]{"h"});
        MimeType.set_rev("text", "x-component", new String[]{"htc"});
        MimeType.set_rev("text", "x-csh", new String[]{"csh"});
        MimeType.set_rev("text", "x-csrc", new String[]{"c"});
        MimeType.set_rev("text", "x-diff", new String[]{"diff", "patch"});
        MimeType.set_rev("text", "x-dsrc", new String[]{"d"});
        MimeType.set_rev("text", "x-haskell", new String[]{"hs"});
        MimeType.set_rev("text", "x-java", new String[]{"java"});
        MimeType.set_rev("text", "x-literate-haskell", new String[]{"lhs"});
        MimeType.set_rev("text", "x-moc", new String[]{"moc"});
        MimeType.set_rev("text", "x-pascal", new String[]{"pas", "p"});
        MimeType.set_rev("text", "x-pcs-gcd", new String[]{"gcd"});
        MimeType.set_rev("text", "x-perl", new String[]{"pl", "pm"});
        MimeType.set_rev("text", "x-pod", new String[]{"pod"});
        MimeType.set_rev("text", "x-python", new String[]{"py"});
        MimeType.set_rev("text", "x-scala", new String[]{"scala"});
        MimeType.set_rev("text", "x-setext", new String[]{"etx"});
        MimeType.set_rev("text", "x-sh", new String[]{"sh"});
        MimeType.set_rev("text", "x-tcl", new String[]{"tcl", "tk"});
        MimeType.set_rev("text", "x-tex", new String[]{"cls", "ltx", "tex", "sty"});
        MimeType.set_rev("text", "x-vcalendar", new String[]{"vcs"});
        MimeType.set_rev("text", "x-vcard", new String[]{"vcf"});
        MimeType.set_rev("text", "xml", new String[]{"xml"});
        MimeType.set_rev("text", "xml-external-parsed-entity", new String[]{"ent"});
        MimeType.set_rev("video", "3gpp", new String[]{"3gpp", "3gp"});
        MimeType.set_rev("video", "3gpp2", new String[]{"3gpp2", "3g2"});
        MimeType.set_rev("video", "annodex", new String[]{"axv"});
        MimeType.set_rev("video", "dl", new String[]{"dl"});
        MimeType.set_rev("video", "dv", new String[]{"dv", "dif"});
        MimeType.set_rev("video", "fli", new String[]{"fli"});
        MimeType.set_rev("video", "gl", new String[]{"gl"});
        MimeType.set_rev("video", "mj2", new String[]{"mj2", "mjp2"});
        MimeType.set_rev("video", "mp4", new String[]{"mpg4", "mp4"});
        MimeType.set_rev("video", "mpeg", new String[]{"mpeg", "mpg", "mpe"});
        MimeType.set_rev("video", "ogg", new String[]{"ogv"});
        MimeType.set_rev("video", "quicktime", new String[]{"mov", "qt"});
        MimeType.set_rev("video", "vnd.fvt", new String[]{"fvt"});
        MimeType.set_rev("video", "vnd.mpegurl", new String[]{"mxu", "m4u"});
        MimeType.set_rev("video", "vnd.ms-playready.media.pyv", new String[]{"pyv"});
        MimeType.set_rev("video", "vnd.nokia.interleaved-multimedia", new String[]{"nim"});
        MimeType.set_rev("video", "vnd.sealed.mpeg1", new String[]{"smpg", "s11"});
        MimeType.set_rev("video", "vnd.sealed.mpeg4", new String[]{"s14"});
        MimeType.set_rev("video", "vnd.sealed.swf", new String[]{"ssw", "sswf"});
        MimeType.set_rev("video", "vnd.sealedmedia.softseal.mov", new String[]{"smo", "s1q", "smov"});
        MimeType.set_rev("video", "x-flv", new String[]{"flv"});
        MimeType.set_rev("video", "x-la-asf", new String[]{"lsx", "lsf"});
        MimeType.set_rev("video", "x-matroska", new String[]{"mpv", "mkv"});
        MimeType.set_rev("video", "x-mng", new String[]{"mng"});
        MimeType.set_rev("video", "x-ms-asf", new String[]{"asf", "asx"});
        MimeType.set_rev("video", "x-ms-wm", new String[]{"wm"});
        MimeType.set_rev("video", "x-ms-wmv", new String[]{"wmv"});
        MimeType.set_rev("video", "x-ms-wmx", new String[]{"wmx"});
        MimeType.set_rev("video", "x-ms-wvx", new String[]{"wvx"});
        MimeType.set_rev("video", "x-msvideo", new String[]{"avi"});
        MimeType.set_rev("video", "x-sgi-movie", new String[]{"movie"});
        MimeType.set_rev("x-conference", "x-cooltalk", new String[]{"ice"});
        MimeType.set_rev("x-epoc", "x-sisx-app", new String[]{"sisx"});
        MimeType.set_rev("x-world", "x-vrml", new String[]{"vrml", "wrl", "vrm"});
    }
}

