/*
 * Decompiled with CFR 0.152.
 */
package paraselene.dyna;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import paraselene.Page;
import paraselene.dyna.Dominion;
import paraselene.dyna.DynamicPage;
import paraselene.dyna.DynamicPageException;
import paraselene.dyna.DynamicPageReloader;
import paraselene.dyna.GrantTagProvider;
import paraselene.dyna.URIResolver;
import paraselene.supervisor.PageID;

public class Skin {
    private Dominion pr;
    private String dec;
    private GrantTagProvider[] gtp;
    private HashMap<String, String> name = new HashMap();
    private HashMap<Key, DynamicPageReloader.Magazine> magazin = new HashMap();

    public Skin(Dominion dominion, String enc, GrantTagProvider[] provider, String ... param_name) {
        this.pr = dominion;
        this.dec = enc;
        this.gtp = provider;
        for (String n : param_name) {
            this.name.put(n.toLowerCase(Locale.ENGLISH), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(File root, String other_path, Page destination, PageInspecter inspecter) throws DynamicPageException {
        if (other_path.charAt(0) != '/') {
            throw new DynamicPageException("bad directory[" + other_path + "]");
        }
        DynamicPage page = null;
        PageID id = destination.getID();
        Key key = new Key(root, id);
        HashMap<Key, DynamicPageReloader.Magazine> hashMap = this.magazin;
        synchronized (hashMap) {
            DynamicPageReloader.Magazine mz = this.magazin.get(key);
            if (mz != null) {
                page = mz.getPage();
            } else {
                page = new DynamicPage(new Resolver(id, other_path), destination, this.gtp);
                page.create(new File(this.pr.getHTMLPath(root.getPath(), id)), null);
                mz = DynamicPageReloader.issue(page);
                this.magazin.put(key, mz);
            }
            DynamicPageException e = mz.getLastError();
            if (e != null) {
                throw e;
            }
        }
        try {
            if (inspecter != null) {
                inspecter.inspect(page);
            }
        }
        catch (Exception e) {
            throw new DynamicPageException(e);
        }
        destination.moveMainTag(page);
    }

    public static interface PageInspecter {
        public void inspect(DynamicPage var1) throws Exception;
    }

    private class Key {
        private File file;
        private PageID id;
        private int hash;

        private Key(File f, PageID pid) {
            this.file = f;
            this.id = pid;
            this.hash = ~this.file.hashCode() ^ pid.getID();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return key.id == this.id && key.file.equals(this.file);
        }
    }

    private class Resolver
    implements URIResolver {
        private PageID id;
        private String other;

        private Resolver(PageID p, String other_path) {
            this.id = p;
            this.other = other_path;
        }

        @Override
        public String resolve(String src) throws Exception {
            Dominion.Path path = Skin.this.pr.resolve(this.id, src, Skin.this.dec);
            String file = path.getPath();
            if (path.getType() == Dominion.Path.Type.RELATIVE) {
                return Dominion.fix(this.other, file, true);
            }
            return file;
        }

        @Override
        public boolean isParamURIName(String n) {
            return Skin.this.name.get(n.toLowerCase(Locale.ENGLISH)) != null;
        }
    }
}

