/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import paraselene.Page;
import paraselene.URIValue;
import paraselene.ajax.Ajax;
import paraselene.supervisor.DataHolder;
import paraselene.supervisor.Forward;
import paraselene.supervisor.HistorySet;
import paraselene.supervisor.Option;
import paraselene.supervisor.PageID;
import paraselene.supervisor.ParaseleneException;
import paraselene.supervisor.RedirectData;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.Supervisor;
import paraselene.supervisor.TransactionSequencer;

class SessionData
implements Serializable,
HttpSessionBindingListener {
    private static final long serialVersionUID = 25L;
    TransactionSequencer seq = new TransactionSequencer();
    HistorySet hist = null;
    private HashMap<PageID, RedirectData> pending = new HashMap();
    private volatile int client;
    boolean planed_clear = false;

    private String getAdder(HttpServletRequest req) {
        String addr = req.getRemoteAddr();
        if (addr == null) {
            return null;
        }
        String[] bt = addr.split("[\\.:]");
        if (bt.length < 4) {
            return addr;
        }
        StringBuilder buf = new StringBuilder(bt[0].trim());
        int len = bt.length - 1;
        for (int i = 1; i < len; ++i) {
            buf = buf.append(".");
            buf = buf.append(bt[1].trim());
        }
        return buf.toString();
    }

    private int getClient(HttpServletRequest req) {
        String[] data = new String[]{req.getHeader("User-Agent"), this.getAdder(req), req.getHeader("X-Forwarded-For")};
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == null) {
                data[i] = "non";
            }
            buf = buf.append("*");
            buf = buf.append(data[i]);
        }
        String str = buf.toString();
        Option.trace(str, new Object[0]);
        return str.hashCode();
    }

    SessionData(HttpServletRequest req) throws ParaseleneException {
        this.client = this.getClient(req);
        this.hist = new HistorySet(req.getSession().getId());
    }

    boolean isSame(HttpServletRequest req) {
        if (this.client == this.getClient(req)) {
            return true;
        }
        this.client = 0;
        System.out.println("-- unmatched client --------------------------");
        System.out.println(new Date().toString());
        System.out.println("IP = " + req.getRemoteAddr());
        System.out.println("User Agent = " + req.getHeader("User-Agent"));
        System.out.println("SessionID = " + req.getSession().getId());
        System.out.println("---------------------------------------------\n");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Forward write(Supervisor sv, Page out, DataHolder holder) throws Exception {
        PageID id = out.getID();
        RedirectData data = null;
        HashMap<PageID, RedirectData> hashMap = this.pending;
        synchronized (hashMap) {
            data = this.pending.get(id);
        }
        sv.getPageFactory().returnPage(out);
        if (data == null) {
            Option.trace("redirect pending data null", new Object[0]);
            return new Forward(403);
        }
        if (holder.request.getURI().toString().indexOf(data.uri) < 0) {
            Option.trace("redirect path unmatched pending(%s) call(%s)", data.uri, holder.request.getURI().toString());
            return new Forward(403);
        }
        if (data.ajax && data.responsed) {
            return new Forward(204);
        }
        sv.write(data.out_page, false, data.fw, holder);
        data.responsed = true;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Forward redirect(Page[] out_ret, Forward fw, RequestParameter req) throws Exception {
        RedirectData rd = new RedirectData();
        rd.fw = fw;
        rd.out_page = out_ret;
        rd.posted = req.getURI();
        rd.uri = TransactionSequencer.makeRedirectURI(this.seq, out_ret[0].getID());
        rd.ajax = req.wasUsedAjax();
        String path = Supervisor.makeWithSessionURI(URIValue.makeAbsolutePath(URIValue.Scheme.getScheme(rd.posted), rd.posted.getPort(), rd.uri), null, null);
        Option.traceWithStack(path, new Object[0]);
        HashMap<PageID, RedirectData> hashMap = this.pending;
        synchronized (hashMap) {
            this.pending.put(out_ret[0].getID(), rd);
        }
        rd.redirect_path = new URI(path);
        return new Forward(rd.redirect_path, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Forward redirect(URI post, boolean ajax_f) {
        if (ajax_f) {
            return new Forward(204);
        }
        HashMap<PageID, RedirectData> hashMap = this.pending;
        synchronized (hashMap) {
            Collection<RedirectData> list = this.pending.values();
            for (RedirectData rd : this.pending.values()) {
                if (!rd.posted.equals(post)) continue;
                return new Forward(rd.redirect_path, false, false);
            }
            return null;
        }
    }

    public void valueBound(HttpSessionBindingEvent ev) {
    }

    public void valueUnbound(HttpSessionBindingEvent ev) {
        if (!this.planed_clear) {
            this.hist.drop();
            Ajax.removeComet(ev.getSession().getId());
        }
    }
}

