/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.mockup;

import paraselene.*;

class CommentSource extends Comment implements Source {
	private static long seq = 0;
	private String val;

	CommentSource( String c ) {
		super( c );
		val = "comment" + Long.toString( seq );
		seq++;
		if ( seq < 0 )	seq = 0;
	}


	public String toSource() {
		StringBuffer	buf = new StringBuffer( "paraselene.Comment " );
		buf = buf.append( val );
		buf = buf.append( "=new paraselene.Comment(" );
		buf = buf.append( Make.escape( getComment() ) );
		buf = buf.append( ");\n" );
		return buf.toString();
	}

	public String getValName() {
		return val;
	}
}

