/*
 * Decompiled with CFR 0.152.
 */
package paraselene.dyna;

import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import paraselene.QueryItem;
import paraselene.URIValue;
import paraselene.supervisor.PageID;
import paraselene.supervisor.TransactionSequencer;

public class Dominion {
    private HashMap<String, RelativePage> map_f2p = new HashMap();
    private HashMap<Integer, String> map_p2f = new HashMap();

    public Dominion(RelativePage ... path) {
        for (RelativePage r : path) {
            this.map_f2p.put(r.uri, r);
            this.map_p2f.put(r.page_id.getID(), r.uri);
        }
    }

    public String getHTMLPath(String parent, PageID id) {
        String child = this.map_p2f.get(id.getID());
        if (parent == null) {
            return child;
        }
        return Dominion.fix(parent, child, false);
    }

    private static boolean isParaselene(String path) {
        for (String s : path.split("/")) {
            int len = s.length();
            if (len < 4 || !s.substring(len - 3).equals(TransactionSequencer.EXTENSION)) continue;
            return true;
        }
        return false;
    }

    public static String fix(String top, String path, boolean url_f) {
        if (new File(path).isAbsolute()) {
            return path;
        }
        if (top == null) {
            return path;
        }
        ArrayList<String> dir = new ArrayList<String>();
        for (String s : top.split("[/\\\\]")) {
            dir.add(s);
        }
        for (String s : path.split("[/\\\\]")) {
            if (s.length() == 0 || ".".equals(s)) continue;
            if ("..".equals(s)) {
                int size = dir.size();
                if (size == 0) {
                    return null;
                }
                dir.remove(size - 1);
                continue;
            }
            dir.add(s);
        }
        int size = dir.size();
        if (size == 0) {
            return null;
        }
        String sep = url_f ? "/" : File.separator;
        StringBuilder buf = new StringBuilder((String)dir.get(0));
        for (int i = 1; i < size; ++i) {
            buf = buf.append(sep).append((String)dir.get(i));
        }
        return buf.toString();
    }

    public Path resolve(PageID id, String path, String dec) throws Exception {
        URI uri = new URI(path);
        if (uri.getScheme() != null) {
            return new Path(Path.Type.ABSOLUTE, path, dec);
        }
        if (path.charAt(0) == '/') {
            return new Path(Path.Type.ABSOLUTE, path, dec);
        }
        path = Dominion.fix(new File(this.getHTMLPath(null, id)).getParent(), uri.getPath(), true);
        if (path == null) {
            throw new Exception(this.getHTMLPath(null, id) + "  /  " + uri.getPath() + "  -> failed");
        }
        RelativePage rp = this.map_f2p.get(path);
        if (rp != null) {
            if (rp.dl_f) {
                return new Path(Path.Type.DOWNLOADABLE, URIValue.pageToDownloadURI(rp.page_id, "data", new QueryItem[0]), dec);
            }
            QueryItem[] item = new URIValue(URLDecoder.decode(path, dec)).getQuery();
            return new Path(Path.Type.PAGE, URIValue.pageToURI(id, uri.getFragment(), item), dec);
        }
        return new Path(Dominion.isParaselene(path) ? Path.Type.ALIAS : Path.Type.RELATIVE, path, dec);
    }

    public static class Path {
        private Type type;
        private String uri;

        private Path(Type t, String s, String dec) throws Exception {
            this.type = t;
            this.uri = URLDecoder.decode(s, dec);
        }

        public Type getType() {
            return this.type;
        }

        public String getPath() {
            return this.uri;
        }

        public static enum Type {
            ABSOLUTE,
            PAGE,
            DOWNLOADABLE,
            ALIAS,
            RELATIVE;

        }
    }

    public static class RelativePage {
        private String uri;
        private PageID page_id;
        private boolean dl_f;

        public RelativePage(String path, PageID id, boolean download2) {
            this.uri = path;
            this.page_id = id;
            this.dl_f = download2;
        }
    }
}

