/*
 * Decompiled with CFR 0.152.
 */
package paraselene.ui;

import java.util.ArrayList;
import java.util.HashMap;
import paraselene.Color;
import paraselene.HTMLPart;
import paraselene.NumberValue;
import paraselene.Page;
import paraselene.QueryItem;
import paraselene.Text;
import paraselene.URIValue;
import paraselene.Valuable;
import paraselene.WebColor;
import paraselene.css.CSSValuable;
import paraselene.css.Property;
import paraselene.css.Style;
import paraselene.supervisor.Feedback;
import paraselene.supervisor.Forward;
import paraselene.supervisor.History;
import paraselene.supervisor.PageID;
import paraselene.supervisor.RequestItem;
import paraselene.supervisor.RequestParameter;
import paraselene.tag.Anchor;
import paraselene.tag.Attribute;
import paraselene.tag.Tag;
import paraselene.ui.PageBypassedDiv;
import paraselene.ui.PageHooker;

public class Tab
extends Tag
implements PageHooker {
    private ArrayList<Page> page_list = new ArrayList();
    private HashMap<String, Boolean> page_enable = new HashMap();
    private Color selected;
    private Color unselected;
    private Tag head = new Tag("div", false);
    private PageBypassedDiv body = new PageBypassedDiv();
    private int select_no = -1;
    private History hist;
    private static final CSSValuable px0 = new NumberValue(0, NumberValue.Unit.PIXEL);
    private static final CSSValuable px1 = new NumberValue(1, NumberValue.Unit.PIXEL);
    private static final CSSValuable none = new Text("none");
    private static final CSSValuable solid = new Text("solid");
    private boolean select_pending = false;

    public Tab() {
        super("div", false);
        this.setColor(new Color(WebColor.DARKORANGE), new Color(WebColor.PALETURQUOISE));
        this.addHTMLPart(this.head, this.body);
        this.body.setAttribute(new Attribute("class", "paraseleneTabBody"));
        this.makeID();
        this.setAttribute(new Attribute("class", "paraselene.ui.Tab"));
    }

    @Override
    protected Tag newReplica() {
        return new Tab();
    }

    public void setColor(Color selected_top, Color unselected_back) {
        this.selected = selected_top;
        this.unselected = unselected_back;
        this.setAttribute(new Attribute("style", (Valuable)new Style(new Property("border-width", px1), new Property("border-style", solid))));
    }

    public void addPage(int start, History history, Page ... page) {
        this.hist = history;
        int i = 0;
        while (i < page.length) {
            this.page_list.add(start, page[i]);
            this.page_enable.put(page[i].getUniqueKey(), true);
            ++i;
            ++start;
        }
        if (this.select_no < 0) {
            this.select(0);
        } else if (this.select_no >= start) {
            this.select(this.select_no + page.length);
        } else {
            this.select(this.select_no);
        }
    }

    public void addPage(History history, Page ... page) {
        this.addPage(this.getPageCount(), history, page);
    }

    public void addPage(int start, History history, PageID ... id) {
        Page[] page = new Page[id.length];
        for (int i = 0; i < id.length; ++i) {
            page[i] = id[i].getPageFactory().getPage(id[i]);
        }
        this.addPage(start, history, page);
    }

    public void addPage(History history, PageID ... id) {
        this.addPage(this.getPageCount(), history, id);
    }

    public void removePage(int no) {
        this.page_enable.remove(this.page_list.remove(no).getUniqueKey());
        if (this.select_no >= no) {
            this.select(this.select_no - 1);
        } else {
            this.select(this.select_no);
        }
    }

    public void removePage(Page page) {
        this.removePage(this.getTabNo(page));
    }

    public void removePage() {
        this.select_no = -1;
        this.page_enable.clear();
        this.page_list.clear();
    }

    public int getTabNo(Page page) {
        int cnt = this.getPageCount();
        for (int i = 0; i < cnt; ++i) {
            if (this.page_list.get(i) != page) continue;
            return i;
        }
        return -1;
    }

    public void select(int no) {
        int cnt = this.getPageCount();
        if (no < 0 || no >= cnt) {
            no = 0;
        }
        this.select_no = no;
        if (this.select_pending) {
            return;
        }
        this.head.removeHTMLPart();
        this.body.setBypassPage(this.hist, null);
        if (cnt == 0) {
            this.select_no = -1;
            return;
        }
        this.page_enable.put(this.getPage(this.select_no).getUniqueKey(), true);
        for (int i = 0; i < cnt; ++i) {
            Page page = this.page_list.get(i);
            Tag div = new Tag("div", false);
            div.setAttribute(new Attribute("class", "paraseleneTab"));
            Tag in = null;
            if (i == this.select_no) {
                in = new Tag("span", false);
                in.setAttribute(new Attribute("class", "paraselene_selected"));
                div.setAttribute(new Attribute("style", (Valuable)new Style(new Property("border-top-color", this.selected), new Property("border-width", new NumberValue(6, NumberValue.Unit.PIXEL), px1, px0, px0), new Property("border-style", solid, solid, none, none), new Property("margin-top", new NumberValue(NumberValue.Sign.MINUS, 5, NumberValue.Unit.PIXEL)))));
                this.body.setBypassPage(this.hist, page);
            } else {
                if (this.getEnable(i)) {
                    in = new Anchor();
                    in.setAttribute(new Attribute("href", URIValue.pageToURI(this.getAssignedPage().getID(), null, new QueryItem(this.getIDAttribute(), Integer.toString(i)))));
                } else {
                    in = new Tag("span", false);
                    in.setAttribute(new Attribute("class", "paraselene_disable"));
                }
                div.setAttribute(new Attribute("style", (Valuable)new Style(new Property("background-color", this.unselected), new Property("border-width", px0, px1, px1, px0), new Property("border-style", none, solid, solid, none))));
            }
            in.addHTMLPart(page.getTitleLabel());
            div.addHTMLPart((HTMLPart)in);
            this.head.addHTMLPart((HTMLPart)div);
        }
    }

    public void select(Page page) {
        this.select(this.getTabNo(page));
    }

    public int getPageCount() {
        return this.page_list.size();
    }

    @Override
    public Forward beforeInput(Page page, RequestParameter req, Forward fw) throws Exception {
        RequestItem item = req.getItem(this.getIDAttribute());
        if (item == null) {
            return fw;
        }
        try {
            int no = Integer.parseInt(item.getValue(0));
            this.select(no);
            fw = new Feedback();
        }
        catch (Exception e) {
            // empty catch block
        }
        return fw;
    }

    @Override
    public void afterOutput(Page from, Page to, RequestParameter req) throws Exception {
    }

    @Override
    public void commitDaemon() {
    }

    public int getSelected() {
        return this.select_no;
    }

    public Page getPage(int no) {
        return this.page_list.get(no);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap(int no1, int no2) {
        if (no1 == no2) {
            return;
        }
        int old = this.select_no;
        int a = no1 < no2 ? no1 : no2;
        int b = no1 < no2 ? no2 : no1;
        Page[] page = new Page[]{this.getPage(b), this.getPage(a)};
        this.select_pending = true;
        try {
            this.removePage(b);
            this.removePage(a);
            this.addPage(a, this.hist, page[0]);
            this.addPage(b, this.hist, page[1]);
        }
        finally {
            this.select_pending = false;
        }
        if (old == a) {
            this.select(b);
        } else if (old == b) {
            this.select(a);
        } else {
            this.select(this.select_no);
        }
    }

    public void swap(Page p1, Page p2) {
        this.swap(this.getTabNo(p1), this.getTabNo(p2));
    }

    public void setEnable(int no, boolean flag) {
        if (no == this.select_no) {
            return;
        }
        this.page_enable.put(this.getPage(no).getUniqueKey(), flag);
        this.select(this.select_no);
    }

    public void setEnable(Page page, boolean flag) {
        this.setEnable(this.getTabNo(page), flag);
    }

    public boolean getEnable(Page page) {
        return this.page_enable.get(page.getUniqueKey());
    }

    public boolean getEnable(int no) {
        return this.getEnable(this.getPage(no));
    }

    @Override
    public void importFromCookie(RequestParameter req) {
        try {
            Integer no = (Integer)this.getCookieValue(req);
            if (no != null) {
                this.select(no);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Forward exportToCookie(RequestParameter req, Forward fw, int expiry, boolean ssl_f) {
        try {
            fw.addCookie(this.makeCookieValue(req, new Integer(this.getSelected()), expiry, ssl_f));
        }
        catch (Exception e) {
            // empty catch block
        }
        return fw;
    }
}

