/*
 * Decompiled with CFR 0.152.
 */
package paraselene.util;

import java.io.Serializable;
import paraselene.util.IPv4;
import paraselene.util.IPv6;

public abstract class IP
implements Serializable {
    private static final long serialVersionUID = 1L;
    int[] addr;

    public static IP toIP(String ip) {
        IP ret = null;
        try {
            ret = new IPv4(ip);
        }
        catch (IPFormatException e4) {
            try {
                ret = new IPv6(ip);
            }
            catch (IPFormatException iPFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    IP() {
    }

    IP(int[] ip) {
        this.addr = ip;
    }

    IP(IP ip) {
        this((int[])ip.addr.clone());
    }

    abstract IP getReplica();

    public IP mask(int bit_length) {
        IP ip = this.getReplica();
        int max_length = ip.addr.length * 8;
        if (bit_length < 0) {
            bit_length = 0;
        }
        if (bit_length > max_length) {
            bit_length = max_length;
        }
        for (int no = 0; no < ip.addr.length; ++no) {
            if (bit_length > 0) {
                if (bit_length < 8) {
                    int bit = 128;
                    int result = 0;
                    while (bit_length > 0) {
                        result |= bit & ip.addr[no];
                        --bit_length;
                        bit >>= 1;
                    }
                    ip.addr[no] = result;
                    continue;
                }
                bit_length -= 8;
                continue;
            }
            ip.addr[no] = 0;
        }
        return ip;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IP)) {
            return false;
        }
        IP cmp = (IP)obj;
        if (cmp.addr.length != this.addr.length) {
            return false;
        }
        return this.equalsLowBit(cmp);
    }

    public boolean equalsLowBit(IP ip) {
        int ip_start = 0;
        int my_start = 0;
        if (ip.addr.length > this.addr.length) {
            ip_start = ip.addr.length - this.addr.length;
        } else if (ip.addr.length < this.addr.length) {
            my_start = this.addr.length - ip.addr.length;
        }
        while (my_start < this.addr.length) {
            if (this.addr[my_start] != ip.addr[ip_start]) {
                return false;
            }
            ++ip_start;
            ++my_start;
        }
        return true;
    }

    public int hashCode() {
        int ret = 0;
        for (int i = 0; i < this.addr.length; i += 4) {
            int tmp = 0;
            for (int j = 0; j < 4; ++j) {
                tmp <<= 8;
                tmp |= this.addr[i * 4 + j];
            }
            ret ^= tmp;
        }
        return ret;
    }

    public static class IPMask
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private IP ip;
        private int mask = -1;

        private IPMask() {
        }

        public IPMask(IP ip_addr, int net_mask) {
            this.ip = ip_addr;
            this.mask = net_mask;
        }

        public IPMask(String str) throws IPFormatException {
            String[] sep = str.split("/");
            if (sep.length > 2 || sep.length < 1) {
                throw new IPFormatException(str);
            }
            this.ip = IP.toIP(sep[0]);
            if (this.ip == null) {
                throw new IPFormatException(str);
            }
            if (sep.length == 2) {
                try {
                    this.mask = Integer.parseInt(sep[1]);
                }
                catch (NumberFormatException e) {
                    throw new IPFormatException(str);
                }
            } else {
                this.mask = this.ip.addr.length * 8;
            }
        }

        public IP getIP() {
            return this.ip;
        }

        public int getMask() {
            return this.mask;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(this.ip.toString());
            buf = buf.append("/").append(this.mask);
            return buf.toString();
        }
    }

    public static class IPFormatException
    extends Exception {
        IPFormatException(String str) {
            super(IPFormatException.makeStr(str));
        }

        private static String makeStr(String str) {
            StringBuilder buf = new StringBuilder("Bad format[");
            buf = buf.append(str);
            buf = buf.append("]");
            return buf.toString();
        }
    }
}

