/*
 * Decompiled with CFR 0.152.
 */
package paraselene.ajax.data;

import paraselene.Color;
import paraselene.HSL;
import paraselene.HTMLPart;
import paraselene.Page;
import paraselene.WebColor;
import paraselene.ajax.data.TagData;
import paraselene.css.CSSValuable;
import paraselene.supervisor.DialogType;

public class Open
extends TagData {
    private static final long serialVersionUID = 2L;
    public String page_id = null;
    public int base_z = 1;
    public String bg;
    public String bg2;
    public String border;
    public String title = "\u3000";
    public boolean modal = false;
    public boolean move = false;
    public boolean active = false;
    public boolean menu = false;
    public int position = 0;
    public String hint_id = null;

    private Open() {
    }

    private String toBg(CSSValuable[] v) {
        if (v == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < v.length; ++i) {
            buf = buf.append(v[i].toString(HTMLPart.StringMode.CSS));
            buf = buf.append(" ");
        }
        return buf.toString();
    }

    private Color getColor(CSSValuable[] v) {
        if (v != null) {
            for (int i = 0; i < v.length; ++i) {
                if (!(v[i] instanceof Color)) continue;
                return (Color)v[i];
            }
        }
        return new Color(WebColor.WHITESMOKE);
    }

    private CSSValuable[] shift(Color org, int v) {
        HSL hsl = org.getHSL();
        hsl.lightness = hsl.lightness < 50.0 ? (hsl.lightness += (double)v) : (hsl.lightness -= (double)v);
        return new CSSValuable[]{new Color(hsl)};
    }

    private static int getPositionNo(DialogType.Position p) {
        int no;
        DialogType.Position[] val = DialogType.Position.values();
        for (no = 0; no < val.length && val[no] != p; ++no) {
        }
        return no;
    }

    public Open(Page page, boolean act_f) {
        super(page.getBodyTag(), !act_f);
        this.page_id = page.getUniqueKey();
        this.base_z = page.getZindex();
        CSSValuable[] st = page.getPopupBackGround();
        Color c = this.getColor(st);
        this.bg = this.toBg(st);
        this.bg2 = this.toBg(this.shift(c, 20));
        this.border = this.toBg(this.shift(c, 10));
        HTMLPart[] title_part = page.getTitleLabel();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < title_part.length; ++i) {
            buf = buf.append(title_part[i].toString(HTMLPart.StringMode.BODY));
        }
        this.title = buf.toString();
        DialogType ptype = page.getPopupType();
        if (ptype != null) {
            this.modal = ptype.isMode();
            this.move = ptype.isTitle();
            this.menu = ptype.isAutoClose();
            this.position = Open.getPositionNo(ptype.getPosition());
            if (this.position != 0) {
                this.hint_id = page.getPopupHint().getIDAttribute();
            }
        } else {
            this.modal = true;
            this.move = true;
            this.menu = false;
            this.position = 0;
        }
        this.active = act_f;
    }
}

