/*
 * Paraselene
 * Copyright (c) 2009-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import paraselene.supervisor.*;

/**
 * 一時問い合わせダイアログ。
 */
public interface EphemeralPage {
	/**
	 * 画面遷移の発生、またはタイムアウトによる中断。
	 */
	public static final Object ABORT = "EphemeralPage.ABORT";
	/**
	 * 呼び出しページが応答を返さなかった、またはユーザー操作による自動クローズ。
	 */
	public static final Object NO_ANSWER = "EphemeralPage.NO_ANSWER";
	/**
	 * 一時問い合わせダイアログでのfirstOutput。
	 * SuperPage を経由せず直接呼ばれることに注意して下さい。
	 * @param req リクエスト内容。
	 * @param param 呼び出し引数。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public void firstOutput( RequestParameter req, Object param ) throws Page.PageException;
}

