/*
 * Paraselene
 * Copyright (c) 2009-2011  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import java.net.*;
import java.io.*;

/**
 * テキスト。出力時に一切テキストの加工を行いません。<br>
 * 入力値をタグとして認識させたい場合などの特殊な用途で使用できます。
 */
public class PlainText extends HTMLPart {
	private static final long serialVersionUID = 2L;
	private String	text = "";

	protected PlainText() {}

	/**
	 * コンストラクタ。StringMode.PLAIN扱い。
	 * @param txt テキスト。
	 */
	public PlainText( String txt ) {
		setText( txt );
	}

	/**
	 * 文字列の設定。
	 * @param txt テキスト。
	 */
	protected void setText( String txt ) {
		text = txt;
		getAssignedTag().setModify();
	}

	/**
	 * テキスト化。
	 * @param mode 出力モード。無視されます。
	 * @return 文字列。
	 */
	public String toString( StringMode mode ) {
		return text;
	}

	public HTMLPart getReplica() {
		return new PlainText( text );
	}

	/**
	 * 複製の作成。getReplica()の戻り値をキャストして返します。
	 * @return 複製。
	 */
	public Valuable getValuableReplica() {
		return (Valuable)getReplica();
	}

	/**
	 * 各引数文字列末尾に改行コードを付けて文字列を追加します。
	 * @param str 追加文字列。
	 */
	public void appendWithCRLF( String ... str ) {
		StringBuilder	buf = new StringBuilder( text );
		for( String s: str ) {
			buf = buf.append( s ).append( "\r\n" );
		}
		setText( buf.toString() );
	}
}


