/*
 * Paraselene
 * Copyright (c) 2009-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import paraselene.supervisor.*;
import paraselene.dyna.*;
import java.util.*;


/**
 * アドイン型外部ページ。
 * アプリケーションのスケルトンソースに含まれないページを追加する場合の
 * スーパークラスです。<br>
 * アプリケーションの SuperPage 同等のメソッドを持っています。
 * 必要に応じてオーバーライドして下さい。<br>
 * このクラスはアプリケーションの SuperPage との派生関係を持ちません。
 * アプリケーション側はそこに注意して下さい。
 */
public abstract class XenoPage extends Page {
	/**
	 * name 属性の検証。
	 * @param page 検証するページ
	 * @param exclude 検証から除外する name。
	 * @return 常にnullを返します。
	 */
	public NameDefine[] inspectName( Page page, String ... exclude ) { return null; }
	/**
	 * 入力値の検証メイン処理。
	 * @param req リクエスト内容。
	 * @param fw デフォルト遷移先。
	 */
	public abstract Forward inputMain( RequestParameter req, Forward fw ) throws PageException;
	/**
	 * 出力情報の設定メイン処理。
	 * @param from 遷移元ページ。
	 * @param req リクエスト内容。
	 * @return 出力ページ。
	 * nullを返すとthisをリターンしたのと同じ扱いにされます。
	 */
	public abstract Page outputMain( Page from, RequestParameter req ) throws PageException;
	/**
	 * 初回outputの呼び出しメイン処理。
	 * @param req リクエスト内容。
	 */
	public abstract void firstOutputMain( RequestParameter req ) throws PageException;

	/**
	 * コンストラクタ。
	 */
	public XenoPage() { super(); }

	/**
	 * 出力文字コード。
	 * @return UTF-8
	 */
	public String getCharset() { return "UTF-8"; }
	/**
	 * 出力コンテントタイプ。
	 * @return null。
	 */
	public String getContentType() { return null; }
	/**
	 * 履歴追加方法。
	 * @return true
	 */
	public boolean isHistoryClear() { return true; }
	/**
	 * 履歴追加許可。
	 * @return true
	 */
	public boolean isAllowHistoryAdd() { return true; }
	/**
	 * アップロードファイルの最大バイト数。
	 * @return 2M
	 */
	public int getUploadMaxBytes() { return 1024 * 1024 * 2; }
	/**
	 * 処理済みリクエストの再呼び出しを検出するか？
	 * @return false;
	 */
	public boolean isCheckRepeatSameRequest() { return false; }
	/**
	 * 初期化。
	 */
	public void init() {}

	/**
	 * AJAXサポート機能の指定。
	 * @return POPUP_DIALOG
	 */
	public AjaxSupport getAjaxSupport() { return AjaxSupport.POPUP_DIALOG; }

	/**
	 * 入力値の検証を行う。
	 * @param req リクエスト内容。
	 * @param fw デフォルト遷移先。
	 */
	public final Forward input( RequestParameter req, Forward fw ) throws PageException {
		return inputMain( req, fw );
	}

	/**
	 * 初回outputの呼び出し直前にコールされます。初期化処理を記述します。
	 * @param req リクエスト内容。
	 */
	public final void firstOutput( RequestParameter req ) throws PageException {
		firstOutputMain( req );
	}

	/**
	 * 出力情報の設定を行う。
	 * @param from 遷移元ページ。直接呼ばれている場合はnullです。
	 * @param req リクエスト内容。
	 * @return 出力ページ。
	 * nullを返すとthisをリターンしたのと同じ扱いにされます。
	 */
	public final Page output( Page from, RequestParameter req ) throws PageException {
		return outputMain( from, req );
	}
}

