/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;

/**
 * SandBox に収納するバックグラウンド処理。
 */
public interface Daemon {
	/**
	 * バックグラウンド処理。このメソッドからリターンすると、スレッドは消滅します。
	 * @param channel バックグラウンドチャネル。
	 * @exception バックグラウンド処理中のエラー。
	 */
	public void run( DaemonChannel channel ) throws Exception;

	/**
	 * 後処理。
	 * スレッドが終わる直前に呼ばれます。正常終了時、例外発生時を問わず呼ばれます。
	 * @param e run で例外がスローされると、それを報告します。
	 * 正常終了時は null です。
	 */
	void onDestroy( Throwable e );

	/**
	 * 他スレッドからの通信。
	 * 他スレッドからデータを受け取り、それに対する応答を返す事ができます。<br>
	 * run とは別スレッドから呼ばれます。
	 * また、同時に複数スレッドから呼ばれる可能性があります。
	 * スレッドセーフな構造にして下さい。
	 * @param obj 受信インスタンス。
	 * @return 応答インスタンス。
	 */
	Object post( Object obj );

}

