/*
 * Paraselene
 * Copyright (c) 2009-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;

import paraselene.*;
import java.net.*;

/**
 * Forwardの代替となるクラスです。<br>
 * Page#output() からエラーまたは別ページへのリダイレクトを指示したい場合に
 * 使用できます。
 */
public class ForwardPage extends NullPage {
	Forward	fw;
	/**
	 * コンストラクタ。エラーを戻す。
	 * <br>セッションは常に解放されます。
	 * @param stat 404等。
	 */
	public ForwardPage( int stat ) {
		fw = new Forward( stat );
	}
	/**
	 * コンストラクタ。リダイレクト指定。
	 * @param uri 管理外のサイト等。
	 * @param session_off true:セッションを解放する、false:セッションを維持する
	 */
	public ForwardPage( URI uri, boolean session_off ) {
		fw = new Forward( uri, session_off );
	}

	public Forward input( RequestParameter req, Forward fw ) throws PageException{
		return fw;
	}
}

