/*
 * Paraselene
 * Copyright (c) 2009-2011  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.form;


import paraselene.*;
import paraselene.tag.*;


/**
 * INPUTタグ。
 */
public class Input extends Control {
	private static final long serialVersionUID = 2L;

	/**
	 * INPUTタグの種別。
	 */
	protected enum Type {
		TEXT("text"),
		PASSWORD("password"),
		CHECK("checkbox"),
		RADIO("radio"),
		SUBMIT("submit"),
		RESET("reset"),
		IMAGE("image"),
		BUTTON("button"),
		FILE("file"),
		HIDDEN("hidden"),
		// HTML5
		SEARCH("search"),
		TELEPHONE("tel"),
		URL("url"),
		EMAIL("email"),
		DATE_AND_TIME("datetime"),
		DATE("date"),
		MONTH("month"),
		WEEK("week"),
		TIME("time"),
		LOCAL_DATE_AND_TIME("datetime-local"),
		NUMBER("number"),
		RANGE("range"),
		COLOR("color");

		private static final long serialVersionUID = 1L;
		static final String TYPE="type";
		String	str;
		private Type( String s ) {
			str = s;
		}
	}

	/**
	 * INPUTタグ種別。
	 */
	protected Type input_type;

	/**
	 * コンストラクタ。
	 * @param t INPUTタグ種別。
	 */
	protected Input( Type t ) {
		super( "input", true );
		try {
			input_type = t;
			setAttribute( new Attribute( Type.TYPE, t.str ) );
		}
		catch( Exception e ) {}
	}

	/**
	 * コンストラクタ。
	 * @param t INPUTタグ種別。
	 * @param name name属性値。
	 */
	protected Input( Type t, String name ) {
		this( t );
		if ( name != null )	setAttribute( new Attribute( "name", name ) );
	}

	protected Tag newReplica() {
		return copy4Replica( new Input( input_type ) );
	}

	/**
	 * HIDDEN属性タグの生成。
	 * @param name name属性
	 * @param value value属性
	 * @return HIDDEN属性INPUTタグ。
	 */
	public static Input createHidden( String name, String value ) {
		Input	inp = new Input( Type.HIDDEN, name );
		inp.setValueString( value );
		return inp;
	}

	/**
	 * 入力不可であるか？
	 * @return true:入力不可、false:入力可能。
	 */
	public boolean isReadOnly() {
		return Control.Status.READONLY.isSet( this );
	}

	/**
	 * 入力不可設定。
	 * @param flag true:入力不可にする、false:入力可能にする。
	 */
	public void setReadOnly( boolean flag ) {
		Control.Status.READONLY.set( this, flag );
	}

	/**
	 * 値の設定。nullを指定すると、空文字列を設定します。
	 * @param v 設定値。
	 */
	public void setValueString( String v ) {
		if ( v == null )	v = "";
		super.setValueString( v );
	}
}


