/*
 * Paraselene
 * Copyright (c) 2009-2011  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.ui;

import paraselene.dyna.*;
import paraselene.tag.*;
import java.util.*;

class Info {
	String		tag;
	String		name;
	GrantTag	data;
	Info( String t, Class<?> cls, GrantTag gt ) {
		tag = t;
		name = cls.getName();
		data = gt;
	}
	GrantTag scan( Tag t ) {
		if ( t.getName().equals( tag ) )	return data;
		return null;
	}
}

/**
 * Paraseleneの特殊ユーザーインターフェイス情報を返します。
 */
public class UI implements GrantTagProvider {
	private static final Info[]	info = new Info[] {
		new Info( "div", paraselene.ui.PageBypassedDiv.class, new GrantTag() {
			public String getNewString() throws DynamicPageException {
				return "new paraselene.ui.PageBypassedDiv()";
			}
			public Tag getNewTag() throws DynamicPageException {
				return new paraselene.ui.PageBypassedDiv();
			}
		}),
		new Info( "div", paraselene.ui.Tab.class, new GrantTag() {
			public String getNewString() throws DynamicPageException {
				return "new paraselene.ui.Tab()";
			}
			public Tag getNewTag() throws DynamicPageException {
				return new paraselene.ui.Tab();
			}
		}),
	};
	private static HashMap<String, Info>	map = new HashMap<String, Info>();

	static {
		for ( int i = 0; i < info.length; i++ ) {
			map.put( info[i].name, info[i] );
		}
	}
	public GrantTag getGrantTag( Tag tag ) throws DynamicPageException {
		String[]	cls = tag.getClassAttribute();
		for ( int i = 0; i < cls.length; i++ ) {
			Info	hit = map.get( cls[i] );
			if ( hit == null )	continue;
			return hit.scan( tag );
		}
		return null;
	}
}

