/*
 * Paraselene
 * Copyright (c) 2009-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.util;

import java.util.*;

/**
 * IPv6アドレス。
 */
public class IPv6 extends IP {
	/**
	 * コンストラクタ。
	 * @param ip IPアドレス文字列。コロン区切りの16進数。::表記も可。<br>
	 * ただし、IPアドレス末尾の%以降は除去されます。
	 */
	public IPv6( String ip ) throws IPFormatException {
		super( parse( ip.trim() ) );
	}

	private static int parse( String str, String num ) throws IPFormatException {
		try {
			int	ret = Integer.parseInt( num, 16 );
			if ( ret < 0 || ret > 0xffff )	throw new IPFormatException( str );
			return ret;
		}
		catch( NumberFormatException e ) {
			throw new IPFormatException( str );
		}
	}

	private static int[] toByte( int[] org ) {
		int[]	ret = new int[16];
		for ( int i = 0; i < org.length; i++ ) {
			ret[i * 2] = org[i] >> 8;
			ret[i * 2 + 1] = org[i] & 0xff;
		}
		return ret;
	}

	private static int[] parse( String str ) throws IPFormatException {
		String[]	num = str.split( ":" );
		if ( num.length < 1 )	throw new IPFormatException( str );
		int	last = num.length - 1;
		String[]	test = num[last].split( "%" );
		num[last] = test[0];
		try {
			IPv4	v4 = new IPv4( num[last] );
			String[]	sub = new String[] {
				toString( v4.addr[0], v4.addr[1] ),
				toString( v4.addr[2], v4.addr[3] ),
			};
			String[]	fix = new String[num.length + 1];
			int	n = 0;
			for ( ; n < last; n++ )	fix[n] = num[n];
			fix[n] = sub[0];
			fix[n + 1] = sub[1];
			num = fix;
		}
		catch( IPFormatException e ) {}

		if ( num.length > 8 || num.length < 3 )	throw new IPFormatException( str );
		for ( int i = 0; i < num.length; i++ )	num[i] = num[i].trim();
		int[]	ret = new int[8];
		for ( int i = 0; i < 8; i++ )	ret[i] = 0;
		int	top_no = 0;
		for ( ; top_no < num.length; top_no++ ) {
			if ( num[top_no].isEmpty() )	break;
			ret[top_no] = parse( str, num[top_no] );
		}
		if ( top_no == 8 )	return toByte( ret );
		if ( top_no < 8 )	throw new IPFormatException( str );

		int	last_no = num.length - 1;
		int set_no = 8 - 1;
		for ( ; last_no > top_no; last_no--, set_no-- ) {
			ret[set_no] = parse( str, num[last_no] );
		}
		return toByte( ret );
	}

	private static String toString( int u, int l ) {
		return Integer.toString( u << 8 | l, 16 );
	}

	private static String toString( String[] data, int start ) {
		StringBuilder	buf = new StringBuilder( data[start] );
		for ( ; start < data.length; start++ ) {
			if ( data[start] == null )	break;
			buf = buf.append( ":" ).append( data[start] );
		}
		return buf.toString();
	}

	/**
	 * 文字列化。
	 * @return IPアドレス文字列。
	 */
	public String toString() {
		String[]	num = new String[8];
		int	zero = -1;
		int tmp_zero = -1;
		int	len = 0;
		for ( int i = 0; i < num.length; i++ ) {
			num[i] = toString( addr[i * 2], addr[i * 2 + 1] );
			if ( tmp_zero >= 0 ) {
				if ( "0".equals( num[i] ) )	continue;
				int	tmp_len = i - tmp_zero;
				if ( tmp_len > len ) {
					zero = tmp_zero;
					len = tmp_len;
				}
				tmp_zero = -1;
			}
			else {
				if ( "0".equals( num[i] ) ) tmp_zero = i;
			}
		}
		if ( tmp_zero >= 0 ) {
			int	tmp_len = num.length - tmp_zero;
			if ( tmp_len > len ) {
				zero = tmp_zero;
				len = tmp_len;
			}
		}

		if ( len < 1 )	return toString( num, 0 );
		len += zero;
		for ( int i = zero; i < len; i++ )	num[i] = null;
		StringBuilder	buf = new StringBuilder( toString( num, 0 ) );
		buf = buf.append( "::" ).append( toString( num, len ) );
		return buf.toString();
	}

	private IPv6( IP ip ) { super( ip ); }
	IP getReplica() {
		return new IPv6( this );
	}
}


