package #1;


import #1.#x.*;
import paraselene.*;
import paraselene.supervisor.*;
import paraselene.tag.*;
import paraselene.tag.form.*;
import paraselene.tag.list.*;
import paraselene.tag.table.*;
import paraselene.tag.ruby.*;
import paraselene.dyna.*;
import paraselene.css.*;
import paraselene.ui.*;

/**
 * サイトページ基底クラス。
 * 全てのページの共通メソッドを持たせたい場合にはこのクラスに記述できます。
 */
public abstract class SuperPage extends #1.#x.SuperPage implements Skin.PageInspecter {
	private static final long serialVersionUID = 1L;
	//--------------------------------------------------------------------
	// HTMLテンプレートをサポートするためのコードです(ここから)
	//--------------------------------------------------------------------
	/**
	 * HTMLテンプレート。
	 * 各引数は、実行環境に合わせて設定して下さい。
	 */
	protected static final Skin SKIN = new Skin(
		DOMINION,
		"UTF-8",	// URIデコード時の文字コード
		null,		// paraselene.ui.UI は明示されずとも自動的に追加されます
		// <param>タグでURIと判断する name 属性
		"data", "codebase", "movie"
	);
	/**
	 * inspectNameで検証から除外するものがあれば指定して下さい。
	 * @return 除外するname。
	 */
	protected String[] getExcludeName() {
		return new String[0];
	}
	/**
	 * ページ検証。テンプレートとして適用不可ならば例外をスローして下さい。
	 * @param page 検証するテンプレートを読み込んだページ。
	 * @exception テンプレート適用処理の中断。
	 */
	public void inspect( DynamicPage page ) throws Exception {
		NameDefine[]	result = inspectName( page, getExcludeName() );
		if ( result != null ) {
			String	message = NameDefine.toString( result );
			throw new Exception( message );
		}
	}
	/**
	 * テンプレート適用。
	 * @exception DynamicPageException テンプレート適用失敗。
	 */
	protected void apply() throws PageException {
		try {
			/* ディレクトリを示すパラメータは実行環境に合わせて指定して下さい。
			   第二引数は、/で始まる文字列でなければなりません。
			*/
			SKIN.apply( new java.io.File( "#3" ), "", this, this );
		}
		catch( DynamicPageException e ) {
			throw new PageException( e );
		}
	}
	//--------------------------------------------------------------------
	// HTMLテンプレートをサポートするためのコードです(ここまで)
	//--------------------------------------------------------------------

	/**
	 * コンストラクタ。
	 */
	public SuperPage() {
		super();
	}

	/**
	 * 出力文字コード。
	 * @return #2
	 */
	public String getCharset() {
		// 各ページで、出力文字コードを変更したい場合はオーバーライド
		// して下さい。
		// または、下記を直接書き換えて下さい。
		return "#2";
	}

	/**
	 * 出力コンテントタイプ。
	 * nullを返すと自動選定されます。選定方法は以下です。<br>
	 * isXML()がtrueを返し、且つ
	 * 携帯からのアクセスである場合に
	 * application/xhtml+xml を返します。<br>
	 * それ以外では text/html を返します。<br>
	 * またその時、getCharset()の戻り値を charset に指定します。
	 * @return null。
	 */
	public String getContentType() {
		// 各ページで、コンテキストタイプを変更したい場合はオーバーライド
		// して下さい。
		return null;
	}

	/**
	 * 履歴追加方法。
	 * 過去に同一ページがあれば、直近からそのページまでの履歴をクリアする。
	 * trueならクリア、falseなら維持する。
	 * @return true
	 */
	public boolean isHistoryClear() {
		// 各ページで、履歴クリアをしたくない場合にはオーバーライドして
		// falseを返して下さい。
		return true;
	}

	/**
	 * 履歴追加許可。
	 * @return true
	 */
	public boolean isAllowHistoryAdd() {
		// 各ページで、履歴に追加したくない場合にはオーバーライドして
		// falseを返して下さい。
		return true;
	}

	/**
	 * アップロードファイルの最大バイト数。
	 * @return 負数なら無制限に受け付けます。
	 */
	public int getUploadMaxBytes() {
		// アップロードに制限をかける場合は下記を修正するか、
		// 各ページでオーバーライドして下さい。
		// ここでは2Mバイトを上限としています。
		return 1024 * 1024 * 2;
	}

	/**
	 * 処理済みリクエストの再呼び出しを検出するか？
	 * このページに遷移するためのURIを生成する際のリクエストID付与を
	 * コントロールします。trueを返すとリクエストIDが付与されます。
	 * @return true:検出する、false:検出しない。
	 */
	public boolean isCheckRepeatSameRequest() {
		// 各ページで、処理済みリクエストの再呼び出しを検出したい場合には
		// オーバーライドしてtrueを返して下さい。
		return false;
	}

	/**
	 * 初期化。
	 */
	public void init() {
		// 全ページ共通の初期化処理があれば記述して下さい。
	}

	/**
	 * AJAXサポート機能の指定。
	 * アクセス元が携帯である場合は、この戻り値が何であっても無効になります。
	 * これ自体か、各ページでオーバーライドしてサポートされたい機能を指定して下さい。
	 * @return AJAXサポート。
	 */
	public AjaxSupport getAjaxSupport() {
		return AjaxSupport.NO;
		//return AjaxSupport.POPUP_DIALOG;
	}

	/**
	 * 入力値の検証を行う。
	 * このメソッドが呼ばれる際には必ずセッションが発生しています。
	 * 入力値のエラーチェックや入力値に即した動作を記述します。
	 * @param req リクエスト内容。
	 * @param fw デフォルト遷移先。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public Forward input( RequestParameter req, Forward fw ) throws PageException {
		// 共通処理等あれば記述して下さい。
		return inputMain( req, fw );
	}

	/**
	 * 初回outputの呼び出し直前にコールされます。初期化処理を記述します。
	 * @param req リクエスト内容。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public void firstOutput( RequestParameter req ) throws PageException {
	/* テンプレートHTMLを利用する場合は、apply()を呼び出して下さい。
		apply();
	 */
		// 共通処理等あれば記述して下さい。
		firstOutputMain( req );
	}

	/**
	 * 出力情報の設定を行う。
	 * @param from 遷移元ページ。直接呼ばれている場合はnullです。
	 * @param req リクエスト内容。
	 * @return 出力ページ。
	 * nullを返すとthisをリターンしたのと同じ扱いにされます。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public Page output( Page from, RequestParameter req ) throws PageException {
		// 共通処理等あれば記述して下さい。
		return outputMain( from, req );
	}
}

