package #1.#x;


import paraselene.*;
import paraselene.supervisor.*;
import paraselene.dyna.*;

/**
 * サイトページ基底クラス。
 * サイトの基本要素を定義します。
 */
public abstract class SuperPage extends Page {
	private static final long serialVersionUID = 1L;
	/**
	 * name 属性の検証。
	 * @param page 検証するページ
	 * @param exclude 検証から除外する name。
	 * @return エラーとなった name。
	 */
	public abstract NameDefine[] inspectName( Page page, String ... exclude );
	/**
	 * 入力値の検証メイン処理。
	 * @param req リクエスト内容。
	 * @param fw デフォルト遷移先。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public abstract Forward inputMain( RequestParameter req, Forward fw ) throws PageException;
	/**
	 * 出力情報の設定メイン処理。
	 * @param from 遷移元ページ。
	 * @param req リクエスト内容。
	 * @return 出力ページ。
	 * nullを返すとthisをリターンしたのと同じ扱いにされます。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public abstract Page outputMain( Page from, RequestParameter req ) throws PageException;
	/**
	 * 初回outputの呼び出しメイン処理。
	 * @param req リクエスト内容。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public abstract void firstOutputMain( RequestParameter req ) throws PageException;

	/**
	 * コンストラクタ。
	 */
	public SuperPage() {
		super();
	}

	/**
	 * ディレクトリ階層調査。<br>
	 * dir には、通常何れかの階層の SuperPage を指定します。
	 * page が、dir が存在するディレクトリ(パッケージ)と同じ位置に存在する、
	 * またはそのサブディレクトリに存在する場合に true となります。
	 * @param dir ディレクトリに含まれるクラス。
	 * 例えば、#1.#z.xxx.yyy.SuperPage.class を指定します。
	 * @param page 調査対象ページ。
	 * @return true:ディレクトリに所属、false:ディレクトリに所属しない。
	 */
	public static boolean isSubDirectory( Class<? extends SuperPage> dir, Page page ) {
		return page.getClass().isAssignableFrom( dir );
	}

	/**
	 * ディレクトリ階層調査。<br>
	 * dir には、通常何れかの階層の SuperPage を指定します。
	 * page が、dir が存在するディレクトリ(パッケージ)と同じ位置に存在する、
	 * またはそのサブディレクトリに存在する場合に true となります。
	 * @param dir ディレクトリに含まれるクラス。
	 * 例えば、#1.#z.xxx.yyy.SuperPage.class を指定します。
	 * @param id 調査対象ページのPageID。
	 * @return true:ディレクトリに所属、false:ディレクトリに所属しない。
	 */
	public static boolean isSubDirectory( Class<? extends SuperPage> dir, PageID id ) {
		PageFactory	pf = PageLoader.getPageFactory();
		Page	page = pf.getPage( id );
		if ( page == null )	return false;
		boolean	ret = isSubDirectory( dir, page );
		pf.returnPage( page );
		return ret;
	}

	/**
	 * 相対パス対応表。
	 */
	public static final Dominion DOMINION = new Dominion(
#5
	);
}

