/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;


/**
 * メモリ使用状況。
 */
public class MemoryInformation {
	private static Runtime	runtime = Runtime.getRuntime();

	/**
	 * JVMの使用可能最大メモリ。バイト。
	 */
	public final long	total = runtime.totalMemory();
	/**
	 * JVMのメモリ空き容量。バイト。
	 */
	public final long	free = runtime.freeMemory();

	/**
	 * コンストラクタ。
	 * 構築したインスタンスのメンバ変数に現在のスナップショットが設定されます。
	 */
	public MemoryInformation(){}

	/**
	 * メモリ使用率の確認。
	 * @return true:良好、false:使用可能メモリの93.75%を使っている。
	 */
	public boolean isSafeFreeMemory() {
		long	limit = total >> 4;
		if ( free > limit )	return true;
		return false;
	}

	/**
	 * ガベージコレクション要求。
	 * 使用可能メモリの87.5%を使っていればガベージコレクトをJVMに要求します。
	 */
	public void doGC() {
		long	limit = total >> 3;
		if ( free > limit )	return;
		runtime.gc();
	}
}

