<?php

/* -------------------------------------------------------------------------
	Simple Image Transformaer
	a part of PC2M Web Content Converter for Mobile Clients
	Copyright (C) 2005-2006 ucb@rcdtokyo.com
	http://www.rcdtokyo.com/pc2m/note/
------------------------------------------------------------------------- */

define('AVERAGE_BIT', 6);
define('AVERAGE_RATIO', 50);

// must have eight args
$args = explode(',', $_SERVER['QUERY_STRING']);
if (count($args) != 8) {
	exit('The request is invalid.');
}
$args[6] = urldecode($args[6]);
$args[7] = urldecode($args[7]);
if (
	// if destination size exceeds 999 x 999
	!preg_match('/^\d{2,6}$/', $args[0].$args[1])
	// if source size exceeds 9999 x 9999
	or !preg_match('/^\d{2,8}$/', $args[3].$args[4])
	// image format must be 1-3
	or !preg_match('/^[1-3][1-3]$/', $args[2].$args[5])
	// quality must be 0-256 (plus ratio identifier)
	or ($args[6] != '' and !preg_match('/^\d{1,3}[^\d\s]*$/', $args[6]))
	// if source URI does not start with HTTP
	or !preg_match('/^https?:\/\/\w/', $args[7])
	) {
	exit('The request is invalid.');
}

imageResize(
	$args[0],
	$args[1],
	$args[2],
	$args[3],
	$args[4],
	$args[5],
	$args[6],
	$args[7]
);

/* ----------------------------------------------------------------------
	imageResize
	returns image binary unless the source is not accessible
---------------------------------------------------------------------- */

function imageResize(
	$_new_width,
	$_new_height,
	$_new_type,
	$_original_width,
	$_original_height,
	$_original_type,
	$_quality,
	$_remote_url) {

	// retrieve remote file as an object
	switch ($_original_type) {
		case 1:
			$_original_image = @imageCreateFromGIF($_remote_url);
			break;
		case 2:
			$_original_image = @imageCreateFromJPEG($_remote_url);
			break;
		case 3:
			$_original_image = @imageCreateFromPNG($_remote_url);
	}

	if (!$_original_image) {
		exit('Failed loading '.$_remote_url);
	} else {
		$_new_image = imageCreateTrueColor($_new_width, $_new_height);

		// fill background white in case of transparenct GIF or PNG
		if ($_original_type != 2) {
			$color = imageColorAllocate($_new_image, 255, 255, 255);
			imagefill($_new_image, 0, 0, $color);
		}
		imageCopyResampled(
			$_new_image, $_original_image,
			0, 0, 0, 0,
			$_new_width, $_new_height,
			$_original_width, $_original_height
		);

		// if qulaity is specified in "numeric + non-numeric" format (e.g. 50%)
		$_use_ratio = false;
		if ($_quality != '' and preg_match('/^(\d{1,3})[^\d\s]/', $_quality, $matches)) {
			$_quality = $matches[1];
			$_use_ratio = true;
		}

		// palettize the image if the destination is GIF or PNG
		if ($_new_type != 2) {

			// if quality is not specified
			if ($_quality == '') {

				// if the source is GIF or PNG, dither by 256 colors
				// and then copy the source's palette
				if ($_original_type != 2) {
					imageTrueColorToPalette($_new_image, true, 256);
					imagePaletteCopy($_new_image, $_original_image);

					// following if-else statement is an alternative choice
					// it will dither by 32 colors if the source palette contains less colors
					// otherwise it will dither by 256 colors and then copy the source palette
					/*
					if (imageColorsTotal($_original_image) < 32) {
						imageTrueColorToPalette($_new_image, false, 32);
					} else {
						imageTrueColorToPalette($_new_image, false, 256);
						imagePaletteCopy($_new_image, $_original_image);
					}
					*/

				} else {
					imageTrueColorToPalette($_new_image, true, pow(2, AVERAGE_BIT));
				}

			// if quality is specified
			} else {
				if ($_use_ratio) {

					// if the source is GIF or PNG, retrieve bit-depth of its palette
					if ($_original_type != 2) {
						$i = imageColorsTotal($_original_image);
						$_base = 1;
						while ($i > 2) {
							$i = $i /2;
							$_base++;
						}
					} else {
						$_base = AVERAGE_BIT;
					}

					// calculate the bit-depth for the destination
					// and set 2^bit-depth as the number of colors for dithering
					if ($_quality == AVERAGE_RATIO) {
						$_bit = $_base;
					} elseif ($_quality < AVERAGE_RATIO) {
						$_bit = $_quality * (($_base -1) / AVERAGE_RATIO) +1;
					} elseif ($_quality > AVERAGE_RATIO) {
						$_bit = ($_quality -AVERAGE_RATIO) * ((8 - $_base) / (100 - AVERAGE_RATIO)) + $_base;
					}
					$_quality = pow(2, round($_bit));
				}
				// valid range here is 1-256
				if ($_quality < 1) {
					$_quality = 1;
				}
				if ($_quality > 256) {
					$_quality = 256;
				}
				imageTrueColorToPalette($_new_image, true, $_quality);
			}
		}

		switch ($_new_type) {
			case 1:
				header("Content-Type:image/gif");
				imageGIF($_new_image);
				break;
			case 2:
				// if quality is specified, use it as the the compression ratio
				// valid range here is 0-100
				if ($_quality == '') {
					$_quality = AVERAGE_RATIO;
				}
				if ($_quality < 0) {
					$_quality = 0;
				}
				if ($_quality > 100) {
					$_quality = 100;
				}
				header("Content-Type:image/jpeg");
				imageJPEG($_new_image, '', $_quality);
				break;
			case 3:
				header("Content-Type:image/png");
				imagePNG($_new_image);
		}
		imageDestroy($_original_image);
		imageDestroy($_new_image);
	}
}

?>