
(*************************************************************************
 Include file for AES_DECR.PAS - Compressed tables/Helper types

 Version  Date      Author      Modification
 -------  --------  -------     ------------------------------------------
 0.10     09.07.06  W.Ehrhardt  Initial version for compressed tables
 0.11     13.07.06  we          Removed InvSBox, b3 gets box byte
 0.12     19.07.06  we          TCdDummy
**************************************************************************)

(**** (C) Copyright 2002-2006 Wolfgang Ehrhardt -- see copying_we.txt ****)


type
  TH3 = packed record
          L: longint;
          b0,b1,b2,box: byte;
        end;

  TH2 = packed record
          b0: byte;
          L: longint;
          b1,b2,box: byte;
        end;

  TH1 = packed record
          b0,b1: byte;
          L: longint;
          b2,box: byte;
        end;

  TH0 = packed record
          b0,b1,b2: byte;
          L: longint;
          box: byte;
        end;

  TDU = record
          case integer of
            0: (D0: TH0);
            1: (D1: TH1);
            2: (D2: TH2);
            3: (D3: TH3);
        end;


{$ifdef StrictLong}
  {$warnings off}
  {$R-} {avoid D9+ errors!}
{$endif}


const
  {$ifdef AES_Decr_DummyAlign}
    TCdDummy : longint = 0;  {Use to align TCd to 8 byte boundary}
  {$endif}
  TCd: packed array[0..2047] of byte = (
         $f4,$a7,$50,$51,$f4,$a7,$50,$52,$41,$65,$53,$7e,$41,$65,$53,$09,
         $17,$a4,$c3,$1a,$17,$a4,$c3,$6a,$27,$5e,$96,$3a,$27,$5e,$96,$d5,
         $ab,$6b,$cb,$3b,$ab,$6b,$cb,$30,$9d,$45,$f1,$1f,$9d,$45,$f1,$36,
         $fa,$58,$ab,$ac,$fa,$58,$ab,$a5,$e3,$03,$93,$4b,$e3,$03,$93,$38,
         $30,$fa,$55,$20,$30,$fa,$55,$bf,$76,$6d,$f6,$ad,$76,$6d,$f6,$40,
         $cc,$76,$91,$88,$cc,$76,$91,$a3,$02,$4c,$25,$f5,$02,$4c,$25,$9e,
         $e5,$d7,$fc,$4f,$e5,$d7,$fc,$81,$2a,$cb,$d7,$c5,$2a,$cb,$d7,$f3,
         $35,$44,$80,$26,$35,$44,$80,$d7,$62,$a3,$8f,$b5,$62,$a3,$8f,$fb,
         $b1,$5a,$49,$de,$b1,$5a,$49,$7c,$ba,$1b,$67,$25,$ba,$1b,$67,$e3,
         $ea,$0e,$98,$45,$ea,$0e,$98,$39,$fe,$c0,$e1,$5d,$fe,$c0,$e1,$82,
         $2f,$75,$02,$c3,$2f,$75,$02,$9b,$4c,$f0,$12,$81,$4c,$f0,$12,$2f,
         $46,$97,$a3,$8d,$46,$97,$a3,$ff,$d3,$f9,$c6,$6b,$d3,$f9,$c6,$87,
         $8f,$5f,$e7,$03,$8f,$5f,$e7,$34,$92,$9c,$95,$15,$92,$9c,$95,$8e,
         $6d,$7a,$eb,$bf,$6d,$7a,$eb,$43,$52,$59,$da,$95,$52,$59,$da,$44,
         $be,$83,$2d,$d4,$be,$83,$2d,$c4,$74,$21,$d3,$58,$74,$21,$d3,$de,
         $e0,$69,$29,$49,$e0,$69,$29,$e9,$c9,$c8,$44,$8e,$c9,$c8,$44,$cb,
         $c2,$89,$6a,$75,$c2,$89,$6a,$54,$8e,$79,$78,$f4,$8e,$79,$78,$7b,
         $58,$3e,$6b,$99,$58,$3e,$6b,$94,$b9,$71,$dd,$27,$b9,$71,$dd,$32,
         $e1,$4f,$b6,$be,$e1,$4f,$b6,$a6,$88,$ad,$17,$f0,$88,$ad,$17,$c2,
         $20,$ac,$66,$c9,$20,$ac,$66,$23,$ce,$3a,$b4,$7d,$ce,$3a,$b4,$3d,
         $df,$4a,$18,$63,$df,$4a,$18,$ee,$1a,$31,$82,$e5,$1a,$31,$82,$4c,
         $51,$33,$60,$97,$51,$33,$60,$95,$53,$7f,$45,$62,$53,$7f,$45,$0b,
         $64,$77,$e0,$b1,$64,$77,$e0,$42,$6b,$ae,$84,$bb,$6b,$ae,$84,$fa,
         $81,$a0,$1c,$fe,$81,$a0,$1c,$c3,$08,$2b,$94,$f9,$08,$2b,$94,$4e,
         $48,$68,$58,$70,$48,$68,$58,$08,$45,$fd,$19,$8f,$45,$fd,$19,$2e,
         $de,$6c,$87,$94,$de,$6c,$87,$a1,$7b,$f8,$b7,$52,$7b,$f8,$b7,$66,
         $73,$d3,$23,$ab,$73,$d3,$23,$28,$4b,$02,$e2,$72,$4b,$02,$e2,$d9,
         $1f,$8f,$57,$e3,$1f,$8f,$57,$24,$55,$ab,$2a,$66,$55,$ab,$2a,$b2,
         $eb,$28,$07,$b2,$eb,$28,$07,$76,$b5,$c2,$03,$2f,$b5,$c2,$03,$5b,
         $c5,$7b,$9a,$86,$c5,$7b,$9a,$a2,$37,$08,$a5,$d3,$37,$08,$a5,$49,
         $28,$87,$f2,$30,$28,$87,$f2,$6d,$bf,$a5,$b2,$23,$bf,$a5,$b2,$8b,
         $03,$6a,$ba,$02,$03,$6a,$ba,$d1,$16,$82,$5c,$ed,$16,$82,$5c,$25,
         $cf,$1c,$2b,$8a,$cf,$1c,$2b,$72,$79,$b4,$92,$a7,$79,$b4,$92,$f8,
         $07,$f2,$f0,$f3,$07,$f2,$f0,$f6,$69,$e2,$a1,$4e,$69,$e2,$a1,$64,
         $da,$f4,$cd,$65,$da,$f4,$cd,$86,$05,$be,$d5,$06,$05,$be,$d5,$68,
         $34,$62,$1f,$d1,$34,$62,$1f,$98,$a6,$fe,$8a,$c4,$a6,$fe,$8a,$16,
         $2e,$53,$9d,$34,$2e,$53,$9d,$d4,$f3,$55,$a0,$a2,$f3,$55,$a0,$a4,
         $8a,$e1,$32,$05,$8a,$e1,$32,$5c,$f6,$eb,$75,$a4,$f6,$eb,$75,$cc,
         $83,$ec,$39,$0b,$83,$ec,$39,$5d,$60,$ef,$aa,$40,$60,$ef,$aa,$65,
         $71,$9f,$06,$5e,$71,$9f,$06,$b6,$6e,$10,$51,$bd,$6e,$10,$51,$92,
         $21,$8a,$f9,$3e,$21,$8a,$f9,$6c,$dd,$06,$3d,$96,$dd,$06,$3d,$70,
         $3e,$05,$ae,$dd,$3e,$05,$ae,$48,$e6,$bd,$46,$4d,$e6,$bd,$46,$50,
         $54,$8d,$b5,$91,$54,$8d,$b5,$fd,$c4,$5d,$05,$71,$c4,$5d,$05,$ed,
         $06,$d4,$6f,$04,$06,$d4,$6f,$b9,$50,$15,$ff,$60,$50,$15,$ff,$da,
         $98,$fb,$24,$19,$98,$fb,$24,$5e,$bd,$e9,$97,$d6,$bd,$e9,$97,$15,
         $40,$43,$cc,$89,$40,$43,$cc,$46,$d9,$9e,$77,$67,$d9,$9e,$77,$57,
         $e8,$42,$bd,$b0,$e8,$42,$bd,$a7,$89,$8b,$88,$07,$89,$8b,$88,$8d,
         $19,$5b,$38,$e7,$19,$5b,$38,$9d,$c8,$ee,$db,$79,$c8,$ee,$db,$84,
         $7c,$0a,$47,$a1,$7c,$0a,$47,$90,$42,$0f,$e9,$7c,$42,$0f,$e9,$d8,
         $84,$1e,$c9,$f8,$84,$1e,$c9,$ab,$00,$00,$00,$00,$00,$00,$00,$00,
         $80,$86,$83,$09,$80,$86,$83,$8c,$2b,$ed,$48,$32,$2b,$ed,$48,$bc,
         $11,$70,$ac,$1e,$11,$70,$ac,$d3,$5a,$72,$4e,$6c,$5a,$72,$4e,$0a,
         $0e,$ff,$fb,$fd,$0e,$ff,$fb,$f7,$85,$38,$56,$0f,$85,$38,$56,$e4,
         $ae,$d5,$1e,$3d,$ae,$d5,$1e,$58,$2d,$39,$27,$36,$2d,$39,$27,$05,
         $0f,$d9,$64,$0a,$0f,$d9,$64,$b8,$5c,$a6,$21,$68,$5c,$a6,$21,$b3,
         $5b,$54,$d1,$9b,$5b,$54,$d1,$45,$36,$2e,$3a,$24,$36,$2e,$3a,$06,
         $0a,$67,$b1,$0c,$0a,$67,$b1,$d0,$57,$e7,$0f,$93,$57,$e7,$0f,$2c,
         $ee,$96,$d2,$b4,$ee,$96,$d2,$1e,$9b,$91,$9e,$1b,$9b,$91,$9e,$8f,
         $c0,$c5,$4f,$80,$c0,$c5,$4f,$ca,$dc,$20,$a2,$61,$dc,$20,$a2,$3f,
         $77,$4b,$69,$5a,$77,$4b,$69,$0f,$12,$1a,$16,$1c,$12,$1a,$16,$02,
         $93,$ba,$0a,$e2,$93,$ba,$0a,$c1,$a0,$2a,$e5,$c0,$a0,$2a,$e5,$af,
         $22,$e0,$43,$3c,$22,$e0,$43,$bd,$1b,$17,$1d,$12,$1b,$17,$1d,$03,
         $09,$0d,$0b,$0e,$09,$0d,$0b,$01,$8b,$c7,$ad,$f2,$8b,$c7,$ad,$13,
         $b6,$a8,$b9,$2d,$b6,$a8,$b9,$8a,$1e,$a9,$c8,$14,$1e,$a9,$c8,$6b,
         $f1,$19,$85,$57,$f1,$19,$85,$3a,$75,$07,$4c,$af,$75,$07,$4c,$91,
         $99,$dd,$bb,$ee,$99,$dd,$bb,$11,$7f,$60,$fd,$a3,$7f,$60,$fd,$41,
         $01,$26,$9f,$f7,$01,$26,$9f,$4f,$72,$f5,$bc,$5c,$72,$f5,$bc,$67,
         $66,$3b,$c5,$44,$66,$3b,$c5,$dc,$fb,$7e,$34,$5b,$fb,$7e,$34,$ea,
         $43,$29,$76,$8b,$43,$29,$76,$97,$23,$c6,$dc,$cb,$23,$c6,$dc,$f2,
         $ed,$fc,$68,$b6,$ed,$fc,$68,$cf,$e4,$f1,$63,$b8,$e4,$f1,$63,$ce,
         $31,$dc,$ca,$d7,$31,$dc,$ca,$f0,$63,$85,$10,$42,$63,$85,$10,$b4,
         $97,$22,$40,$13,$97,$22,$40,$e6,$c6,$11,$20,$84,$c6,$11,$20,$73,
         $4a,$24,$7d,$85,$4a,$24,$7d,$96,$bb,$3d,$f8,$d2,$bb,$3d,$f8,$ac,
         $f9,$32,$11,$ae,$f9,$32,$11,$74,$29,$a1,$6d,$c7,$29,$a1,$6d,$22,
         $9e,$2f,$4b,$1d,$9e,$2f,$4b,$e7,$b2,$30,$f3,$dc,$b2,$30,$f3,$ad,
         $86,$52,$ec,$0d,$86,$52,$ec,$35,$c1,$e3,$d0,$77,$c1,$e3,$d0,$85,
         $b3,$16,$6c,$2b,$b3,$16,$6c,$e2,$70,$b9,$99,$a9,$70,$b9,$99,$f9,
         $94,$48,$fa,$11,$94,$48,$fa,$37,$e9,$64,$22,$47,$e9,$64,$22,$e8,
         $fc,$8c,$c4,$a8,$fc,$8c,$c4,$1c,$f0,$3f,$1a,$a0,$f0,$3f,$1a,$75,
         $7d,$2c,$d8,$56,$7d,$2c,$d8,$df,$33,$90,$ef,$22,$33,$90,$ef,$6e,
         $49,$4e,$c7,$87,$49,$4e,$c7,$47,$38,$d1,$c1,$d9,$38,$d1,$c1,$f1,
         $ca,$a2,$fe,$8c,$ca,$a2,$fe,$1a,$d4,$0b,$36,$98,$d4,$0b,$36,$71,
         $f5,$81,$cf,$a6,$f5,$81,$cf,$1d,$7a,$de,$28,$a5,$7a,$de,$28,$29,
         $b7,$8e,$26,$da,$b7,$8e,$26,$c5,$ad,$bf,$a4,$3f,$ad,$bf,$a4,$89,
         $3a,$9d,$e4,$2c,$3a,$9d,$e4,$6f,$78,$92,$0d,$50,$78,$92,$0d,$b7,
         $5f,$cc,$9b,$6a,$5f,$cc,$9b,$62,$7e,$46,$62,$54,$7e,$46,$62,$0e,
         $8d,$13,$c2,$f6,$8d,$13,$c2,$aa,$d8,$b8,$e8,$90,$d8,$b8,$e8,$18,
         $39,$f7,$5e,$2e,$39,$f7,$5e,$be,$c3,$af,$f5,$82,$c3,$af,$f5,$1b,
         $5d,$80,$be,$9f,$5d,$80,$be,$fc,$d0,$93,$7c,$69,$d0,$93,$7c,$56,
         $d5,$2d,$a9,$6f,$d5,$2d,$a9,$3e,$25,$12,$b3,$cf,$25,$12,$b3,$4b,
         $ac,$99,$3b,$c8,$ac,$99,$3b,$c6,$18,$7d,$a7,$10,$18,$7d,$a7,$d2,
         $9c,$63,$6e,$e8,$9c,$63,$6e,$79,$3b,$bb,$7b,$db,$3b,$bb,$7b,$20,
         $26,$78,$09,$cd,$26,$78,$09,$9a,$59,$18,$f4,$6e,$59,$18,$f4,$db,
         $9a,$b7,$01,$ec,$9a,$b7,$01,$c0,$4f,$9a,$a8,$83,$4f,$9a,$a8,$fe,
         $95,$6e,$65,$e6,$95,$6e,$65,$78,$ff,$e6,$7e,$aa,$ff,$e6,$7e,$cd,
         $bc,$cf,$08,$21,$bc,$cf,$08,$5a,$15,$e8,$e6,$ef,$15,$e8,$e6,$f4,
         $e7,$9b,$d9,$ba,$e7,$9b,$d9,$1f,$6f,$36,$ce,$4a,$6f,$36,$ce,$dd,
         $9f,$09,$d4,$ea,$9f,$09,$d4,$a8,$b0,$7c,$d6,$29,$b0,$7c,$d6,$33,
         $a4,$b2,$af,$31,$a4,$b2,$af,$88,$3f,$23,$31,$2a,$3f,$23,$31,$07,
         $a5,$94,$30,$c6,$a5,$94,$30,$c7,$a2,$66,$c0,$35,$a2,$66,$c0,$31,
         $4e,$bc,$37,$74,$4e,$bc,$37,$b1,$82,$ca,$a6,$fc,$82,$ca,$a6,$12,
         $90,$d0,$b0,$e0,$90,$d0,$b0,$10,$a7,$d8,$15,$33,$a7,$d8,$15,$59,
         $04,$98,$4a,$f1,$04,$98,$4a,$27,$ec,$da,$f7,$41,$ec,$da,$f7,$80,
         $cd,$50,$0e,$7f,$cd,$50,$0e,$ec,$91,$f6,$2f,$17,$91,$f6,$2f,$5f,
         $4d,$d6,$8d,$76,$4d,$d6,$8d,$60,$ef,$b0,$4d,$43,$ef,$b0,$4d,$51,
         $aa,$4d,$54,$cc,$aa,$4d,$54,$7f,$96,$04,$df,$e4,$96,$04,$df,$a9,
         $d1,$b5,$e3,$9e,$d1,$b5,$e3,$19,$6a,$88,$1b,$4c,$6a,$88,$1b,$b5,
         $2c,$1f,$b8,$c1,$2c,$1f,$b8,$4a,$65,$51,$7f,$46,$65,$51,$7f,$0d,
         $5e,$ea,$04,$9d,$5e,$ea,$04,$2d,$8c,$35,$5d,$01,$8c,$35,$5d,$e5,
         $87,$74,$73,$fa,$87,$74,$73,$7a,$0b,$41,$2e,$fb,$0b,$41,$2e,$9f,
         $67,$1d,$5a,$b3,$67,$1d,$5a,$93,$db,$d2,$52,$92,$db,$d2,$52,$c9,
         $10,$56,$33,$e9,$10,$56,$33,$9c,$d6,$47,$13,$6d,$d6,$47,$13,$ef,
         $d7,$61,$8c,$9a,$d7,$61,$8c,$a0,$a1,$0c,$7a,$37,$a1,$0c,$7a,$e0,
         $f8,$14,$8e,$59,$f8,$14,$8e,$3b,$13,$3c,$89,$eb,$13,$3c,$89,$4d,
         $a9,$27,$ee,$ce,$a9,$27,$ee,$ae,$61,$c9,$35,$b7,$61,$c9,$35,$2a,
         $1c,$e5,$ed,$e1,$1c,$e5,$ed,$f5,$47,$b1,$3c,$7a,$47,$b1,$3c,$b0,
         $d2,$df,$59,$9c,$d2,$df,$59,$c8,$f2,$73,$3f,$55,$f2,$73,$3f,$eb,
         $14,$ce,$79,$18,$14,$ce,$79,$bb,$c7,$37,$bf,$73,$c7,$37,$bf,$3c,
         $f7,$cd,$ea,$53,$f7,$cd,$ea,$83,$fd,$aa,$5b,$5f,$fd,$aa,$5b,$53,
         $3d,$6f,$14,$df,$3d,$6f,$14,$99,$44,$db,$86,$78,$44,$db,$86,$61,
         $af,$f3,$81,$ca,$af,$f3,$81,$17,$68,$c4,$3e,$b9,$68,$c4,$3e,$2b,
         $24,$34,$2c,$38,$24,$34,$2c,$04,$a3,$40,$5f,$c2,$a3,$40,$5f,$7e,
         $1d,$c3,$72,$16,$1d,$c3,$72,$ba,$e2,$25,$0c,$bc,$e2,$25,$0c,$77,
         $3c,$49,$8b,$28,$3c,$49,$8b,$d6,$0d,$95,$41,$ff,$0d,$95,$41,$26,
         $a8,$01,$71,$39,$a8,$01,$71,$e1,$0c,$b3,$de,$08,$0c,$b3,$de,$69,
         $b4,$e4,$9c,$d8,$b4,$e4,$9c,$14,$56,$c1,$90,$64,$56,$c1,$90,$63,
         $cb,$84,$61,$7b,$cb,$84,$61,$55,$32,$b6,$70,$d5,$32,$b6,$70,$21,
         $6c,$5c,$74,$48,$6c,$5c,$74,$0c,$b8,$57,$42,$d0,$b8,$57,$42,$7d);
var
  Td: packed array[byte] of TDU absolute TCd;

{$ifdef StrictLong}
  {$warnings on}
  {$ifdef RangeChecks_on}
    {$R+}
  {$endif}
{$endif}


