#!/bin/sh
cat << 'EEE' > /dev/null
/* Copyright (C) 2021 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

set -eu

# path/binary setting
cd `dirname $0`	#base $0 dir
fdir=`pwd`
cd ../..
topdir=`pwd`	#configure root
cp -Rf $fdir ./
cd _tests
wdir=`pwd`
PATH="$wdir:$PATH"
touch log.txt

ln -fs "$topdir"/src/ped ./
ln -fs "$topdir"/src/ped.h ./
ln -fs "$topdir"/src/libped.a ./
ln -fs "$topdir"/src/luka.ped ./

ln -fs "$topdir"/src/tests.code ./tests.c

eval "`shunit_m`"
echo "--- run binary test: `pwd`/$0
..."

set +e
( set -x
#--build test
cc `find ./ -maxdepth 1 -name '*.c'`	\
	`find ./ -maxdepth 1 -name '*.a'`	\
	-I./ -ldl -lm
_suc
./a.out  >buf_ 2>&1
_suc
cat buf_|grep 'fail/all:' >&3

### -- test_maincode
./ped -h
_suc

./ped -H
_suc

./ped -V
_suc

./ped -re 'ID<-[a-z]+ {_1="Z"}' -d
_suc

./ped -rf nofile.ped < tests.sh
_fail

#-e/f
_eq "12Z" `echo "12a"|./ped -re 'ID<-[a-z]+ {_1="Z"}'`

./ped -rf luka.ped < tests.sh
_suc

./ped -nrf luka.ped tests.sh
_suc

./ped -nrf nofile.txt
_fail

_eq "d#ccZ" `./ped -re 'R1<- "a" ("b"/"c") "d" {_1=_3"\043"_2;_3="Z"}' -E "acd"`
_eq aZc `echo abc|./ped -re 'R1<-"b" {_1="Z"}'  #>>  aZc `

echo abc|./ped -rf luka.ped
_suc

	msg="selective test"
./ped -rf luka.ped -e 'R1<-"b" {_1="Z"}'
_fail

# -E/ag1
_eq aZc `./ped -re 'R1<-"b" {_1="Z"}' -E 'abc'  #>>  aZc`
_eq aZc `printf "abc"| ./ped -re 'R1<-"b" {_1="Z"}'	#>> (same)`

	msg="selective test"
./ped -re 'R1<-"b" {_1="Z"}' -E abc tests.sh
_fail

./ped -re 'R1<-"b" {_1="Z"}' tests.sh
_suc

#-n/N
_eq Z `echo abc|./ped -nre 'R1<-"a" {_1="Z"}'  #>>  Z`

	msg="errstop test"
echo abc|./ped -Ne 'R1<-"a"'
_fail

_eq a `echo abc|./ped -nre 'R1<-"a"'  #>> a`
_eq a `echo abc|./ped  -re 'R1 <- "a"	OTHER <- . {_0 = ""}'	#>> a`

#-r
_eq dABbbZ `./ped -re 'R1 <- "a" ("b"/"c") "d" {_1=_3 "AB" _2;_3="Z"}' -E abd`

# -R
sv="$LANG"	#>> LC_CTYPE == lang.UTF-8
_eq Z  `./ped -re 'RULE <- e/./ {_0 = "Z"}' -E "Σ"	#>> Z`
_eq ZZ `./ped -Re 'RULE <- e/./ {_0 = "Z"}' -E "Σ"		#>> ZZ`
LANG="C"
_eq ZZ `./ped -re 'RULE <- e/./ {_0 = "Z"}' -E "Σ"		#>> ZZ`
_eq ZZ `./ped -Re 'RULE <- e/./ {_0 = "Z"}' -E "Σ"		#>> ZZ`
LANG="$sv"

# -t/T
echo abc | ./ped -tre 'R1 <- "a" {_0="@"}'| grep '\\100'
_suc

	msg="-T skips editblk"
echo abc | ./ped -Tre 'R1 <- "a" {_0="@"}'| grep '\\100'
_fail

# -o
./ped -rf luka.ped tests.sh -o /dev/null
_suc

# -L
./ped -rL 'ab' -f luka.ped tests.sh
_suc

./ped -rL '\r\u000a' -f luka.ped tests.sh
_suc

./ped -rL 'E' -e 'R1 <- "v" {_E}' tests.sh
_fail

./ped -re 'R1 <- "v" id' tests.sh
_fail

./ped -e 'R1 <- h"\"' tests.sh
_fail

./ped -re 'R1 <- h"\"' tests.sh
_suc

buf='\\'
buf=`./ped -re 'R1 <- h"\" {_0=h"@"}' -E "$buf"`
_eq '@@' "$buf" 

./ped -re '' tests.sh > buf.txt
_suc
diff -u tests.sh buf.txt
_suc
test -e buf.txt && rm buf.txt

{
src='//luka.ped sample
[==[ lua orig + C-syntax expantion ]==]
lo u = require("util")

fn myf(ag1){
	for(i=1,ag1){
		if(i==5||i==6){continue}
		print(i)
		break
	}
}
'
echo "$src"
./ped -rf ./luka.ped -E "$src"
_suc
echo ""
} >&3

## --test_end
_res 2>&3
echo "--- SUCCESS for all tests. see $0, log.txt if needs" >&3
) 3>&2 >log.txt 2>&1 
test $? = 0 && flg=0 || flg=1

test "$flg" = 0 && exit 0
#err
tail log.txt >/dev/stderr
echo "--- test FAILED, see $0, log.txt" >/dev/stderr
exit 1
