#!/bin/sh
cat << 'EEE' > /dev/null
/* Copyright (C) 2021 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

set -eu
(
# path/binary setting
pdir=`pwd`	#parent, callsrc dir
cd `dirname $0`	#base $0 dir
bdir=`pwd`
cd ../..
topdir=`pwd`	#configure root
cd "$bdir"
cp "$topdir"/src/ped ./
PATH="$bdir:$PATH"

echo "--- run binary test: `pwd`/$0
..."

(
# posix: 2.8.1 Consequences of Shell Errors, Other utility >>> shall not exit
# needs check $?. see 'set -e' help and posix man
_eq(){ test "$1" != "$2" && exit 1;:; }
_neq(){ test "$1" = "$2" && exit 1;:; }
_suc(){ test $? = 0 || exit 1;:; }
_fail(){ test $? != 0 || exit 1;:; }

# posix: 2.5.3 Shell Variables
#If the shell is not currently executing a script or function, the value of LINENO is unspecified. 
dmy=${LINENO:='no_POSIX'}

#--- from license: cc-by-sa 3.0 (code is changed from the orig)
# https://stackoverflow.com/questions/17804007	Q: dspjm  ->  A: devnull
PS4='${LINENO}	: '
#--- end license:	cc-by-sa 3.0

set -x
# info
ped -h
_suc

ped -H
_suc

ped -V
_suc

ped -re 'ID<-[a-z]+ {_1="Z"}' -d
_suc

ped -rf nofile.ped < tests.sh
_fail

#-e/f
_eq "12Z" `echo "12a"|ped -re 'ID<-[a-z]+ {_1="Z"}'`

ped -rf luka.ped < tests.sh
_suc

ped -nrf luka.ped tests.sh
_suc

ped -nrf nofile.txt
_fail

_eq "d#ccZ" `ped -re 'R1<- "a" ("b"/"c") "d" {_1=_3"\043"_2;_3="Z"}' -E "acd"`
_eq aZc `echo abc|ped -re 'R1<-"b" {_1="Z"}'  #>>  aZc `

echo abc|ped -rf luka.ped
_suc

	msg="selective test"
ped -rf luka.ped -e 'R1<-"b" {_1="Z"}'
_fail

# -E/ag1
_eq aZc `ped -re 'R1<-"b" {_1="Z"}' -E 'abc'  #>>  aZc`
_eq aZc `printf "abc"| ped -re 'R1<-"b" {_1="Z"}'	#>> (same)`

	msg="selective test"
ped -re 'R1<-"b" {_1="Z"}' -E abc tests.sh
_fail

ped -re 'R1<-"b" {_1="Z"}' tests.sh
_suc

#-n/N
_eq Z `echo abc|ped -nre 'R1<-"a" {_1="Z"}'  #>>  Z`

	msg="errstop test"
echo abc|ped -Ne 'R1<-"a"'
_fail

_eq a `echo abc|ped -nre 'R1<-"a"'  #>> a`
_eq a `echo abc|ped  -re 'R1 <- "a"	OTHER <- . {_0 = ""}'	#>> a`

#-r
_eq dABbbZ `ped -re 'R1 <- "a" ("b"/"c") "d" {_1=_3 "AB" _2;_3="Z"}' -E abd`

# -R
sv="$LANG"	#>> LC_CTYPE == lang.UTF-8
_eq Z  `ped -re 'RULE <- r/./ {_0 = "Z"}' -E "Σ"	#>> Z`
_eq ZZ `ped -Re 'RULE <- r/./ {_0 = "Z"}' -E "Σ"		#>> ZZ`
LANG="C"
_eq ZZ `ped -re 'RULE <- r/./ {_0 = "Z"}' -E "Σ"		#>> ZZ`
_eq ZZ `ped -Re 'RULE <- r/./ {_0 = "Z"}' -E "Σ"		#>> ZZ`
LANG="$sv"

# -t/T
echo abc | ped -tre 'R1 <- "a" {_0="@"}'| grep '\\100'
_suc

	msg="-T skips editblk"
echo abc | ped -Tre 'R1 <- "a" {_0="@"}'| grep '\\100'
_fail

# -o
ped -rf luka.ped tests.sh -o /dev/null
_suc

# -L
ped -rL 'ab' -f luka.ped tests.sh
_suc

ped -rL '\r\u000a' -f luka.ped tests.sh
_suc

ped -rL 'E' -e 'R1 <- "v" {_E}' tests.sh
_fail

ped -re 'R1 <- "v" id' tests.sh
_fail

:	# make rc=0, complete
) >/dev/null 2>buf.log || (tail buf.log;echo "--- test FAILED"; exit 1) >/dev/stderr

echo "--- success for all tests"
)
