#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[/][/*]SH_'     ;O=${0##*[/]};R=`dirname $0`;R=${R%/}/;R0=$R$O;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGsuffix"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d
:l;n;p;bl"<$R0>$Rm;$Rp"$Rm"';RB=$($R"s/${C}OP//p"<$R0|(F=mw;while read -r a b;do
B=${a%:};F=`$Rp"$F"|$R"s#$B:*##1;p"`${a%_};$Rp"C$B=\$(cat<<'E'$O$b${O}E$O)";done
$Rp"R1=$F"));Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;bl"<$R0';Cw="(R=LS;$Rw;$Rw>&3;R=HD
$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';Re=eval\ ;$Re"$RB";while getopts $R1\
 R;do case $R in \?)exit 1;;*)$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac
done;[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit   #END GPL3+*/

/*SH_LS*/
/* Copyright (C) 2021 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/*SH_doc
@NAME lbc - helper macro/api to embed luajit code into C

@SYNOPSYS
<pre>
#include "lbc.h"
typedef struct struct lbc_tag {
	lua_t* L;
	char* emsg;
	int rc;
	char glname[64];
	int lpflg;
	int used;
} lbc_t;
	
typedef struct lbc_rttag {
	int inner_flg; 
	int  tp;
	int i;
	double d;
	const char* s;
	int sz;
} lbc_rt;
	
//runner
lbc_t* lbc_new(void);
void lbc_free(lbc_t* obj);
int lbc_reqbcM(lbc_t* obj, ...);
int lbc_runbcM(lbc_t* obj, int ac, char** av, FILE_IDENT );
int lbc_runstr(lbc_t* obj, int ac, char** av, const char* str);
int lbc_prunbcM(lbc_t* obj, int ac, char** av, name );
int lbc_prunstr(lbc_t* obj, int ac, char** av, const char* str);

//result-reader	
lbc_rt lbc_tbval(lbc_t* obj, ...);
int lbc_tbvalsv(int nidx, lbc_t* obj, ...);
int lbc_delsv(lbc_t* obj, int idx);
int lbc_cleansv(lbc_t* obj);
int lbc_directf(int nidx, lbc_t* obj, ...);
int lbc_pdirectf(int nidx, lbc_t* obj, ...);
#define LBC_C2P	//see NOTES. for directf/pdirectf 
#define LBC_P2C
#define LBC_P2S


//result-support
lbc_pairs(k, v, obj, ...){...}
lbc_ipairs(i, v, obj, ...){...}
int lbc_keysv(int nidx, lbc_t* obj);
int lbc_valsv(int nidx, lbc_t* obj);
	
//lhh, use luatb as hash instead of c99 hsearch()
typedef struct luahash_tag{
	lua_t* L;
	char* emsg;
	int rc;
	char glname[64];
	int lpflg;
	int cnt;
} lhh_t;
typedef lbc_rt lhh_rt;

lhh_t* lhh_new(void);
void lhh_free(lhh_t* obj);
int lhh_set(lhh_t* obj, key, val, ...);
int lhh_unset(lhh_t* obj, key);
lhh_rt lhh_get(lhh_t* obj, key);

// use 'double' args instead of 'int'
int lhh_setd(lhh_t* obj, key, val, ...);
int lhh_unsetd(lhh_t* obj, key);
lhh_rt lhh_getd(lhh_t* obj, key);
</pre>


@DESCRIPTION
lbc assists embed luajit code to C.	

<pre>
basic API:
- lbc_new() makes luajit vm
- lbc_reqbcM() imports dependent lj bytecode file as require()
- lbc_runbcM(), runstr() execute byte/str code
- lbc_tbval() gets rtn/tb val with C type, int, char* etc
- lbc_free() closes luajit vm and release memory

additional API:
- lbc_directf() executes luajit code directly as lbc_runstr()
  Only available after runbcM()/runstr()
- prunbcM(), prunstr(), pdirectf() catches assert() and rtn emsg
- lbc_tbvalsv(), delsv(), cleansv() treats rtn/tb val
- lbc_pairs(), ipairs(), keysv(), valsv() handle luatb from C.
   mimicing the syntax of lua.
</pre>
**lhh** is hash api using luatb. lhh is independet from **lbc**.
lhh can uses lbc_pairs() / lbc_ipairs() macro. see samples.
<pre>
- lhh_new() creates hashtable. setup luavm and luatb internally.
- lhh_set() sets key/val to hash.
- lhh_unset() removes key/val from hash.
- lhh_get() gets val from hash.
- lhh_free() closes hash(luavm) and releases memory.
</pre>
setd(),unsetd(),getd() uses double type instead of integer.


EXSAMPLE
======
```
--mod.lua
local M={}
function M.myf() print("from_mod"); return 10; end
return M

--run.lua
local m = require("mod")
m.myf()
return -3, "gw"
-- ~$ luajit run.lua	#>> (testrun) from_mod
-- ~$ luajit -b mod.lua mod.h	#>> prepare bytecode mod.h
-- ~$ luajit -b run.lua run.h	#>> run.h

//--src.c 
#include "lbc.h"
int main(int argc, char** argv) {
	lbc_t* obj = lbc_new();
	#include "mod.h"
	lbc_reqbcM(obj, mod);	//macro: mod >> "mod.h" strlen(mod_XX);
	#include "run.h"
	int n = lbc_runbcM(obj, argc, argv, run);	//n=len{-3, "gw"}=2
		// set argv to _G.arg, works as ~$ luajit run.lua ag1 ag2 ...
	lbc_rt val = lbc_tbval(obj, 0, 2);	// val=obj[0][2]
	printf("%s\n", val.s);	// val.tp=='s'tring, val.s== "gw"
	lbc_free(obj);
	return 0;
}
//~$ gcc src.c -static liblbc.a -lm -ldl
//(or ~$ gcc src.c -lluajit5.1 -lm -ldl liblbc.a)
//..liblbc.a holds whole libluajit5.1.a files.

----------
//--src2.c,	detail sample code
#include "lbc.h"
int main(int ac, char** av) {
	lbc_t* obj = lbc_new();
	#include "mod1.h"
	#include "mod2.h"
	#include "mod3.h"
	#include "mod4.h"
	lbc_reqbcM(obj, mod1, mod2, mod3);	// support at least 9 args
	lbc_reqbcM(obj, mod4);	// allow req many times
	int n = lbc_runstr(obj, ac, av, "return require('mod2').myf()");
//call only once lbc_runbcM() or lbc_runstr() 
	
	lbc_rt val=lbc_tbval(obj,0,1);	//obj[0]={r1,r2}, obj[0][1]=r1 etc
//luartns are saved to [0], return 1,2,{10,20} >> obj[0]={1,2,{10,20}} 
//- int val.tp='s': (n)um(s)tr(t)b(b)ool(N)il(f)c(T)hread(u)data(l)udata
//- tp='s' >> sz=bytesz, tp='t' >> sz==#tb (tb[1]-tb[n], cnt only seq)
//- tp: val.i/val.d/val.s/val.sz == int/dbl/const char* /int 
//- test yourself if needs tp check: val.d-val.i==0 (...maybe int)
//- true/false,nil is converted to int val.i 1/0
//- val cant hold non-C data, table/func etc. val.tp check only.

// allows int/str key, tbval(obj,0,"k",&p,n)==obj[0]["k"]["str"][3]
//- use as str if ag starts with "/&. char* p="str", char** p=&str
//- strkey cant holds '\0'. not "/& args are treated as int
//- dbl cant use as key, lbc_tbval(obj, 3.01, "key1") == obj[3]["key1"]

	int idx=lbc_tbvalsv(3,obj,0,2); // obj[3]=obj[0][2]={1,k="a\0z"} etc
// copy from idx[0][2] to dst idx[3]. dstidx allows only intnum.
// lbc_runXX(), directf() uses obj[0] as rtnbuff and overwrite.

	idx = lbc_tbvalsv(-1, obj, 0, 1);	//dstidx<0: use autoidx. rtn= -1
	idx = lbc_tbvalsv(-9, obj, 0,"a");	//rtn=-2,obj[-2]=obj[0]["a"]=nil
	idx = lbc_tbvalsv(-1, obj, 0, 2);	//rtn= -2 (upper obj[-2]=nil)
	lbc_delsv(obj, -2);	// obj[-2]=nil
	lbc_cleansv(obj);	// del all autoidx, obj[idx<0]
	idx = lbc_tbvalsv(-7,obj,0); //obj[-1]=obj[0],rtn= -1
// you must manage saveidx yourself if use idx>0
// you may use autoidx for local val or tmpbuff pool etc.

//---
//mimic of luatb forloop, lbc_pairs/ipairs/keysv/valsv (macro/funcs)
//(k,v,obj,0,"key") >> obj[0]["key"]	...you cant use dbl as keyidx
	lbc_pairs(k, v, obj, 0){
		printf("%c, %c\n", k.tp, v.tp);		// obj[0] must be tb
		printf("%d, %d\n", k.i, v.i);		//k,v holds lbc_rt data
	}
	lbc_ipairs(num, val, obj, -3){
		printf("%d,%c\n",num,val.tp);	//obj[-3], ipair key is int
		int idx;
		idx=lbc_keysv(-8,obj); //obj[autoidx]=keydata, no needs ag 'num'
		idx=lbc_valsv(2,obj); //obj[2]=obj[-3][keydata]
		if(num>3){break;}
	}
	lbc_rt ck=lbc_tbval(obj, 2); //ck.i==123 etc. saved at pairs/ipairs

//---
//you can use lbc_directf() after lbc_runXX()
//almost the same as lbc_runstr()
//1: no argc, argv
//2: share the luajit global env. share the _G value 
//3: lua_pushfstring() fmt, restricted printf() fmt. see lua manual
//4: rtn is saved to obj[0]
	n = lbc_directf(obj, "print('hw'); return 10,%d", 20); //>> hw, n=2
	val = lbc_tbval(obj, 0, 2);		//>> retuns to obj[0], val.i==20

//you can access/edit obj[0][2] to use obj->glname as follows
	lbc_directf(obj,"print(%s[0][2]);return 1,'gw'",obj->glname); //20
	val = lbc_tbval(obj, 0, 2);	// val.s == "gw", overwrote obj[0]

//prunbcM(), prunstr(), pdirectf() works as pcall()
//catches inner error, assert() and 'return emsg' , returns 1 str if err.
	n= lbc_pdirectf(obj,"assert(nil,'abc')"); // err: n= -1, rtnsz=1
	if(n<0){ val = lbc_tbval(obj, 0, 1); }	// val.s == "abc", errmsg.
// rc 'n' is the same as runbcM(), count of return args if noerr

	lbc_free(obj);
	
//----
//--luahash, lhh is independent from lbc, lhh->L != lbc->L
//keystr cant holds '\0' but valstr can if set ag4.
	lhh_t* rec = lhh_new();
	int sum = lhh_set(rec,1,10); // rec[1]=10, sum=1(cnt holds data)
	lhh_set(rec, "abc", -3);	// rec["abc"] = -3
	lhh_set(rec, 11, "xy") ;	// rec[11] = "xy", sum=2
	lhh_set(rec,"a","a\0b",3);	// rec["a"]=a(\0)b, sz=3 (ag4)
	const char* ky = "abc";
	lhh_set(rec, &ky, -4);	// rec["abc"] = -4, sum=4, overwrite

//args numtype is int in dfl. XXd treats args as double type.
//set the correct type/value or cast (int) (double) if use numarg 
	lhh_setd(rec, 2.2, "a");	//rec[2.2]="a", setd() uses k/v dbl
	lhh_setd(rec, (double)2, 2.7); // rec[2]=2.7, treated by the luarule
	lhh_unsetd(rec, 2.2);	//rec[2.2]=nil, unset()/unsetd()
	lhh_unset(rec, "nosetkey");	//noerr
	
//get
	lhh_rt v = lhh_get(rec, "abc");	// v.tp='n', v.i= -4, v.tp/i/d/s/sz
	v = lhh_getd(rec, (double)11);	// v.tp='s', v.s="xy", v.sz=2
	v = lhh_get(rec, "a");	// v.tp='s', v.sz=3
//lhh can borrow lbc pairloop
	lbc_pairs(k, v, rec){
		printf("%s/%d %s/%d\n", k.s?k.s:"", k.i, v.s?v.s:"", v.i);
		lhh_unset(rec, 1);	// ok, del in loop
		lhh_set(rec, 11, "xxyz");	// ok, replace in loop
		//lhh_set(rec, 99, 1);
		//NG, add newval. use other buff, lhh_set(rec2, 99, 1) etc
		//lhh_get(rec, 1);
		//NG, get() breaks stack sequence. use k.i, v.i etc
	}
	lhh_free(rec);
	return 0;
}
//~$ gcc src2.c -lluajit5.1-a -lm -ldl liblbc.a
//if you use valgrind memcheck, use -static to avoid miscount.
//~$ gcc src2.c -static liblbc.a -lm -ldl
```

@OPTIONS	-
@EXIT_STATUS	-
@RETURN_VALUE
<pre>
int lbc_reqbcM(): suc/fail == 0/not0
int lbc_delsv():	same 
int lbc_cleansv():	same

int lbc_runbcM(): cnt return args. eg) (lua)return 0,"a",{1,2} >> 3
int lbc_runstr():	same
int lbc_directf():	same
int lbc_prunbcM(): same if no err. return -1 and set one emsg if err.
int lbc_prunstr():	same
int lbc_pdirectf():	same

int lbc_tbvalsv():	savedist index
int lbc_keysv():	same	
int lbc_valsv():	same

int lhh_set(): count of all holding keys
int lhh_setd(): same
int lhh_unset(): same
int lhh_unsetd(): same
</pre>
@ERRORS output emsg and exit(1)
@NOTES
- sloppy benchmark:

<pre>
--luajit vs lbc
lj : for i=1,num do local local v=i+1 end
C  : while(num){ lbc_tbvalsv(2, obj, 0, 1); }
//lj : real 154.00ms	:	loop: 100*1000*1000: (1)
//lbc: real	2943.116 ms	:	loop:   1*1000*1000: 20x100 == (2000)

--c99 hash vs lhh
- c99 posix hsearch()
	real	46.685 ms	: c99setloop: 1000*1000
	real	44.315 ms	: c99getloop: 1000*1000
- c arr[], arr[10]=100 etc
	real	21.068 ms	: arr, setloop: 1000*1000
	real	16.977 ms	: arr, getloop: 1000*1000
- luajit, table/arr tb[123]="abc"	etc
	set/get 22ms	:loop: 1000*1000
- lhh() lhh_set(obj,"key",10) etc
	real	197.392 ms	: lhh, setloop: 1000*1000
	real	192.476 ms	: lhh, getloop: 1000*1000
- lbc_directf(), "local tb[123]=456; return" etc
	real	3936.665 ms	: .directf: 1000*1000

FAST: c_arr,lj(1) > c99hash(2) >> lhh(10) >>> lbc(200) :SLOW
</pre>
..luajit vm is very fast but lua_stack() handling cause bottlenecks.
maybe you can bypass it with luajit ffi() cdata, direct pointer access.
(https://luajit.org/ext_ffi_tutorial.html, Cast pointer to address)
```
	normal usage                  use ffi() cdata
-----+          +-----          -----+          +-----
     | push/pop |               lj() +----------+ C_func()
lj() +----------+ C_func()           +----------+ 
     +----------+                    |          | 
     |          |            cdata <--------------> arr[]
-----+          +-----          -----+          +-----
```
- bypass code: lj >>> C
```
const char* cmd = 
  " ffi = require('ffi')"		//head "(space)", lua is free format  
  " local tb = {}; for i=1,1000 do tb[#tb+1]=i end"
  " local box= ffi.new('int[?]', #tb, tb )"

  " local adrs= " LBC_C2P("box")
  //-- macro 'LBC_C2P()' works as below, cdata to ptrnum
  //" local adrs=tonumber(ffi.cast('intptr_t',ffi.cast('void *',box)))"
 
  " return adrs, box"		//holds datasrc 'box' to protect from gc.
;
lbc_directf(obj, "%s", cmd);
lbc_rt res = lbc_tbval(obj, 0, 1);	//adrs
int* arr = (int*)(intptr_t)res.d;	// adrs(number) >> arr(ptr)
printf("%d %d\n", arr[0], arr[1]);		//>>1,2
```
- bypass code: lj <<< C
```
#include <inttypes.h>
const char* s = "a\0bc";
const char* fmt = " ffi = require('ffi')"
	" local str = " LBC_P2S
	
	//-- macro 'LBC_P2S' works as below. needs ptr + sz
	// " local cdata = ffi.new('uintptr_t', %" PRIuPTR ")"
	// " cdata = ffi.cast('const char*', cdata)"
	// " local str = ffi.string(cdata, %d)"
	
	//-- macro 'LBC_P2C' works as below. needs ptr only
	// " local cdata =" LBC_P2C
	// " cdata = ffi.cast(void*, ffi.new('uintptr_t', %" PRIuPTR "))"

	" return str..'xyz'"	//gc deletes cdata. res is copied to 'str'
;
lbc_directf(obj, fmt, s, 4);	// ptr,binsz == "a\0bc", 4
res = lbc_tbval(obj, 0, 1);	
printf("%c %s %s, %d\n", res.tp,res.s,res.s+2,res.sz);
	// 's', a(\0bcxyz), bcxyz, 7
lbc_free(obj);

// num<->ptr cast allows only throught intptr_t/uintptr_t in luajit.
// printf("%p\n", p) / printf("%" PRIuPTR "\n", p) work allmost the same
// the latter is more portable (c99 defined)
// ffi.string(cdata, len) can get str/bin[len] data from C

```
- concept
```
- use luajit code as __asm__ in C
- i want to embed normal luajit src.lua directly to C src
- no glue code, glue file
- get luacode result without complex stack handling
- output C code as 1 file without dependent files (a.out, libX.so etc) 
- easy api, low learning cost
- portable, posix
```

@CONFORMING_TO POSIX.1-2001+
@BUGS \-
@COPYRIGHT Copyright 2021 momi-g, GPLv3+
@VERSION 2021-07-05 v1.1.0
@SEE_ALSO
<pre>
https://www.lua.org/
https://luajit.org/
https://stackoverflow.com/questions/2632300
https://stackoverflow.com/questions/44479282
</pre>
//SH_docE*/
/*SH_ED*/

/*SH_HD*/
#ifndef lbc_5c607fb65f2e
#define lbc_5c607fb65f2e

#include <stdio.h>
#include <string.h>
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include "stop cc: needs compiler posix-2001 or upper(c99+)"
#endif
#ifndef	LBC_GLNAME
	#define LBC_GLNAME	"BCRUNNER_ARR"
#endif
#ifndef LBC_BCNAME
	#define LBC_BCNAME(name)	luaJIT_BC_ ## name
#endif
#define LBC_QU(...)	LBC_QUsub(__VA_ARGS__)
#define LBC_QUsub(...)	#__VA_ARGS__

typedef void lua_t;
typedef struct lbc_tag {
	lua_t* L;
	char* emsg;
	int rc;
	char glname[64];
	int lpflg;
	int used;
} lbc_t;

typedef struct lbc_rttag {
	int inner_flg;		//forloopのフラグで使う内部フラグ
	int  tp;
	int i;
	double d;
	const char* s;
	int sz;
} lbc_rt;

//--init+run
lbc_t* lbc_new(void);
void lbc_free(lbc_t* obj);

#define lbc_reqbcM(obj, ...)	lbc_reqbc_impl(obj, LBC_AG2REQ(__VA_ARGS__) )
#define lbc_runbcM(obj,ac,av,name)	\
	lbc_runbc_impl(0, obj, ac, av, LBC_BCNAME(name), (int)sizeof(LBC_BCNAME(name)), #name )
#define lbc_runstr(obj, ac, av, str)	\
	lbc_runbc_impl(0, obj,ac,av, str,strlen(str),__FILE__"_" LBC_QU(__LINE__) "_directstr" )
#define lbc_prunbcM(obj,ac,av,name)	\
	lbc_runbc_impl(1, obj, ac, av, LBC_BCNAME(name), (int)sizeof(LBC_BCNAME(name)), #name )
#define lbc_prunstr(obj, ac, av, str)	\
	lbc_runbc_impl(1, obj,ac,av, str,strlen(str),__FILE__"_" LBC_QU(__LINE__) "_directstr" )

/**/ int lbc_reqbc_impl(lbc_t* obj, ...);
/**/ int lbc_runbc_impl(int pflg, lbc_t* obj, int ac, char **av, const void* bc, int bcsz, const char* name );

#define LBC_AG2REQ(...)	LBC_EACH_MC(LBC_REQBC,LBC_REQBCE, __VA_ARGS__)
#define LBC_REQBC(n,a)	LBC_BCNAME(a), (int)sizeof(LBC_BCNAME(a)), #a
#define LBC_REQBCE(n,a)	NULL,0,NULL

//--result
#define lbc_tbval(...)	lbc_tbval_sub( LBC_AG2TB(__VA_ARGS__) )
#define lbc_tbvalsv(nidx,...) lbc_tbvalsv_sub(nidx, LBC_AG2TB(__VA_ARGS__) )
int lbc_delsv(lbc_t* obj,int idx);
int lbc_cleansv(lbc_t* obj);
#define lbc_directf(obj, ...) (lua_pushfstring(obj->L,__VA_ARGS__),lbc_directf_impl(0, obj) )
#define lbc_pdirectf(obj, ...) (lua_pushfstring(obj->L,__VA_ARGS__),lbc_directf_impl(1, obj) )
#define LBC_C2P(var) " tonumber(require('ffi').cast('intptr_t', require('ffi').cast('void *', " #var")))"
#define LBC_P2C	" require('ffi').cast('void*', require('ffi').new('uintptr_t', %" PRIuPTR "))"
#define LBC_P2S	" require('ffi').string(require('ffi').cast('const char*', require('ffi').new('uintptr_t', %" PRIuPTR ")), %d)"

#ifndef LBC_SOURCECODE
	const char* lua_pushfstring(/*nock*/);
#endif
lbc_rt lbc_tbval_impl(lbc_t* obj, const char* pidx, int idx, ...);
int lbc_tbvalsv_impl(int nidx, lbc_t* obj, const char* pidx, int idx, ...);
int lbc_directf_impl(int pflg, lbc_t* obj);
#define lbc_tbval_sub(...)	lbc_tbval_subb(__VA_ARGS__)
#define lbc_tbval_subb(lit,obj, ...)	lbc_tbval_impl(obj,__VA_ARGS__)
#define lbc_tbvalsv_sub(...)	lbc_tbvalsv_subb(__VA_ARGS__)
#define lbc_tbvalsv_subb(nidx,lit,obj,...) lbc_tbvalsv_impl(nidx,obj,__VA_ARGS__)
#define LBC_AG2TB(...)	LBC_EACH_MC(LBC_AGMC,LBC_AGMCE, __VA_ARGS__)
#define LBC_AGMC(n,a)	#a, a
#define LBC_AGMCE(n,a)	NULL, 0

//--result-support
#define lbc_pairs(k,v,...)	lbc_pairs_sub(0,k,v, LBC_AG2TB(__VA_ARGS__) )
#define lbc_ipairs(i,v,...)	lbc_ipairs_sub(1,i,v, LBC_AG2TB(__VA_ARGS__) )
#define lbc_keysv(nidx, obj)	lbc_keyvalsv_impl(nidx, obj, 'k')
#define lbc_valsv(nidx, obj)	lbc_keyvalsv_impl(nidx, obj, 'v')
int lbc_pairinit(int flg, lbc_t* obj, ...);
int lbc_pairexit(lbc_t* obj);
int lbc_isnextval(int mode, lbc_t* obj, void* k, lbc_rt* v);
int lbc_keyvalsv_impl(int nidx, lbc_t* obj, int tgt);
#define lbc_pairs_sub(mode, k,v, ...)	lbc_pairs_subb(mode,k,v,__VA_ARGS__)
#define lbc_pairs_subb(mode, k,v,lit,obj,...)	lbc_pairs_impl(mode,k,v,obj,__VA_ARGS__)
#define lbc_ipairs_sub(mode, k,v, ...)	lbc_ipairs_subb(mode,k,v,__VA_ARGS__)
#define lbc_ipairs_subb(mode, k,v,lit,obj,...)	lbc_ipairs_impl(mode,k,v,obj,__VA_ARGS__)
#define lbc_pairs_impl(mode, k,v, obj,...)	\
	for(lbc_rt k={0},v={1};lbc_pairinit(v.inner_flg, (lbc_t*)obj, __VA_ARGS__);lbc_pairexit((lbc_t*)obj) )	\
	for( ;lbc_isnextval(mode, (lbc_t*)obj, &k, &v); )
#define lbc_ipairs_impl(mode,i, v, obj, ...)	\
	for(lbc_rt v={1}; lbc_pairinit(v.inner_flg, (lbc_t*)obj, __VA_ARGS__);lbc_pairexit((lbc_t*)obj) )	\
	for( int i=0;lbc_isnextval(mode, (lbc_t*)obj, &i, &v); )

//--others, hash
typedef struct luahash_tag{
	lua_t* L;
	char* emsg;
	int rc;
	char glname[64];
	int lpflg;
	int cnt;
} lhh_t;
typedef lbc_rt lhh_rt;
#define LHH_GLNAME	"lhh_gname"

lhh_t* lhh_new(void);
void lhh_free(lhh_t* obj);
#define lhh_set(obj,k,v,...)	lhh_set_impl(0,obj,#k,k,#v,v,__VA_ARGS__+0)
#define lhh_setd(obj,k,v,...)	lhh_set_impl(1,obj,#k,k,#v,v,(double)(__VA_ARGS__+0) )

#define lhh_unset(obj, key)	lhh_unset_impl(0, obj, #key, key)
#define lhh_unsetd(obj, key)	lhh_unset_impl(1, obj, #key, key)
#define lhh_get(obj, key)	lhh_get_impl(0, obj, #key, key)
#define lhh_getd(obj, key)	lhh_get_impl(1, obj, #key, key)
/**/ int lhh_set_impl(int dmode, lhh_t* obj, const char* s, ...);
/**/ int lhh_unset_impl(int dmode, lhh_t* obj, const char* k, ...);
/**/ lhh_rt lhh_get_impl(int dmode, lhh_t* obj, const char* k, ...);

//--others, MC
// from license: cc-by-sa 2.5/3.0 (code is changed from the orig)
// https://stackoverflow.com/questions/2632300	Q: Ed Marty  ->  A: Matthew Slattery
#define LBC_EACH_MC(m,e,...)	LBC_EACH_MCsub(__VA_ARGS__,99,98,97,96,95,94,93,92,91,90 \
	,89,88,87,86,85,84,83,82,81,80,79,78,77,76,75,74,73,72,71,70,69,68,67,66 \
	,65,64,63,62,61,60,59,58,57,56,55,54,53,52,51,50,49,48,47,46,45,44,43,42 \
	,41,40,39,38,37,36,35,34,33,32,31,30,29,28,27,26,25,24,23,22,21,20,19,18 \
	,17,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0) (m,e,__VA_ARGS__)
#define LBC_EACH_MCsub(a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17 \
	,a18,a19,a20,a21,a22,a23,a24,a25,a26,a27,a28,a29,a30,a31,a32,a33,a34,a35 \
	,a36,a37,a38,a39,a40,a41,a42,a43,a44,a45,a46,a47,a48,a49,a50,a51,a52,a53 \
	,a54,a55,a56,a57,a58,a59,a60,a61,a62,a63,a64,a65,a66,a67,a68,a69,a70,a71 \
	,a72,a73,a74,a75,a76,a77,a78,a79,a80,a81,a82,a83,a84,a85,a86,a87,a88,a89 \
	,a90,a91,a92,a93,a94,a95,a96,a97,a98,a99,num,...)	LBC_MCN ## num

// https://stackoverflow.com/questions/44479282 Q: user1150609 -> A: H Walters
#define LBC_MCN0( m,e,a, ...)	e(0 ,a)
#define LBC_MCN1( m,e,a, ...)	m(1 ,a), LBC_MCN0( m,e, __VA_ARGS__ )
#define LBC_MCN2( m,e,a, ...)	m(2 ,a), LBC_MCN1( m,e, __VA_ARGS__ )
#define LBC_MCN3( m,e,a, ...)	m(3 ,a), LBC_MCN2( m,e, __VA_ARGS__ )
#define LBC_MCN4( m,e,a, ...)	m(4 ,a), LBC_MCN3( m,e, __VA_ARGS__ )
#define LBC_MCN5( m,e,a, ...)	m(5 ,a), LBC_MCN4( m,e, __VA_ARGS__ )
#define LBC_MCN6( m,e,a, ...)	m(6 ,a), LBC_MCN5( m,e, __VA_ARGS__ )
#define LBC_MCN7( m,e,a, ...)	m(7 ,a), LBC_MCN6( m,e, __VA_ARGS__ )
#define LBC_MCN8( m,e,a, ...)	m(8 ,a), LBC_MCN7( m,e, __VA_ARGS__ )
#define LBC_MCN9( m,e,a, ...)	m(9 ,a), LBC_MCN8( m,e, __VA_ARGS__ )
#define LBC_MCN10(m,e,a, ...)	m(10,a), LBC_MCN9( m,e, __VA_ARGS__ )
#define LBC_MCN11(m,e,a, ...)	m(11,a), LBC_MCN10(m,e, __VA_ARGS__ )
#define LBC_MCN12(m,e,a, ...)	m(12,a), LBC_MCN11(m,e, __VA_ARGS__ )
#define LBC_MCN13(m,e,a, ...)	m(13,a), LBC_MCN12(m,e, __VA_ARGS__ )
#define LBC_MCN14(m,e,a, ...)	m(14,a), LBC_MCN13(m,e, __VA_ARGS__ )
#define LBC_MCN15(m,e,a, ...)	m(15,a), LBC_MCN14(m,e, __VA_ARGS__ )
#define LBC_MCN16(m,e,a, ...)	m(16,a), LBC_MCN15(m,e, __VA_ARGS__ )
#define LBC_MCN17(m,e,a, ...)	m(17,a), LBC_MCN16(m,e, __VA_ARGS__ )
#define LBC_MCN18(m,e,a, ...)	m(18,a), LBC_MCN17(m,e, __VA_ARGS__ )
#define LBC_MCN19(m,e,a, ...)	m(19,a), LBC_MCN18(m,e, __VA_ARGS__ )
#define LBC_MCN20(m,e,a, ...)	m(20,a), LBC_MCN19(m,e, __VA_ARGS__ )
#define LBC_MCN21(m,e,a, ...)	m(21,a), LBC_MCN20(m,e, __VA_ARGS__ )
#define LBC_MCN22(m,e,a, ...)	m(22,a), LBC_MCN21(m,e, __VA_ARGS__ )
#define LBC_MCN23(m,e,a, ...)	m(23,a), LBC_MCN22(m,e, __VA_ARGS__ )
#define LBC_MCN24(m,e,a, ...)	m(24,a), LBC_MCN23(m,e, __VA_ARGS__ )
#define LBC_MCN25(m,e,a, ...)	m(25,a), LBC_MCN24(m,e, __VA_ARGS__ )
#define LBC_MCN26(m,e,a, ...)	m(26,a), LBC_MCN25(m,e, __VA_ARGS__ )
#define LBC_MCN27(m,e,a, ...)	m(27,a), LBC_MCN26(m,e, __VA_ARGS__ )
#define LBC_MCN28(m,e,a, ...)	m(28,a), LBC_MCN27(m,e, __VA_ARGS__ )
#define LBC_MCN29(m,e,a, ...)	m(29,a), LBC_MCN28(m,e, __VA_ARGS__ )
#define LBC_MCN30(m,e,a, ...)	m(30,a), LBC_MCN29(m,e, __VA_ARGS__ )
#define LBC_MCN31(m,e,a, ...)	m(31,a), LBC_MCN30(m,e, __VA_ARGS__ )
#define LBC_MCN32(m,e,a, ...)	m(32,a), LBC_MCN31(m,e, __VA_ARGS__ )
#define LBC_MCN33(m,e,a, ...)	m(33,a), LBC_MCN32(m,e, __VA_ARGS__ )
#define LBC_MCN34(m,e,a, ...)	m(34,a), LBC_MCN33(m,e, __VA_ARGS__ )
#define LBC_MCN35(m,e,a, ...)	m(35,a), LBC_MCN34(m,e, __VA_ARGS__ )
#define LBC_MCN36(m,e,a, ...)	m(36,a), LBC_MCN35(m,e, __VA_ARGS__ )
#define LBC_MCN37(m,e,a, ...)	m(37,a), LBC_MCN36(m,e, __VA_ARGS__ )
#define LBC_MCN38(m,e,a, ...)	m(38,a), LBC_MCN37(m,e, __VA_ARGS__ )
#define LBC_MCN39(m,e,a, ...)	m(39,a), LBC_MCN38(m,e, __VA_ARGS__ )
#define LBC_MCN40(m,e,a, ...)	m(40,a), LBC_MCN39(m,e, __VA_ARGS__ )
#define LBC_MCN41(m,e,a, ...)	m(41,a), LBC_MCN40(m,e, __VA_ARGS__ )
#define LBC_MCN42(m,e,a, ...)	m(42,a), LBC_MCN41(m,e, __VA_ARGS__ )
#define LBC_MCN43(m,e,a, ...)	m(43,a), LBC_MCN42(m,e, __VA_ARGS__ )
#define LBC_MCN44(m,e,a, ...)	m(44,a), LBC_MCN43(m,e, __VA_ARGS__ )
#define LBC_MCN45(m,e,a, ...)	m(45,a), LBC_MCN44(m,e, __VA_ARGS__ )
#define LBC_MCN46(m,e,a, ...)	m(46,a), LBC_MCN45(m,e, __VA_ARGS__ )
#define LBC_MCN47(m,e,a, ...)	m(47,a), LBC_MCN46(m,e, __VA_ARGS__ )
#define LBC_MCN48(m,e,a, ...)	m(48,a), LBC_MCN47(m,e, __VA_ARGS__ )
#define LBC_MCN49(m,e,a, ...)	m(49,a), LBC_MCN48(m,e, __VA_ARGS__ )
#define LBC_MCN50(m,e,a, ...)	m(50,a), LBC_MCN49(m,e, __VA_ARGS__ )
#define LBC_MCN51(m,e,a, ...)	m(51,a), LBC_MCN50(m,e, __VA_ARGS__ )
#define LBC_MCN52(m,e,a, ...)	m(52,a), LBC_MCN51(m,e, __VA_ARGS__ )
#define LBC_MCN53(m,e,a, ...)	m(53,a), LBC_MCN52(m,e, __VA_ARGS__ )
#define LBC_MCN54(m,e,a, ...)	m(54,a), LBC_MCN53(m,e, __VA_ARGS__ )
#define LBC_MCN55(m,e,a, ...)	m(55,a), LBC_MCN54(m,e, __VA_ARGS__ )
#define LBC_MCN56(m,e,a, ...)	m(56,a), LBC_MCN55(m,e, __VA_ARGS__ )
#define LBC_MCN57(m,e,a, ...)	m(57,a), LBC_MCN56(m,e, __VA_ARGS__ )
#define LBC_MCN58(m,e,a, ...)	m(58,a), LBC_MCN57(m,e, __VA_ARGS__ )
#define LBC_MCN59(m,e,a, ...)	m(59,a), LBC_MCN58(m,e, __VA_ARGS__ )
#define LBC_MCN60(m,e,a, ...)	m(60,a), LBC_MCN59(m,e, __VA_ARGS__ )
#define LBC_MCN61(m,e,a, ...)	m(61,a), LBC_MCN60(m,e, __VA_ARGS__ )
#define LBC_MCN62(m,e,a, ...)	m(62,a), LBC_MCN61(m,e, __VA_ARGS__ )
#define LBC_MCN63(m,e,a, ...)	m(63,a), LBC_MCN62(m,e, __VA_ARGS__ )
#define LBC_MCN64(m,e,a, ...)	m(64,a), LBC_MCN63(m,e, __VA_ARGS__ )
#define LBC_MCN65(m,e,a, ...)	m(65,a), LBC_MCN64(m,e, __VA_ARGS__ )
#define LBC_MCN66(m,e,a, ...)	m(66,a), LBC_MCN65(m,e, __VA_ARGS__ )
#define LBC_MCN67(m,e,a, ...)	m(67,a), LBC_MCN66(m,e, __VA_ARGS__ )
#define LBC_MCN68(m,e,a, ...)	m(68,a), LBC_MCN67(m,e, __VA_ARGS__ )
#define LBC_MCN69(m,e,a, ...)	m(69,a), LBC_MCN68(m,e, __VA_ARGS__ )
#define LBC_MCN70(m,e,a, ...)	m(70,a), LBC_MCN69(m,e, __VA_ARGS__ )
#define LBC_MCN71(m,e,a, ...)	m(71,a), LBC_MCN70(m,e, __VA_ARGS__ )
#define LBC_MCN72(m,e,a, ...)	m(72,a), LBC_MCN71(m,e, __VA_ARGS__ )
#define LBC_MCN73(m,e,a, ...)	m(73,a), LBC_MCN72(m,e, __VA_ARGS__ )
#define LBC_MCN74(m,e,a, ...)	m(74,a), LBC_MCN73(m,e, __VA_ARGS__ )
#define LBC_MCN75(m,e,a, ...)	m(75,a), LBC_MCN74(m,e, __VA_ARGS__ )
#define LBC_MCN76(m,e,a, ...)	m(76,a), LBC_MCN75(m,e, __VA_ARGS__ )
#define LBC_MCN77(m,e,a, ...)	m(77,a), LBC_MCN76(m,e, __VA_ARGS__ )
#define LBC_MCN78(m,e,a, ...)	m(78,a), LBC_MCN77(m,e, __VA_ARGS__ )
#define LBC_MCN79(m,e,a, ...)	m(79,a), LBC_MCN78(m,e, __VA_ARGS__ )
#define LBC_MCN80(m,e,a, ...)	m(80,a), LBC_MCN79(m,e, __VA_ARGS__ )
#define LBC_MCN81(m,e,a, ...)	m(81,a), LBC_MCN80(m,e, __VA_ARGS__ )
#define LBC_MCN82(m,e,a, ...)	m(82,a), LBC_MCN81(m,e, __VA_ARGS__ )
#define LBC_MCN83(m,e,a, ...)	m(83,a), LBC_MCN82(m,e, __VA_ARGS__ )
#define LBC_MCN84(m,e,a, ...)	m(84,a), LBC_MCN83(m,e, __VA_ARGS__ )
#define LBC_MCN85(m,e,a, ...)	m(85,a), LBC_MCN84(m,e, __VA_ARGS__ )
#define LBC_MCN86(m,e,a, ...)	m(86,a), LBC_MCN85(m,e, __VA_ARGS__ )
#define LBC_MCN87(m,e,a, ...)	m(87,a), LBC_MCN86(m,e, __VA_ARGS__ )
#define LBC_MCN88(m,e,a, ...)	m(88,a), LBC_MCN87(m,e, __VA_ARGS__ )
#define LBC_MCN89(m,e,a, ...)	m(89,a), LBC_MCN88(m,e, __VA_ARGS__ )
#define LBC_MCN90(m,e,a, ...)	m(90,a), LBC_MCN89(m,e, __VA_ARGS__ )
#define LBC_MCN91(m,e,a, ...)	m(91,a), LBC_MCN90(m,e, __VA_ARGS__ )
#define LBC_MCN92(m,e,a, ...)	m(92,a), LBC_MCN91(m,e, __VA_ARGS__ )
#define LBC_MCN93(m,e,a, ...)	m(93,a), LBC_MCN92(m,e, __VA_ARGS__ )
#define LBC_MCN94(m,e,a, ...)	m(94,a), LBC_MCN93(m,e, __VA_ARGS__ )
#define LBC_MCN95(m,e,a, ...)	m(95,a), LBC_MCN94(m,e, __VA_ARGS__ )
#define LBC_MCN96(m,e,a, ...)	m(96,a), LBC_MCN95(m,e, __VA_ARGS__ )
#define LBC_MCN97(m,e,a, ...)	m(97,a), LBC_MCN96(m,e, __VA_ARGS__ )
#define LBC_MCN98(m,e,a, ...)	m(98,a), LBC_MCN97(m,e, __VA_ARGS__ )
#define LBC_MCN99(m,e,a, ...)	m(99,a), LBC_MCN98(m,e, __VA_ARGS__ )
// end license:	cc-by-sa 2.5/3.0

#endif /* lbc_5c607fb65f2e */
/*SH_ED*/

/*SH_SC*/
/* tool macros */
#ifndef ERRact
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#if  (200112L <= _POSIX_C_SOURCE +0)  /* nealy 200112L, _POSIX_C_SOURCE	c99*/
#define ERRact(xpr, msg, act)	if(xpr){ fprintf(stderr, \
	        "ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, __func__ \
	        ,getpid(), "hit(" #xpr ")", msg, strerror(errno) );act ;}
#else
#define ERRact(xpr, msg, act)	if(xpr){ fprintf(stderr, \
	        "ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, "func:c99+" \
	        ,0 , "hit(" #xpr ")", msg, strerror(errno) );act ;}
#endif
#define STOP(xpr, msg)	ERRact(xpr, msg, fputs("STOP\n",stderr);exit(1))
#endif
#define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)
/*tool end*/

#include <stdlib.h>
#include <string.h>

#include "luaconf.h"
#include "lua.h"
#include "lauxlib.h"
#include "lualib.h"

#define LBC_SOURCECODE
#include "*SH_bn*.h"

lbc_t* lbc_new(void) {
	lua_State *L = luaL_newstate();
	luaL_openlibs(L);
	lbc_t* res = (lbc_t*)calloc(1, sizeof(lbc_t));
	res->L = L;
	return res;
}
void lbc_free(lbc_t* obj) {
	lua_close(obj->L);
	free(obj->emsg);
	*obj=(lbc_t) {0};
	free(obj);
}

#ifdef TEST
	#include "*SH_bn*.h"	/*SH_co* -pedantic -static -lluajit -lm -ldl 	*/
	#include "hcut.h"
	#include "msgp.h"
	#include "laptime.h"
	#define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)
	#define qu(...)		Qsub(__VA_ARGS__)
	#define Qsub(...)	#__VA_ARGS__
#endif

#ifdef TEST
HCUT_ADD(t_new) {
	lbc_t* obj = lbc_new();
	dbg(obj->emsg);
	lbc_free(obj);
}
#endif

//bcどもをmod登録。bcはtbでrtnしていることを前提にしてる
int lbc_reqbc_impl(lbc_t* obj, ...) {
	// const char* bc, int bcsz, const char* name, ...
	lua_t* L = obj->L;
	lua_getglobal(L, "package");
	lua_getfield(L, -1, "preload");	//preloadはtbでnameなtbが有るとmodとして登録される
	//preloadはsearch関数返し。bcは先頭当たりにsearch関数を持ってるのでそれでブート
	va_list vp;
	va_start(vp, obj);
	//bc >> tb
	while(1){
		const char* bc = va_arg(vp, char*);
		int bcsz = va_arg(vp, int);
		const char* name = va_arg(vp, char*);
		if(bc==NULL){break;}
		lua_pushstring(L, name);
		int rc = luaL_loadbuffer(L, bc, bcsz, name);
		; ERRact(rc, "fatal: load bc failed", printf("name: %s\n", name); exit(1));
		lua_settable(L, -3);
	}
	va_end(vp);
	lua_settop(L, -3);
	return 0;
}
#ifdef TEST
HCUT_ADD(t_req) {
	lbc_t* obj = lbc_new();
//#include "al.h"
//#include "cl.h"
//	lbc_reqbcM(obj, al, cl);
	lbc_free(obj);
}
#endif

int lbc_runbc_impl(int pflg, lbc_t* obj, int ac, char **av, const void* bcs, int bcsz, const char* name) {
	//bcはstrもいれた。自動判別なのでうまくいくはず
	; STOP(obj->used, "obj already ran");
	const char* bc=bcs;
	lua_t* L = obj->L;
	obj->used=1;
	int rc = luaL_loadbuffer(L, bc, bcsz, name);
	; ERRact(rc, "fatal: load bc failed", printf("name: %s\n", name); exit(1));
	// http://milkpot.sakura.ne.jp/lua/lua51_manual_ja.html#6
	lua_settop(L, 0);
	lua_newtable(L);
	for(int i=0; i<ac; i++) {
		lua_pushstring(L, av[i]);
		lua_rawseti(L, -2, i);
	}
	lua_setglobal(L, "arg");
	//
	rc = luaL_loadbuffer(L, bc, bcsz, name);
	; ERRact(rc, "fatal: load bc failed", printf("name: %s\n", name); exit(1));
	lua_getglobal(L, "arg");
	int narg;
	for(narg=1; !lua_isnil(L,-1); narg++) {lua_rawgeti(L, 2, narg); }
	lua_pop(L, 1);
	lua_remove(L, 2);
	rc = lua_pcall(L, narg-2, LUA_MULTRET, 0);	//0はerrcbがあればfcidx

	//rc!=0なら1にemsgが詰まってる
	; STOP(pflg==0 && rc, lua_tolstring(L, 1, NULL) );
	if(rc){ pflg= -1;}
	
	//rtnはtbに詰めて返す
	int rtnsz = lua_gettop(L);	// a|b|c, 3
	lua_newtable(L);	//	a|b|c| tb
	lua_insert(L, 1);	//	tb |a|b|c
	for(int i=rtnsz; i>0; i--) {
		lua_pushnumber(L, i);	//	tb |a|b|c|3
		lua_insert(L, -2);	//tb |a|b|3|c
		lua_rawset(L, 1);	// tb |a|b  tb[3]=c
	}
	if(pflg<0){ rtnsz=1;}	//pcallはrc== -1でemsgが一つだけ
	
	//globalのarrを探す
	int i=0;
	for(i=0;; i++) {
		sprintf(obj->glname, "%s%d", LBC_GLNAME, i);
		lua_getglobal(L, obj->glname);	// tb | gl
		if(lua_isnil(L, -1)) { break;}
		lua_pop(L,1);	// tb
	}
	lua_pop(L, 1);
	//nameを見つけたのでtbをセット
	lua_newtable(L);	//	res|tb
	lua_pushnumber(L, 0);	//	res|tb|0
	lua_insert(L, 1);
	lua_insert(L, 1);//	tb|0|res
	lua_rawset(L, 1);	// tb[0]=restb, tbr
	lua_setglobal(L, obj->glname);
	return rtnsz;	//rtn nargsを返す errは-1でobjにemsgが入る
	//Lとglname[0]={1,2,3} とtbszのrtnszが出来た
	//ハンドリングは別関数で試す。とりあえずここまでテストしてmcroも準備する
}
#ifdef TEST
HCUT_ADD(t_run) {
	lbc_t* obj = lbc_new();
#include "al.h"
#include "cl.h"
	lbc_reqbcM(obj, al, cl);
#include "bl.h"
	int n;
//	n = lbc_runbcM(obj,  argc, argv, bl);
//	dbg(n, obj->emsg);
n = lbc_runstr(obj, argc, argv, "return require('cl').cf()");
dbg(n, obj->emsg);
	lbc_free(obj);
}
#endif

static const char* lbc_tbval_ag2tb(lua_t* L, va_list vp);
lbc_rt lbc_tbval_impl(lbc_t* obj, const char* pidx, int idx, ...) {
	; ERRact(obj->lpflg, "thisfunc cant use in pairloop blk", exit(1) );
	lua_t* L = obj->L;
//
	va_list vp;
	va_start(vp, idx);
	const char* rs;
	rs = lbc_tbval_ag2tb(L, vp);
	va_end(vp);
	rs = lua_pushfstring(L, "return %s[%d]%s", obj->glname, idx, rs);
//
	int rc = luaL_dostring(L, rs);
	; ERRact(rc, "catch err, bad code?", fputs(rs, stderr); exit(1));
	lua_replace(L, 1);	//強制的にtop==1 rtnでstk保持必須だからしょうがないね
	lua_settop(L, 1);
//
	lbc_rt res= {0};
	//val
	if(lua_type(L, -1) == LUA_TNUMBER) {
		res.tp='n';
		res.s=NULL;
		res.i = lua_tointeger(L, -1);
		res.d = lua_tonumber(L, -1);
	} else if(lua_type(L, -1) == LUA_TSTRING) {
		res.tp='s';
		res.i=0;
		res.d=0;
		size_t sz=0;
		res.s = lua_tolstring(L, -1, &sz);
		res.sz = (int)sz;
	} else if(lua_type(L, -1) == LUA_TTABLE) {
		res.tp='t';
		res.i=0;
		res.d=0;
		res.s=NULL;
		res.sz = lua_objlen(L, -1);
	} else if(lua_type(L, -1) == LUA_TNIL) { res.tp='N'; }
	else if(lua_type(L, -1) == LUA_TBOOLEAN) {
		res.tp='b';
		const char* p = lua_tostring(L, -1);
		if(p[0]=='t') {res.i=1;}
	} else if(lua_type(L, -1) == LUA_TFUNCTION) { res.tp='f'; }
	else if(lua_type(L, -1) == LUA_TUSERDATA) { res.tp='u'; }
	else if(lua_type(L, -1) == LUA_TTHREAD) { res.tp='T'; }
	else if(lua_type(L, -1) == LUA_TLIGHTUSERDATA) { res.tp='l'; }
	else { STOP(1, "unreachable block"); }
	return res;
}

static int lbc_searchnidx(lbc_t* obj);
int lbc_tbvalsv_impl(int nidx, lbc_t* obj, const char* pidx, int idx, ...) {
//	; ERRact(nidx==0, "[0] is blocked idx", exit(1));
//	; ERRact(obj->lpflg, "thisfunc cant use in pairloop blk", exit(1));
	if(nidx<0){ nidx = lbc_searchnidx(obj); }
	lua_t* L = obj->L;
//
	va_list vp;
	va_start(vp, idx);
	const char* rs;
	rs = lbc_tbval_ag2tb(L, vp);
	va_end(vp);
//
	rs = lua_pushfstring(L, "%s[%d]=%s[%d]%s", obj->glname, nidx, obj->glname, idx, rs);
	int rc = luaL_dostring(L, rs);
	lua_settop(L, -3);	//ag2とcmdの二つ
	; STOP(rc, "fatal err");
	return nidx;
}

// return系の共通コード ""とか&とか normalとsvで2x2で4倍になるので固めてる
// ("a",1,"z")	>> ["a"][1]["z"]
static const char* lbc_tbval_ag2tb(lua_t* L, va_list vp) {
	const char* rs="";
	lua_pushstring(L, "");	//dmy
	while(1) {
		char* p = va_arg(vp, char*);
		; if(p==NULL) {break;}	//sentinel
		if(p[0]=='"' || p[0]=='&') {
			char* s;
			if(p[0]=='"') { s = va_arg(vp, char*); }
			if(p[0]=='&') { s = *va_arg(vp, char**); }	//&系は二重なので細工
			//key == str "anc" or &s == ["abc"] ["ptr_s"]
			; ERRact(strchr(s, '"'), "keystr holds double-quote",fputs(p, stderr); exit(1));
			rs = lua_pushfstring(L, "%s[\"%s\"]", rs, s);
		} else {
			//key==num
			int inum = va_arg(vp, int);
			rs = lua_pushfstring(L, "%s[%d]", rs, inum);
		}
		lua_remove(L, -2);
	}
	return rs;
}
static int lbc_searchnidx(lbc_t* obj) {
	lua_t* L = obj->L;
	const char* fmt =
	"local i=-1;while 1 do local v = %s[i];if v==nil then return i end;i=i-1;end";
	const char* p = lua_pushfstring(L, fmt, obj->glname);
	int rc = luaL_dostring(L, p);	//(luaL_loadstring(L, str) || lua_pcall(L, 0, LUA_MULTRET, 0))
	; STOP(rc, "fatal err");
	int idx = lua_tonumber(L, -1);
	lua_pop(L, 2);
	return idx;
}

int lbc_delsv(lbc_t* obj,int idx) {
//	; ERRact(idx==0, "[0] is blocked idx", exit(1));
	lua_t* L = obj->L;
	const char*	fmt = "%s[%d] = nil";
	const char* cs = lua_pushfstring(L, fmt,  obj->glname, idx);
	int rc = luaL_dostring(L, cs);
	lua_pop(L, 1);
	; STOP(rc, "fatal err");
	return 0;
}
int lbc_cleansv(lbc_t* obj) {
	lua_t* L = obj->L;
	const char*	fmt = "for k,v in pairs(%s) do "
	                  "if type(k)=='number' and k<0 then %s[k]=nil end; end";
	const char* cs = lua_pushfstring(L, fmt,  obj->glname, obj->glname);
	int rc = luaL_dostring(L, cs);
	; ERRact(rc, "fatal err", fprintf(stderr, "%s\n",lua_tostring(L,-1)); exit(1));
	lua_pop(L, 1);
	return 0;
}
int lbc_directf_impl(int pflg, lbc_t* obj) {
//	; ERRact(nidx==0, "svidx 0 is booked", printf("save:%d\n", nidx); exit(1));
//	if(nidx<0) { nidx= lbc_searchnidx(obj);}
	lua_t* L = obj->L;
	int lv = lua_gettop(L);	//strがいる
	const char* p = lua_tostring(L, -1);
	int rc = luaL_dostring(L, p);	//(luaL_loadstring(L, str) || lua_pcall(L, 0, LUA_MULTRET, 0))
	; STOP(rc&&pflg==0, lua_tostring(L,-1) );
	if(rc){ pflg= -1; }
	//rtnはtbに詰めて返す
	int rtnsz = lua_gettop(L) - lv;	// cmd|a|b|c
//
	lua_newtable(L);	//	cmd|a|b|c| tb
	lua_replace(L, lv);	//	tb |a|b|c	..overwrite
	for(int i=rtnsz; 0<i; i--) {
		lua_pushnumber(L, i);	//	tb |a|b|c|3
		lua_insert(L, -2);	//tb |a|b|3|c
		lua_rawset(L, lv);	// tb |a|b  tb[3]=c
	}
	if(pflg<0){ rtnsz= -1; }
	lua_getglobal(L, obj->glname);	//	tb|gl
	lua_insert(L, -2);//	gl|tb
	lua_rawseti(L, -2, 0);	// gl[0]=tb
	lua_pop(L, 1);
	return rtnsz;
}
#ifdef TEST
HCUT_ADD(t_val) {
	lbc_t* obj = lbc_new();
#include "al.h"
	lbc_reqbcM(obj, al);
#include "bl.h"
	int n = lbc_runbcM(obj, argc, argv, bl);
//;dbg(n, obj->emsg);
	lbc_rt val = lbc_tbval(obj, 0, 1);
;dbg(val.tp, val.i, val.d);
	n = lbc_tbvalsv(-1, obj, 0, 1);
;dbg(n);
	val = lbc_tbval(obj, -1);
;dbg(val.tp, val.i, val.d);
	//	lbc_cleansv(obj);
	lbc_delsv(obj, -1);
	val = lbc_tbval(obj, -1);
;dbg(val.tp, val.i, val.d);
	val = lbc_tbval(obj, n);
;dbg(n, val.tp, val.i, val.d, val.s, val.sz);
	puts("change:");
	val = lbc_tbval(obj, 0, 3, "unko");
;dbg(n, val.tp, val.i, val.d, val.s, val.sz);
	const char* p = "unko";
	val = lbc_tbval(obj, 0, 3, &p);
;dbg(n, val.tp, val.i, val.d, val.s, val.sz);
	n = lbc_directf(obj, "return 11,20,30");
	val = lbc_tbval(obj, 0, 3);
	eq_i(val.tp, 'n');
	eq_i(val.i, 30);
;dbg(n, val.i);

	n = lbc_pdirectf(obj, "retur 11,20,30");
	val = lbc_tbval(obj, 0, 1);
;dbg(n, val.tp);
	puts(val.s);
	
	lbc_free(obj);
}
#endif

#ifdef TEST
HCUT_ADD(t_directf) {
	lbc_t* obj = lbc_new();
#include "al.h"
	lbc_reqbcM(obj, al);
#include "bl.h"
	lbc_runbcM(obj, argc, argv, bl);
dbg(lua_gettop(obj->L));
	int n = lbc_directf(obj, "return 10,20,30");
	eq_i(n, 3);
	lbc_pairs(k, v, obj, 0) {
		dbg(k.i, v.i);
	}
	lbc_ipairs(i, v, obj, 0) {
		dbg(i, v.i);
	}
dbg(lua_gettop(obj->L));
laptime(0);
#define LP 1*1000
	loop(LP){ lbc_directf(obj, "local arr={}; arr[10]=20");}
laptime("direct: " qu(LP) );
	//direct access
	const char* cmd = 
		" ffi = require('ffi')"
		" local tb = {}; for i=1,1000 do tb[#tb+1]=i end"
		" local box= ffi.new('int[?]', #tb, tb )"
		" local adrs= tonumber(ffi.cast('intptr_t',ffi.cast('void *', box)))"
		" return adrs, box, tb"		//holds datasrc to protect from gc.
	;
	lbc_directf(obj, "%s", cmd);
	lbc_rt res = lbc_tbval(obj, 0, 1);	//adrs
	int* arr = (int*)(intptr_t)res.d;	// arr >> adrs >> box
	dbg( arr[0], arr[1] );		//>>1,2
	
	const char* s = "a\0bc";
	const char* fmt = 
	" local cdata = ffi.new('intptr_t', %p)"
	" cdata = ffi.cast('char*', cdata)"
	// if use intptr_t, use c99 header inttypes.h macro 'PRId/o/x/uPTR'
	//" local cdata = ffi.new('char*'," PRIdPTR ")"	//printf(fmt, (intptr_t)s);
	" local str = ffi.string(cdata, %d)"
	" print(str)"
	" return str..'xyz'"
	;
	lbc_directf(obj, fmt, s, 4);	// sz==4
	res = lbc_tbval(obj, 0, 1);		//adrs
	dbg( res.tp, res.s, res.s+2, res.sz);	// 's', a(\0bcxyz), bcxyz, 7
	lbc_free(obj);
}
#endif

int lbc_keyvalsv_impl(int nidx, lbc_t* obj, int tgt) {
	lua_t* L = obj->L;
//	; ERRact(nidx==0, "use [1] or upper", printf("save:%d\n", nidx); exit(1));
	; STOP(obj->lpflg==0, "use only lbc_pair() loop");
	if(nidx<0) { nidx= lbc_searchnidx(obj);}
	if(tgt=='k') {tgt= -4;}
	if(tgt=='v') {tgt= -3;}
	//	..|k|v 初期スタック状態 forの中のみ
	lua_getglobal(L, obj->glname);
	lua_pushnumber(L, nidx);	//	k|v|name|3
	lua_pushvalue(L, tgt);	//...|k|v|name|3|kcopy の順になってるはず コピー追加
	lua_rawset(L, -3);		//...|k|v|name[3]
	lua_pop(L, 1);		//	..|k|v
	return nidx;
}

int lbc_pairexit(lbc_t* obj) {
	lua_settop(obj->L, -4);	// tb|k|v なので-4が本来の位置
	obj->lpflg=0;
	return 0;
}
int lbc_pairinit(int flg, lbc_t* obj, ...) {
	if(flg==0) {return 0;}
	obj->lpflg=1;
	lua_t* L = obj->L;
	lua_settop(obj->L, 0);
//
	va_list vp;
	va_start(vp, obj);
	const char* rs;
	rs = lbc_tbval_ag2tb(L, vp);
	va_end(vp);
	rs = lua_pushfstring(L, "return %s%s", obj->glname, rs);
//
	int rc = luaL_dostring(L, rs);
	; ERRact(rc, "catch err, bad code?", fputs(rs, stderr); exit(1));
	; ERRact(lua_type(L, -1)!=LUA_TTABLE, "idx doesnt have tb", printf("idx:%s\n", rs) );
	lua_insert(L, -3);	//agとcmdとrtnの三つでrtnを残す
	lua_pop(L, 2);
	//nilstartでnext準備で2つ乗っけておく
	lua_pushnil(obj->L);
	lua_pushnil(obj->L);
	return 1;
}
int lbc_isnextval(int mode, lbc_t* obj, void* k, lbc_rt* v) {
	lua_t* L=obj->L;
	lua_pop(L,1);	//最初に2こ積んでおけばいい
	lbc_rt* key = k;
	if(mode>0) {
		// arr系は直接問い合わせ popが邪魔だけど合わせる vが残るからそれでちょうどいい
		// breakは二つで起きるので常に2つ乗っける状態にする
		int* num = k;
		*num=*num+1;	//ここで追加なので0start
//		lua_pushnil(L);	//ダミー追加 stackのlenを合わせる
		lua_rawgeti(L, -2, *num );
		if(lua_type(L, -1) == LUA_TNIL) { v->inner_flg=0; goto lb_RTN; }
	} else {
		//key系はiter問い合わせ 空は終了 で2つ埋めて合わせる
		*key = (lbc_rt){0};
		if(lua_next(L, -2)==0) {
			//break
			 v->inner_flg=0;
			lua_pushnil(obj->L);
			lua_pushnil(obj->L);
			goto lb_RTN;
		}
		//key
		if(lua_type(L, -2) == LUA_TNUMBER) {
			key->tp='n';
			key->s=NULL;
			key->i = lua_tointeger(L, -2);
			key->d = lua_tonumber(L, -2);
		} else if(lua_type(L, -2) == LUA_TSTRING) {
			key->tp='s';
			key->i=0;
			key->d=0;
			size_t sz=0;
			key->s = lua_tolstring(L, -2, &sz);
			key->sz = (int)sz;
		} else if(lua_type(L, -2) == LUA_TNIL) { key->tp='N'; }
		else if(lua_type(L, -2) == LUA_TTABLE) { key->tp='t'; }
		else if(lua_type(L, -2) == LUA_TFUNCTION) { key->tp='f'; }
		else if(lua_type(L, -2) == LUA_TUSERDATA) { key->tp='u'; }
		else if(lua_type(L, -2) == LUA_TTHREAD) { key->tp='T'; }
		else if(lua_type(L, -2) == LUA_TLIGHTUSERDATA) { key->tp='l'; }
	}
	lbc_rt* val = v;
	*val = (lbc_rt){1};	//rcが入ってる
	//val
	if(lua_type(L, -1) == LUA_TNUMBER) {
		val->tp='n';
		val->s=NULL;
		int i = lua_tointeger(L, -1);
		double d = lua_tonumber(L, -1);
		val->i=i;
		val->d=d;
		if(i!=d) { val->d=d; val->i=0; }
	} else if(lua_type(L, -1) == LUA_TSTRING) {
		val->tp='s';
		val->i=0;
		val->d=0;
		size_t sz=0;
		val->s = lua_tolstring(L, -1, &sz);
		val->sz = (int)sz;
	} else if(lua_type(L, -1) == LUA_TTABLE) {
		val->tp='t';
		val->i=0;
		val->d=0;
		val->s=NULL;
		val->sz = 0;
	} else if(lua_type(L, -1) == LUA_TNIL) {
		val->tp='N';
		val->i=0;
		val->d=0;
		val->s=NULL;
		val->sz = 0;
	} else if(lua_type(L, -1) == LUA_TBOOLEAN) {
		val->tp='b';
		const char* p = lua_tostring(L, -1);
		if(p[0]=='t') {val->i=1;}
	} else if(lua_type(L, -1) == LUA_TFUNCTION) { val->tp='f'; }
	else if(lua_type(L, -1) == LUA_TUSERDATA) { val->tp='u'; }
	else if(lua_type(L, -1) == LUA_TTHREAD) { val->tp='T'; }
	else if(lua_type(L, -1) == LUA_TLIGHTUSERDATA) { val->tp='l'; }
	else { STOP(1, "unreachable block"); }
lb_RTN:;
	return v->inner_flg;
}

#ifdef TEST
HCUT_ADD(t_pairs) {
	lbc_t* obj = lbc_new();
#include "al.h"
#include "bl.h"
	lbc_reqbcM(obj, al);
	lbc_runbcM(obj, argc, argv, bl);
	//
	lbc_pairs(k, v, obj, 0) {
		int rc = lbc_valsv(-1, obj);
		dbg(rc, k.tp, k.s, k.i, v.tp, v.s, v.i, v.d, v.sz);
	}
	lbc_pairs(i, v, obj, 0) {
		dbg(i, v.tp);
		puts(v.s?v.s:"no" );
	}
	lbc_free(obj);
}
#endif

#ifdef TEST
HCUT_ADD(t_bm1) {
	lbc_t* obj = lbc_new();
	#include "al.h"
	#include "bl.h"
	lbc_reqbcM(obj, al);
	lbc_runbcM(obj, argc, argv, bl);
	//
#undef LP
#define LP	1000*1000
	laptime(0);
	loop(LP){ lbc_rt res = lbc_tbval(obj, 0, 1);}
	laptime("tbval() getloop: " qu(LP));

	laptime(0);
	loop(LP){ int n = lbc_tbvalsv(1, obj, 0, 1);}
	laptime("tbval() setloop: " qu(LP));
	
	lbc_free(obj);
//lj	154.00ms	:	local num=100*1000*1000
//real	2556.991 ms	: ./lbc.ts.c 115: t_bm1_sub(): msg:tbval() getloop: 1000*1000
//real	2943.116 ms	: ./lbc.ts.c 119: t_bm1_sub(): msg:tbval() setloop: 1000*1000
}
#endif


#ifdef TEST
#include <stdio.h>
#include <stdlib.h>
#include <search.h>

#define LPnum 1000*1000
HCUT_ADD(t_bm2) {
	ENTRY e;
	ENTRY *ep;
	hcreate(30);
	; laptime(0);
	loop(LPnum) {
		e.key = "key";
		e.data = (void *) 1;
		ep = hsearch(e, ENTER);
	}
	; laptime("c99setloop: " qu(LPnum));
	; laptime(0);
	loop(LPnum) {
		e.key = "key";
		ep = hsearch(e, FIND);
//		printf("%d\n", (int)ep->data );
		//printf("%9.9s -> %9.9s:%d\n", e.key, ep ? ep->key : "NULL", ep ? (int)(ep->data) : 0);
	}
	; laptime("c99getloop: " qu(LPnum));
	hdestroy();
//real	46.685 ms	: ./lbc.ts.c 141: t_bm2_sub(): msg:c99setloop: 1000*1000
//real	44.315 ms	: ./lbc.ts.c 149: t_bm2_sub(): msg:c99getloop: 1000*1000
}
#endif

#ifdef TEST
HCUT_ADD(t_bm3) {
	int sz=1000;
	int arr[sz];
	for(int i=0;i<sz;i++){arr[i]=i;}
	laptime(0);
	loop(LPnum) { arr[LPnum%sz]=10; }
	laptime("arr, setloop: " qu(LPnum));
//
	laptime(0);
	int b=0;
	loop(LPnum) { b=arr[LPnum%sz]; }
	laptime("arr, getloop: " qu(LPnum));
//real	21.068 ms	: ./lbc.ts.c 159: t_bm3_sub(): msg:arr, setloop: 1000*1000
//real	16.977 ms	: ./lbc.ts.c 164: t_bm3_sub(): msg:arr, getloop: 1000*1000
}
#endif

#ifdef TEST
HCUT_ADD(t_bm4) {
	lhh_t* obj = lhh_new();
	laptime(0);
	loop(LPnum) { lhh_set(obj, lpcnt, lpcnt); }
	laptime("lhh, setloop: " qu(LPnum));
//
	lhh_rt res;
	laptime(0);
	loop(LPnum) { res = lhh_get(obj, lpcnt); }
	laptime("lhh, getloop: " qu(LPnum));
//real	197.392 ms	: ./lbc.ts.c 172: t_bm4_sub(): msg:lhh, setloop: 1000*1000
//real	192.476 ms	: ./lbc.ts.c 177: t_bm4_sub(): msg:arr, getloop: 1000*1000
}
#endif

lhh_t* lhh_new(void){
	lua_State *L = luaL_newstate();
	; STOP(L==NULL, "fatal err");
	lhh_t* res = (lhh_t*)calloc(1, sizeof(lhh_t) );
	; STOP(res==NULL, "memerr");
	res->L = L;
	strcpy(res->glname, LHH_GLNAME);
	lua_newtable(L);
//	lua_pushnumber(L, 0);
//	lua_newtable(L);
//	lua_rawset(L, -3);
	lua_setglobal(L, LHH_GLNAME);
	return res;
}
void lhh_free(lhh_t* obj){
	lua_close(obj->L);
	*obj=(lhh_t){0};
	free(obj);
}

//#define lhh_set(obj, key, val, ...)	lhh_set_impl(0, obj, #key, key, #val, val, __VA_ARGS__+0)
//#define lhh_setd(obj, key, val, ...)	lhh_set_impl(1, obj, #key, key, #val, val, __VA_ARGS__+0)
int lhh_set_impl(int dmode, lhh_t* obj, const char* s, ...){
	lua_t* L = obj->L;
	va_list vp;
	va_start(vp, s);
//
//	lhh_preset(obj);
	lua_getglobal(L, obj->glname);
	char* p = (char*)s;
	//key
//dbg(dmode, lua_gettop(L) );
	if(p[0]=='"') { lua_pushstring(L, va_arg(vp, char*) ); }
	else if(p[0]=='&') { lua_pushstring(L, *va_arg(vp, char**) );}	//&系は二重なので細工
	else if(dmode){ lua_pushnumber(L, va_arg(vp, double) );}
	else{ lua_pushnumber(L, va_arg(vp, int) ); }
	//val
	p = va_arg(vp, char*);
//dbg("23", p[0]);
	if(p[0]=='"') {
		p = va_arg(vp, char*);
		int sz=0;
		if(dmode){ sz = (int)va_arg(vp, double); }
		else{ sz = va_arg(vp, int); }
		if(!sz){sz=strlen(p); }
		lua_pushlstring(L, p, sz);
	}else if(p[0]=='&') {
		p = *va_arg(vp, char**);
		int sz=0;
		if(dmode){ sz = (int)va_arg(vp, double); }
		else{ sz = va_arg(vp, int); }
		if(!sz){sz=strlen(p); }
		lua_pushlstring(L, p, sz);
	}else if(dmode){
		double num = va_arg(vp, double);
		lua_pushnumber(L, num);
	}else{
		int num = va_arg(vp, int);
		lua_pushnumber(L, num);
	}
	lua_rawset(L, -3);
	lua_pop(L, 1);
	va_end(vp);
	obj->cnt++;
	return obj->cnt;
}

int lhh_unset_impl(int dmode, lhh_t* obj, const char* s, ...){
	lua_t* L = obj->L;
	va_list vp;
	va_start(vp, s);
	char* p = (char*)s;
//
//	lhh_preset(obj);
	lua_getglobal(L, obj->glname);
	//key
	if(p[0]=='"') { lua_pushstring(L, va_arg(vp, char*) ); }
	else if(p[0]=='&') { lua_pushstring(L, *va_arg(vp, char**) );}	//&系は二重なので細工
	else if(dmode){	lua_pushnumber(L, va_arg(vp, double) );}
	else{ lua_pushnumber(L, va_arg(vp, int) ); }
	lua_pushnil(L);
	lua_rawset(L, -3);
	lua_pop(L, 1);
	obj->cnt--;
	return obj->cnt;
}

lhh_rt lhh_get_impl(int dmode, lhh_t* obj, const char* s, ...){
	lua_t* L = obj->L;
	lhh_rt res={0};
	va_list vp;
	va_start(vp, s);
	char* p = (char*)s;
//
	; STOP(obj->lpflg, "lhh_get() doesnt work in the pairloop to save stack state");
	lua_settop(L, 0);
	lua_getglobal(L, obj->glname);

//	lhh_preset(obj);
	//key
	if(p[0]=='"') { lua_pushstring(L, va_arg(vp, char*) ); }
	else if(p[0]=='&') { lua_pushstring(L, *va_arg(vp, char**) );}	//&系は二重なので細工
	else if(dmode){	lua_pushnumber(L, va_arg(vp, double) );}
	else{ lua_pushnumber(L, va_arg(vp, int) ); }
	lua_rawget(L, -2);
	lua_remove(L, 1);
	//numが先じゃないとstirngになっちゃう
	if(lua_isnumber(L, -1) ){
		res.tp='n';
		res.d = lua_tonumber(L, -1);
		res.i = (int)res.d;
	}else if(lua_isstring(L, -1) ){
		size_t sz;
		res.s = lua_tolstring(L, -1, &sz);
		res.sz = (int)sz;
		res.tp='s';
	}else{
		res.tp='N';
	}
	return res;
}
#ifdef TEST
HCUT_ADD(t_lhh) {
	lhh_t* obj = lhh_new();
	lhh_set(obj, "key1", "val");
	lhh_set(obj, "key2", 11);
	const char* p = "123\0xyz";
	lhh_set(obj, "key3", &p, 7);
	lhh_set(obj, 3, 10);
	lhh_set(obj, 4, "unko");
	lhh_set(obj, 5, &p, 6);
;dbg(obj->cnt);	//6
	lhh_unset(obj, 3);
;dbg(obj->cnt);	//5
	lhh_setd(obj, (double)9.2, 10.1);
	lhh_rt res = lhh_get(obj, 4);
;dbg(res.s, res.tp, res.sz);
	res = lhh_getd(obj, 9.2);
;dbg(res.s, res.tp, res.sz, res.d, res.i);
;dbg();
	lbc_pairs(k,v,obj){
		dbg(k.i, k.d, k.s, k.tp, v.i, v.d, v.s, v.tp);
		//lhh_get(obj, 3);
		lhh_unset(obj, 5);
	}
	lhh_free(obj);
}
#endif

/*SH_SMP
#include "*SH_bn*.h"	//SH_co*	-static lib*SH_bn*.a libluajit-5.1.a -ldl -lm	*
#include <stdio.h>

int main(int argc, char** argv) {
	lbc_t* obj = lbc_new();
//	#include "mod.h"
//	#include "run.h"
//	lbc_reqbcM(obj, mod);
//	lbc_runbcM(obj, argc, argv, run);
	lbc_runstr(obj, argc, argv, "return 1,2,3" );
	lbc_rt res = lbc_tbval(obj, 0, 1);
	printf("%c / %d\n", res.tp, res.i);
	lbc_free(obj);
	return 0;
}

//SH_SMPE*/

#ifdef TEST
HCUT_RUN("stderr", 1,
         t_lbc)
#endif


/*
 change log
 --
2021-07-05	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c(msgp.h): omit dbg()

2021-07-05	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c(lbc_rt): rename member 'rc' >> 'inner_flg'
	(doc): fix doc. v1.1.0

2021-06-23	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c(LBC_C2P, P2C, P2S): fix directf() ffi macros

2021-05-08	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c(all): v1.0.0 release

2021-04-25	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c(-): init

*/

/*SH_ED*/

/*SH_OP _ set -e;a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a"	#*/
/*SH_OP	h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout		GPLv3+"	 #*/
/*SH_OP	f sed -ne "/${C}DF/q;/;/d;/^[a-zA-Z].*)/p"<$R0 #*/
/*SH_OP t $e"$CW";ftt "$@";$p'cc -pedantic -pg $tf $Rs `fOI $tf` `fg $tf` `fL`'|fv	#*/
/*SH_OP T $e"$CW";ftt "$@";$p'cc -O2 $tf $Rs `fOI $tf` `fg $tf` `fL`'|fv	#*/
/*SH_OP s $e"$CB";fgr0 "${C}SMP" "${C}SMPE"<$Rs|fbn>eg.c;$p'cc eg.c `fg eg.c`'|fv #*/

/*SH_OP L $p"valgrind --leak-check=full ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"|fv #*/
/*SH_OP M $p"fM ./a.out"|fv	 #*/
/*SH_OP P $p'valgrind --tool=callgrind --callgrind-out-file=log.out ./a.out;kcachegrind log.out'|fv	 #*/

/*SH_OP b $e"$CW";$p'cc -c $Rs -pedantic -O2 -Wall -g `fg $Rs` `fI $Rs`'|fv;$p"$bn.o"	#*/
/*SH_OP B $e"$Cb";$p"ar -r lib$bn.a $bn.o `fO $Rs`"|fv;$p"lib$bn.a"	#*/
/*SH_OP A $e"$CB";$p'fA lib$bn.a `fg $Rh $Rs|fu|grep '[.]a$'|fU`'|fv;$p"lib$bn.a" #*/
/*SH_OP S $e"$Cb";$p"cc -shared -fPIC -o lib$bn.so $bn.o `fOI $Rs` `fg $Rs`"|fv;$p"lib$bn.so" #*/
/*SH_OP W $e"$Cm$O$Cw">/dev/null;$i0;$i1;$p"$Rs $Rh $tf"	#*/
/*SH_OP o $e"$CW";$p"rm $tf"|fv;fman $R0 3	#*/

/*SH_DF
#-- noob
fman()(fgr0 "${C}doc" "${C}docE"<$1>$Rm
cat $Rm|sed -e's/^@\([_a-zA-Z][_[:alnum:]]*\)/\n\n# \1\n\n/g
/^\\/{s/^\\/<br>/g}'>$bn.md
cat $bn.md|pandoc -f markdown -thtml> $Rm
cat $Rm|pandoc -s -f html -t man -M title="$bn" -M section="$2" \
-M date=`date '+%Y-%m-%d'` > $bn.$2
sed -e 's/^.nf/.RE\n.nf/'<$bn.$2>$Rm
mv $Rm $bn.$2
$p"$bn.$2">/dev/stderr
)
fhtml()( md2h $bn.md $bn )

#-- local
# f_inc<$Rh>$tf;mv $tf $Rh
f_inc()( awk '
$1=="#include" && $2 =="\"lua.h\"" {next}
$1=="#include" && $2 =="\"luaconf.h\"" {next}
{print}'
)

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frf)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()(sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

# fO src.o from inc"src.abc" etc. kick self
fO()(set -- `fdp "$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.o/'|fU`
	buf="";for i;do test -f $i&&buf="$buf $i";done;$p"$buf"
)
fI()(fdp "$@"|sed -e 's/[^/]*$//g'|fu|sed -e '/./s/^/ -I/g'|fU)
fL()(find -L `dirname $R0` -type d|sed -e 's/^/-L/g'|fU)
# inc""系.h,hpp,oをパス付きで羅列 OIはfdpが重複するので高速化でまとめる
fOI()(
set -- `fdp "$@"`
s="-I./ "`$p"$@"|sed -e 's/[^/]*$//g'|fu|sed -e 's/^/ -I/g'|fU`
set -- `$p"$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.o/'|fU`
buf="";for i;do test -f $i&&buf="$buf $i";done;
$p"$buf $s"
)

# 依存inc""を再帰的に取得./以下全て self系はkick
fdp()( l="$*"; paths="$@"; all=""; used=""
 while :;do
	all=`$p$all $paths|fU`	#差分を追加 repの始末 差分たちからaaa.hを取得 partial path
	buf=`(cat $paths|sed -ne 's@^[ \t]*#inc[^"]*.\([a-zA-Z0-9._]*\)".*@\1@p')|sort -u`
	ch=`$p$used $buf|tr -s ' ' '\n'|sort|uniq -u`	#使用済は外す
	used="$used $ch"	#リスト更新
	paths=`fsvy $ch|sort -u`	#ls検索 name系のみのはず
	buf=`$p"$all" "$paths"|fU`	#増えたらloop
	[ ${#all} = ${#buf} ]&&break
 done
# initを除く
 set -- $all
 for i;do a=${i##*[/]}; a=${a%%.*};[ "${l##*$a*}" = "$l" ]&&set -- "$@" $i;shift;done
 $p"$@"
)

# corecode:search + depthck + uniq
fsvy()(c="find -L ./ -false"
	for i; do c="$c -o -path '*'$i";done; l=`$e"$c"`
	for i; do $p"$l"|grep -F "$i"|awk '{sv=$0;print gsub("[/]","") " " sv}'|
	sort -k 1.1,1n -k 2.2,2|awk '{print $2;exit}'; done
)

# libをまとめる
fA()(n=0;dir=`dirname $0`/tmpdir;mkdir $dir;cd $dir;
 for i;do
 	n=$((n+1))
 	cp ../$i $i
 	ar -x $i
 	for ii in *.o;do mv "$ii" "p${n}_$ii";done
 	ar -r lib$bn.aa *.o
 	rm *.o
 done
 $p'mv lib$bn.aa ../lib$bn.a'|fv
 cd ..;rm -r $dir
)

#-- yacc
# /*SH_OP y $e"$CW";fy
# /*SH_OP Y $e"$Cy";fU $( ($p"lib$bn.a";fg $Rs $Rh)|$n|grep '[.]a$'|$U)
fy()(
cat<<'EEE'|fv
f0 "${C}YACC" "${C}YACCE"<$Rs>myyacc.y
f0 "${C}LEX" "${C}LEXE"<$Rs>mylex.l
lex mylex.l; yacc -p zz -dv myyacc.y
cat y.tab.c lex.yy.c > $Rs
gcc -c y.tab.c lex.yy.c -lfl `fA $Rs $Rh`
rm mylex.l myyacc.y lib$bn.a
ar r lib$bn.a `fo $Rs` y.tab.o lex.yy.o
$p"lib$bn.a"
EEE
)

#-- longcmd
frf()(
 awk -v r="${C##*]}rf" 'match($0,r){
 s=substr($0, RSTART+RLENGTH+1)
 gsub(/.[^*]*$/, "", s);split(s, a)
 m="[ -f %s ]&&echo \"/*--copyfrom %s*\"/&&cat %s&&echo \"/*--copyend %s*\"/"
 for(i=1;v=a[i];i++){ system( sprintf(m, v,v,v,v))}
 next
 }
 {print}'
)

ftt()(a="`sed -ne 's@^HCUT_ADD(\([^)]*\).*@\1, @p' $tf|tr -d '\n'`NULL"
	if [ $# != 0 ];then	a=""; for i;do a="$a $i,";done; a="$a NULL"; fi
	sed -ne "p;/_RUN/bl;d;:l;/[)]/{c\\$O $a)$O p;d};n;bl"<$tf>$Rm;mv $Rm $tf)
i0=$e'fgr0 "^#ifdef TEST" "^#endif"<$R0|fbn>$tf'
i1=$e'fgR "^#ifdef TEST" "^#endif"<$Rs|fbn>$Rm;mv $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh'
fM()(
 valgrind -q --tool=massif --massif-out-file=./vmem.buf --stacks=yes --trace-children=yes $1>/dev/null
 ms_print ./vmem.buf|sed -ne '/[KMG]B/bl;d;:l;/snap/q;p;n;bl';rm ./vmem.buf)

/*SH_DE*/
