#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[/][/*]SH_'     ;O=${0##*[/]};R=`dirname $0`;R=${R%/}/;R0=$R$O;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGsuffix"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d
:l;n;p;bl"<$R0>$Rm;$Rp"$Rm"';RB=$($R"s/${C}OP//p"<$R0|(F=mw;while read -r a b;do
B=${a%:};F=`$Rp"$F"|$R"s#$B:*##1;p"`${a%_};$Rp"C$B=\$(cat<<'E'$O$b${O}E$O)";done
$Rp"R1=$F"));Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;bl"<$R0';Cw="(R=LS;$Rw;$Rw>&3;R=HD
$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';Re=eval\ ;$Re"$RB";while getopts $R1\
 R;do case $R in \?)exit 1;;*)$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac
done;[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit   #END GPL3+*/

/*SH_LS*/
/*
 Copyright (C) 1991-2012 the Free Software Foundation, Inc.
 Copyright (C) 2021 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/*-*
@name	ureg
@_brief	portable regex with posix-ERE + binary 
@synopsis

 typedef struct ureg_tag {
 	void* data;		//opaque regobj
 	char* fastmap;	//fastmap[0]-[255]. holds 1st byte hit or not
 	char* lc;		//locale str
 	int rawflg;		//locale flg
 	const char* p;	//result buff
 	int sz;		//buff
 	const char* pbk[10];	//buff
 	int szbk[10];	//buff
 } ureg_t;

 ureg_t* ureg_new(const char* reg [,int reglen, int syn] )
 ureg_t* ureg_new_raw(const char* reg [,int reglen, int syn] )
 int ureg_search(ureg_t* obj, const char* s [,int slen] )
 int ureg_search_head(ureg_t* obj, const char* s [,int slen] )
 void ureg_free(ureg_t* obj)

 // helper/wrapper funcs
 ureg_t ureg_easy(const char* reg,const char* s [,int reglen,int slen,int syn])
 int ureg_dflsyn(void);
 void* ureg_iconv(const char* toenc, const char* fromenc, char** s [,int slen])

@_eg
 #include "ureg.h"

 int main() {
 //simple
 	ureg_t res = ureg_easy("a[bc]", "123abc"); //res.p="123abc"+3, res.sz=2
 	res = ureg_easy("a(b|c)", "123abc");  //res.pbk[1]="123abc"+4,res.szbk[1]=1
		printf("%.*s", res.szbk[0], res.pbk[0]);	//>> "ab"

 //complex
 	ureg_t* obj = ureg_new("a(b|c)");	//rtn NULL: err
 	const char* s = "123abc";
 	int rc = ureg_search(obj, s);	//rc== hit:>=0 nohit/err:<0
 	  //obj->p=s+3, obj->sz=2
 	  //obj->pbk[0]= s+3, obj->szbk[0] =2	//p==pbk[0]: all the match string
 	  //obj->pbk[1]= s+4, obj->szbk[1] =1	//backref: (b|c) hits 123a(b)c
 	  //obj->pbk[2]= NULL,obj->szbk[2] =-1	//set NULL/-1 if no result

 	rc = ureg_search_head(obj, s);	//search_head: regex hits only string top
 	  // obj->p= NULL, obj->sz= -1	//nohit
 	rc = ureg_search_head(obj, s+3);
 	  // obj->p= s+3, obj->sz= 2
 	ureg_free(obj);
 	
 	setlocale(LC_CTYPE, "UTF32");	// ~$ iconv -l
 	obj = ureg_new_raw("a(b|c)");
 	setlocale(LC_CTYPE, "C");	// reset
 	rc = ureg_search(obj, s);
 	ureg_free(obj);
 	
 //ureg_iconv(): not regex, but you maybe need. conv encode UTF-8,EBCDIC etc
 	const char* s0 = "hwd";		//"hwd"=="\150\167\144" in ascii(C) charset
 	const char* s1 = "\210\246\204";	//"hwd" in EBCDIC-BR
 	char* s = s0;
 	int* p = ureg_iconv("EBCDIC-BR","ASCII",&s,2);	//(to,from,s0_adrs,len)
 	int binsz = p[0];	//==2, conv result bytesz
 	char* pp = (char*)(p+1);
 	  // pp[0]=='\210', pp[1]=='\246', pp[2]=='\0'
 	  // srcptr &s is changed to "hwd"+2, "(hw)d" pos, s[0]=='d'
      // | binsz |  c  |  c  | 0 |
      //    int    char  char  \0		case: binsz=2
	free(p);	// ureg_iconv() rtns sz+bin malloc()ed ptr.
	return 0;
 }
 // ~$ gcc src.c libureg.a

@_param -
@_return	-
@description
 --- regex expression
 default ureg() uses posix-ERE with the following expantion.
    - [] and .(dot) includes '\n' and '\0'
    - [z-a], reverse range causes err
    - [] allows multibyte(mb) charactor range in mb locale, [\u1000-\u2000] etc
    - allow binary expression except [] and .(dot)	eg) "\377z[0-9]" etc
    - [] and .(dot) ignores bad byte.
      eg)  [Σ\377]==[\u03a3]	: 1char, multibyte locale
      eg)  [Σ\377]==[\316\243\377]	:3 char, C locale

 --- easy mode
  - func
	ureg_t ureg_easy(const char* r,const char* s [,int rlen,int slen,int syn])

	ureg_easy() uses for oneshot search. use '-1' if rlen/slen/syn is omitted.
	search result is set to rtn.	if nohit, set res.p==NULL, res.sz<0.
		res = ureg_easy("a[bc]", "123abc");	//match, res.p="..."+3, res.sz=2
		res = ureg_easy("a[bc]", "123abc", -1, -1 ,-1);	//same result

  - params:
	r: regex str.
	s: search target string/binary.
	rlen: r size. use strlen(r) if set -1/noset.
	slen: s size.
	syn: change regex syntax. see below 'complex mode'.

  - result:
    res.p : regex matched ptr. res.p[0]=='a' in above samnple. "123(a)bc".
    res.sz: match string byte size.
    other : see below 'complex mode'.

  - minimum code:
	#include "ureg.h"
	int main(int argc, char** argv){
		ureg_t res = ureg_easy("a[bc]", "123abc");
		printf("%.*s \n" res.sz, res.p);	//>> disp "ab"
		return 0;	//no memleak
	}
	// ~$ gcc src.c libureg.a

  - restriction
    - locale raw mode is unsupport. always run under the sys locale (UTF-8 etc)
    - malloc()/free() is executed every time


 --- complex mode: 1.compile regex, 2.search, 3.free ptn
 1. compile regex
  - func
	ureg_t* obj = ureg_new(const char* reg [,int reglen, int syn] )
	ureg_t* obj = ureg_new_raw(const char* reg [,int reglen, int syn] )

   C_lang uses "C" or "POSIX" locale in default setting
   
		eg) int main(){ puts( setlocale(LC_CTYPE, NULL) ); }	//>> "C"
   
   and regex semantics is differences from locale "C" to "UTF-8".
	C:		"[Σ]" == "[\316\243]" == "(\316|\243)"	// binary \316 or \243
	UTF-8:  "[Σ]" == "\316\243"	// regard "\316\243" sequences as onechar.

   ureg_new() uses OS locale, setlocale(LC_CTYPE, "") (see ~$ echo $LANG) and
   use its locale when search.
   ureg_new_raw() uses current locale and never changes locale setting, so
   adjusting locale is user duty. if new/search locale isnt the same, you
   may catch strange results. 
   obj holds setlocale(LC_TYPE,NULL) data when new() to obj->lc as string.

 	#include "ureg.h"		//~$ cc src.c  libureg.a
	int main() {
		ureg_t* obj = ureg_new("[Σ]");	//save env locale, setlocale(LC_TYPE,"")
		puts(obj->lc);	// "XX.UTF-8" etc
		ureg_search(obj, "xΣyz");	// match len: obj->sz=2
		ureg_free(obj);

		obj = ureg_new_raw("[Σ]");	//== "(\316|\243)" at locale "C"
		puts(obj->lc);	// "C" etc
		ureg_search(obj, "xΣyz");	// obj->sz=1
		ureg_free(obj);

			setlocale(LC_CTYPE, "C.UTF-8");
		obj = ureg_new_raw("[Σ]");	//== "\316\243" at UTF-8
			setlocale(LC_CTYPE, "C");
		ureg_search(obj, "xΣyz");	// obj->sz=1, use current locale
			puts(obj->lc);	//>> "C.UTF-8"
		ureg_free(obj);

		return 0;
	}
   
   i reccomend you to use ureg_new() except rare/special usage.
   len/syn uses strlen(reg)/(dfl) if set -1/noset. the follows work as the same.
	  obj = ureg_new(rstr);
	  obj = ureg_new(rstr, strlen(rstr) );
	  obj = ureg_new(rstr, -1, -1);

  - param: reg
   regex expression str. mb class/range works only under the mb locale env.
     - [Σ-Τ] == "(\u03a3|\u03a4)" 	:"XXX.UTF-8" == setlocale(LC_CTYPE,"")
     - [Σ-Τ] == [\316\243-\316\244]== [\243-\316]		:"ASCII" 
   if you use ureg_new() and system supports mb, you can use mb charactors.

  - param: reglen
   if regstr has '\0', you needs to set len. use strlen(len) if set-1/noset
		const char* r = "[\t\0]";
		obj = ureg_new(r, 4);		//reg matches '\t' or '\0'

  - param: syn
   if you want to change regex syntax from default, set this syntax flag.
   you can use gnu-regex flag. posix-regcomp() flag is unsupported.
   ureg_dflsyn() rtns dfl flag.
		int syn = ureg_dflsyn();
		syn |= RE_ICASE;	 // ignorecase mode, "abc" == "[aA][bB][cC]"
		obj = ureg_new("abc", -1, syn);
		rc = ureg_search(obj, "00AbC11");	//hit "AbC"

   dfl syntax is:
 dflsyn = 0
 //	| RE_BACKSLASH_ESCAPE_IN_LISTS //"\" works as esc in [] on:yes off:no //posix:off, special chars is only ^-[] in class
 // | RE_ICASE			// ignore case, aa==Aa	 on:a==A off:a!=A
	| RE_INTERVALS		// use {} op	on:use off:normal chars
 //	| RE_LIMITED_OPS	// +*?| are normal chars	on:yes off:special chars
	| RE_CHAR_CLASSES	// use [:alnum:] etc	on:yes off:no

 	| RE_CONTEXT_INDEP_ANCHORS	//$^ are special except []/esc (a^c etc) yes/no
	| RE_CONTEXT_INDEP_OPS	// *+? raise err in bad pos, "+a" etc	on/off
	| RE_CONTEXT_INVALID_DUP	// "{2}a" raise err	on:yes off:[{][2][}]a
	| RE_CONTEXT_INVALID_OPS	// +*? raise err, "?a" etc	on:yes off:[+]a
 	| RE_UNMATCHED_RIGHT_PAREN_ORD //")a" DOESNT raise err	on:[)]a off:err
 //	| RE_INVALID_INTERVAL_ORD	// "}abc" DOESNT raise err	on:[}] off:err

	| RE_DOT_NEWLINE	// .(dot) includes '\n'	on:include off:exclude
 //	| RE_DOT_NOT_NULL	// .(dot) excludes '\0'	on:exclude off:include
 //	| RE_HAT_LISTS_NOT_NEWLINE	//[^a] excludes '\n' 	on:exclude off:include

 //	| RE_NEWLINE_ALT	// a(\n)b works as a|b, on:\n==| off:| only
	| RE_NO_BK_BRACES	// interval {}, on:{} off:\{\} //needs RE_INTERVALS:on
	| RE_NO_BK_PARENS	// grouping (),	on:() off:\(\)
	| RE_NO_BK_VBAR		// | or \|,  on:| off:\|	//needs RE_LIMITED_OPS:off
 //	| RE_NO_BK_REFS		// use \1,\2 etc  on:nouse off:use
 //	| RE_BK_PLUS_QM		// repeat "a+" or "a\+" 	on:\+ off:+

	| RE_DEBUG		// holds dbginfo	on:yes off:no	//emsg etc
	| RE_NO_EMPTY_RANGES	// [z-a] is err range	on:yes off:no, use as empty
	| RE_NO_GNU_OPS		// use out of standard op, \< etc 	on:nouse off:use
 //	| RE_NO_POSIX_BACKTRACKING	//use shortest match	on:yes off:no,longest
 //	| RE_NO_SUB		//drop backref data, (ab)c \1=ab etc.	on:yes off:hold
 ;
 
 // --gnu-predefined other syntax
 //	#define _RE_SYNTAX_POSIX_COMMON
 //	  (RE_CHAR_CLASSES | RE_DOT_NEWLINE      | RE_DOT_NOT_NULL
 //	   | RE_INTERVALS  | RE_NO_EMPTY_RANGES)
 //
 //	#define RE_SYNTAX_POSIX_EXTENDED
 //	  (_RE_SYNTAX_POSIX_COMMON | RE_CONTEXT_INDEP_ANCHORS
 //	   | RE_CONTEXT_INDEP_OPS  | RE_NO_BK_BRACES
 //	   | RE_NO_BK_PARENS       | RE_NO_BK_VBAR
 //	   | RE_UNMATCHED_RIGHT_PAREN_ORD)
 //
 //	   Differs from ..._POSIX_EXTENDED in that RE_CONTEXT_INVALID_OPS
 //	   replaces RE_CONTEXT_INDEP_OPS and RE_NO_BK_REFS is added.
 //	#define RE_SYNTAX_POSIX_MINIMAL_EXTENDED
 //	  (_RE_SYNTAX_POSIX_COMMON  | RE_CONTEXT_INDEP_ANCHORS
 //	   | RE_CONTEXT_INVALID_OPS | RE_NO_BK_BRACES
 //	   | RE_NO_BK_PARENS        | RE_NO_BK_REFS
 //	   | RE_NO_BK_VBAR          | RE_UNMATCHED_RIGHT_PAREN_ORD)
 //
 // --posix-ERE
 //	--undefined
 //	/()/
 //	/+aa|*{/
 //	/|g/
 //	[z-a]
 //	[a-c-e]
 // --valid
 //	[]]
 //	[\]]	>>2char '\' or ']'
 //	[-a]	>>2char '-' or 'a'
 //	[ac-]
 //	/a^b/, /a$b/ >> valid, but never matched
 
   ...gnu-regex manual have inconsistent expression(DO/NOT DO/NO/LIMIT etc) and
   low readability. refer to the above and the mit manual.
   ( http://web.mit.edu/gnu/doc/html/regex_2.html#SEC3 )

  - return: ureg_t* obj
   this obj holds regex expression, result and others.

		typedef struct ureg_tag {
			void* data;		// compiled opaque data. holds dfa, term list etc
			char* fastmap;	// uses for prune if needs
			char* lc;		// locale str. "XXX.UTF-8", "C" etc
			int rawflg;		// ureg_new() / ureg_new_raw() == 0/1
			const char* p;	// result buff.
			int sz;			// buff
			const char* pbk[10];	// buff
			int szbk[10];	// buff
		} ureg_t;
	
	obj->data is ptr to 'struct re_pattern_buffer*', gnu-regex struct.
	fastmap is ptr to gnu-regex struct members. see gnu-regex manual.
	allmost all users dont care about data/fastmap. see gnu-regex manual 
	if you needs. (-D_GNU_SOURCE + #include <regex.h>) 

 2. search
  - func
	int rc = ureg_search (ureg_t* obj, const char* s [,int slen] )
	int rc = ureg_search_head (ureg_t* obj, const char* s [,int slen] )

   ureg_search() finds match data from s. use strlen(s) if slen= -1/noset.
   ureg_search_head() sees only the target string head. if you used ureg_new(),
   search with obj->lc locale setting.
   
   funcs rtns >=0 or <0 == hit/nohit. srcptr+rc will be hittop ptr.
		r = "a[bc]";
		obj = ureg_new(r);
		s = "123abc";
		rc = ureg_search(obj, s);		//rc=3, hit: "...(ab)c", s[rc]='a'
		rc = ureg_search_head(obj, s);	//rc<0, nohit
		rc = ureg_search_head(obj, s+3);	//rc=0, hit "(ab)c", s[rc]='a'

   search funcs doesnt support pirtial match. you need fulltext.
		r = "a[bc]";	s = "123abc";
		rc = ureg_search(obj, s, 4);	//"123a", reg hits 'a' but fail. rc<0
		// if supports rc= -5(pirtial/morestr) etc, you may use fgetc()

  - param: obj
   regex data. search result is set to obj member. set NULL / -1 if nohit.
		char* obj->p : full matching ptrpos
		int   obj->sz: byte of matching str
		char* obj->pbk[10]: back referece ptrpos. obj->p == obj->pbk[0]
		int  obj->szbk[10]: byte of back reference data. obj->sz==obj->szbk[0]

		sample:
		r = "a[bc]";	s = "123abc";
		rc = ureg_search(obj, s);
		  //obj->p=s+4, obj->sz=2,  pbk[0]=p,szbk[0]=sz, pbk[1]=NULL,szbk[1]=-1
 		r = "(a(b|c))";	s = "123abc";
		rc = ureg_search(obj, s);	//obj->p, pbk is as below
		
		//	str: "123abc",	reg: "(a)(b|c)"
		//	p  :  ...oo.., sz=2, rc=3, p==s+rc
		//	p0 :   (p0==p) 
		//	p1 :  ...o..., sz=1
		//	p2 :  ....o.., sz=1
		//	p3 :  NULL,    sz= -1
		
   back reference result \1-\9 is set to pbk/szbk[1-9]. [0] has fullmatch data.
   index 1-9 applies to open parlen '(' order.
	reg:	( a ( b | c ) )
	bk :	\1  \2

  - param: s
	search target string. treated as binary.
  - param: slen
    target byte size. use strlen(s) if set -1/noset.
  - return: rc
	return hit adrsidx if suc search (p==src+rc). suc/fail == rc>=0 / rc<0

 4. free
  - func
	void ureg_free(ureg_t* obj)
   obj is malloc()ed. free memory when you finish regex search.


 --- other func: ureg_iconv()
  - func
	void* p=ureg_iconv(const char* tenc,const char* fenc,char** s [,int slen])

   this func doesnt directly related to regex, buf useful if you have different
   encoding data.

  - params:
	tenc: toenc type string. "UTF-8", "EBCDIC-BR" etc. see ~$ iconv -l
	fenc: fromenc. src encode type.
	s: srcptr-reference. this arg is changed by func, so pass the srcptr copy.
	slen: src byte size. use strlen(*s) if set -1/noset.

  - result:
    p: converted binary stream with bytesize. byte sequence is as follows.
			| binsz |  c  |  c  | 0 |
			   int    char  char  \0		case: binsz=2

	   use type punning (int), (char*) to get sz and binptr.
			int* p = ureg_iconv(...);	//p is malloc()ed as strdup()
			int binsz = p[0];	//==2, conv result bytesz
			char* bin = (char*)(p+1);
			printf("%.*s \n", binsz, bin);
			free(p);

	s: posbuff. if allsrc is converted to other enc, s is set as s == src+slen.
	  if detect invalid byte sequences, s is set to its address.
		all suc: "oooooooo"
		          ........s(maybe \0 or other)
		bad seq: "ooooox.."
		          .....s.. (s[0]=='\377' etc. between start and (s-1) is valid)


 --- benchmark:	loop(10*1000){ ureg_easy("4.6", "1234567890"); } etc
   - ureg
	real 465.921 ms	: ./ureg.ts.c 192: t_bm0_sub(): msg:easy:10*1000
	real 395.018 ms	: ./ureg.ts.c 202: t_bm1_sub(): msg:new-free: 10*1000
	real 13.612 ms	: ./ureg.ts.c 209: t_bm1_sub(): msg:search: 10*1000
	real 364.995 ms	: ./ureg.ts.c 222: t_bm2_sub(): msg:new-free@raw: 10*1000
	real 4.457 ms	: ./ureg.ts.c 229: t_bm2_sub(): msg:search@raw: 10*1000
   - oniguruma
	real 17.268 ms	: ./ureg.ts.c 264: t_bm4_sub(): msg:new-free@onig: 10*1000
	real 4.473 ms	: ./ureg.ts.c 276: t_bm4_sub(): msg:search@onig: 10*1000
   - strstr()
	real 0.050 ms	: ./ureg.ts.c 240: t_bm3_sub(): msg:strstr(): 10*1000

		FAST: strstr(1) >>> onig(100) >>> ureg(3000) :SLOW

 --- concept
 	- avoid complex api
 	- avoid non-standard regexp/operator like PCRE
 	- support binary input

@notes
 http://web.mit.edu/gnu/doc/html/regex_7.html
 http://www.kt.rim.or.jp/~kbk/regex/re_7.html
 https://regular-expressions.mobi/refunicode.html?wlr=1
 https://stackoverflow.com/questions/2359811/working-with-gnu-regex-functions-in-c-or-c
 https://stackoverflow.com/questions/8727795/does-posix-regex-h-provide-unicode-or-basically-non-ascii-characters
 https://stackoverflow.com/questions/48743106/whats-ansi-x3-4-1968-encoding
 https://www.iana.org/assignments/character-sets/character-sets.xhtml
@conforming_to posix-2001+
@version 2021-06-03 v3.0.1
@copyright Copyright 2021 momi-g, GPLv3+
-*/

/*SH_ED*/

/*SH_HD*/
#ifndef ureg_dfb770dd3ce8
#define ureg_dfb770dd3ce8

#include <stdio.h>
#if ( _POSIX_C_SOURCE +0 < 200112L )
	# include "needs compiler posix-2001 or upper(c99+)"
#endif

#include <locale.h>
#include <langinfo.h>
#include <iconv.h>
typedef struct ureg_tag {
	void* data;
	char* fastmap;
	char* lc;
	int rawflg;
	const char* p;
	int sz;
	const char* pbk[10];
	int szbk[10];
} ureg_t;

ureg_t* ureg_new_impl(int rawflg, const char* rstr, int rstrsz, int syn, ...);
void ureg_free(ureg_t* obj);
int ureg_search_impl(int topflg, ureg_t* obj, const char* tgtstr, int slen, ...);
int ureg_dflsyn(void);

ureg_t ureg_easy_impl(const char* reg, const char* s, int rlen, int slen, int syn, ...);
void* ureg_iconv_impl(const char* toenc, const char* fromenc, char** str, int strsz, ...);

#define ureg_new(...)		  ureg_new_impl(0,__VA_ARGS__, -1,-1 )
#define ureg_new_raw(...)	  ureg_new_impl(1,__VA_ARGS__, -1,-1 )
#define ureg_search(obj, ...)	  ureg_search_impl(0,obj, __VA_ARGS__, -1 )
#define ureg_search_head(obj,...)	ureg_search_impl(1, obj,__VA_ARGS__, -1 )
#define ureg_easy(reg, ...)		ureg_easy_impl(reg, __VA_ARGS__,-1,-1,-1)
#define ureg_iconv(toenc, fromenc, ...)		ureg_iconv_impl(toenc, fromenc, __VA_ARGS__, -1)

#endif	//ureg_dfb770dd3ce8
/*SH_ED*/

/*SH_SC*/
//	#ifndef _GNU_SOURCE
//		#define _GNU_SOURCE
//	#endif
//	#include <stdio.h>
//	#ifndef _DEFAULT_SOURCE
//		# inclide "this src needs -D_GNU_SOURCE / glibc"
//	#endif

#include "*SH_bn*.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/* tool macros */
#ifndef ERRact
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#if  (200112L <= _POSIX_C_SOURCE +0)  /* nealy 200112L, _POSIX_C_SOURCE	c99*/
#define ERRact(xpr, msg, act)	if(xpr){ fprintf(stderr, \
	        "ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, __func__ \
	        ,getpid(), "hit(" #xpr ")", msg, strerror(errno) );act ;}
#else
#define ERRact(xpr, msg, act)	if(xpr){ fprintf(stderr, \
	        "ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, "func:c99+" \
	        ,0 , "hit(" #xpr ")", msg, strerror(errno) );act ;}
#endif
#define STOP(xpr, msg)	ERRact(xpr, msg, fputs("STOP\n",stderr);exit(1))
#endif
#define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)

#include "msgp.h"

#ifdef TEST
#include "hcut.h"
#include "msgp.h"
#include "laptime.h"
#include "*SH_bn*.h"		//*SH_co* lib*SH_bn*.a	*/
#define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)
#define qu(...)		Qsub(__VA_ARGS__)
#define Qsub(...)	#__VA_ARGS__
#endif

#ifdef TEST
HCUT_ADD(t_ureg_0) {
	int rc;
	ureg_t* obj;
//	const char* rs = "[ac]|\n";
	const char* rg = "(.|([\000]|[\001]|[\002]|[\003]|[\004]|[\005]|[\006]|[\007]|[\010]|[\011]|[\012]|[\013]|[\014]|[\015]|[\016]|[\017]|[\020]|[\021]|[\022]|[\023]|[\024]|[\025]|[\026]|[\027]|[\030]|[\031]|[\032]|[\033]|[\034]|[\035]|[\036]|[\037]|[\040]|[\041]|[\042]|[\043]|[\044]|[\045]|[\046]|[\047]|[\050]|[\051]|[\052]|[\053]|[\054]|[\055]|[\056]|[\057]|[\060]|[\061]|[\062]|[\063]|[\064]|[\065]|[\066]|[\067]|[\070]|[\071]|[\072]|[\073]|[\074]|[\075]|[\076]|[\077]|[\100]|[\101]|[\102]|[\103]|[\104]|[\105]|[\106]|[\107]|[\110]|[\111]|[\112]|[\113]|[\114]|[\115]|[\116]|[\117]|[\120]|[\121]|[\122]|[\123]|[\124]|[\125]|[\126]|[\127]|[\130]|[\131]|[\132]|[\133]|[\134]|[\135]|[\136]|[\137]|[\140]|[\141]|[\142]|[\143]|[\144]|[\145]|[\146]|[\147]|[\150]|[\151]|[\152]|[\153]|[\154]|[\155]|[\156]|[\157]|[\160]|[\161]|[\162]|[\163]|[\164]|[\165]|[\166]|[\167]|[\170]|[\171]|[\172]|[\173]|[\174]|[\175]|[\176]|[\177]|[\200]|[\201]|[\202]|[\203]|[\204]|[\205]|[\206]|[\207]|[\210]|[\211]|[\212]|[\213]|[\214]|[\215]|[\216]|[\217]|[\220]|[\221]|[\222]|[\223]|[\224]|[\225]|[\226]|[\227]|[\230]|[\231]|[\232]|[\233]|[\234]|[\235]|[\236]|[\237]|[\240]|[\241]|[\242]|[\243]|[\244]|[\245]|[\246]|[\247]|[\250]|[\251]|[\252]|[\253]|[\254]|[\255]|[\256]|[\257]|[\260]|[\261]|[\262]|[\263]|[\264]|[\265]|[\266]|[\267]|[\270]|[\271]|[\272]|[\273]|[\274]|[\275]|[\276]|[\277]|[\300]|[\301]|[\302]|[\303]|[\304]|[\305]|[\306]|[\307]|[\310]|[\311]|[\312]|[\313]|[\314]|[\315]|[\316]|[\317]|[\320]|[\321]|[\322]|[\323]|[\324]|[\325]|[\326]|[\327]|[\330]|[\331]|[\332]|[\333]|[\334]|[\335]|[\336]|[\337]|[\340]|[\341]|[\342]|[\343]|[\344]|[\345]|[\346]|[\347]|[\350]|[\351]|[\352]|[\353]|[\354]|[\355]|[\356]|[\357]|[\360]|[\361]|[\362]|[\363]|[\364]|[\365]|[\366]|[\367]|[\370]|[\371]|[\372]|[\373]|[\374]|[\375]|[\376]|[\377]))";
//	const char* rg = ".";
//dbg(strlen(rg) );
	obj = ureg_new_raw(rg, 1029);
	for(int i=0;i<256;i++){
		printf("%d ", obj->fastmap[i]);
//		printf("|[\\%03o]", i);
	}
	puts("");
	rc = ureg_search_head(obj, "");
dbg(rc, obj->p, obj->sz);

	ureg_free(obj);
}
#endif

#ifdef TEST
HCUT_ADD(t_ureg_new) {
	int rc;
	ureg_t* obj;
	//ureg_t* ureg_new_impl(const char* restr, int slen, int syn, int rawflg);
	const char* rs = "[a-bあc]";
	obj = ureg_new(rs, -1);
	eq(obj!=NULL, "ascii");
	ureg_free(obj);
//
	rs = "[z-a]";
	fputs("**bad range expr test**\n",stderr);
	obj = ureg_new(rs);
	fputs("**bad range expr test -end**\n",stderr);
	eq(obj==NULL, "inverse range==err");
	ureg_free(obj);
//
	rs = "[a-zあ\377]";
	obj = ureg_new(rs);
	eq(obj!=NULL, "mix mb/bin");
	ureg_free(obj);
//
	rs = "123(12)(abc)zz";
	obj = ureg_new(rs);
	eq(obj!=NULL, "blk");
	ureg_free(obj);
//
	rs = "^123$";
	obj = ureg_new(rs);
	eq(obj!=NULL, "anc");
	ureg_free(obj);
//
	rs = "a{1}";
	obj = ureg_new(rs);
	eq(obj!=NULL, "rp1");
	ureg_free(obj);
//
	rs = "a{1,}";
	obj = ureg_new(rs);
	eq(obj!=NULL, "rp2");
	ureg_free(obj);
//
	rs = "a{1,3}";
	obj = ureg_new(rs);
	eq(obj!=NULL, "rp3");
	ureg_free(obj);
//
	rs = "あいう";
	obj = ureg_new(rs);
	eq(obj!=NULL, "mb");
	ureg_free(obj);
//
	rs = "[あ-う]";
	obj = ureg_new(rs);
	eq(obj!=NULL, "mblist");
	ureg_free(obj);
//
	rs = "(a|b)c\\1";
	obj = ureg_new(rs);
	eq(obj!=NULL, "bkref");
	ureg_free(obj);

//
	rs = "^((ab|[あ-う])|(12{0,2}))\\1$";
	obj = ureg_new(rs, -1);
	eq(obj!=NULL, "fulltest");
	ureg_free(obj);
}
#endif

#ifdef TEST
HCUT_ADD(t_ureg_search) {
//puts(setlocale(LC_CTYPE, NULL) );
	int rc;
	ureg_t* obj;
	char* rs=NULL;
	char* s=NULL;
	//ureg_t* ureg_new_impl(const char* restr, int slen, int syn, int rawflg);
	rs = "[abc]";
	obj = ureg_new(rs);
	eq(obj!=NULL);
	//puts(setlocale(LC_CTYPE, NULL) );
	rc = ureg_search(obj, "1abc");
	eq_i(obj->p[0], 'a');
	eq_i(obj->sz, 1);
	ureg_free(obj);
//
	rs = "a[あ-う]";
	obj = ureg_new(rs);
	rc = ureg_search(obj, "1abc", -1);
	eq_p(obj->p, NULL, "nohit test");
	eq_i(obj->sz, -1);
	ureg_free(obj);
//
	rs = "[あ-う]";
	obj = ureg_new(rs);
	rc = ureg_search(obj, "1abいc");
//printf("%.*s \n", obj->sz, obj->p);
	eq_s(obj->p, "いc", "mbhit test");
	eq_i(obj->sz, 3);
	//dbg(rc, obj->p, obj->pbk[0], obj->sz, obj->szbk[0], setlocale(LC_CTYPE, NULL) );
	ureg_free(obj);
//
	rs = "[abc]";
	obj = ureg_new(rs);
	rc = ureg_search(obj, "123a", 4);
	eq(obj->p!=NULL, "nohit test");
	eq_i(obj->sz, 1);
	ureg_free(obj);
//
	rs = "Ω";
	s="1ab\377Ωxyz";
	obj = ureg_new(rs);
	rc = ureg_search(obj, s);
	eq(obj->p!=NULL, "nohit test");
	eq_p(obj->p, s+4);
	eq_i(obj->sz, 2);
	ureg_free(obj);
//
	rs = "[\377]";
	s="1ab\377Ωxyz";
	obj = ureg_new_raw(rs);
	rc = ureg_search(obj, s);
	eq(obj->p!=NULL, "nohit test");
	eq_p(obj->p, s+3);
	eq_i(obj->sz, 1);
	ureg_free(obj);
//
	rs = "[\377z]";		//invalid byte is ignored in reg-class(multi byte)
	s="\377z";
	obj = ureg_new(rs);
	rc = ureg_search(obj, s);
	eq_i(rc, 1);
	eq(obj->p!=NULL, "nohit test");
	eq_p(obj->p, s+1);
	eq_i(obj->sz, 1);
	ureg_free(obj);
}
#endif

#define ARRI10	{-1,-1,-1,-1,-1, -1,-1,-1,-1,-1}
ureg_t ureg_easy_impl(const char* r, const char* s, int rlen, int slen, int syn, ...) {
	if(rlen== -1) {rlen=strlen(r);}
	if(slen== -1) {slen=strlen(s);}
	ureg_t* obj = ureg_new(r, rlen, syn);
//dbg(r,rlen, obj, obj->lc, obj->rawflg);
//
	if(obj==NULL) { return (ureg_t) {NULL, NULL, NULL, 0, NULL, -1, {0}, ARRI10}; }
	ureg_search(obj, s, slen);
	ureg_t res = *obj;
//dbg(s,slen, res.p, obj->p, obj->sz);
	ureg_free(obj);
	res.data=NULL;
	return res;
}
#ifdef TEST
HCUT_ADD(t_ureg_easy) {
//	puts(setlocale(LC_ALL, NULL) );
	const char* rs = "2";
	const char* s = "123a\377あbc";
	ureg_t res = ureg_easy(rs, s);
	eq_p(res.p, s+1);
	eq_i(res.sz, 1);
	
	rs="Ω";
	s = "1234abcΩあabc\377";
	res = ureg_easy(rs, s);
dbg(res.p, res.sz);
	eq_p(res.p, s+7);
	eq_i(res.sz, 2);
	
	printf("%d %.*s \n", res.sz, res.sz, res.p);
}
#endif

//strpは完全成功ならstrsz+1, ダメシーケンスならその先頭を指す p-1が有効endになる
void* ureg_iconv_impl(const char* toenc, const char* fromenc, char** str, int strsz, ...) {
	iconv_t fd_cv = iconv_open(toenc, fromenc);
	if(fd_cv==(iconv_t)-1) { return NULL; }
	int mmsz = 128-1;	//end '\0' room
	char* mm = (char*)malloc(mmsz);
	if(mm==NULL) {return NULL;}
	size_t rc= (size_t)-1;
	char* sp = *str;
	char* dp = mm+sizeof(int);
	size_t inleft = strsz;
	size_t outleft = mmsz-(dp-mm);
	while(rc==(size_t)-1) {
		errno=0;
		iconv(fd_cv, NULL,NULL,NULL,NULL);
		rc = iconv(fd_cv, &sp, &inleft, &dp, &outleft);
		if(errno==E2BIG) {
			//realloc再挑戦
			int idx = dp-mm;
			mmsz*=2 -1;
			mm = (char*)realloc(mm,mmsz);
			//sp = sp;	inleft = inleft;
			dp = mm+idx;
			outleft = mmsz-idx;
			continue;
		} else if(errno== EILSEQ||errno== EINVAL||inleft==0) {
			*str = sp;	// end+1 ptrpos
			int sz = mmsz - outleft-sizeof(int);
			mm[sizeof(int)+sz]='\0';	// add \0
			int* ip = (int*)mm;
			ip[0]=sz;
			break;
		} else { STOP(1, "unreachable code. fatal err"); }
	}
	iconv_close(fd_cv);
	return mm;
}

#ifdef TEST
HCUT_ADD(t_ureg_iconv) {
	const char* s = "\343\201\202\343\201\204\343\201\206";
	const char* ss = "\202\240\202\242\202\244";
	char* p = (char*)ss;
	puts(p);
	int* pp = ureg_iconv("UTF-8", "SHIFT_JIS", &p, strlen(p));
	int sz = pp[0];
	char* str = (char*)&pp[1];
	dbg(sz);
	puts(str);
	free(pp);
}
#endif

#ifdef TEST
HCUT_ADD(t_ureg) {
	int rc;
	ureg_t* obj;
	const char* s;
	obj = ureg_new_raw("(\277|\377)");
	rc = ureg_search(obj, "a\377");
	eq(rc>0);
	ureg_free(obj);
//
	obj = ureg_new("[あ]");
	dbg(obj->p);
	rc = ureg_search(obj, s="xあayz\343");
	eq(obj->p -s == 1);
	eq_i(obj->sz, 3);
	// dbg(obj);exit(1);
	// dbg(rc, obj->sidx, obj->eidx);
	ureg_free(obj);
//
	obj = ureg_new("[aあbc]");
	rc = ureg_search_head(obj, s="あxayz\343", -1);
	eq(rc==0);
	eq_p(obj->p, s);
	eq_i(obj->sz, 3);
	rc = ureg_search_head(obj, s="xあayz\343");
	eq(rc<0);
	eq_p(obj->p, NULL);
	eq_i(obj->sz, -1);
	// dbg(rc, obj->sidx, obj->eidx);
	ureg_free(obj);
	obj = ureg_new("[abc]");
	rc = ureg_search(obj, s="xayz\343");
	eq(rc>0);
	eq(obj->p -s == 1);
	eq_i(obj->sz, 1);
	// dbg(rc, obj->sidx, obj->eidx);
	ureg_free(obj);
//
	obj = ureg_new_raw("[あ]");
	rc = ureg_search(obj, s="xaあyz\343", -1);
//dbg(obj->p, obj->sz, rc, obj->lc);
	eq(rc>0);
	eq(obj->p -s == 2);
	eq_i(obj->sz, 1);
	// dbg(rc, obj->sidx, obj->eidx);
	ureg_free(obj);
//
	char* sv = setlocale(LC_ALL, NULL);
	setlocale(LC_ALL, "");
	obj = ureg_new_raw("[あ]");
	rc = ureg_search(obj, s="xあyz\343", -1);
	eq(rc>0);
	eq(obj->p -s == 1);
	eq_i(obj->sz, 3);
	setlocale(LC_ALL, sv);
	// dbg(rc, obj->sidx, obj->eidx);
	ureg_free(obj);
}
#endif

#ifdef TEST
#define Lcnt	10*1000
#define RR	"4.6"
#define SS	"1234567890"
#endif

#ifdef TEST
HCUT_ADD(t_bm0) {
laptime(0);
	loop(Lcnt){ ureg_t res = ureg_easy(RR,SS); }
laptime("easy:" qu(Lcnt));
}
#endif

#ifdef TEST
HCUT_ADD(t_bm1) {
	int rc;
	ureg_t* obj;
laptime(0);
	loop(Lcnt) {
		obj = ureg_new(RR);
		ureg_free(obj);
	}
laptime("new-free: " qu(Lcnt));
//
	obj = ureg_new(RR);
laptime(0);
	loop(Lcnt) {
		rc = ureg_search(obj, SS);
	}
laptime("search: " qu(Lcnt));
	//	dbg(rc, obj->sidx, obj->eidx, obj->len);
	ureg_free(obj);
}
#endif

#ifdef TEST
HCUT_ADD(t_bm2) {
	int rc;
	ureg_t* obj;
	setlocale(LC_CTYPE, "");
laptime(0);
	loop(Lcnt) {
		obj = ureg_new_raw(RR);
		ureg_free(obj);
	}
laptime("new-free@raw: " qu(Lcnt));
//
	obj = ureg_new(RR);
laptime(0);
	loop(Lcnt) {
		rc = ureg_search(obj, SS);
	}
laptime("search@raw: " qu(Lcnt));
	setlocale(LC_CTYPE, "C");
	ureg_free(obj);
}
#endif

#ifdef TEST
HCUT_ADD(t_bm3) {
	int rc;
	char* res=NULL;
laptime(0);
	loop(Lcnt) {
		res = strstr(RR, SS);
	}
laptime("strstr(): " qu(Lcnt));
}
#endif

#ifdef TEST
#include "oniguruma.h"	//*SH_co*	libonig.a	*/
HCUT_ADD(t_bm4) {
	int rc;
	
	const char* reg = RR;
	const char* str = SS;

laptime(0);

	OnigEncoding encs[] = { ONIG_ENCODING_UTF8 };
	onig_initialize(encs, sizeof(encs)/sizeof(encs[0]));
	/* 初期化でエンコードの種類と数をあれこれ。内部でメモリ確保するんだろう。 */
	regex_t* cmp;
	OnigErrorInfo emsg;
	const unsigned char* sadd=(const unsigned char*)reg;
	const unsigned char* eadd=(const unsigned char*) (sadd+strlen(reg));
laptime(0);
	loop(Lcnt) {
		rc = onig_new(&cmp, sadd, eadd, ONIG_OPTION_FIND_LONGEST, ONIG_ENCODING_UTF8
		, ONIG_SYNTAX_POSIX_EXTENDED, &emsg);
		onig_free(cmp);
	}
laptime("new-free@onig: " qu(Lcnt));

	rc = onig_new(&cmp, sadd, eadd, ONIG_OPTION_FIND_LONGEST, ONIG_ENCODING_UTF8
		, ONIG_SYNTAX_POSIX_EXTENDED, &emsg);
	OnigRegion* posobj = onig_region_new();
	sadd=(const unsigned char*)str;
	eadd=(const unsigned char*)(sadd+strlen(str) );
laptime(0);
	loop(Lcnt) {
		rc = onig_search(cmp, (const unsigned char*)str, eadd, sadd, eadd, posobj, ONIG_OPTION_NONE);
//		puts(str+posobj->beg[0]);
	}
laptime("search@onig: " qu(Lcnt));
//	if(rc >= 0) {	/*hit*/
//		obj->s = posobj->beg[0];
//		obj->e = posobj->end[0] -1;
//	}
	onig_region_free(posobj, 1); /* 1:free self, 0:free contents only */
	onig_free(cmp);
	onig_end();
}
#endif

/*SH_SMP
#include <stdio.h>
#include <locale.h>
#include "*SH_bn*.h"
int main(){
	int rc;
	ureg_t* obj;
	char* p;

	obj = ureg_new("[あ]");
	rc = ureg_search(obj, "xあayz\343", 7);
	;	printf("%.*s \n", obj->sz, obj->p);
	ureg_free(obj);

	setlocale(LC_ALL, "");
	obj = ureg_new_raw( "[あ]");
	rc = ureg_search(obj, "xあyz\343", 7);
	;	printf("%.*s \n", obj->sz, obj->p);
	setlocale(LC_ALL, p);
	ureg_free(obj);
	return 0;
}
//	~$ gcc smpl.c *SH_bn*.c libureg.a
//SH_SMPE*/

#ifdef TEST
HCUT_RUN("stderr", 1,	/* keep newline. use for SH sed edit, -t test.*/
//autofill by brp,	t_ureg_iconv, t_ureg, t_bm1, t_bm2, t_bm3
);
#endif

/*
 change log
 --
2021-07-02  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.c(ureg_t): add struct member 'fastmap'
	(ureg_new_impl): fix fastmap init setting, re_comp_fastmap()
	(cmtdoc): fix doc 

2021-06-26  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.c(macro): make it simple
	(ureg_easy): fix no work bug
	(ureg_search_impl): fix lastidx=3; >> lastidx=slen-1; left of dbg.

2021-06-03  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.c(ureg_new_impl): init_localeinfo() changes errno. sv + rollback.

2021-05-30  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.h: add include guard

2021-04-16  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.c (all): change backend. use sed-regex api. v3.0.0

2021-03-16  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.c (all): rename u8rg >> ureg, change ureg_t obj, add svlc, v2.0.0.

	* *SH_bn*.c (new_impl): add inner func

2021-02-17  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.c (u8rg_match): omit -4byte request. dfa cant do partial match.
	* (u8rg_search): same.

2021-02-09  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.c (all): v1.0.0.

*/
/*SH_ED*/

/*SH_EXT*/
#ifndef ERRact
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#if  (200112L <= _POSIX_C_SOURCE +0)  /* nealy 200112L, _POSIX_C_SOURCE	c99*/
#define ERRact(xpr, msg, act)	if(xpr){ fprintf(stderr, \
	        "ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, __func__ \
	        ,getpid(), "hit(" #xpr ")", msg, strerror(errno) );act ;}
#else
#define ERRact(xpr, msg, act)	if(xpr){ fprintf(stderr, \
	        "ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, "func:c99+" \
	        ,0 , "hit(" #xpr ")", msg, strerror(errno) );act ;}
#endif
#define STOP(xpr, msg)	ERRact(xpr, msg, fputs("STOP\n",stderr);exit(1))
#endif
#define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)

typedef struct ureg_tag {
	void* data;
	char* fastmap;
	char* lc;
	int rawflg;
	const char* p;
	int sz;
	const char* pbk[10];
	int szbk[10];
} ureg_t;

static int ureg_dflsyntax = 0
 //	| RE_BACKSLASH_ESCAPE_IN_LISTS //"\" works as esc in [] on:yes off:no //posix:off, special chars is only ^-[] in class
 // | RE_ICASE			// ignore case, aa==Aa	 on:a==A off:a!=A
 | RE_INTERVALS		// use {} op	on:use off:normal chars
 //	| RE_LIMITED_OPS	// +*?| are normal chars	on:yes off:special chars
 | RE_CHAR_CLASSES	// use [:alnum:] etc	on:yes off:no

 | RE_CONTEXT_INDEP_ANCHORS	//$^ are special except []/esc (a^c etc) yes/no
 | RE_CONTEXT_INDEP_OPS	// *+? raise err in bad pos, "+a" etc	on/off
 | RE_CONTEXT_INVALID_DUP	// "{2}a" raise err	on:yes off:[{][2][}]a
 | RE_CONTEXT_INVALID_OPS	// +*? raise err, "?a" etc	on:yes off:[+]a
 | RE_UNMATCHED_RIGHT_PAREN_ORD //")a" doesnt raise err	on:[)]a off:err
 //	| RE_INVALID_INTERVAL_ORD	// "}abc" uses as [}]abc	on:[}] off:err

 | RE_DOT_NEWLINE	// . includes '\n'	on:include off:exclude
 //	| RE_DOT_NOT_NULL	// . excludes '\0'	on:exclude off:include
 //	| RE_HAT_LISTS_NOT_NEWLINE	//[^a] excludes '\n' 	on:exclude off:include

 //	| RE_NEWLINE_ALT	// a(\n)b works as a|b, on:\n==| off:| only
 | RE_NO_BK_BRACES	// interval {}, on:{} off:\{\} //needs RE_INTERVALS:on
 | RE_NO_BK_PARENS	// grouping (),	on:() off:\(\)
 | RE_NO_BK_VBAR		// | or \|,  on:| off:\|	//needs RE_LIMITED_OPS:off
 //	| RE_NO_BK_REFS		// use \1,\2 etc  on:nouse off:use
 //	| RE_BK_PLUS_QM		// repeat "a+" or "a\+" 	on:\+ off:+		ERE:off

 | RE_DEBUG	// regcomp() holds dbginfo	on:yes off:no	//emsg etc
 | RE_NO_EMPTY_RANGES	// [z-a] is err range	on:yes off:no, use as empty
 | RE_NO_GNU_OPS		// use out of standard op, \< etc 	on:nouse off:use
 //	| RE_NO_POSIX_BACKTRACKING	//use shortest match	on:yes off:no,longetst
 //	| RE_NO_SUB		//drop backref data, (ab)c \1=ab etc.	on:yes off:hold
;
// http://web.mit.edu/gnu/doc/html/regex_7.html#SEC46
void ureg_free(ureg_t* obj) {
	if(!obj) {return;}
	struct regex* sedobj = obj->data;
	if(sedobj->dfa) {
		dfafree(sedobj->dfa);
		free(sedobj->dfa);
		sedobj->dfa = NULL;
	}
	regfree(&sedobj->pattern);
	free(sedobj);
	free(obj->lc);
	free(obj);
}

int ureg_dflsyn(void) { return ureg_dflsyntax; }
#include <locale.h>
#include <regex.h>
int ureg_search_impl(int headflg, ureg_t* obj, const char *str, int slen, ...);
ureg_t* ureg_new_impl(int rawflg, const char* r, int rlen, int syn, ...) {
	if(rlen== -1){ rlen=strlen(r); }
	if(syn== -1){ syn=ureg_dflsyntax; }
	; STOP(r==NULL||rlen<0, "ag1/ag2 is NULL/ sz<0");
	char svlc[128]= {0};
	strcpy(svlc, setlocale(LC_CTYPE, NULL));	//now locale
	struct regex* new_regex;
	const char *error;
//
	ureg_t* res = (ureg_t*)calloc(sizeof(ureg_t), 1);
	; ERRact(!res, "calloc() failed", goto lb_ERR);
	if(rawflg==0) { setlocale(LC_CTYPE, ""); }
	res->lc = strdup( setlocale(LC_CTYPE, NULL) );
	// sed malloc() func. abort()/exit(1) if err.
	new_regex = xzalloc(sizeof(struct regex) + rlen - 1);
	new_regex->flags = 0; //sed cmdopt. REG_NEWLINE etc. not gnuregex flg. always 0
	memcpy(new_regex->re, r, rlen);
	new_regex->sz = rlen;
	res->data = new_regex;	//for free() logic
//
	// prune map needs 256 byte
	if(!(syn&RE_ICASE)) { new_regex->pattern.fastmap = malloc(1 << (sizeof(char) * 8)); }
	re_set_syntax(syn);	//>> wapper of 're_syntax_options', gnureg glvar
	error = re_compile_pattern(new_regex->re, new_regex->sz, &new_regex->pattern);
	; ERRact(error, error, fprintf(stderr, "%s\n", r); goto lb_ERR);

//add: fastmap compile, init
	int	rc = re_compile_fastmap (&new_regex->pattern);	//suc/fail == 0/-2
//	new_regex->pattern.fastmap_accurate=1;
	; ERRact(rc, "compile regex-fastmap failed ", goto lb_ERR);
//printf("aft acc:%d fptr:%p \n", new_regex->pattern.fastmap_accurate, new_regex->pattern.fastmap);
//for(int i=0;i<256;i++){	printf("%d:%d ", i, res->fastmap[i]); }

	// omit sed flg, trouble makers. used in dfacomp() dfaparse() etc at dfa.c
	new_regex->pattern.newline_anchor = 0; //sedflg. use \n as ^$ work. DONT set
	new_regex->pattern.translate = NULL;	//works as 'tr' cmd
	int dfaopts = DFA_EOL_NUL; // DFA_EOL_NUL(use \n >> \0), DFA_ANCHOR 
	new_regex->dfa = dfaalloc();
	//locale setting: copied from sed.c main()
	struct localeinfo lc;
	//add_fix>>> sv errno
	int errno_sv=errno;
	init_localeinfo(&lc);	//important. get locale setting.
	errno=errno_sv;
	//corecode for locale. parses bytes to tokens using mbrtowc() etc. see dfa.c
	dfasyntax(new_regex->dfa, &lc, syn, dfaopts);
	dfacomp(new_regex->re, new_regex->sz, new_regex->dfa, 1);	//1, uses for search
	/* The patterns which consist of only ^ or $ often appear in
	   substitution, but regex and dfa are not good at them, as regex does
	   not build fastmap, and as all in buffer must be scanned for $.  So
	   we mark them to handle manually.  */
	if(new_regex->sz == 1) {
		if(new_regex->re[0] == '^')	{ new_regex->begline = true; }
		if(new_regex->re[0] == '$')	{ new_regex->endline = true; }
	}
	res->data = new_regex;
	res->fastmap = new_regex->pattern.fastmap;
	setlocale(LC_CTYPE, svlc);
	return res;
lb_ERR:;
	ureg_free(res);
	setlocale(LC_CTYPE, svlc);
	return NULL;
}

// suc/fail,err = rtn >0 / <0
// rtn hit[idx] ptridx. >=0
#define ARRI10	{-1,-1,-1,-1,-1, -1,-1,-1,-1,-1}
int ureg_search_impl(int headflg, ureg_t* obj, const char *str, int slen, ...) {
	// struct re_registers
	// {
	//   unsigned num_regs;
	//   regoff_t *start;
	//   regoff_t *end;
	// };
	// from gnuregex
//init
	char* s = (char*)str;
	if(slen<0){ slen=strlen(s); }
	int sarr[10]=ARRI10;
	int earr[10]=ARRI10;
	struct re_registers bkres= {10, sarr, earr };	// 10... posix supports \1-\9
	struct regex* sedobj = obj->data;
	// use sed regexp.c, rtn suc/other=1/0. ag4:str offset=0, ag6:regoffsz=10
	
	obj->p=NULL;
	obj->sz = -1;
	for(int i=0;i<10;i++){
		obj->pbk[i] = NULL;
		obj->szbk[i] = -1;
	}
	char svlc[128]={0};
	if(obj->rawflg==0){
		strcpy(svlc, setlocale(LC_CTYPE, NULL));	//now locale
		setlocale(LC_CTYPE, obj->lc);
	}
	int lastidx=slen-1; //"abc" ...[2]==les-1
	//gnuは頭おかしい。rangeじゃない。lastidx of searchhead.
	//lenをそのまま突っこむと範囲外のの\0系からも探索してしまう
	if(headflg){ lastidx=0;}
	// sed-regexp() uses superset but needs src copy/malloc(). omit.
	int rc = re_search(&sedobj->pattern, s, slen, 0, lastidx, &bkres);
	// jeez. ag5 is not RANGE but laststart_IDX. manual uses inappropriate name.
	// in case search only top 3byte "...XYZ" len=6, set range=2. not 3.
	// because innercode uses as 'p <= srcptr+range'	(regexec.c)
	// so s[range] == s[3] == 'X' is searched. s[2] is collect.

	if(rc<0){ goto lb_ERR; }
	for(int i=0;;i++) {
		if(bkres.start[i] <0) {break;}
		obj->pbk[i]  = s + bkres.start[i];	// set -1 if nomatch/err
		obj->szbk[i] = bkres.end[i] - bkres.start[i];
	}
	obj->p  = obj->pbk[0];
	obj->sz = obj->szbk[0];
	if(obj->rawflg==0){ setlocale(LC_CTYPE, svlc);}
	return (int)((char*)obj->p - (char*)str );
lb_ERR:;
	if(obj->rawflg==0){ setlocale(LC_CTYPE, svlc);}
	return -1;
}
/*SH_ED*/

/*SH_OP _ set -e;a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a"	#*/
/*SH_OP	h $p"-t/s/b:test/smpl/bld /T:t+mem /f:functop	GPLv3+"	 #*/
/*SH_OP	f sed -ne "/${C}DF/q;/;/d;/^[a-z].*)/p"<$R0 #*/

/*SH_OP t $e"$CW";ftt "$@";$p'cc -O0 -static -pedantic -g -pg $Rm `fOI $tf` `fg $tf`'|fv	#*/
/*SH_OP T $e"$CW";ftt "$@";$p'cc -O2 $Rm `fOI $tf` `fg $tf`'|fv	#*/
/*SH_OP s $e"$CW";fgr "${C}SMP" "${C}SMPE"<$Rs|fbn>eg.c;$p'cc eg.c `fg eg.c`'|fv #*/
/*SH_OP L $p"valgrind --leak-check=full ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"|fv #*/
/*SH_OP M $p"fM"|fv	 #*/
/*SH_OP P $p'valgrind --tool=callgrind --callgrind-out-file=log.out ./a.out;kcachegrind log.out'|fv	 #*/

/*SH_OP W $e"$Cm$O$Cw";$i0;$i1;fbn<$Rh>$Rm;mv $Rm $Rh;$p"$Rs $tf";$e"$CJ"	#*/
/*SH_OP J fgr "${C}LS" "${C}ED"<$R0>tmp.c;fgr "${C}EXT" "${C}ED"<$R0|fbn>>tmp.c	#*/

/*SH_OP y $e"$CW";fy	#*/
/*SH_OP Y $e"$Cy";fU $( ($p"lib$bn.a";fg $Rs $Rh)|$n|grep '[.]a$'|$U)	#*/

/*SH_DF
#-- noob
fman()(fgr0 "${C}doc" "${C}docE"<$1>$Rm
cat $Rm|sed -e's/^@\([_a-zA-Z][_[:alnum:]]*\)/\n\n# \1\n\n/g
/^\\/{s/^\\/<br>/g}'>$bn.md
cat $bn.md|pandoc -f markdown -thtml> $Rm
cat $Rm|pandoc -s -f html -t man -M title="$bn" -M section="$2" \
-M date=`date '+%Y-%m-%d'` > $bn.$2
sed -e 's/^.nf/.RE\n.nf/'<$bn.$2>$Rm
mv $Rm $bn.$2
fhtml
)
fhtml()( md2h $bn.md $bn )

#-- local

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frf)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()(sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

# fO src.o from inc"src.abc" etc. kick self
fO()(set -- `fdp "$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.o/'|fU`
	buf="";for i;do test -f $i&&buf="$buf $i";done;$p"$buf"
)
fI()(fdp "$@"|sed -e 's/[^/]*$//g'|fu|sed -e '/./s/^/ -I/g'|fU)
fL()(find -L `dirname $R0` -type d|sed -e 's/^/-L/g'|fU)
# inc""系.h,hpp,oをパス付きで羅列 OIはfdpが重複するので高速化でまとめる 複数file_ok
fOI()(
set -- `fdp "$@"`
s="-I./ "`$p"$@"|sed -e 's/[^/]*$//g'|fu|sed -e 's/^/ -I/g'|fU`
set -- `$p"$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.o/'|fU`
buf="";for i;do test -f $i&&buf="$buf $i";done;
$p"$buf $s"
)

# 依存inc""を再帰的に取得./以下全て self系はkick
fdp()( l="$*"; paths="$@"; all=""; used=""
 while :;do
	all=`$p$all $paths|fU`	#差分を追加 repの始末 差分たちからaaa.hを取得 partial path
	buf=`(cat $paths|sed -ne 's@^[ \t]*#inc[^"]*.\([a-zA-Z0-9._]*\)".*@\1@p')|sort -u`
	ch=`$p$used $buf|tr -s ' ' '\n'|sort|uniq -u`	#使用済は外す
	used="$used $ch"	#リスト更新
	paths=`fsvy $ch|sort -u`	#ls検索 name系のみのはず
	buf=`$p"$all" "$paths"|fU`	#増えたらloop
	[ ${#all} = ${#buf} ]&&break
 done
# initを除く
 set -- $all
 for i;do a=${i##*[/]}; a=${a%%.*};[ "${l##*$a*}" = "$l" ]&&set -- "$@" $i;shift;done
 $p"$@"
)

# corecode:search + depthck + uniq
fsvy()(c="find -L ./ -false"
	for i; do c="$c -o -path '*'$i";done; l=`$e"$c"`
	for i; do $p"$l"|grep -F "$i"|awk '{sv=$0;print gsub("[/]","") " " sv}'|
	sort -k 1.1,1n -k 2.2,2|awk '{print $2;exit}'; done
)

# libをまとめる
fA()(n=0;dir=`dirname $0`/tmpdir;mkdir $dir;cd $dir;
 for i;do
 	n=$((n+1))
 	cp ../$i $i
 	ar -x $i
 	for ii in *.o;do mv "$ii" "p${n}_$ii";done
 	ar -r lib$bn.aa *.o
 	rm *.o
 done
 $p'mv lib$bn.aa ../lib$bn.a'|fv
 cd ..;rm -r $dir
)

#-- yacc
# /*SH_OP y $e"$CW";fy
# /*SH_OP Y $e"$Cy";fU $( ($p"lib$bn.a";fg $Rs $Rh)|$n|grep '[.]a$'|$U)
fy()(
cat<<'EEE'|fv
f0 "${C}YACC" "${C}YACCE"<$Rs>myyacc.y
f0 "${C}LEX" "${C}LEXE"<$Rs>mylex.l
lex mylex.l; yacc -p zz -dv myyacc.y
cat y.tab.c lex.yy.c > $Rs
gcc -c y.tab.c lex.yy.c -lfl `fA $Rs $Rh`
rm mylex.l myyacc.y lib$bn.a
ar r lib$bn.a `fo $Rs` y.tab.o lex.yy.o
$p"lib$bn.a"
EEE
)

#-- longcmd
frf()(
 awk -v r="${C##*]}rf" 'match($0,r){
 s=substr($0, RSTART+RLENGTH+1)
 gsub(/.[^*]*$/, "", s);split(s, a)
 m="[ -f %s ]&&echo \"/*--copyfrom %s*\"/&&cat %s&&echo \"/*--copyend %s*\"/"
 for(i=1;v=a[i];i++){ system( sprintf(m, v,v,v,v))}
 next
 }
 {print}'
)

ftt()(a="`sed -ne 's@^HCUT_ADD(\([^)]*\).*@\1, @p' $tf|tr -d '\n'`NULL"
	if [ $# != 0 ];then	a=""; for i;do a="$a $i,";done; a="$a NULL"; fi
	sed -ne "p;/_RUN/bl;d;:l;/[)]/{c\\$O $a)$O p;d};n;bl"<$tf>$Rm;mv $Rm $tf
	cat $Rs $tf>$Rm
)
i0=$e'fgr0 "^#ifdef TEST" "^#endif"<$R0|fbn>$tf'
i1=$e'fgR "^#ifdef TEST" "^#endif"<$Rs|fbn>$Rm;mv $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh'
fM()(
 valgrind -q --tool=massif --massif-out-file=./vmem.buf --stacks=yes --trace-children=yes $1>/dev/null
 ms_print ./vmem.buf|sed -ne '/[KMG]B/bl;d;:l;/snap/q;p;n;bl';rm ./vmem.buf)

/*SH_DE*/
