#!/bin/sh
cat << 'EEE' > /dev/null
/* Copyright (C) 2021 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

set -eu

# path/binary setting
cd `dirname $0`	#base $0 dir
fdir=`pwd`
cd ../..
topdir=`pwd`	#configure root
cp -Rf $fdir ./
cd _tests
wdir=`pwd`
PATH="$wdir:$PATH"
touch log.txt

cp -RLf "$topdir"/src/libureg.a ./
cp -RLf "$topdir"/src/ureg.h ./

cp -RLf "$topdir"/src/tests.code ./tests.c
echo "--- run binary test: `pwd`/$0
..."

set +e
( set -x
# posix: 2.8.1 Consequences of Shell Errors, Other utility >>> shall not exit
# needs check $?. see 'set -e' help and posix man
_eq(){ test "$1" = "$2"&&_AC|| exit 1;:; }
_neq(){ test "$1" != "$2"&&_AC|| exit 1;:; }
_suc(){ test $? = 0 &&_AC|| exit 1;:; }
_fail(){ test $? != 0 || exit 1;:; }
_AC(){ AC=$((AC+1)); }
AC=0

# posix: 2.5.3 Shell Variables
#If the shell is not currently executing a script or function, the value of LINENO is unspecified. 
dmy=${LINENO:='no_POSIX'}

#--- from license: cc-by-sa 3.0 (code is changed from the orig)
# https://stackoverflow.com/questions/17804007	Q: dspjm  ->  A: devnull
PS4='${LINENO}	: '
#--- end license:	cc-by-sa 3.0

### -- test_maincode
cc [!_]*.c [!_]*.a
_suc
./a.out
_suc
## --test_end

echo "fail/all: 0/$AC
--- SUCCESS for all tests. see $0, log.txt if needs" >&3
) 3>&2 >log.txt 2>&1 
test $? = 0 && flg=0 || flg=1

#clean
#cp -rf "$bdir" "$topdir"
#af=`ls *`
#buf=`printf '%s\n' $af $bf|sort|uniq -u`
#rm -rf $buf

test "$flg" = 0 && exit 0
#err
tail log.txt >/dev/stderr
echo "--- test FAILED, see $0, log.txt" >/dev/stderr
exit 1
