#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[/][/*]SH_'		;O=${0##*[/]};R=`dirname $0`/;R0=$R$O;Re=eval\ ;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGext"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d;:l
n;p;b l"<$R0>$Rm;$Rp"$Rm"';Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;b l"<$R0';Cw="(R=LS
$Rw;$Rw>&3;R=HD;$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';RB=$($R"s/${C}OP//p"\
<$R0|(F=mw;while read -r a b;do B=${a%:};F=`$Rp"$F"|$R"s#$B:*##;p"`${a%_};$Rp"
C$B=\$(cat<<'E'$O$b${O}E$O)";done;$Rp"R1=$F"));$Re"$RB";while getopts $R1 R;do
case $R in \?)exit 1;;*)$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac;done
[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit #END  GPLv3+*/

//SH_LS
/* Copyright (C) 2017 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
//SH_ED

//SH_HD
/*SH_doc*
title=*SH_bn* section=3 repnl=\040
@name	*SH_bn*
@_brief	printf() wrapper functions
@_syno
 void pf1-3(const char* fmt, ...);
 void npf1-3(const char* fmt, ...);
 void epf(const char* fmt, ...);
 void nepf(condt char* fmt, ...);
 void dpf(condt char* fmt, ...);
 void dbg(...);
 void idbg(...);
 void sbg(s0, s1, ...[,strsz], [, cmt] );
 
 struct MSGP_cmndata_tag {
	int rc;		// suc/err
	char  tostr[128];	// for tostring, "stderr, stdout ..."
	//..opaque data
 } typedef MSGP_t;
 
 MSGP_t pfset(FILE* p1, FILE* p2, FILE* p3, FILE* dg);
 MSGP_t pfget();
 FILE*  pfgetfp(int idx);	//pf1-3,dbg ==  MSGP_FP_PF1-3, MSGP_FP_DBG
 FILE*  pfsetfp(int idx, FILE* fp);
 MSGP_t pfpush(MSGP_t obj);

@tl_dr
	@(code)@
 #include "msgp.h"
 int main() {
 	pf1("aa");	// automatically add '\n'
 	npf2("bb");		// header 'n' no newline
 	pf3("cc");
 	dbg("dd");	// >> disp: aa, bb, cc, dd
 	
 	pfset(NULL,stderr,NULL,PF_NOCHANGE);	//>> pf1-3,dbg setting
 	npf1("aa");
 	pf2("bb");
 	pf3("cc");
 	dbg("dbg is", 123, "var");	// >>arg support int,dbl,ptr,char,str
 	idbg(1, 10)	//same as dbg() but avoid str, SEGV longjmp()
 	const char* s = "hello, world";
 	sbg(s,s,s)	//near to dbg(), but check for str, avoid SEGV longjmp()
 	
 	MSGP_t old = pfset(stdout, stdout, stdout, stderr);	//>> dfl setting
 	pf1("info: %s", old.tostr);
 	epf("epf/nepf is always disp to stderr.");
 	dpf("dpf() follows dbg() i/o setting, uses for -D_DBG etc");
 	
 	old = pfset(1,NULL,NULL,NULL);	//bad fp, old.rc != 0
 	puts(old.tostr);	// no change if err
 	
 	return 0;
 }
 // ~$ gcc src.c msgp.c
	@()@
@param
	@(list)
	fmt: printf fmt
	p1-dg: NULL(noout)/PF_NOCHANGE/FILE*
	obj: output setting rtns before setting obj. use it to restore. obj.tostr
	holds state msgstr. obj.rc holds api action result, suc/fail== 0/not0.
	pfset() is canceled if obj.rc != 0.
	@()

@return 	pfset()/pfpush() rtns before setting. pfget() rtns current setting.
	dbg() rtns some int val.
	
@details
	dbg() is printf debug helper. not need args type(int, char* etc).
		@(code)--@
	eg)	dbg(12,num,s,"cmt",1.11);
 >>>
	DBG: src.c 7: main(): cnt:1 pid:17477 arg:(12,num,s,"comment",1.11)
	12 = i:12 / d:-1.72631 / p:0xc / c:\014 '\f' / s:(mem_err)
	num = i:678 / d:-1.72631 / p:0x2a6 / c:\246 '?' / s:(mem_err)
	s = i:4636870 / d:-1.72631 / p:0x46c0c6 / c:\306 '?' / s:abc
	"cmt" = i:4636911 / d:-1.72631 / p:0x46c0ef / c:\357 '?' / s:cmt
	1.11 = i:1546188227 / d:1.11 / p:0x5c28f5c3 / c:\303 '?' / s:(mem_err)
		@()--@
	the type of argument is not specified. guess type and convert. --
	i/d/p/c/s == int/dbl/ptr/char/str--
	dbg() are stricted output size. max 1024 byte(1024 char) at once.--
	dbg() supports variable args. allows at least 1-9 args. --
	dbg() uses SIGSEGV/longjmp. it may cause some troubles if your pg uses signals. --
 
@notes -
@conforming_to POSIX.1-2001+ (-D_XOPEN_SOURCE=600/_POSIX_C_SOURCE=200112L)
@copyright Copyright 2017 Momi-g, GPLv3+
@_ver 2022-07-12 v1.3.9 (2017-XX-XX v1.0.0)
@_see -
//SH_docE*/

#ifndef b7b7ab95edd0
#define b7b7ab95edd0

//https://www.jpcert.or.jp/sc-rules/c-pre13-c.html
//-D_POSIX_C_SOURCE=200112L
//-D_XOPEN_SOURCE=600
//199901L > __STDC_VERSION__+0

//2001L: sigaction()
#include <features.h> 	//SH_co* -D_XOPEN_SOURCE=600 -std=c99 */
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include	"needs compiler posix-2001 or upper(c99+)"
#endif

#include <stdint.h>	//uint
#include <stdio.h>	//FILE* type

//---api_start
struct MSGP_cmndata_tag {
	int rc;
	char  tostr[128];	// for tostring, "stderr, stdout ..."
	void* arrfp[6];	// epf + pf1,pf2,pf3,dbg + NULL
	void* brrfp[6];
	FILE* (*getfp)(int idx);
} typedef MSGP_t;

enum {
	MSGP_FP_EPF = 0
	, MSGP_FP_PF1
	, MSGP_FP_PF2
	, MSGP_FP_PF3
	, MSGP_FP_DBG
	, MSGP_FP_SUM
};
#define PF_NOCHANGE	(&MSGP_cmndata)
#define MSGP_ck	MSGP_cmndata.getfp
extern MSGP_t MSGP_cmndata;

/*replace printf()*/
#define epf(...)	(MSGP_ck(MSGP_FP_EPF)?MSGP_cmnpf_b7b7(MSGP_FP_EPF, 1, __VA_ARGS__):0)
#define pf1(...)	(MSGP_ck(MSGP_FP_PF1)?MSGP_cmnpf_b7b7(MSGP_FP_PF1, 1, __VA_ARGS__):0)
#define pf2(...)	(MSGP_ck(MSGP_FP_PF2)?MSGP_cmnpf_b7b7(MSGP_FP_PF2, 1, __VA_ARGS__):0)
#define pf3(...)	(MSGP_ck(MSGP_FP_PF3)?MSGP_cmnpf_b7b7(MSGP_FP_PF3, 1, __VA_ARGS__):0)
#define dpf(...)	(MSGP_ck(MSGP_FP_DBG)?MSGP_cmnpf_b7b7(MSGP_FP_DBG, 1, __VA_ARGS__):0)

#define npf1(...)	(MSGP_ck(MSGP_FP_PF1)?MSGP_cmnpf_b7b7(MSGP_FP_PF1, 0, __VA_ARGS__):0)
#define npf2(...)	(MSGP_ck(MSGP_FP_PF2)?MSGP_cmnpf_b7b7(MSGP_FP_PF2, 0, __VA_ARGS__):0)
#define npf3(...)	(MSGP_ck(MSGP_FP_PF3)?MSGP_cmnpf_b7b7(MSGP_FP_PF3, 0, __VA_ARGS__):0)
#define ndpf(...)	(MSGP_ck(MSGP_FP_DBG)?MSGP_cmnpf_b7b7(MSGP_FP_DBG, 0, __VA_ARGS__):0)

/*setting*/
#define pfset(...)  pfset_b7b7_impl(__VA_ARGS__, #__VA_ARGS__) 
#define pfget(none)	pfget_b7f7(none)
#define pfgetfp(...)	pfgetfp_b7f7(__VA_ARGS__)
#define pfsetfp(...)	pfsetfp_b7f7(__VA_ARGS__, #__VA_ARGS__)
#define pfpush(MSGP_t)	pfpush_b7f7(MSGP_t)

/*dbg*/
#define	dbg(...)	(MSGP_ck(MSGP_FP_DBG)?MSGP_dbg (__VA_ARGS__):0)
#define	idbg(...)	(MSGP_ck(MSGP_FP_DBG)?MSGP_idbg(__VA_ARGS__):0)
#define sbg(...)	(MSGP_ck(MSGP_FP_DBG)?MSGP_sbg (__VA_ARGS__):0)
//---api_end

/* wrap, conv */
int MSGP_cmnpf_b7b7(int tgt, int nflg, const char* fmt, ...);
MSGP_t pfset_b7b7_impl(void* pf1, void* pf2, void* pf3, void* dbg, const char* s);
MSGP_t pfget_b7f7(void);
FILE* pfgetfp_b7f7(int idx);
FILE* pfsetfp_b7f7(int idx, FILE* fp, const char* s);
MSGP_t pfpush_b7f7(MSGP_t predata);

#define MSGP_sbg(...)	( \
	dbg_b7b7_top(MSGP_FP_DBG, __FILE__, __LINE__, __func__, #__VA_ARGS__ "+s")	\
	, dbg_b7b7_end(MSGP_FP_DBG, ""), sck_b7b7_x(__VA_ARGS__,~0)	\
	)

/*
#ifndef MSGP_sck_pf
	#define MSGP_sck_pf	printf
#endif
*/
#define sck_b7b7_x(...)	sck_b7b7_impl(NULL, #__VA_ARGS__, __VA_ARGS__)
int sck_b7b7_impl(int(*cb)(const char*, ...), const char* ags_, ...);

// for dbg()
// from license: cc-by-sa 2.5/3.0 (code is changed from the orig)
// https://stackoverflow.com/questions/2632300	Q: Ed Marty  ->  A: Matthew Slattery
#define ARGCNT(...) ARGCNT_2(__VA_ARGS__,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0)
#define ARGCNT_2(args,n16,n15,n14,n13,n12,n11,n10,n9,n8,n7,n6,n5,n4,n3,n2,num,...)	ARGCNT_3(num)
#define ARGCNT_3(a) ITERMCR_ ## a

// https://stackoverflow.com/questions/44479282 Q: user1150609 -> A: H Walters
#define ITERMCR_1(...) 		dbg_b7b7_middle( 1, #__VA_ARGS__, __VA_ARGS__)
#define ITERMCR_2(a,...)	dbg_b7b7_middle( 2, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_1(__VA_ARGS__)
#define ITERMCR_3(a,...)	dbg_b7b7_middle( 3, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_2(__VA_ARGS__)
#define ITERMCR_4(a,...) 	dbg_b7b7_middle( 4, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_3(__VA_ARGS__)
#define ITERMCR_5(a,...) 	dbg_b7b7_middle( 5, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_4(__VA_ARGS__)
#define ITERMCR_6(a,...) 	dbg_b7b7_middle( 6, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_5(__VA_ARGS__)
#define ITERMCR_7(a,...) 	dbg_b7b7_middle( 7, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_6(__VA_ARGS__)
#define ITERMCR_8(a,...) 	dbg_b7b7_middle( 8, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_7(__VA_ARGS__)
#define ITERMCR_9(a,...) 	dbg_b7b7_middle( 9, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_8(__VA_ARGS__)
#define ITERMCR_10(a,...) 	dbg_b7b7_middle(10, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_9(__VA_ARGS__)
#define ITERMCR_11(a,...) 	dbg_b7b7_middle(11, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_10(__VA_ARGS__)
#define ITERMCR_12(a,...) 	dbg_b7b7_middle(12, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_11(__VA_ARGS__)
#define ITERMCR_13(a,...) 	dbg_b7b7_middle(13, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_12(__VA_ARGS__)
#define ITERMCR_14(a,...) 	dbg_b7b7_middle(14, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_13(__VA_ARGS__)
#define ITERMCR_15(a,...) 	dbg_b7b7_middle(15, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_14(__VA_ARGS__)
#define ITERMCR_16(a,...) 	dbg_b7b7_middle(16, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_15(__VA_ARGS__)
// end license:	cc-by-sa 2.5/3.0

//ref: http://idlysphere.blog66.fc2.com/blog-entry-181.html 可愛い。
//ref: http://www.open-std.org/jtc1/sc22/wg14/www/docs/n1570.pdf >>A1.7 Punctuators（区切り子）
//ref: https://bytes.com/topic/c/answers/218725-does-not-give-valid-preprocessing-token-why
//ref: https://ja.stackoverflow.com/questions/34093
//ref: http://www.c-lang.org/detail/macro_detail.html	#__line__ TYPE

// dbg() dmydata for allign arg sz
typedef union dbg_b7b7_argtag{
	int i;
	char* p;
	double d;
} dbg_b7b7_arg_t;

#define	MSGP_dbg(...)	dbg_sub(__VA_ARGS__+0)
#define	dbg_sub(...)	(	\
	dbg_b7b7_top(MSGP_FP_DBG, __FILE__, __LINE__, __func__, #__VA_ARGS__)	\
	, ARGCNT(__VA_ARGS__)(__VA_ARGS__), dbg_b7b7_end(MSGP_FP_DBG, "\n") )

int dbg_b7b7_top(int plv, const char* fname, int nline, \
            const char* fcname, const char* rawstr);
int dbg_b7b7_middle(int agnum, char* rawlit, ...);
int dbg_b7b7_end(int plv, const char* es);
// dbg() ... err

//add
#define	MSGP_idbg(...)	idbg_sub(__VA_ARGS__+0)
#define	idbg_sub(...)	(idbg_b7b7_top()	\
	,dbg_b7b7_top(MSGP_FP_DBG, __FILE__, __LINE__, __func__, #__VA_ARGS__)	\
	, ARGCNT(__VA_ARGS__)(__VA_ARGS__) ,dbg_b7b7_end(MSGP_FP_DBG, "\n"), idbg_b7b7_end())

int idbg_b7b7_top(void);
int idbg_b7b7_end(void);

//hpp
#ifdef _IMPL_*SH_bn*		/*SH_c o* -D_IMPL_*SH_bn*	*/
	#include "*SH_bn*.c"	/*SH_rf*	*SH_bn*.c	*/
#endif

#endif
//SH_ED

//SH_SC

# include "*SH_bn*.h"
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>		//exit()
#include <errno.h>
#include <unistd.h>	//getpid()	fd, STDERR_FILENO.  FILE* ... stdout stream.
#include <stdint.h>	//intptr_t type
#include <signal.h> //siginfo_t

#define DBG_B7B7_MLEN	100
#define DBG_B7B7_BUFFSIZE	1024
#define PF_MAXINFOLEN (128-1)

static int	GLdbgcounter = 0;
char GLdbgbuffer[DBG_B7B7_BUFFSIZE+1]={0};
static int	GLdbgmode = 0;	//add. idbg

//static char tostr_sub[PF_MAXINFOLEN+1] = "stdout, stdout, stdout, stderr";

static FILE* getfp(int idx);
MSGP_t MSGP_cmndata = {
	.rc = 0
	, .tostr = "pf1-3,dbg: stdout, stdout, stdout, stderr"
	, .arrfp = {NULL,	NULL,	NULL,	NULL,	NULL,  (void*)1}
	, .brrfp = {&stderr, &stdout, &stdout, &stdout, &stderr, NULL}
	, .getfp = getfp
	// epf, pf1,2,3 dbg, NULL
};

#ifdef TEST
	#include <assert.h>
	#include "*SH_bn*.h"
	#include "hcut.h"
	#include "laptime.h"
	#define qu(...)		Qsub(__VA_ARGS__)
	#define Qsub(...)	#__VA_ARGS__

	#ifndef loop
	# define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)
	#endif
#endif

FILE* pfgetfp_b7f7(int idx) {
	FILE* rp = NULL;
	switch(idx){
		case MSGP_FP_PF1: break;
		case MSGP_FP_PF2: break;
		case MSGP_FP_PF3: break;
		case MSGP_FP_DBG: break;
		default: idx=-1;break;
	}
	//bad tgt
	if(idx<0){ return rp; }
	rp = getfp(idx);
	return rp;
}
//--code
static FILE* getfp(int idx){
	void** arr = MSGP_cmndata.arrfp;
	void** brr = MSGP_cmndata.brrfp;
	if(	arr[MSGP_FP_SUM]){
		for(int i=0; i<MSGP_FP_SUM; i++){ arr[i] = *(void**)brr[i];	}
		arr[MSGP_FP_SUM]=NULL;
	}
	return arr[idx];
}

FILE* pfsetfp_b7f7(int idx, FILE* fp, const char* s) {
	FILE* rp = NULL;
	switch(idx){
		case MSGP_FP_PF1: break;
		case MSGP_FP_PF2: break;
		case MSGP_FP_PF3: break;
		case MSGP_FP_DBG: break;
		default: idx=-1;break;
	}
	//bad tgt
	if(idx<0){ return rp; }
	
	void* arr[] = {NULL, PF_NOCHANGE, PF_NOCHANGE, PF_NOCHANGE, PF_NOCHANGE, NULL};
	arr[idx] = fp;
	MSGP_t yo = pfset_b7b7_impl(arr[1], arr[2], arr[3], arr[4], s);
	if(yo.rc){return rp;}
	rp = yo.arrfp[idx];
	return rp;
}
#ifdef TEST
HCUT_ADD(t_fp) {
	FILE* fp = NULL;
	MSGP_t bk = pfget();
	//get
	fp = pfgetfp(MSGP_FP_PF1);
	eq_p(fp, stdout);
	fp = pfgetfp(MSGP_FP_DBG);
	eq_p(fp, stderr);
	//geterr
	fp = pfgetfp(-1);
	eq_p(fp, NULL);

	//set
	fp = pfsetfp(MSGP_FP_PF2, stderr);
	eq_p(fp, stdout);	//pre
	fp = pfsetfp(MSGP_FP_PF2, stdout);
	eq_p(fp, stderr);	//pre
	//seterr
	fp = pfsetfp(-1, stdout);
	eq_p(fp, NULL);	//pre
	bk = pfpush(bk);
	puts(bk.tostr);
}
#endif


//pf_cmn()
int MSGP_cmnpf_b7b7(int plv, int nlflg, const char* fmt, ...) {
	int rc=0;
	FILE* fp = getfp(plv);
	if(fp == NULL) { return rc; }

	va_list vl;
	va_start(vl, fmt);
	rc = vfprintf(fp, fmt, vl);
	if(nlflg==1) {
		fprintf(fp, "\n");
		rc++;
	}
	fflush(fp);
	va_end(vl);
	return rc;
}

 	
// i/o funcs: ret pre_settings.   pf1-3,dbg
MSGP_t pfset_b7b7_impl(void* p1, void* p2, void* p3, void* dg, const char* s) {
	getfp(0);	//initck
	MSGP_t rbuf = MSGP_cmndata;
	void** arr = MSGP_cmndata.arrfp;
	void** brr = MSGP_cmndata.brrfp;
	int iarr[] = { MSGP_FP_PF1, MSGP_FP_PF2, MSGP_FP_PF3, MSGP_FP_DBG };
	void** parr[] = { &p1, &p2, &p3, &dg, NULL };
	
	//kick badfp
	void* fp = NULL;
	rbuf.rc = 0;
	for(int i=0; parr[i];i++){
		fp = *parr[i];
		if(fp==NULL||fp==PF_NOCHANGE){continue;}
		int rc = fprintf(fp, "%s", "");
		if(rc<0){ rbuf.rc = errno; return rbuf; }
	}
	
	for(int i=0;parr[i];i++){
		int n = iarr[i];
		brr[n]=arr[n];
		fp = *parr[i];
		fp==PF_NOCHANGE ? fp=brr[n] :0;
		arr[n] = fp;
	}
	snprintf(MSGP_cmndata.tostr, PF_MAXINFOLEN, "pf1-3,dbg: %s", s);
	return rbuf;
}
#ifdef TEST
HCUT_ADD(t_badfp) {
	MSGP_t bk = pfset(NULL,NULL,NULL,NULL);
	eq_i(bk.rc, 0);
puts(bk.tostr);
	bk = pfpush(bk);
	eq_i(bk.rc, 0);
puts(bk.tostr);
	bk = pfset(stdin,NULL,NULL,NULL);
	eq_i(bk.rc!=0);
epf("%d\n", bk.rc);
puts(strerror(bk.rc) );
puts(bk.tostr);
	bk = pfget();
	eq_i(bk.rc, 0);
puts(bk.tostr);
}
#endif

MSGP_t pfget_b7f7() {
	getfp(0);	//initck
	MSGP_cmndata.rc = 0;
	return MSGP_cmndata;
}

MSGP_t pfpush_b7f7(MSGP_t obj) {
	getfp(0);
	MSGP_t rbuf = MSGP_cmndata;
	MSGP_cmndata = obj;
	MSGP_cmndata.rc = 0;
	return rbuf;
}

static int sck_pfcb(const char* fmt, ...){
	FILE* fp = getfp(MSGP_FP_DBG);
	if(fp==NULL){return 0;}
	int rc=0;
	va_list ap;
	va_start(ap, fmt);
	rc = vfprintf(fp, fmt, ap);
	return rc;
}

//dbg funcs,	add numonly
int sck_b7b7_impl(int(*cb)(const char*, ...), const char* ags_, ...) {
	cb=sck_pfcb;
	char* ags = (char*)ags_;
	int msz=0;
	const char* msg = NULL;
	char* sarr[128]= {0};
	//
	va_list ap;
	va_start(ap, ags_);
	int flg=1;	//head+" ~0 etc
	int idx=0;
	for(char* p = ags;; p++) {
		//printf("%d, %d, %c\n", flg, msz, *p);
		if(flg==1){
			char* pp=NULL;
			if( strtol(p, &pp, 10) ) { flg=0; p=pp-1; continue; }
			else { flg = -1; }
		}
		if(*p==',') {
			if(flg== -1) { sarr[idx] = va_arg(ap, char*); }
			//printf("%d, %s\n", idx, sarr[idx]);
			if(flg== 0) { msz = va_arg(ap, int); }
			idx++;
			flg=1;
			continue;
		}
		if(flg!= -1){ continue; }
		if(*p=='"') { msg = va_arg(ap, char*); break; }
		if(*p=='~') { break; }
	}
	va_end(ap);
	int rc=0;
	//print
	if(msg&& *msg!=':') { rc+=cb("--cmt: %s\n", msg); }
	for(int i=0; sarr[i]; i++) {
		char* p = sarr[i];
		int sz = strlen(p);
		if(msz>0 && sz>msz) {
			rc+=cb("sz=%d: ^%.*s..\n", sz, msz, p);
		} else if(msz<-1&& sz> -msz*2) {
			rc+=cb("sz=%d: ^%.*s..%.*s$\n", sz, -msz, p, -msz, p+sz+msz);
		} else {
			rc+=cb("sz=%d: ^%s$\n", sz, p);
		}
	}
	//end
	rc+=cb("\n");
	return rc;
}

int idbg_b7b7_top(void){ GLdbgmode= -1; return 0;}
int idbg_b7b7_end(void){ GLdbgmode= 0 ; return 0;}

#include <setjmp.h>
static sigjmp_buf marktry;	// try-catch sigsegv. sigjmp ... posix2001 upper
static void dbg_siggrep(int flg, int signum);

int dbg_b7b7_top(int plv, const char* fname, int nline
 , const char* fcname, const char* rawstr) {
	FILE* fp = getfp(MSGP_FP_DBG);
	GLdbgcounter++;		//global counter for debag info
	if(fp == NULL|| GLdbgbuffer[0]!='\0') { return 0; }
	int orest=  DBG_B7B7_BUFFSIZE - 1;
	GLdbgbuffer[0]='\0';
	const char* pfix = "DBG";
	if( *(rawstr+strlen(rawstr)-1) == 's'){ pfix = "SBG"; }
	snprintf( GLdbgbuffer, orest,
         "%s: %s %d: %s(): cnt:%d pid:%d arg:(%.*s)\n", pfix,
         fname, nline, fcname, GLdbgcounter, getpid(), (int)(strlen(rawstr)-2), rawstr);
	return 0;
}

int dbg_b7b7_middle(int agnum, char* rawlit, ...) {
	if( GLdbgbuffer[0]=='\0') { return 0; }
	if(agnum==1 && strlen(rawlit)==2){return 0;} //dbg()系。要素があれば+0で3以上になる。
	int cutsz=0;
	if(agnum==1){cutsz=2;}	//尻尾に+0がついてるのでキリトリセン
	
	char sbuf[DBG_B7B7_MLEN+1]={0};
	int orest = DBG_B7B7_MLEN;
	snprintf( sbuf, orest, "\t%.*s = ", (int)(strlen(rawlit)-cutsz), rawlit);
	orest=DBG_B7B7_MLEN - strlen(sbuf);

	va_list vl, vls;
	va_start(vl, rawlit);
	va_copy(vls, vl);

	int ri;
	double rd;
	char* rp;
	//int系. double系が先だとそっちに行くから。アクセス違反はsegvで逃げる。
	ri = va_arg(vl, int);	//local変数 int未満は全部intに格上げされる。
	snprintf( &(sbuf[strlen(sbuf)]), orest, "i:%d / ", ri);
	orest=DBG_B7B7_MLEN - strlen(sbuf);

	//double系.
	va_copy(vl, vls);
	rd = va_arg(vl, double);
	snprintf( &(sbuf[strlen(sbuf)]), orest, "d:%f / ", rd);
	orest=DBG_B7B7_MLEN - strlen(sbuf);
	
	//ptr
	va_copy(vl, vls);
	rp = va_arg(vl, char*);	// vl_add -> argpos_add -> argraw(int/char*)
	snprintf( &(sbuf[strlen(sbuf)]), orest, "p:%p / ", rp);
	orest=DBG_B7B7_MLEN - 1 - strlen(sbuf);
	
	//char
	// %hh + c ... int args. not char args. (promote args problem. see man printf)
	// edit escape chars \n>>\\n etc
//	va_start(vl, rawlit);
//	ri = va_arg(vl, int);	
	char cbuf[2]= {(char)ri, 0};
	char* msg;
	if(cbuf[0] == '\0') { msg = (char*)"\\0";}
	else if(cbuf[0] == '\a') { msg = (char*)"\\a";}
	else if(cbuf[0] == '\b') { msg = (char*)"\\b";}
	else if(cbuf[0] == '\t') { msg = (char*)"\\t"; }
	else if(cbuf[0] == '\n') { msg = (char*)"\\n";}
	else if(cbuf[0] == '\v') { msg = (char*)"\\v";}
	else if(cbuf[0] == '\f') { msg = (char*)"\\f";}
	else if(cbuf[0] == '\r') { msg = (char*)"\\r";}
	else if(1){ msg = cbuf; }
	
	// hh ... size select char
	snprintf( &(sbuf[strlen(sbuf)]), orest, "c:\134%03hho '%s' / s:", ri, msg );
	orest=DBG_B7B7_MLEN - strlen(sbuf);

	//string
	if(GLdbgmode != -1 ){
		//add str skip mode(idbg). avoid SEGV trap err
		// http://www.nurs.or.jp/~sug/soft/super/longjmp.htm
		// try - catch signal stop
		if(sigsetjmp(marktry, SIGSEGV) == 0) {
			dbg_siggrep(1, SIGSEGV);	//set trap
			strncpy( &(sbuf[strlen(sbuf)] ), rp, orest);
		} else {
			strncpy( &(sbuf[strlen(sbuf)]), "(mem_err)", orest );
		}
		dbg_siggrep(0, SIGSEGV);	//reset trap
	}else{
		strncpy( &(sbuf[strlen(sbuf)]), "(skip)", orest );
	}

	va_end(vl);
	va_end(vls);

	//add + \n
	if(strlen(sbuf) >= DBG_B7B7_MLEN-1 ){ sbuf[DBG_B7B7_MLEN-1]='*'; }
	int len = strlen(GLdbgbuffer);
	strncpy( &(GLdbgbuffer[len]), sbuf, DBG_B7B7_BUFFSIZE-len-1);
	len = strlen(GLdbgbuffer);
	if( len+1 == DBG_B7B7_BUFFSIZE ){GLdbgbuffer[len-1]='\n';}
	else{GLdbgbuffer[len]='\n';}
	return 0;
}

int dbg_b7b7_end(int plv, const char* es) {
	getfp(0);
	FILE* fp = getfp(MSGP_FP_DBG);
	if(fp==NULL) {goto lbl_RTN;}
	if(es==NULL){es = "";}
	fprintf(fp, "%s%s", GLdbgbuffer, es);
	fflush(fp);		//	buff is an evil
lbl_RTN:;	
	GLdbgbuffer[0]='\0';
	return 0;
}

static void dbg_sigfunc(int signum, siginfo_t* info, void* ctx) {
	//sighandle, sigcatch?, siginterrrupt?,sig"exception code(java)"?
	//in code, very,very, verrrry stricted.
	//1. use only "signal safe function"
	//2. use global(outer function) var, "volatile sig_atomic_t"
	//3. you can use auto var (stack, local memory?)
	//http://d.hatena.ne.jp/yupo5656/20040712/p2
	siglongjmp(marktry, 1);
	//	char msg[] = "sig_catch. err?\n";
	//	write(STDERR_FILENO, msg, strlen(msg) );	// #include <unistd.h>
}

// (1/0, SIGSEGV) on, off. if get sig, rtn 1(dbg_sigfunc), else rtn 0.
static void dbg_siggrep(int flg, int signum) {
	static struct sigaction sct_ss;	//snapshot for save state.
	struct sigaction sct = {0};
	sigemptyset(&(sct.sa_mask));	//clear. 0xFFFF -> block recall SIG when this method running.
	sigaddset(&sct.sa_mask, signum);	// target signal
	if(flg==0) {		// reset trap
		sigaction(signum, &sct_ss, NULL);
		//sct.sa_handler = SIG_DFL;	//SIG_DFL or SIG_IGN
	} else {	//set trap
		//signal select action 1.def 2.ign 3.func
		//3.func ...SA_SIGINFO+sa_sigaction or sct.sa_handler = *func.
		//sct.sa_handler = SIG_IGN;	//set proc sig work enable(def) or disable(catch) .
		sct.sa_flags = SA_SIGINFO;	//send sig state to myfunc();
		sct.sa_flags |= SA_RESETHAND;	//add one shot setting.
		//		zzz.sa_flags = zzz.sa_flags | SA_RESTART;	//default sigtrap drop blocking method.
		//sct.sa_flags |= SA_NOCLDWAIT;	//if SIG_DEF.  SIG_IGN ignore sa_flags.
		sct.sa_sigaction = dbg_sigfunc;	// restricted type, (int, siginfo_t *, void *)
		sigaction(signum, &sct, &sct_ss);		//run(set) trap  NULL...oldsetting buf.
	}
}

#ifdef TEST
HCUT_ADD(t_dbg) {
	int rc=0;
	rc = dbg();
	eq_i(rc==0 || rc!=0);
	dbg(1,10);
	int a=100;
	char* s0 = "unkokko";
	dbg(3,10.2, 10.3, s0, 'z', a);
	dbg();
//*
	const char* s = "hello, world";
	const char* ss= "good bye, cosmos";
	; puts("ag1");
	sbg(s);
	sbg(s, "f");
	sbg(s,-1);
	sbg(s,-1, "f");
	sbg(s, 3);
	sbg(s, 3, "h");
	sbg(s,-2);
	sbg(s,-2, "ht");
	; puts("ag2");
	sbg(s, ss);
	sbg(s, ss, "f");
	sbg(s, ss, -1);
	sbg(s, ss, -1, "f");
	sbg(s, ss, 3);
	sbg(s, ss, 3, "h");
	sbg(s, ss, -2);
	sbg(s, ss, -2, "ht");
	; puts("ag3");
	sbg(s, ss, ss);
	sbg(s, ss, ss, "f");
	sbg(s, ss, ss, -1);
	sbg(s, ss, ss, -1, "f");
	sbg(s, ss, ss,  3);
	sbg(s, ss, ss,  3, "h");
	sbg(s, ss, ss, -2);
	sbg(s, ss, ss, -2, "ht");
//*/
}
#endif

/*SH_SMP*
# include "msgp.h"

int main() {
	int a = 123 ;
	int b = 223;
	double c = 12.3;
	char* d = NULL;
	dbg(a,c,b,d);
//	return 0;
	
	epf("epf");
	pf1("pf1");
	npf1("npf1\n");
	pf2("pf2");
	pf3("pf3");
	dbg("dbg", printf("abc%d\n",1) );
	puts("--");
//
	FILE* fp = stdout;
	MSGP_t bk = pfset(NULL,PF_NOCHANGE,fp,NULL);	// pf1,pf2,pf3,dbg. NULL=noout
	puts(bk.tostr);	// >>prestate: stdout,sout,sout,serr
	puts( pfget().tostr);	//nowstate: NULL,PF_NOCHANGE,fp,NULL
	epf("epf");
	pf1("pf1");
	pf2("pf2");
	pf3("pf3");
	dbg("dbg");
	puts("--");
//
	bk = pfset(stdout,NULL,NULL, stdout);
	puts(bk.tostr);	// >> NULL,stdout,fp,NULL
	puts( pfget().tostr);	// >> stdout,NULL,NULL, stdout
	epf("epf");
	pf1("pf1");
	pf2("pf2");
	pf3("pf3");
	dbg("dbg");
	puts("--");
	//
	bk = pfpush(bk);
	puts(bk.tostr);	// >> stdout,NULL,NULL, stdout	... save&load.
	puts( pfget().tostr);	// >> NULL,stdout,fp,NULL
	epf("epf");
	pf1("pf1");
	pf2("pf2");
	pf3("pf3");
	dbg("dbg");
	puts("--");
}
//~$ gcc src.c msgp.c -Wall -pedantic -D_XOPEN_SOURCE=600 -std=c99
//SH_SMPE*/

#ifdef TEST
#ifndef VLV
	#define VLV	1
#endif /**/
HCUT_RUN("stderr", VLV /* lv 0,1,2,3 */,	/* keep nl for SH sed edit */
         t_dbg);
#endif


/*
 change log
 --
2022-07-12  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.h(pfset): add obj.rc rtncode api

2022-07-07  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.h(sbg, sck): add new api, disp s1/s1,s2 info
	* (dbg_end): add end '\n' on/off arg
	* (dbg): add parlen blk ( dbg(), dbg_mdl(), dbg_end() )
	* (all): rewrite all code, macro

2022-07-05  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.h(all): change fn() ret void >> int, stmt to expr, ternary op
	
2022-06-28  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.h(dbg): fix api __VA_ARGS__ for c99 warning
	
	* *SH_bn*.h(doc): update doc, brp others

2021-11-16  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.h(dbg_b7b7_top, middle): fix for 64bit print(%.*s) >> (int)cast

2021-07-10  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.h(dbg_middle): add (dbg_b7b7_arg_t){0}, fix b/o read.
 
2021-05-21  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.h(PF_NOCHANGE): funcptr>>glvar ptr. func <> void* is gray code.

	* *SH_bn*.h(-pedantic): debug code for -Wpedantic.

2021-05-06  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.h(doc): fix cmtdoc, allow dbg(void)

2021-02-22  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.h(idbg): unofficial api, add+improve. dispname cutoff bug

2021-01-18  Momi-g	<dmy@dmy.dmy>

	* msgp.sh.c ( dbg() macro ): improve __VA_ARGS__+0, allow dbg(void) api
	* (dbg_b7b7_top): fix msg to skip "+0"
	* (dbg_b7b7_middle): fix msg, add dbg(void) ck code 
	* (t_dbg test): add test 
	
2021-01-09  Momi-g	<dmy@dmy.dmy>

	* msgp.sh.c (pfset): fix pfset strcpy src/dst overlap bug
	
	* msgp.sh.c (hcut.hpp): adapt new unittest macro
	
	* msgp.sh.c (sh code): adapt new build script

2020-05-15  Momi-g	<dmy@dmy.dmy>

	* msgp.sh.c (dbg): rewrite code, fix va_arg double bug

*/

/*SH_ED*/

/*SH_OP _ set -e;a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e	#*/
/*SH_OP	h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout		GPLv3+"	 #*/
/*SH_OP	f sed -ne "/${C}DF/q;/;/d;/^[a-zA-Z].*)/p"<$R0 #*/
/*SH_OP t $e"$CW";ftt "$@";$p'cc -O0 $dm -Wall -pedantic -Wfatal-errors -g -pg -ggdb3 $Rm `fOI $Rs $tf` `fg $Rh $Rs $tf` `fL`'|fv	#*/
/*SH_OP T $e"$CW";ftt "$@";$p'cc -O3 $dm $Rm `fOI $Rs $tf ` `fg $Rs $tf ` `fL`'|fv	#*/
/*SH_OP s $e"$CW";fgr0 "${C}SMP" "${C}SMPE"<$R0|fbn>eg.c;$p'cc eg.c $bn.c `fg eg.c` `fOI eg.c`'|fv #*/

/*SH_OP L $p"fml $@"|fv #*/
/*SH_OP M $p"fM ./a.out"|fv	 #*/
/*SH_OP P $p'valgrind --tool=callgrind --callgrind-out-file=log.out ./a.out;kcachegrind log.out'|fv	 #*/

/*SH_OP b $e"$CW";$p'cc -c $Rs -pedantic -O2 -Wall -g `fg $Rs` `fI $Rs`'|fv;$p"$bn.o" #*/
/*SH_OP B $e"$Cb";$p"ar -r lib$bn.a $bn.o `fO $Rs`"|fv;$p"lib$bn.a"	#*/
/*SH_OP A $e"$CB";$p'fA lib$bn.a `fg $Rh $Rs|fu|grep '[.]a$'|fU`'|fv;$p"lib$bn.a" #*/
/*SH_OP S $e"$CW";$p"cc -shared -fPIC -o lib$bn.so $bn.c `fOI $Rs` `fg $Rs`"|fv;$p"lib$bn.so" #*/
/*SH_OP W $e"$Cm$O$Cw">/dev/null;fborn;$p"$Rs $Rh $tf"	#*/
/*SH_OP o $e"$CW";$p'fman $Rh 3'|fv		#*/

/*SH_OP y cp $Rs $bn.cbrt;$p"cbrt $bn.cbrt --c $Rs --h cbft.h"|fv	#*/
/*SH_OP Y $e"$Cm$O$Cw">/dev/null;$e"$Cy";fborn;$p"$Rs $Rh $tf"		#*/

/*SH_DF
#-- noob
fman()( $p"cat $1|sed -e '/${C}docE/q'|fgr0 '${C}doc' '${C}docE'|amn >$bn.$2
 mandoc -Thtml <$bn.$2 >$bn.$2.html
 man -Tutf8 /dev/stdin<$bn.$2|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt
 "|fv
)

#-- local

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frf|frv|flit)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()($e\$p`sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"`|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

# fO src.o from inc"src.abc" etc. kick self
fO()(set -- `fdp "$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
 buf="";for i;do test -f $i&&buf="$buf $i";done;$p"$buf"
)
fI()(fdp "$@"|sed -e 's/[^/]*$//g'|fu|sed -e '/./s/^/ -I/g'|fu|grep -v '^\-I$'|fU)
fL()(find -L `dirname $R0` -type d|sed -e 's/^/-L/g'|fU)
 # inc""系.h,hpp,oをパス付きで羅列 OIはfdpが重複するので高速化でまとめる 複数file_ok
fOI()(
 set -- `fdp "$@"`
 s="-I./ "`$p"$@"|sed -e 's/[^/]*$//g'|fu|sed -e 's/^/ -I/g'|fu|grep -v '^\-I$'|fU`
 set -- `$p"$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
 buf="";for i;do test -f $i&&buf="$buf $i";done;
 $p"$buf $s"
)

# 依存inc""を再帰的に取得./以下全て self系はkick
fdp()( l="$*"; paths="$@"; all=""; used=""
 while :;do
  all=`$p$all $paths|fU`	#差分を追加 repの始末 差分たちからaaa.hを取得 partial path
  buf=`(cat $paths|sed -ne 's@^[ \t]*#inc[^"]*.\([a-zA-Z0-9._]*\)".*@\1@p')|sort -u`
  ch=`$p$used $buf|tr -s ' ' '\n'|sort|uniq -u`	#使用済は外す
  used="$used $ch"	#リスト更新
  paths=`fsvy $ch|sort -u`	#ls検索 name系のみのはず
  buf=`$p"$all" "$paths"|fU`	#増えたらloop
  [ ${#all} = ${#buf} ]&&break
 done
# initを除く
 set -- $all
 for i;do a=${i##*[/]}; a=${a%%.*};[ "${l##*$a*}" = "$l" ]&&set -- "$@" $i;shift;done
 $p"$@"
)

# corecode:search + depthck + uniq
fsvy()(c="find -L ./ -false"
 for i; do c="$c -o -path '*'$i";done; l=`$e"$c"`
 for i; do $p"$l"|grep -F "$i"|awk '{sv=$0;print gsub("[/]","") " " sv}'|
 sort -k 1.1,1n -k 2.2,2|awk '{print $2;exit}'; done
)

# libをまとめる
fA()(n=0;dir=`dirname $0`/tmpdir;mkdir $dir;cd $dir;
 for i;do
 	n=$((n+1))
 	cp ../$i $i
 	ar -x $i
 	for ii in *.o;do mv "$ii" "p${n}_$ii";done
 	ar -r lib$bn.aa *.o
 	rm *.o
 done
 $p'mv lib$bn.aa ../lib$bn.a'|fv
 cd ..;rm -r $dir
)

#-- yacc
fy(){
 set -e
 cat<<'EEE'|fv
 fgr0 "${C}YACC" "${C}YACCE"<$Rs|fbn>myyacc.y
 fgr0 "${C}LEX" "${C}LEXE"<$Rs|fbn>mylex.l
 fgR "${C}YACC" "${C}YACCE"<$Rs>$Rm
 fgR "${C}LEX" "${C}LEXE"<$Rm>$Rs

 lex mylex.l
 #bison -Wnone -Wall -Wno-empty-rule -p zz -dv myyacc.y
 # bisonはy.tab.c固定名ではなくsrc.tab.c/hを吐く 標準に戻す
 bison -Wnone -Wall -Wno-empty-rule -dv myyacc.y --defines=y.tab.h -o y.tab.c

 cat $Rh y.tab.c lex.yy.c > $Rs
 $p"$Rs"
EEE
}

#-- longcmd
frf()(
 # *sh_rf* 0 a.txt b.txt ...でcat纏めて出力 top0でsrcinfoは無し出力
 awk -v tg="${C##*]}rf" 'index($0,tg){
 s=substr($0, index($0,tg)+length(tg)+1);split(s, a)
 m="[ -f \"%s\" ]&&(echo \"/*--copyfrom %s*\"/;cat \"%s\";echo \"/*--copyend %s*\"/)"
 mm="[ -f \"%s\" ]&&(_=\"%s\"/;cat \"%s\";_=\"%s\")"
 for(i=1;i in a;i++){v=a[i];if(v==0){m=mm;continue};system(sprintf(m,v,v,v,v)) }
 next
 }
 {print}'
)
frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")
flit()(sed -ne "/${C##*]}lit/b l;p;d;:l;n;/${C##*]}litE/d;"'s/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g;p;b l')

fml()(
 # --show-leak-kinds=definite,indirect(inner ref),possible,reachable(doesnt p=NULL)
 #cmd="valgrind --leak-check=full --show-leak-kinds=all --track-origins=yes --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"
 cmd="valgrind --leak-check=full --show-leak-kinds=definite,possible --track-origins=no --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"
 test $# = 0 && $p"$cmd"|fv && return
 set -- " " "$@"
 $e"$Ct"
 test $? = 0 && $p"$cmd"|fv
)

ftm(){
 awk -v w="$1" '
 /^HCUT_ADD/ && index($0,"("w")")==0 {
	while(match($0,"^#endif$") ==0 ){getline}
	print $0; next
 }
 {print $0}'
}

fte()(
 cat > $Rm-
 cmd="cat"
 [ $# != 0 ] && cmd='ftm $b'
 a="`sed -ne 's@^HCUT_ADD(\([^)]*\).*@\1, @p' $Rm-|tr -d '\n'`NULL"
 if [ $# != 0 ];then	a=""; for i;do a="$a $i,";done; a="$a NULL"; fi
 b=`$p"$a"|tr ',' ' '`
 sed -ne "p;/_RUN/b l;d;:l;/[)]/{c \\$O $a)$O p;d};n;b l" $Rm-|$e"$cmd"|
 fgr0 "^#ifdef TEST" '^#endif$'
 rm $Rm-
)

ftt(){
 [ $# != 0 ] && [ "${1#[0123]}" = "" ]&&dm="-DVLV=$1"&&shift
 (cat $Rs;fte "$@"<$tf)>$Rm
}
fborn(){
 fgr "^#ifdef TEST" "^#endif$"<$R0|fbn>$tf
 fgR "^#ifdef TEST_" "^#endif$"<$tf |fte>tests.code
 fgR "^#ifdef TEST" "^#endif$"<$Rs|fbn>$Rm;mv $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh
}
fM()(
 valgrind -q --tool=massif --massif-out-file=./vmem.buf --stacks=yes --trace-children=yes $1>/dev/null
 ms_print ./vmem.buf|sed -ne '/[KMG]B/bl;d;:l;/snap/q;p;n;bl';rm ./vmem.buf
)

/*SH_DE*/
