/* Copyright (C) 2019 Momi-g
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/* add license cmt from cutest-1.5 README.txt */
/*
 NOTE

 The license is based on the zlib/libpng license. For more details see
 http://www.opensource.org/licenses/zlib-license.html. The intent of the
 license is to:

 - keep the license as simple as possible
 - encourage the use of CuTest in both free and commercial applications
   and libraries
 - keep the source code together
 - give credit to the CuTest contributors for their work

 If you ship CuTest in source form with your source distribution, the
 following license document must be included with it in unaltered form.
 If you find CuTest useful we would like to hear about it.

 LICENSE

 Copyright (c) 2003 Asim Jalis

 This software is provided 'as-is', without any express or implied
 warranty. In no event will the authors be held liable for any damages
 arising from the use of this software.

 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it
 freely, subject to the following restrictions:

 1. The origin of this software must not be misrepresented; you must not
 claim that you wrote the original software. If you use this software in
 a product, an acknowledgment in the product documentation would be
 appreciated but is not required.

 2. Altered source versions must be plainly marked as such, and must not
 be misrepresented as being the original software.

 3. This notice may not be removed or altered from any source
 distribution.
*/
/*SH_doc
title=hcut section=3 repnl=\040
@name	hcut.h
@_brief C-lang unittest framework implemented in 1 header file
@_syno
 HCUT_ADD(testname){...}
 HCUT_RUN(void* logfile, int msglv [, testnames ...] );

 int eq_i(int i1, int i2);
 int eq_d(double d1, double d2);
 int eq_p(void* p1, void* p2);
 int eq_s(const char* s1, const char* s2);
 int eq(anytype val);
@tl_dr
		@(code)@
	#include <stdio.h>
	#include "hcut.h"	//holds implements as XX.hpp

	int hw() {
	 	puts("from hw func");
	 	return 0;
	}
	HCUT_ADD(hw_etc) {
	 	int ck = 123;
	 	eq( hw()==10 );	// returns int, suc/fail == 0/1
	 	eq_i( hw(), 100, "mycmt" );
	 	printf("XXX:%s\n", argv[0]);	//allow to access main(argc, argv)
	}
	HCUT_RUN("stderr", 1, hw_etc );	//HCUT_RUN() holds main()

	// ~$ cc src.c && ./a.out; echo $?	#>> disp to stderr
		@()@
@_eg
		@(code)@
	//-- separate test codes style
	//-- hw.c
	#include <stdio.h>
	int hw() { puts("hw"); return 0; }

	//-- test_hw.c
	#include "hcut.h"
	HCUT_ADD(t_hw1) { eq_i( hw(), 0, "mymsg" ); }
	HCUT_ADD(t_hw2) { eq_s("a","x"); eq_d(0.0); eq(10); }
	HCUT_RUN("./log.txt", 2, t_hw1, t_hw2 );

	// ~$ cc hw.c test_hw.c && ./a.out; echo $?; cat log.txt
		@()@

@_desc	`hcut` is portable unittest framework for C-lang. --
	supplies minimal and enough of what is necessary.
		@(code)--@
	-- HCUT_ADD(name){..} / HCUT_RUN("log.txt", lv, names...);
	name : expands to 'int XX_testname(..)' etc.
	log  : NULL,"NULL"/stdout,"stdout"/stderr,"stderr" == noout/stdout/stderr
	lv   : verbose lv. 0/1/2/3. quiet/normal/verbose/verbose+failstop
	names: exec suite list

	-- eq(av1-2) / eq_X(av1-3)
	argc == 1-3, (a1)/(a1,a2)/(a1,a2,str) >> ig/bool/cmp/cmp+memo
	ac0( eq(), eq_s() etc ) is invalid.
	all asserts can take lastag as cmt, eq_i(1,2, "failtest_cmt") etc.
		@()--@
@return
 HCUT_ADD(): multi statement. dont assume to return values. --
 HCUT_RUN(): holds main() and rc is failed cnt. rtn -1 if fatal err. --
 eqXX(): return int. pass/fail == 0/1. --

@notes int/ptr is treated as intptr_t
@conforming_to c99+ (-D_ISOC99_SOURCE/_POSIX_C_SOURCE=200112L etc)
@copyright Copyright 2019 momi-g, GPLv3+
@_ver 2022-06-28 v1.3.5 (2019-10-15 v1.0.0)
@_see
	https://sourceforge.net/projects/cutest/files/cutest/1.5 --
	https://en.wikipedia.org/wiki/List_of_unit_testing_frameworks --
//SH_docE*/

// change... sed -i 'HCUT_9611a28d' 'some_new_prefix_str'
#ifndef HCUT_9611a28d
#define HCUT_9611a28d

//--api
#define eq_i(...)	(HCUT_eqx(intptr_t,	i, __VA_ARGS__), HCUT_isterm() )
#define eq_d(...)	(HCUT_eqx(double,	d, __VA_ARGS__), HCUT_isterm() )
#define eq_p(...)	(HCUT_eqx(intptr_t, 	p, __VA_ARGS__), HCUT_isterm() )
#define eq_s(...)	(HCUT_eqx(intptr_t, 	s, __VA_ARGS__), HCUT_isterm() )
#define eq(...)		(HCUT_eq_b(__VA_ARGS__), HCUT_isterm() )

#define HCUT_ADD(tfn)	HCUT_ADD_impl(tfn)
#define HCUT_RUN(out,  ...)	HCUT_RUN_impl(out,  __VA_ARGS__)

//--impl
#include <stdio.h>	//SH_co* -D_ISOC99_SOURCE -std=c99 */
#if (__STDC_VERSION__ +0 < 199901L)
	#include "needs compiler c99 or upper"
#endif

#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <stdint.h>

//tools
#define HCUT_Eact(xpr, msg, act)	if(xpr){ int en_=errno; fprintf(stderr \
	        , "ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, __func__ \
	        , getpid(), "hit(" #xpr ")", msg, strerror(en_) ); act; }
#define HCUT_STOP(rc, msg)	HCUT_Eact(rc, msg, exit(1) )

#define HCUT_CK(rc)	HCUT_Eact(!(rc), "stop", exit(1) )
#define HCUT_tsz(tb)	(sizeof(tb)/sizeof(tb[0]))
#define HCUT_lp(n)	for(int lpcnt=1; lpcnt<=n;lpcnt++)
#define HCUT_each(i,tb)	for(int i=0; i<HCUT_tsz(tb); i++)
#define HCUT_pi(i)	printf("%d\n", i)

//#define eq_s(...)	(HCUT_eqx(char*, 	s, 0, __VA_ARGS__), HCUT_isterm() )

//--code
//fc (int agc, char* flnm, int lnum, char* fcnm, char* ckstr, int a1, int a2, char* msg);
#define HCUT_eqx(TP, P, ...)	(HCUT_eq ## P(HCUTac(__VA_ARGS__), __FILE__	\
	, __LINE__, __func__, HCUT_agq(__VA_ARGS__), HCUT_agv(TP,P,__VA_ARGS__) ))

//args counter, (0, ...) start with 0.
#define HCUTac(...) ( strlen(#__VA_ARGS__)==0 ? 0: HCUTacc(__VA_ARGS__) )
#define HCUTacc(...) HCUTacc_(__VA_ARGS__, 3,2,1,z)
#define HCUTacc_(n3,n2,n1,num, ...) num

//bool ag0-2
#define HCUT_eq_b(...)		(HCUT_eqb(HCUTac(__VA_ARGS__), __FILE__ \
	, __LINE__, __func__, HCUT_agq(1, __VA_ARGS__), HCUT_agb(__VA_ARGS__)) )

#define HCUT_agb(...)	HCUT_agb_(HCUTacc(__VA_ARGS__), __VA_ARGS__) 
#define HCUT_agb_(n, ...) HCUT_agb__(n, __VA_ARGS__)
#define HCUT_agb__(n, ...) HCUT_agb ## n(__VA_ARGS__)

#define HCUT_agb1(a) !!(a), 1, "-"
#define HCUT_agb2(a,b) !!(a), 1, (char*)(b)

// needs middle wrapper macro to expand 'num' char
#define HCUT_agq(...)	 HCUT_agq_( HCUTacc(__VA_ARGS__), __VA_ARGS__)
#define HCUT_agq_(a, ...)	 HCUT_agq__(a, __VA_ARGS__)
#define HCUT_agq__(a, ...)	 HCUT_agq ## a(__VA_ARGS__, z)

#define HCUT_agq1(a, ...) #a ", -"		// ag == 0/1, ck with agc
#define HCUT_agq2(a,b,   ...) #a ", " #b
#define HCUT_agq3(a,b,c, ...) #a ", " #b

// needs middle wrapper
#define HCUT_agv(tp,p, ...)	 HCUT_agv_(HCUTacc(__VA_ARGS__), tp,p,__VA_ARGS__ )
#define HCUT_agv_(a,tp,p, ...)	 HCUT_agv__(a,tp,p, __VA_ARGS__)
#define HCUT_agv__(a,tp,p, ...)	 HCUT_agv ## a(tp,p, __VA_ARGS__, z)

#define HCUT_agv1(tp,p, a, ...) (tp)(!!(a)), (tp)1, "-"
#define HCUT_agv2(tp,p, a,b, ...) (tp)(a), (tp)(b), "-"
#define HCUT_agv3(tp,p, a,b,c, ...) (tp)(a), (tp)(b), (char*)c

/*
int HCUT_Bi(int z, ...){
	int rc;
	va_list ap;
	va_start(ap, z);
	rc = va_arg(ap, int);
	va_end(ap);
	return rc
}
*/

//--core api funcs
typedef struct HCUT_cmn_tag {
	FILE* fp;
	int outlv;
	const char* fcname;
	int fail;
	int suc;
	int rc;
} HCUT_cmn_t;
static HCUT_cmn_t HCUT_cmn;

#include <stdarg.h>
static
int HCUT_pf(int lv, const char* fmt, ...) {
	if(HCUT_cmn.outlv < lv) { return 0;}
	if(HCUT_cmn.fp == NULL) { return 0;}
	va_list va;
	va_start(va, fmt);
	int rc = vfprintf(HCUT_cmn.fp, fmt, va);
	va_end(va);
	return rc;
}

#include <stdlib.h>
static
int HCUT_isterm() {
	if(HCUT_cmn.outlv!=3 || HCUT_cmn.fail==0) {return HCUT_cmn.rc;}
	HCUT_pf(1, "detect test err & stop mode\n");
	HCUT_pf(1, "fail/all: %d/%d\n", HCUT_cmn.fail, HCUT_cmn.fail + HCUT_cmn.suc);
	exit(HCUT_cmn.fail);
	return 0;
}

#define HCUT_CMNCODE                                           \
	if(agc==1){	rc = !!a1; fmt = fmtb; }                       \
	HCUT_cmn.rc = rc; msg==NULL?msg="-": msg;                  \
	if(rc==1){ HCUT_cmn.suc++; HCUT_pf(2,fmt,"suc ",flnm,lnum,fcnm,ckstr,a1,a2,msg); } \
	else{HCUT_cmn.fail++;HCUT_pf(1,fmt,"FAIL",flnm,lnum,fcnm,ckstr,a1,a2,msg);}       \

int HCUT_eqi(int agc, const char* flnm, int lnum
	, const char* fcnm, const char* ckstr, intptr_t aa, intptr_t bb, const char* msg) {
	if(agc==0) {return 0; }
	int a1 = (int)aa;
	int a2 = (int)bb;
	const char* fmt = "%s: %s:%d:%s(): (%s): %d =i= %d	:%s\n";
	const char* fmtb= "%s: %s:%d:%s(): (%s): %d =i= %d (bool)	:%s\n";
	int rc = (a1==a2);
	; HCUT_CMNCODE;
	return rc;
}

int HCUT_eqd(int agc, const char* flnm, int lnum
	, const char* fcnm, const char* ckstr, double a1, double a2, const char* msg) {
	if(agc==0) {return 0; }
	const char* fmt = "%s: %s:%d:%s(): (%s): %f =d= %f	:%s\n";
	const char* fmtb= "%s: %s:%d:%s(): (%s): %f =d= %f (bool)	:%s\n";
	int rc = (a1==a2);
	; HCUT_CMNCODE;
	return rc;
}

int HCUT_eqp(int agc, const char* flnm, int lnum
	, const char* fcnm, const char* ckstr, intptr_t aa, intptr_t bb, const char* msg) {
	if(agc==0) {return 0; }
	const void* a1 = (const void*)aa;
	const void* a2 = (const void*)bb;
	const char* fmt = "%s: %s:%d:%s(): (%s): %p =p= %p	:%s\n";
	const char* fmtb= "%s: %s:%d:%s(): (%s): %p =p= %p (bool)	:%s\n";
	int rc = (a1==a2);
	; HCUT_CMNCODE;
	return rc;
}

char HCUT_s1[16] = {0};
char HCUT_s2[16] = {0};
int HCUT_eqs(int agc, const char* flnm, int lnum
	, const char* fcnm, const char* ckstr, intptr_t aa, intptr_t bb, const char* msg) {
	if(agc==0) { return 0; }
	const char* a1 = (const char*)aa;
	const char* a2 = (const char*)bb;
	const char* fmt = "%s: %s:%d:%s(): (%s): %s =s= %s	:%s\n";
	const char* fmtb= "%s: %s:%d:%s(): (%s): %d =s= %d (bool)	:%s\n";
	//bool comes as 0x01 etc. conv.
	int rc = !!a1;
	while(agc>1) {
		if(a1==NULL && a2==NULL){ a1=a2="(nil)"; rc=1; }
		if(a1==NULL){ a1="(nil)"; rc=0; }
		if(a2==NULL){ a2="(nil)"; rc=0; }
		if(rc==0){break;}

		rc = (strcmp(a1, a2) == 0);
		sprintf(HCUT_s1, "%.*s%s", 10, a1, strlen(a1)>10?"..": "");
		sprintf(HCUT_s2, "%.*s%s", 10, a2, strlen(a1)>10?"..": "");
		a1 = (char*)HCUT_s1;
		a2 = (char*)HCUT_s2;
		break;
	}
	; HCUT_CMNCODE;
	return rc;;
}

int HCUT_eqb(int agc, const char* flnm, int lnum
	, const char* fcnm, const char* ckstr, int a1, int a2, const char* msg) {
	if(agc==0) {return 0; }
	const char* fmt = "%s: %s:%d:%s(): (%s): %d =b= %d (bool)	:%s\n";
	const char* fmtb= "%s: %s:%d:%s(): (%s): %d =b= %d (bool)	:%s\n";
	//bool spacific, (1, var) >> "1, " 1st 3char is dummy, 2,3 is the same
	ckstr += 3;
	int rc = a1;
	; HCUT_CMNCODE;
	return rc;;
}

#define HCUT_ADD_impl(tfn)	void tfn ## sub(int ac, char** av); \
	int tfn(int ac, char** av){ tfn ## sub(ac, av);return 0; } \
	void tfn ## sub(int argc, char** argv)
// void: autocomplete 'return num;' allows only 'main()' funcs

/*
HCUT_ADD(tf){ ..code.. }
	>>	(expands)
void tfsub(int ac, char** av);
int tf(int ac, char** av){	tfsub(ac, av);	return 0;}
void tfsub(int argc, char** argv) {..code..}
*/

typedef int (*HCUT_ft)(int argc, char** argv);
#define HCUT_FCNT (sizeof(HCUT_tfarr)/sizeof(HCUT_tfarr[0]) -1)

// init {NULL,} : trailing comma is valid c89+,  https://stackoverflow.com/questions/2311864
// {NULL, f1, f2} >>rotate>> {f1,f2,NULL} for sentinel
#define HCUT_RUN_impl(out, lv, ...)	\
	HCUT_ft HCUT_tfarr[]={NULL, __VA_ARGS__};	\
	int main(int argc, char** argv){	\
		int rc = HCUT_run_(out, lv, HCUT_FCNT, HCUT_tfarr, argc, argv);	\
		char** p = (char**)&HCUT_tfarr;	\
		*p=NULL;	\
		return rc;	\
	}
// *p=NULL ... kill valgrind reachable mem warning

int HCUT_run_(void* out, int lv, int fcnt, HCUT_ft* tfarr, int argc, char** argv) {
	//rotate testlist for sentinel
	for(int i=0; i<fcnt; i++) { tfarr[i]=tfarr[i+1]; }
	tfarr[fcnt]=NULL;
	FILE* fp=NULL;
	; HCUT_Eact(lv<0||3<lv, "verboseLv allows only 0,1,2,3", exit(-1));
	if(out ==NULL) { HCUT_cmn.fp = NULL;}
	else if(out == stdout) { HCUT_cmn.fp = out;}
	else if(out == stderr) { HCUT_cmn.fp = stderr;}
	else if(strcmp(out, "NULL")==0) { HCUT_cmn.fp = NULL;}
	else if(strcmp(out, "stdout")==0) { HCUT_cmn.fp = stdout;}
	else if(strcmp(out, "stderr")==0) { HCUT_cmn.fp = stderr;}
	else if(1) {
		fp = fopen(out, "w+");
		; HCUT_Eact(fp==NULL, "fopen() failed: ", fputs(out, stderr); exit(-1););
		HCUT_cmn.fp = fp;
	}
	HCUT_cmn.outlv = lv;
	// exec
	for(int i=0; i<fcnt && tfarr[i]; i++) { tfarr[i](argc, argv); }
	// report
	HCUT_pf(1, "fail/all: %d/%d\n", HCUT_cmn.fail, HCUT_cmn.fail + HCUT_cmn.suc);
	if(fp) {fclose(fp);}
	return HCUT_cmn.fail;
	
	//unreachable code, kill nouse warning
	HCUT_isterm();
	return -1;
}
#endif /* HCUT */
