/* Copyright (C) 2019 Momi-g
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/* add license cmt from cutest-1.5 README.txt */
/*
 NOTE
 
 The license is based on the zlib/libpng license. For more details see
 http://www.opensource.org/licenses/zlib-license.html. The intent of the
 license is to:
 
 - keep the license as simple as possible
 - encourage the use of CuTest in both free and commercial applications
   and libraries
 - keep the source code together
 - give credit to the CuTest contributors for their work
 
 If you ship CuTest in source form with your source distribution, the
 following license document must be included with it in unaltered form.
 If you find CuTest useful we would like to hear about it.
 
 LICENSE
 
 Copyright (c) 2003 Asim Jalis
 
 This software is provided 'as-is', without any express or implied
 warranty. In no event will the authors be held liable for any damages
 arising from the use of this software.
 
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it
 freely, subject to the following restrictions:
 
 1. The origin of this software must not be misrepresented; you must not
 claim that you wrote the original software. If you use this software in
 a product, an acknowledgment in the product documentation would be
 appreciated but is not required.
 
 2. Altered source versions must be plainly marked as such, and must not
 be misrepresented as being the original software.
 
 3. This notice may not be removed or altered from any source
 distribution.
*/
// no_mainsrc. header only code.


/*SH_SMP
#include <stdio.h>
#include "hcut.h"

int hw() {
	puts("hw");
	return 0;
}

// expand to "void t_hw(int argc, char** argv){...}"
HCUT_ADD(t_hw) {
	int ck = 123;
	eq(hw() == 0 );
	eq(hw() == ck, "cmt if last arg(void*) is exist" );
}

int gw() {
	puts("gw");
	return 0;
}
HCUT_ADD(test_gw12345) {
	//assert type: cmp, int, dbl, str, ptr 
	eq(10==2, "all asserts support lastarg cmt");
	eq_i( gw(), 3);
	eq_d(1.01, 666);
	eq_s("aaa", "bbb");
	eq_p("aaa", NULL, "my_cmt");
	
	puts("my_test_end?");
}

HCUT_RUN("stderr", 1, t_hw, test_gw12345 )

// HCUT_RUN() holds "int main(int argc, char** argv){..}" and returns fail cnt.
// arg1 : msgout filename. "stdout","stderr","NULL" are used as FILE* or noout. 
// arg2 : verbose lv. 0/1/2/3 ... quiet/normal/verbose/stop
// arg3-: test all suite you set here.  (use ~$ sed -ne '/^HCUT/{=;p}' test.c)
// rtn/exit status: cnt of failed assert. rtn -1 if fatal err.
//SH_SMPE*/


/*
 change log
 --
2021-11-30	Momi-g	<dmy@dmy.dmy>
	
	* hcut.sh.c(HCUT_RUN): add lv==3, stop if fail. v1.3.0
	* (HCUT..._BACK): add macro for lv==3 stop
	* (eq asserts): change macro expr >> statement for lv==3

2021-07-10	Momi-g	<dmy@dmy.dmy>
	
	* hcut.sh.c(HCUT_RUN): add *p=NULL, stop valgrind mem warning

2021-07-06	Momi-g	<dmy@dmy.dmy>
	
	* hcut.sh.c(HCUT_RUN): return 1 >> -1 if apierr

2021-06-26	Momi-g	<dmy@dmy.dmy>
	
	* hcut.sh.c(eq_p): change cast (void*) >> (char*) for allow ptr+1

2021-06-14	Momi-g	<dmy@dmy.dmy>
	
	* hcut.sh.c(macros): change mc, ERRact >> HCUT_Eact

2021-06-09	Momi-g	<dmy@dmy.dmy>
	
	* hcut.sh.c(macros): fix c99 -pedantic, __VA_ARGS__, out of standard syntax

2021-02-18	Momi-g	<dmy@dmy.dmy>
	
	* hcut.sh.c(HCUT_RUN): debug, add fclose()
	
	* hcut.sh.c(eq): rewrite. use cmn macro _SAME logic
	
	* hcut.sh.c(hcut): change output .hpp >> .h

2021-02-18	Momi-g	<dmy@dmy.dmy>
	
	* hcut.sh.c(assert_eq_SAME): debug, add va_end() at macro end

2021-01-19	Momi-g	<dmy@dmy.dmy>
	
	* hcut.sh.c(eq_i,d,p): fix macro, (a,b)	>> ( (int)a,(int)b ) etc

2020-10-28	Momi-g	<dmy@dmy.dmy>
	
	* hcut.sh.c: v1.2.2 release
	* hcut.sh.c(hcut): rename srcfile name, header suffix .cc -> .hpp
	* (brp.sh): add Rh="$bn.hpp", change .cc to .hpp

2020-10-25	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.cc(assert_eqs): debug rc strcmp() >> (strcmp==0)
	change eqs args type void* >> const char*

2020-10-19	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.cc: support cmdline data (argc, argv) at HCUT_ADD() codeblock
	* (doc): fix doc.

2020-06-30	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.cc: v1.1.0 rewrite.

2020-02-02	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.cc: v1.0.2 releases.

	* hcut.sh.cc (#define ast): change API stirng, ast->eq.
	* hcut.sh.cc (@sh-opt): fix Doc.

2020-1-11	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.cc (@sh-opt): fix Doc.
	
2019-11-3	Momi-g	<dmy@dmy.dmy>
	
	* hcut.sh.cc: v1.0.1 releases.
	
	* hcut.sh.cc: (@sh-opt): build opt -b add. fix Doc. 

2019-10-15	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.cc: v1.0.0 releases. 

*/
