/*	GPLv3+	*/
/* Copyright (C) 2021 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*SH_doc*
title=laptime section=3 repnl=\040
@name	laptime
@_brief	research interval times
@_syno
 #include laptime.h
 
 const char* laptime([int num / const char* msg]);
 const char* flaptime(FILE* fp, [int num / const char* msg]);
@tl_dr
	@(code)@
 #include <unistd.h>		//sleep()
 #include "laptime.h"

 int main(int argc, char** argv) {
 	cosnt char* p = NULL;
 	laptime(0);  //reset and start
 	sleep(1);	
 	laptime();   //>> real 1009ms	: src.c 4:func(): msg:- (to stderr)
 	laptime("hw");  //>> real 1010ms	: src.c 5:func(): msg:hw
 
 	laptime(0); // reset
 	laptime();  //>> real 5ms	: src.c 4:func(): msg:-	
 	
 	flaptime(stdout, 0);   //laptime(0) with req fp, 
 	flaptime(stdout);      //laptime()
 	flaptime(stdout, "hello");   //laptime("hello")
 	
 	p = flaptime(NULL, "hw");    //nodisp if fp == NULL
 	puts(p);   //ret output msg in the inner static sbuf[]
 	
 	return 0;
 }
 // ~$ cc src.c
	@()@
@params
		@(code)--@
	- num : int. only 0. reset and start timer.
	- msg : char*. disp spend times+msg
	- void: conv to blank lit "".
	- fp  : output FILE* fp. laptime() use stderr. noout if set NULL
		@()@
@return
	msgptr saved in inner static sbuf[128]. output msg is not limited,
	but rtnstr maybe cutoff if too long.
@_desc
	save times to static val when set laptime(0). thread-unsafe.
	time precision is 'ms'.
@notes -
@copyrihgt Copyright 2022 momi-g, GPLv3+
@conforming_to POSIX.1-2001+ (-D_XOPEN_SOURCE=600 etc)
@_ver 2022-07-10 v1.0.3	(2021-02-17 v1.0.0)
//SH_docE*/

#include <stdio.h>
#include <unistd.h>
#include <time.h>


#define LAPTIME_MSGSZ 128 -1
static char sbuf[LAPTIME_MSGSZ+1] = {0};
static struct timespec lapbase;

const char* laptime_sub(FILE* fp, const char* str
 , const char* fname, int lnum, const char* fcname, const char* msg){
	 
	if(str[0]!='\0'&&msg==NULL){ clock_gettime(CLOCK_MONOTONIC, &lapbase); return sbuf; }
	struct timespec tbuf;
	clock_gettime(CLOCK_MONOTONIC, &tbuf);
	time_t s = tbuf.tv_sec-lapbase.tv_sec;
	long ns = tbuf.tv_nsec-lapbase.tv_nsec;
	if(ns<0){s--; ns+=1000*1000*1000;}
	double bet = (double)s*1000 + (double)ns/1000/1000;

	msg==NULL ? msg="-": 0;
	char* fmt = "real\t%.3f ms\t:  %s %d: %s(): msg:%s\n";

	fp ? fprintf(fp,fmt, 	bet, fname, lnum, fcname, msg) :0;
	snprintf(sbuf, LAPTIME_MSGSZ, fmt, 	bet, fname, lnum, fcname, msg);
	return sbuf;
}



/*SH_SMP
#include <unistd.h>		//sleep()
#include "laptime.h"

int main(int argc, char** argv) {
	laptime(0);	//reset
	sleep(1);	
	laptime();		//>> real 9ms	: src.c 4:func(): msg:-
	laptime("hw");	//>> real 10ms	: src.c 5:func(): msg:hw

	laptime(0);	// reset
	laptime();	//>> real 5ms	: src.c 4:func(): msg:-	
	return 0;
}
// ~$ cc src.c laptime.c
//SH_SMPE*/


/*
 change log
 --
2022-07-10 Momi-g	<dmy@dmy.dmy>

	* laptime.c(header): add hpp, change apt rtntype void >> int

	* laptime.c(flaptime): add newapi, rewriet output code

2021-06-22  Momi-g	<dmy@dmy.dmy>

	* laptime.c(header): fix #error, edit cmt etc. v1.0.2

2021-02-17  Momi-g	<dmy@dmy.dmy>

	* laptime.c: v1.0.0

*/

