#!/bin/sh
cat << 'EEE' > /dev/null
/* Copyright (C) 2021 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

set -eu

# path/binary setting
cd `dirname $0`	#base $0 dir
fdir=`pwd`
cd ../..
topdir=`pwd`	#configure root
cp -Rf $fdir ./
cd _tests
wdir=`pwd`
PATH="$wdir:$PATH"
touch log.txt

ln -fs "$topdir"/src/tests.code ./
ln -fs "$topdir"/src/qy ./

shunit_m -v2 > buf_
cat tests.code >> buf_
mv buf_ tests.code

echo "--- run test: `pwd`/$0
..."
eval "`shunit_m`"

set +e
( set -x
### -- test_maincode
which bash && {
	bash --posix ./tests.code
	_suc
}

## --test_end
_res 2>&3
echo "--- SUCCESS for all tests. see $0, log.txt if needs"
) 2>&1 | tee log.txt | tail -n 1 | grep SUCCESS
test $? = 0 && flg=0 || flg=1
cat log.txt | grep 'fail/all'

test "$flg" = 0 && exit 0
#err
tail log.txt >/dev/stderr
echo "--- test FAILED, see $0, log.txt" >/dev/stderr
exit 1
