#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[/][/*]SH_'		;O=${0##*[/]};R=`dirname $0`/;R0=$R$O;Re=eval\ ;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGext"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d;:l
n;p;b l"<$R0>$Rm;$Rp"$Rm"';Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;b l"<$R0';Cw="(R=LS
$Rw;$Rw>&3;R=HD;$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';RB=$($R"s/${C}OP//p"\
<$R0|(F=mw;while read -r a b;do B=${a%:};F=`$Rp"$F"|$R"s#$B:*##;p"`${a%_};$Rp"
C$B=\$(cat<<'E'$O$b${O}E$O)";done;$Rp"R1=$F"));$Re"$RB";while getopts $R1 R;do
case $R in \?)exit 1;;* )$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac;done
[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit #END  GPLv3+ */

/*SH_LS*/
/* Copyright (C) 2019 Momi-g
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/* add license cmt from cutest-1.5 README.txt */
/*
 NOTE

 The license is based on the zlib/libpng license. For more details see
 http://www.opensource.org/licenses/zlib-license.html. The intent of the
 license is to:

 - keep the license as simple as possible
 - encourage the use of CuTest in both free and commercial applications
   and libraries
 - keep the source code together
 - give credit to the CuTest contributors for their work

 If you ship CuTest in source form with your source distribution, the
 following license document must be included with it in unaltered form.
 If you find CuTest useful we would like to hear about it.

 LICENSE

 Copyright (c) 2003 Asim Jalis

 This software is provided 'as-is', without any express or implied
 warranty. In no event will the authors be held liable for any damages
 arising from the use of this software.

 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it
 freely, subject to the following restrictions:

 1. The origin of this software must not be misrepresented; you must not
 claim that you wrote the original software. If you use this software in
 a product, an acknowledgment in the product documentation would be
 appreciated but is not required.

 2. Altered source versions must be plainly marked as such, and must not
 be misrepresented as being the original software.

 3. This notice may not be removed or altered from any source
 distribution.
*/
/*SH_ED*/

/*SH_HD*/
/*SH_doc
title=*SH_bn* section=3 repnl=\040
@name	*SH_bn*.h
@_brief C-lang unittest framework implemented in 1 header file
@_syno
 HCUT_ADD(testname){...}
 HCUT_RUN(void* logfile, int msglv [, testnames ...] );

 int eq_i(int i1, int i2);
 int eq_d(double d1, double d2);
 int eq_p(void* p1, void* p2);
 int eq_s(const char* s1, const char* s2);
 int eq(anytype val);
@tl_dr
		@(code)@
	#include <stdio.h>
	#include "hcut.h"	//holds implements as XX.hpp

	int hw() {
	 	puts("from hw func");
	 	return 0;
	}
	HCUT_ADD(hw_etc) {
	 	int ck = 123;
	 	eq( hw()==10 );	// returns int, suc/fail == 0/1
	 	eq_i( hw(), 100, "mycmt" );
	 	printf("XXX:%s\n", argv[0]);	//allow to access main(argc, argv)
	}
	HCUT_RUN("stderr", 1, hw_etc );	//HCUT_RUN() holds main()

	// ~$ cc src.c && ./a.out; echo $?	#>> disp to stderr
		@()@
@_eg
		@(code)@
	//-- separate test codes style
	//-- hw.c
	#include <stdio.h>
	int hw() { puts("hw"); return 0; }

	//-- test_hw.c
	#include "hcut.h"
	HCUT_ADD(t_hw1) { eq_i( hw(), 0, "mymsg" ); }
	HCUT_ADD(t_hw2) { eq_s("a","x"); eq_d(0.0); eq(10); }
	HCUT_RUN("./log.txt", 2, t_hw1, t_hw2 );

	// ~$ cc hw.c test_hw.c && ./a.out; echo $?; cat log.txt
		@()@

@_desc	`*SH_bn*` is portable unittest framework for C-lang. --
	supplies minimal and enough of what is necessary.
		@(code)--@
	-- HCUT_ADD(name){..} / HCUT_RUN("log.txt", lv, names...);
	name : expands to 'int XX_testname(..)' etc.
	log  : NULL,"NULL"/stdout,"stdout"/stderr,"stderr" == noout/stdout/stderr
	lv   : verbose lv. 0/1/2/3. quiet/normal/verbose/verbose+failstop
	names: exec suite list

	-- eq(av1-2) / eq_X(av1-3)
	argc == 1-3, (a1)/(a1,a2)/(a1,a2,str) >> ig/bool/cmp/cmp+memo
	ac0( eq(), eq_s() etc ) is invalid.
	all asserts can take lastag as cmt, eq_i(1,2, "failtest_cmt") etc.
		@()--@
@return
 HCUT_ADD(): multi statement. dont assume to return values. --
 HCUT_RUN(): holds main() and rc is failed cnt. rtn -1 if fatal err. --
 eqXX(): return int. pass/fail == 0/1. --

@notes int/ptr is treated as intptr_t
@conforming_to c99+ (-D_ISOC99_SOURCE/_POSIX_C_SOURCE=200112L etc)
@copyright Copyright 2019 momi-g, GPLv3+
@_ver 2022-06-28 v1.3.5 (2019-10-15 v1.0.0)
@_see
	https://sourceforge.net/projects/cutest/files/cutest/1.5 --
	https://en.wikipedia.org/wiki/List_of_unit_testing_frameworks --
//SH_docE*/

// change... sed -i 'HCUT_9611a28d' 'some_new_prefix_str'
#ifndef HCUT_9611a28d
#define HCUT_9611a28d

//--api
#define eq_i(...)	(HCUT_eqx(intptr_t,	i, __VA_ARGS__), HCUT_isterm() )
#define eq_d(...)	(HCUT_eqx(double,	d, __VA_ARGS__), HCUT_isterm() )
#define eq_p(...)	(HCUT_eqx(intptr_t, 	p, __VA_ARGS__), HCUT_isterm() )
#define eq_s(...)	(HCUT_eqx(intptr_t, 	s, __VA_ARGS__), HCUT_isterm() )
#define eq(...)		(HCUT_eq_b(__VA_ARGS__), HCUT_isterm() )

#define HCUT_ADD(tfn)	HCUT_ADD_impl(tfn)
#define HCUT_RUN(out,  ...)	HCUT_RUN_impl(out,  __VA_ARGS__)

//--impl
#include <stdio.h>	//SH_co* -D_ISOC99_SOURCE -std=c99 */
#if (__STDC_VERSION__ +0 < 199901L)
	#include "needs compiler c99 or upper"
#endif

#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <stdint.h>

//tools
#define HCUT_Eact(xpr, msg, act)	if(xpr){ int en_=errno; fprintf(stderr \
	        , "ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, __func__ \
	        , getpid(), "hit(" #xpr ")", msg, strerror(en_) ); act; }
#define HCUT_STOP(rc, msg)	HCUT_Eact(rc, msg, exit(1) )

#define HCUT_CK(rc)	HCUT_Eact(!(rc), "stop", exit(1) )
#define HCUT_tsz(tb)	(sizeof(tb)/sizeof(tb[0]))
#define HCUT_lp(n)	for(int lpcnt=1; lpcnt<=n;lpcnt++)
#define HCUT_each(i,tb)	for(int i=0; i<HCUT_tsz(tb); i++)
#define HCUT_pi(i)	printf("%d\n", i)

//#define eq_s(...)	(HCUT_eqx(char*, 	s, 0, __VA_ARGS__), HCUT_isterm() )

//--code
//fc (int agc, char* flnm, int lnum, char* fcnm, char* ckstr, int a1, int a2, char* msg);
#define HCUT_eqx(TP, P, ...)	(HCUT_eq ## P(HCUTac(__VA_ARGS__), __FILE__	\
	, __LINE__, __func__, HCUT_agq(__VA_ARGS__), HCUT_agv(TP,P,__VA_ARGS__) ))

//args counter, (0, ...) start with 0.
#define HCUTac(...) ( strlen(#__VA_ARGS__)==0 ? 0: HCUTacc(__VA_ARGS__) )
#define HCUTacc(...) HCUTacc_(__VA_ARGS__, 3,2,1,z)
#define HCUTacc_(n3,n2,n1,num, ...) num

//bool ag0-2
#define HCUT_eq_b(...)		(HCUT_eqb(HCUTac(__VA_ARGS__), __FILE__ \
	, __LINE__, __func__, HCUT_agq(1, __VA_ARGS__), HCUT_agb(__VA_ARGS__)) )

#define HCUT_agb(...)	HCUT_agb_(HCUTacc(__VA_ARGS__), __VA_ARGS__) 
#define HCUT_agb_(n, ...) HCUT_agb__(n, __VA_ARGS__)
#define HCUT_agb__(n, ...) HCUT_agb ## n(__VA_ARGS__)

#define HCUT_agb1(a) !!(a), 1, "-"
#define HCUT_agb2(a,b) !!(a), 1, (char*)(b)

// needs middle wrapper macro to expand 'num' char
#define HCUT_agq(...)	 HCUT_agq_( HCUTacc(__VA_ARGS__), __VA_ARGS__)
#define HCUT_agq_(a, ...)	 HCUT_agq__(a, __VA_ARGS__)
#define HCUT_agq__(a, ...)	 HCUT_agq ## a(__VA_ARGS__, z)

#define HCUT_agq1(a, ...) #a ", -"		// ag == 0/1, ck with agc
#define HCUT_agq2(a,b,   ...) #a ", " #b
#define HCUT_agq3(a,b,c, ...) #a ", " #b

// needs middle wrapper
#define HCUT_agv(tp,p, ...)	 HCUT_agv_(HCUTacc(__VA_ARGS__), tp,p,__VA_ARGS__ )
#define HCUT_agv_(a,tp,p, ...)	 HCUT_agv__(a,tp,p, __VA_ARGS__)
#define HCUT_agv__(a,tp,p, ...)	 HCUT_agv ## a(tp,p, __VA_ARGS__, z)

#define HCUT_agv1(tp,p, a, ...) (tp)(!!(a)), (tp)1, "-"
#define HCUT_agv2(tp,p, a,b, ...) (tp)(a), (tp)(b), "-"
#define HCUT_agv3(tp,p, a,b,c, ...) (tp)(a), (tp)(b), (char*)c

/*
int HCUT_Bi(int z, ...){
	int rc;
	va_list ap;
	va_start(ap, z);
	rc = va_arg(ap, int);
	va_end(ap);
	return rc
}
*/

//--core api funcs
typedef struct HCUT_cmn_tag {
	FILE* fp;
	int outlv;
	const char* fcname;
	int fail;
	int suc;
	int rc;
} HCUT_cmn_t;
static HCUT_cmn_t HCUT_cmn;

#include <stdarg.h>
static
int HCUT_pf(int lv, const char* fmt, ...) {
	if(HCUT_cmn.outlv < lv) { return 0;}
	if(HCUT_cmn.fp == NULL) { return 0;}
	va_list va;
	va_start(va, fmt);
	int rc = vfprintf(HCUT_cmn.fp, fmt, va);
	va_end(va);
	return rc;
}

#include <stdlib.h>
static
int HCUT_isterm() {
	if(HCUT_cmn.outlv!=3 || HCUT_cmn.fail==0) {return HCUT_cmn.rc;}
	HCUT_pf(1, "detect test err & stop mode\n");
	HCUT_pf(1, "fail/all: %d/%d\n", HCUT_cmn.fail, HCUT_cmn.fail + HCUT_cmn.suc);
	exit(HCUT_cmn.fail);
	return 0;
}

#define HCUT_CMNCODE                                           \
	if(agc==1){	rc = !!a1; fmt = fmtb; }                       \
	HCUT_cmn.rc = rc; msg==NULL?msg="-": msg;                  \
	if(rc==1){ HCUT_cmn.suc++; HCUT_pf(2,fmt,"suc ",flnm,lnum,fcnm,ckstr,a1,a2,msg); } \
	else{HCUT_cmn.fail++;HCUT_pf(1,fmt,"FAIL",flnm,lnum,fcnm,ckstr,a1,a2,msg);}       \

int HCUT_eqi(int agc, const char* flnm, int lnum
	, const char* fcnm, const char* ckstr, intptr_t aa, intptr_t bb, const char* msg) {
	if(agc==0) {return 0; }
	int a1 = (int)aa;
	int a2 = (int)bb;
	const char* fmt = "%s: %s:%d:%s(): (%s): %d =i= %d	:%s\n";
	const char* fmtb= "%s: %s:%d:%s(): (%s): %d =i= %d (bool)	:%s\n";
	int rc = (a1==a2);
	; HCUT_CMNCODE;
	return rc;
}

int HCUT_eqd(int agc, const char* flnm, int lnum
	, const char* fcnm, const char* ckstr, double a1, double a2, const char* msg) {
	if(agc==0) {return 0; }
	const char* fmt = "%s: %s:%d:%s(): (%s): %f =d= %f	:%s\n";
	const char* fmtb= "%s: %s:%d:%s(): (%s): %f =d= %f (bool)	:%s\n";
	int rc = (a1==a2);
	; HCUT_CMNCODE;
	return rc;
}

int HCUT_eqp(int agc, const char* flnm, int lnum
	, const char* fcnm, const char* ckstr, intptr_t aa, intptr_t bb, const char* msg) {
	if(agc==0) {return 0; }
	const void* a1 = (const void*)aa;
	const void* a2 = (const void*)bb;
	const char* fmt = "%s: %s:%d:%s(): (%s): %p =p= %p	:%s\n";
	const char* fmtb= "%s: %s:%d:%s(): (%s): %p =p= %p (bool)	:%s\n";
	int rc = (a1==a2);
	; HCUT_CMNCODE;
	return rc;
}

char HCUT_s1[16] = {0};
char HCUT_s2[16] = {0};
int HCUT_eqs(int agc, const char* flnm, int lnum
	, const char* fcnm, const char* ckstr, intptr_t aa, intptr_t bb, const char* msg) {
	if(agc==0) { return 0; }
	const char* a1 = (const char*)aa;
	const char* a2 = (const char*)bb;
	const char* fmt = "%s: %s:%d:%s(): (%s): %s =s= %s	:%s\n";
	const char* fmtb= "%s: %s:%d:%s(): (%s): %d =s= %d (bool)	:%s\n";
	//bool comes as 0x01 etc. conv.
	int rc = !!a1;
	while(agc>1) {
		if(a1==NULL && a2==NULL){ a1=a2="(nil)"; rc=1; }
		if(a1==NULL){ a1="(nil)"; rc=0; }
		if(a2==NULL){ a2="(nil)"; rc=0; }
		if(rc==0){break;}

		rc = (strcmp(a1, a2) == 0);
		sprintf(HCUT_s1, "%.*s%s", 10, a1, strlen(a1)>10?"..": "");
		sprintf(HCUT_s2, "%.*s%s", 10, a2, strlen(a1)>10?"..": "");
		a1 = (char*)HCUT_s1;
		a2 = (char*)HCUT_s2;
		break;
	}
	; HCUT_CMNCODE;
	return rc;;
}

int HCUT_eqb(int agc, const char* flnm, int lnum
	, const char* fcnm, const char* ckstr, int a1, int a2, const char* msg) {
	if(agc==0) {return 0; }
	const char* fmt = "%s: %s:%d:%s(): (%s): %d =b= %d (bool)	:%s\n";
	const char* fmtb= "%s: %s:%d:%s(): (%s): %d =b= %d (bool)	:%s\n";
	//bool spacific, (1, var) >> "1, " 1st 3char is dummy, 2,3 is the same
	ckstr += 3;
	int rc = a1;
	; HCUT_CMNCODE;
	return rc;;
}

#define HCUT_ADD_impl(tfn)	void tfn ## sub(int ac, char** av); \
	int tfn(int ac, char** av){ tfn ## sub(ac, av);return 0; } \
	void tfn ## sub(int argc, char** argv)
// void: autocomplete 'return num;' allows only 'main()' funcs

/*
HCUT_ADD(tf){ ..code.. }
	>>	(expands)
void tfsub(int ac, char** av);
int tf(int ac, char** av){	tfsub(ac, av);	return 0;}
void tfsub(int argc, char** argv) {..code..}
*/

typedef int (*HCUT_ft)(int argc, char** argv);
#define HCUT_FCNT (sizeof(HCUT_tfarr)/sizeof(HCUT_tfarr[0]) -1)

// init {NULL,} : trailing comma is valid c89+,  https://stackoverflow.com/questions/2311864
// {NULL, f1, f2} >>rotate>> {f1,f2,NULL} for sentinel
#define HCUT_RUN_impl(out, lv, ...)	\
	HCUT_ft HCUT_tfarr[]={NULL, __VA_ARGS__};	\
	int main(int argc, char** argv){	\
		int rc = HCUT_run_(out, lv, HCUT_FCNT, HCUT_tfarr, argc, argv);	\
		char** p = (char**)&HCUT_tfarr;	\
		*p=NULL;	\
		return rc;	\
	}
// *p=NULL ... kill valgrind reachable mem warning

int HCUT_run_(void* out, int lv, int fcnt, HCUT_ft* tfarr, int argc, char** argv) {
	//rotate testlist for sentinel
	for(int i=0; i<fcnt; i++) { tfarr[i]=tfarr[i+1]; }
	tfarr[fcnt]=NULL;
	FILE* fp=NULL;
	; HCUT_Eact(lv<0||3<lv, "verboseLv allows only 0,1,2,3", exit(-1));
	if(out ==NULL) { HCUT_cmn.fp = NULL;}
	else if(out == stdout) { HCUT_cmn.fp = out;}
	else if(out == stderr) { HCUT_cmn.fp = stderr;}
	else if(strcmp(out, "NULL")==0) { HCUT_cmn.fp = NULL;}
	else if(strcmp(out, "stdout")==0) { HCUT_cmn.fp = stdout;}
	else if(strcmp(out, "stderr")==0) { HCUT_cmn.fp = stderr;}
	else if(1) {
		fp = fopen(out, "w+");
		; HCUT_Eact(fp==NULL, "fopen() failed: ", fputs(out, stderr); exit(-1););
		HCUT_cmn.fp = fp;
	}
	HCUT_cmn.outlv = lv;
	// exec
	for(int i=0; i<fcnt && tfarr[i]; i++) { tfarr[i](argc, argv); }
	// report
	HCUT_pf(1, "fail/all: %d/%d\n", HCUT_cmn.fail, HCUT_cmn.fail + HCUT_cmn.suc);
	if(fp) {fclose(fp);}
	return HCUT_cmn.fail;
	
	//unreachable code, kill nouse warning
	HCUT_isterm();
	return -1;
}
#endif /* HCUT */
/*SH_ED*/

/*SH_SC*/
// no_mainsrc. header only code.
int HCUT_kill_c99_empty_code_warning = 0;

#ifdef TEST
#include "*SH_bn*.h"	//SH_co* -std=c99 */
HCUT_ADD(t_hcut) {

	HCUT_CK( HCUT_cmn.suc==0 );
	
	int tb[] = {
	0 == eq_i(0),
	1 == eq_i(10),
	1 == eq_i(10,10),
	0 == eq_i(11,21),
	1 == eq_i(10,10, "msg"),
	0 == eq_i(11,21, "msg-----"),
	};
	HCUT_each(i, tb){ HCUT_CK(tb[i] ); }
	//
	int tbi[] = {
	0 == eq_i(NULL),
	1 == eq_i("a"),
	1 == eq_i(10.1, 10.5),
	0 == eq_i(11.1, 21.1),
	1 == eq_i(10.2, 10.3, "msg"),
	0 == eq_i(11.1, 21.3, "msg-----"),
	};
	HCUT_each(i, tbi){ HCUT_CK(tbi[i] ); }
	//
	int tbd[] = {
	0 == eq_d(0),
	1 == eq_d(10),
	1 == eq_d(10,10),
	0 == eq_d(11,21),
	1 == eq_d(10,10, "msg"),
	0 == eq_d(11,21, "msg------"),
	};
	HCUT_each(i, tbd){ HCUT_CK(tbd[i] ); }
	//
	int tbp[] = {
	0 == eq_p(0),
	1 == eq_p(10),
	1 == eq_p(10,10),
	0 == eq_p(11,21),
	1 == eq_p(10,10, "msg"),
	0 == eq_p(11,21, "msg------"),
	};
	HCUT_each(i, tbp){ HCUT_CK(tbp[i] ); }
	//
	int tbs[] = {
	0 == eq_s(NULL),
	1 == eq_s("aa"),
	1 == eq_s("aa","aa"),
	0 == eq_s("aa","bb"),
	1 == eq_s("aa", "aa", "msg"),
	0 == eq_s("aa", "bb", "msg------"),
	};
	HCUT_each(i, tbs){ HCUT_CK(tbs[i] ); }
	//
	//lontstr
	const char*	s11 = "12345678901234567890";
	const char* s22 = NULL;
	int tbsl[] = {
	0 == eq_s(NULL),
	1 == eq_s(s11),
	1 == eq_s(s11,s11),
	1 == eq_s(NULL, NULL),
	0 == eq_s(s11,s22),
	1 == eq_s(s11,s11, "msg"),
	0 == eq_s(s11,s22, "msg------"),
	};
	//HCUT_each(i, tbsl){ HCUT_pi(i); HCUT_CK(tbsl[i] ); }
	HCUT_each(i, tbsl){ HCUT_CK(tbsl[i] ); }
	//
	fputs("--pass hcut suc/fail api test\n", stderr);
	int b = HCUT_cmn.suc;
	eq_i(b<0);
	return;
	//-----------
	//-----------
	//-----------
	
	int i0=0, i1=11, i2=22;
	double d0=0.0, d1=11.1, d2=22.1, d00=0.1;
	void*  p0=NULL, *p1=(void*)"a", *p2=(void*)"b";
	const char*  s0=NULL
	, *s1 = "12345678901234567890"
	, *s2 = "_2345678901234567890"
	;
	//val: int,double,ptr
	//ag0
//	int t0[] = { eq(), eq_i(), eq_d(), eq_p(), eq_s(), };
//	int t0r[] = { 0, 0, 0, 0, 0, };
//	HCUT_CK( HCUT_cmn.suc == 0 );
//	HCUT_each(i, t0){ HCUT_CK( t0[i]==t0r[i] ); }
//	puts("-- pass: ag0\n");
	;
	//ag1
	int t1b[] = {
	eq(i0), eq(i1), eq(i2), 
	eq(d0), eq(d1), eq(d2), eq(d00),
	eq(p0), eq(p1), eq(p2),  
	eq(s0), eq(s1), eq(s2),
	};
	int t1br[] = {
	0,1,1,
	0,1,1,1,
	0,1,1,
	0,1,1,
	};
	HCUT_each(i, t1b){ HCUT_CK( t1b[i]==t1br[i] ); }
	HCUT_CK( HCUT_cmn.suc == 9 );
	puts("pass: eq(x) suc/fail test\n");
	;
	int t1i[] = {
	eq_i(i0), eq_i(i1), eq_i(i2), 
	eq_i(d0), eq_i(d1), eq_i(d2), eq_i(d00),
	eq_i(p0), eq_i(p1), eq_i(p2),  
	eq_i(s0), eq_i(s1), eq_i(s2),
	};
	HCUT_each(i, t1i){ HCUT_CK( t1i[i]==t1br[i] ); }
	puts("pass: eq_i(x) suc/fail test\n");
	;
	double t1d[] = {
	eq_d(i0), eq_d(i1), eq_d(i2), 
	eq_d(d0), eq_d(d1), eq_d(d2), eq_d(d00),
	eq_d(p0), eq_d(p1), eq_d(p2),  
	eq_d(s0), eq_d(s1), eq_d(s2),
	};
	HCUT_each(i, t1d){ HCUT_CK( t1d[i]==t1br[i] ); }
	puts("pass: eq_d(x) suc/fail test\n");
	;
	double t1p[] = {
	eq_p(i0), eq_p(i1), eq_p(i2), 
	eq_p(d0), eq_p(d1), eq_p(d2), eq_p(d00),
	eq_p(p0), eq_p(p1), eq_p(p2),  
	eq_p(s0), eq_p(s1), eq_p(s2),
	};
	HCUT_each(i, t1p){ HCUT_CK( t1p[i]==t1br[i] ); }
	puts("pass: eq_p(x) suc/fail test\n");
	;
	double t1s[] = {
	eq_s(i0), eq_s(i1), eq_s(i2), 
	eq_s(d0), eq_s(d1), eq_s(d2), eq_s(d00),
	eq_s(p0), eq_s(p1), eq_s(p2),  
	eq_s(s0), eq_s(s1), eq_s(s2),
	};
	HCUT_each(i, t1s){ HCUT_CK( t1s[i]==t1br[i] ); }
	puts("pass: eq_s(x) suc/fail test\n");
	puts("-- pass: ag1\n");
	
	//ag2
	int t2b[] = {
		eq(i0, NULL), eq(i0, s1), eq(i1, s1), eq(d1, s1), 	eq(p1, s1), eq(s1, NULL),
	};
	int t2br[] = { 0,0,1,1,1,1, };
	HCUT_each(i, t2b){ HCUT_CK( t2b[i]==t2br[i] ); }
	puts("pass: eq(x,y) suc/fail test\n");
	;
	int t2i[] = {
		//NULL
		eq_i(NULL, NULL), eq_i(NULL, i0), eq_i(NULL, i1), eq_i(NULL, i2),
		eq_i(NULL, d0), eq_i(NULL, d00), eq_i(NULL, d1), eq_i(NULL, d2),
		eq_i(NULL, p0), eq_i(NULL, p1), eq_i(NULL, p2),
		eq_i(NULL, s0), eq_i(NULL, s1), eq_i(NULL, s2),
		//i0
		eq_i(i0, NULL), eq_i(i0, i0), eq_i(i0, i1), eq_i(i0, i2),
		eq_i(i0, d0),   eq_i(i0, d00),eq_i(i0, d1), eq_i(i0, d2),
		eq_i(i0, p0),   eq_i(i0, p1), eq_i(i0, p2),
		eq_i(i0, s0),   eq_i(i0, s1), eq_i(i0, s2),
		//i1
		eq_i(i1, NULL), eq_i(i1, i0), eq_i(i1, i1), eq_i(i1, i2),
		eq_i(i1, d0),   eq_i(i1, d00),eq_i(i1, d1), eq_i(i1, d2),
		eq_i(i1, p0),   eq_i(i1, p1), eq_i(i1, p2),
		eq_i(i1, s0),   eq_i(i1, s1), eq_i(i1, s2),
		//i2
		eq_i(i2, NULL), eq_i(i2, i0), eq_i(i2, i1), eq_i(i2, i2),
		eq_i(i2, d0),   eq_i(i2, d00),eq_i(i2, d1), eq_i(i2, d2),
		eq_i(i2, p0),   eq_i(i2, p1), eq_i(i2, p2),
		eq_i(i2, s0),   eq_i(i2, s1), eq_i(i2, s2),
		//d0
		eq_i(d0, NULL), eq_i(d0, i0), eq_i(d0, i1), eq_i(d0, i2),
		eq_i(d0, d0),   eq_i(d0, d00),eq_i(d0, d1), eq_i(d0, d2),
		eq_i(d0, p0),   eq_i(d0, p1), eq_i(d0, p2),
		eq_i(d0, s0),   eq_i(d0, s1), eq_i(d0, s2),
		//d1
		eq_i(d1, NULL), eq_i(d1, i0), eq_i(d1, i1), eq_i(d1, i2),
		eq_i(d1, d0),   eq_i(d1, d00),eq_i(d1, d1), eq_i(d1, d2),
		eq_i(d1, p0),   eq_i(d1, p1), eq_i(d1, p2),
		eq_i(d1, s0),   eq_i(d1, s1), eq_i(d1, s2),
		//d2
		eq_i(d2, NULL), eq_i(d2, i0), eq_i(d2, i1), eq_i(d2, i2),
		eq_i(d2, d0),   eq_i(d2, d00),eq_i(d2, d1), eq_i(d2, d2),
		eq_i(d2, p0),   eq_i(d2, p1), eq_i(d2, p2),
		eq_i(d2, s0),   eq_i(d2, s1), eq_i(d2, s2),
		//p0
		eq_i(p0, NULL), eq_i(p0, i0), eq_i(p0, i1), eq_i(p0, i2),
		eq_i(p0, d0),   eq_i(p0, d00),eq_i(p0, d1), eq_i(p0, d2),
		eq_i(p0, p0),   eq_i(p0, p1), eq_i(p0, p2),
		eq_i(p0, s0),   eq_i(p0, s1), eq_i(p0, s2),
		//p1
		eq_i(p1, NULL), eq_i(p1, i0), eq_i(p1, i1), eq_i(p1, i2),
		eq_i(p1, d0),   eq_i(p1, d00),eq_i(p1, d1), eq_i(p1, d2),
		eq_i(p1, p0),   eq_i(p1, p1), eq_i(p1, p2),
		eq_i(p1, s0),   eq_i(p1, s1), eq_i(p1, s2),
		//p2
		eq_i(p2, NULL), eq_i(p2, i0), eq_i(p2, i1), eq_i(p2, i2),
		eq_i(p2, d0),   eq_i(p2, d00),eq_i(p2, d1), eq_i(p2, d2),
		eq_i(p2, p0),   eq_i(p2, p1), eq_i(p2, p2),
		eq_i(p2, s0),   eq_i(p2, s1), eq_i(p2, s2),
		//s0
		eq_i(s0, NULL), eq_i(s0, i0), eq_i(s0, i1), eq_i(s0, i2),
		eq_i(s0, d0),   eq_i(s0, d00),eq_i(s0, d1), eq_i(s0, d2),
		eq_i(s0, p0),   eq_i(s0, p1), eq_i(s0, p2),
		eq_i(s0, s0),   eq_i(s0, s1), eq_i(s0, s2),
		//s1
		eq_i(s1, NULL), eq_i(s1, i0), eq_i(s1, i1), eq_i(s1, i2),
		eq_i(s1, d0),   eq_i(s1, d00),eq_i(s1, d1), eq_i(s1, d2),
		eq_i(s1, p0),   eq_i(s1, p1), eq_i(s1, p2),
		eq_i(s1, s0),   eq_i(s1, s1), eq_i(s1, s2),
		//s2
		eq_i(s2, NULL), eq_i(s2, i0), eq_i(s2, i1), eq_i(s2, i2),
		eq_i(s2, d0),   eq_i(s2, d00),eq_i(s2, d1), eq_i(s2, d2),
		eq_i(s2, p0),   eq_i(s2, p1), eq_i(s2, p2),
		eq_i(s2, s0),   eq_i(s2, s1), eq_i(s2, s2),
	};
	int t2ir[] = {
	1,1,0,0,	1,1,0,0,	1,0,0,	1,0,0,	//NULL
	1,1,0,0,	1,1,0,0,	1,0,0,	1,0,0,	//i0
	0,0,1,0,	0,0,1,0,	0,0,0,	0,0,0,	//i1
	0,0,0,1,	0,0,0,1,	0,0,0,	0,0,0,	//i2
	
	1,1,0,0,	1,1,0,0,	1,0,0,	1,0,0,	//d0
	0,0,1,0,	0,0,1,0,	0,0,0,	0,0,0,	//d1
	0,0,0,1,	0,0,0,1,	0,0,0,	0,0,0,	//d2
	
	1,1,0,0,	1,1,0,0,	1,0,0,	1,0,0,	//p0
	0,0,0,0,	0,0,0,0,	0,1,0,	0,0,0,	//p1
	0,0,0,0,	0,0,0,0,	0,0,1,	0,0,0,	//p2 140
	
	1,1,0,0,	1,1,0,0,	1,0,0,	1,0,0,	//s0
	0,0,0,0,	0,0,0,0,	0,0,0,	0,1,0,	//s1
	0,0,0,0,	0,0,0,0,	0,0,0,	0,0,1,	//s2
	};
	//HCUT_each(i, t2i){ HCUT_pi(i); HCUT_CK( t2i[i]==t2ir[i] ); }
	HCUT_each(i, t2i){ HCUT_CK( t2i[i]==t2ir[i] ); }
	puts("pass: eq_i(x,y) suc/fail test\n");
	;
}
#endif

/*SH_SMP
#include <stdio.h>
#include "*SH_bn*.h"

int hw() {
	puts("hw");
	return 0;
}

// expand to "void t_hw(int argc, char** argv){...}"
 HCUT_ADD(t_hw) {
	int ck = 123;
	eq(hw() == 0 );
	eq(hw() == ck, "cmt if last arg(void*) is exist" );
}

int gw() {
	puts("gw");
	return 0;
}
 HCUT_ADD(test_gw12345) {
	//assert type: cmp, int, dbl, str, ptr
	eq(10==2, "all asserts support lastarg cmt");
	eq_i( gw(), 3);
	eq_d(1.01, 666);
	eq_s("aaa", "bbb");
	eq_p("aaa", NULL, "my_cmt");

	puts("my_test_end?");
}

 HCUT_RUN("stderr", 2, t_hw, test_gw12345 )

// HCUT_RUN() holds "int main(int argc, char** argv){..}" and returns fail cnt.
// ag1 : msgout filename. "stdout","stderr","NULL" are used as FILE* or noout.
// ag2 : verbose lv. 0/1/2/3 ... quiet/normal/verbose/verbose + stop if err
// ag3-: test all suite you set here.  (use ~$ sed -ne '/^HCUT/{=;p}' test.c)
// rtn/exit status: cnt of failed assert. rtn -1 if fatal err.
//SH_SMPE*/

#ifdef TEST

#ifndef TLV
	#define TLV	1
#endif /**/
HCUT_RUN("stderr", TLV /* lv 0,1,2,3 */,	/* keep newline. use for SH sed edit, -t test.*/
         t_hcut);
#endif

/*
 change log
 --
2022-06-28	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*(api): fix __VA_ARGS__ macro for c99
	
	* *SH_bn*(logfile): allow stdout/stderr FILE* ptr, change to void*

2022-06-21	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*(all): omit ag0 eq_i() etc.

2022-06-19	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*(all): rewrite. allow eqX(ac0-3), (stmt) >> (expr) all assertss.

2022-05-17	Momi-g	<dmy@dmy.dmy>

	* (assert_eqs): fix ag1/ag2 NULL input == SEGV >> safe

2022-05-16	Momi-g	<dmy@dmy.dmy>

	* (eq asserts): fix/add block,  eq_i_mcr(1+2, 2) >> eq_i_mcr( (1+2), (2) )

2021-11-30	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.c(HCUT_RUN): add lv==3, stop if fail. v1.3.0
	* (HCUT..._BACK): add macro for lv==3 stop
	* (eq asserts): change macro expr >> statement for lv==3

2021-07-10	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.c(HCUT_RUN): add *p=NULL, stop valgrind mem warning

2021-07-06	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.c(HCUT_RUN): return 1 >> -1 if apierr

2021-06-26	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.c(eq_p): change cast (void*) >> (char*) for allow ptr+1

2021-06-14	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.c(macros): change mc, ERRact >> HCUT_Eact

2021-06-09	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.c(macros): fix c99 -pedantic, __VA_ARGS__, out of standard syntax

2021-02-18	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.c(HCUT_RUN): debug, add fclose()

	* hcut.sh.c(eq): rewrite. use cmn macro _SAME logic

	* hcut.sh.c(*SH_bn*): change output .hpp >> .h

2021-02-18	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.c(assert_eq_SAME): debug, add va_end() at macro end

2021-01-19	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.c(eq_i,d,p): fix macro, (a,b)	>> ( (int)a,(int)b ) etc

2020-10-28	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.c: v1.2.2 release
	* hcut.sh.c(*SH_bn*): rename srcfile name, header suffix .cc -> .hpp
	* (brp.sh): add Rh="$bn.hpp", change .cc to .hpp

2020-10-25	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.cc(assert_eqs): debug rc strcmp() >> (strcmp==0)
	change eqs args type void* >> const char*

2020-10-19	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.cc: support cmdline data (argc, argv) at HCUT_ADD() codeblock
	* (doc): fix doc.

2020-06-30	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.cc: v1.1.0 rewrite.

2020-02-02	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.cc: v1.0.2 releases.

	* hcut.sh.cc (#define ast): change API stirng, ast->eq.
	* hcut.sh.cc (@sh-opt): fix Doc.

2020-1-11	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.cc (@sh-opt): fix Doc.

2019-11-3	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.cc: v1.0.1 releases.

	* hcut.sh.cc: (@sh-opt): build opt -b add. fix Doc.

2019-10-15	Momi-g	<dmy@dmy.dmy>

	* hcut.sh.cc: v1.0.0 releases.

*/
/*SH_ED*/

/*SH_OP _ set -e;a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e	#*/
/*SH_OP	h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout		GPLv3+"	 #*/
/*SH_OP	f sed -ne "/${C}DF/q;/;/d;/^[a-zA-Z].*)/p"<$R0 #*/
/*SH_OP t $e"$CW";ftt "$@";$p'cc -O0 $dm -Wall -pedantic -Wfatal-errors -g -pg -ggdb3 $Rm `fOI $Rs $tf` `fg $Rs $tf` `fL`'|fv	#*/
/*SH_OP T $e"$CW";ftt "$@";$p'cc -O3 $dm $Rm `fOI $Rs $tf ` `fg $Rs $tf ` `fL`'|fv	#*/
/*SH_OP s fgr0 "${C}SMP" "${C}SMPE"<$R0|fbn>eg.c;$p'cc eg.c `fg eg.c` `fOI eg.c`'|fv #*/

/*SH_OP L $p"fml $@"|fv #*/
/*SH_OP M $p"fM ./a.out"|fv	 #*/
/*SH_OP P $p'valgrind --tool=callgrind --callgrind-out-file=log.out ./a.out;kcachegrind log.out'|fv	 #*/

/*SH_OP b $e"$CW";$p'cc -c $Rs -pedantic -O2 -Wall -g `fg $Rs` `fI $Rs`'|fv;$p"$bn.o" #*/
/*SH_OP B $e"$Cb";$p"ar -r lib$bn.a $bn.o `fO $Rs`"|fv;$p"lib$bn.a"	#*/
/*SH_OP A $e"$CB";$p'fA lib$bn.a `fg $Rh $Rs|fu|grep '[.]a$'|fU`'|fv;$p"lib$bn.a" #*/
/*SH_OP S $e"$CW";$p"cc -shared -fPIC -o lib$bn.so $bn.c `fOI $Rs` `fg $Rs`"|fv;$p"lib$bn.so" #*/
/*SH_OP W $e"$Cm$O$Cw">/dev/null;fborn;$p"$Rs $Rh $tf"	#*/
/*SH_OP o $e"$CW";$p'fman $Rh 3'|fv		#*/

/*SH_OP y cp $Rs $bn.cbrt;$p"cbrt $bn.cbrt --c $Rs --h cbft.h"|fv	#*/
/*SH_OP Y $e"$Cm$O$Cw">/dev/null;$e"$Cy";fborn;$p"$Rs $Rh $tf"		#*/

/*SH_DF
#-- noob
fman()( $p"cat $1|sed -e '/${C}docE/q'|fgr0 '${C}doc' '${C}docE'|amn >$bn.$2
 mandoc -Thtml <$bn.$2 >$bn.$2.html
 man -Tutf8 /dev/stdin<$bn.$2|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt
 "|fv
)

#-- local

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frf|frv|flit)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()($e\$p`sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"`|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

# fO src.o from inc"src.abc" etc. kick self
fO()(set -- `fdp "$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
	buf="";for i;do test -f $i&&buf="$buf $i";done;$p"$buf"
)
fI()(fdp "$@"|sed -e 's/[^/]*$//g'|fu|sed -e '/./s/^/ -I/g'|fu|grep -v '^\-I$'|fU)
fL()(find -L `dirname $R0` -type d|sed -e 's/^/-L/g'|fU)
# inc""系.h,hpp,oをパス付きで羅列 OIはfdpが重複するので高速化でまとめる 複数file_ok
fOI()(
set -- `fdp "$@"`
s="-I./ "`$p"$@"|sed -e 's/[^/]*$//g'|fu|sed -e 's/^/ -I/g'|fu|grep -v '^\-I$'|fU`
set -- `$p"$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
buf="";for i;do test -f $i&&buf="$buf $i";done;
$p"$buf $s"
)

# 依存inc""を再帰的に取得./以下全て self系はkick
fdp()( l="$*"; paths="$@"; all=""; used=""
 while :;do
	all=`$p$all $paths|fU`	#差分を追加 repの始末 差分たちからaaa.hを取得 partial path
	buf=`(cat $paths|sed -ne 's@^[ \t]*#inc[^"]*.\([a-zA-Z0-9._]*\)".*@\1@p')|sort -u`
	ch=`$p$used $buf|tr -s ' ' '\n'|sort|uniq -u`	#使用済は外す
	used="$used $ch"	#リスト更新
	paths=`fsvy $ch|sort -u`	#ls検索 name系のみのはず
	buf=`$p"$all" "$paths"|fU`	#増えたらloop
	[ ${#all} = ${#buf} ]&&break
 done
# initを除く
 set -- $all
 for i;do a=${i##*[/]}; a=${a%%.*};[ "${l##*$a*}" = "$l" ]&&set -- "$@" $i;shift;done
 $p"$@"
)

# corecode:search + depthck + uniq
fsvy()(c="find -L ./ -false"
	for i; do c="$c -o -path '*'$i";done; l=`$e"$c"`
	for i; do $p"$l"|grep -F "$i"|awk '{sv=$0;print gsub("[/]","") " " sv}'|
	sort -k 1.1,1n -k 2.2,2|awk '{print $2;exit}'; done
)

# libをまとめる
fA()(n=0;dir=`dirname $0`/tmpdir;mkdir $dir;cd $dir;
 for i;do
 	n=$((n+1))
 	cp ../$i $i
 	ar -x $i
 	for ii in *.o;do mv "$ii" "p${n}_$ii";done
 	ar -r lib$bn.aa *.o
 	rm *.o
 done
 $p'mv lib$bn.aa ../lib$bn.a'|fv
 cd ..;rm -r $dir
)

#-- yacc
fy(){
set -e
cat<<'EEE'|fv
fgr0 "${C}YACC" "${C}YACCE"<$Rs|fbn>myyacc.y
fgr0 "${C}LEX" "${C}LEXE"<$Rs|fbn>mylex.l
fgR "${C}YACC" "${C}YACCE"<$Rs>$Rm
fgR "${C}LEX" "${C}LEXE"<$Rm>$Rs

lex mylex.l
#bison -Wnone -Wall -Wno-empty-rule -p zz -dv myyacc.y 
# bisonはy.tab.c固定名ではなくsrc.tab.c/hを吐く 標準に戻す
bison -Wnone -Wall -Wno-empty-rule -dv myyacc.y --defines=y.tab.h -o y.tab.c

cat $Rh y.tab.c lex.yy.c > $Rs
$p"$Rs"
EEE
}

#-- longcmd
frf()(
 # *sh_rf* 0 a.txt b.txt ...でcat纏めて出力 top0でsrcinfoは無し出力
 awk -v tg="${C##*]}rf" 'index($0,tg){
 s=substr($0, index($0,tg)+length(tg)+1);split(s, a)
 m="[ -f \"%s\" ]&&(echo \"/*--copyfrom %s*\"/;cat \"%s\";echo \"/*--copyend %s*\"/)"
 mm="[ -f \"%s\" ]&&(_=\"%s\"/;cat \"%s\";_=\"%s\")"
 for(i=1;i in a;i++){v=a[i];if(v==0){m=mm;continue};system(sprintf(m,v,v,v,v)) }
 next
 }
 {print}'
)
frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")
flit()(sed -ne "/${C}lit/bl;p;d;:l;n;/${C}litE/d;"'s/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g;p;bl')


fml()(
 # --show-leak-kinds=definite,indirect(inner ref),possible,reachable(doesnt p=NULL)
 #cmd="valgrind --leak-check=full --show-leak-kinds=all --track-origins=yes --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"
 cmd="valgrind --leak-check=full --show-leak-kinds=definite,possible --track-origins=no --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"
 test $# = 0 && $p"$cmd"|fv && return
 set -- " " "$@"
 $e"$Ct"
 test $? = 0 && $p"$cmd"|fv
)

ftm(){
 awk -v w="$1" '
 /^HCUT_ADD/ && index($0,"("w")")==0 {
	while(match($0,"^#endif$") ==0 ){getline}
	print $0; next
 }
 {print $0}'
}

fte()(
 cat > $Rm-
 cmd="cat"
 [ $# != 0 ] && cmd='ftm $b'
 a="`sed -ne 's@^HCUT_ADD(\([^)]*\).*@\1, @p' $Rm-|tr -d '\n'`NULL"
 if [ $# != 0 ];then	a=""; for i;do a="$a $i,";done; a="$a NULL"; fi
 b=`$p"$a"|tr ',' ' '`
 sed -ne "p;/_RUN/b l;d;:l;/[)]/{c \\$O $a)$O p;d};n;b l" $Rm-|$e"$cmd"|
 fgr0 "^#ifdef TEST" '^#endif$'
 rm $Rm-
)

ftt(){
 [ $# != 0 ] && [ "${1#[0123]}" = "" ]&&dm="-DVLV=$1"&&shift
 (cat $Rs;fte "$@"<$tf)>$Rm
}
fborn(){
 fgr "^#ifdef TEST" "^#endif$"<$R0|fbn>$tf
 fgR "^#ifdef TEST_" "^#endif$"<$tf |fte>tests.code
 fgR "^#ifdef TEST" "^#endif$"<$Rs|fbn>$Rm;mv $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh
}
fM()(
 valgrind -q --tool=massif --massif-out-file=./vmem.buf --stacks=yes --trace-children=yes $1>/dev/null
 ms_print ./vmem.buf|sed -ne '/[KMG]B/bl;d;:l;/snap/q;p;n;bl';rm ./vmem.buf)

/*SH_DE*/
