<?php
/**
 * PHPUnit test case for TableDefinitionDao
 * 
 * The method skeletons below need to be filled in with 
 * real data so that the tests will run correctly. Replace 
 * all EXPECTED_VAL and PARAM strings with real data. 
 * 
 * Created with PHPUnit_Skeleton on 2006-05-29
 */
require_once 'PHPUnit.php';
class TableDefinitionDaoTest extends PHPUnit_TestCase {

    var $TableDefinitionDao;

    function TableDefinitionDaoTest($name = false)
    {
        $this->PHPUnit_TestCase($name);
    }

    function setUp()
    {
        require_once '../peewee.config.php';
        require_once ROOT_DIR . 'dao/TableDefinitionDao.php';
		require_once ADODB_INC_PATH;
        $this->TableDefinitionDao =& new TableDefinitionDao(PEEWEE_DSN);
    }

    function tearDown()
    {
        unset($this->TableDefinitionDao);
    }

    function testgetColumnList()
    {
        $result   = $this->TableDefinitionDao->getColumnList("user");
		$this->assertEquals($result["ID"], "id");
		$this->assertEquals($result["NAME"], "name");
		$this->assertEquals($result["AGE"], "age");
		$this->assertEquals($result["CREATEDATE"], "createdate");
		$this->assertEquals($result["EDITDATE"], "editdate");
    }
    function testgetTableNameList()
    {
        $result   = $this->TableDefinitionDao->getTableNameList();
		$this->assertEquals($result[0], "multi_primarykey");
		$this->assertEquals($result[1], "user");
    }

    function testgetPrimaryKeyList()
    {
        $result   = $this->TableDefinitionDao->getPrimaryKeyList("user");
		$this->assertEquals($result[0], "id");
    }
}
?>
