<?php

/**
 * BaseDaoGenerator
 *
 * <code>
 * $a = new BaseDaoGenerator("adodb-path", "your dsn definition");
 * $a->createBaseDaoClass(...);
 * </code>
 *
 * @package    peewee.logic
 * @author     rds <tk@rasign.jp>
 * @license    http://www.opensource.org/licenses/bsd-license.php  BSD License
 * @version    Release: 0.0.1
 * @link       http://rasign.jp/peewee/
 */
class BaseDaoGenerator{
    /**
     * @var    String
     * @access private
     */
    var $adodbIncPath = null;

    /**
     * @var    String
     * @access private
     */
    var $dsn = null;

    /**
     * default constructor
     *
     * @param $adodbIncPath Adodb Include Path
     * @param $dsn DataSourceName
     * @access public
     */
    function BaseDaoGenerator($adodbIncPath, $dsn){
        $this->adodbIncPath = $adodbIncPath;
        $this->dsn = $dsn;
    }

    /**
     * generate data access object - base class
     *
     * @param  String $tableName tablename
     * @return String basedaosourcecode
     * @access public
     */
    function createBaseDaoClass(){
        $baseDao = null;
        $baseDao= <<< BASEDAO_END

require_once "{$this->adodbIncPath}";

/**
 * BaseDao Class
 *
 * @package
 * @author
 * @license
 * @version
 */
class BaseDao{
    /**
     * default constructor
     *
     * @access public
     */
    function BaseDao(){}


    /**
     * get database connection
     *
     * @access public
     */
    function getConnection(){
        return ADONewConnection("{$this->dsn}");
    }
}
BASEDAO_END;

        return $baseDao;
    }
}
?>