<?php
/**
 * PHPUnit test case for BaseDaoGenerator
 * 
 * The method skeletons below need to be filled in with 
 * real data so that the tests will run correctly. Replace 
 * all EXPECTED_VAL and PARAM strings with real data. 
 * 
 * Created with PHPUnit_Skeleton on 2006-05-29
 */
require_once 'PHPUnit.php';
class BaseDaoGeneratorTest extends PHPUnit_TestCase {

    var $BaseDaoGenerator;

    function BaseDaoGeneratorTest($name = false)
    {
        $this->PHPUnit_TestCase($name);
    }

    function setUp()
    {
        require_once '../peewee.config.php';
        require_once 'BaseDaoGenerator.php';
        $this->BaseDaoGenerator =& new BaseDaoGenerator(ADODB_INC_PATH, DSN);
    }

    function tearDown()
    {
        unset($this->BaseDaoGenerator);
    }

    function testcreateBaseDaoClass()
    {
        $result   = $this->BaseDaoGenerator->createBaseDaoClass();
		$this->assertFalse(stristr($result, "<?"));
		$this->assertFalse(stristr($result, "?>"));
    }

    function testOutputClassDefinition()
    {
        $result   = $this->BaseDaoGenerator->createBaseDaoClass();
		$this->assertTrue(stristr($result, "class BaseDao"));
    }

    function testOutputConstructor()
    {
        $result   = $this->BaseDaoGenerator->createBaseDaoClass();
		$this->assertTrue(stristr($result, "function BaseDao()"));
    }

    function testOutputGetConnection()
    {
        $result   = $this->BaseDaoGenerator->createBaseDaoClass();
		$this->assertTrue(stristr($result, "function getConnection()"));
    }


}
// Running the test.
//$suite  = new PHPUnit_TestSuite('BaseDaoGeneratorTest');
//$result = PHPUnit::run($suite);
//echo $result->toHtml();
?>
