<?php
/**
 * PHPUnit test case for DaoGenerator
 * 
 * The method skeletons below need to be filled in with 
 * real data so that the tests will run correctly. Replace 
 * all EXPECTED_VAL and PARAM strings with real data. 
 * 
 * Created with PHPUnit_Skeleton on 2006-05-29
 */
require_once 'PHPUnit.php';
class CompositeKeySupportDaoGeneratorTest extends PHPUnit_TestCase {

    var $DaoGenerator;

    function CompositeKeySupportDaoGeneratorTest($name = false)
    {
        $this->PHPUnit_TestCase($name);
    }

    function setUp()
    {
        require_once '../peewee.config.php';
        require_once ROOT_DIR . 'logic/CompositeKeySupportDaoGenerator.php';
        require_once ROOT_DIR . 'util/StringUtility.php';
        $this->DaoGenerator =& new CompositeKeySupportDaoGenerator(ADODB_INC_PATH, DSN);
    }

    function tearDown()
    {
        unset($this->DaoGenerator);
    }

    function testcreateDao()
    {
        $result   = $this->DaoGenerator->createDao("table_name", array("col1", "col2"), array("col1"));
		$this->assertFalse(stristr($result, "<?"));
		$this->assertFalse(stristr($result, "?>"));
    }

    function testOutputRequire()
    {
        $result   = $this->DaoGenerator->createDao("table_name", array("col1", "col2"), array("col1"));
		$this->assertTrue(stristr($result, "require_once \"TableNameDto.php\";"));
    }

    function testOutputClassDefinition()
    {
        $result   = $this->DaoGenerator->createDao("table_name", array("col1", "col2"), array("col1"));
		$this->assertTrue(stristr($result, "class TableNameDao"));
    }

    function testOutputConstructor()
    {
        $result   = $this->DaoGenerator->createDao("table_name", array("col1", "col2"), array("col1"));
		$this->assertTrue(stristr($result, "function TableNameDao()"));
    }

    function testOutputGetConnection()
    {
        $result   = $this->DaoGenerator->createDao("table_name", array("col1", "col2"), array("col1"));
		$this->assertTrue(stristr($result, "function getConnection()"));
    }

    function testOutputFindByKey()
    {
        $result   = $this->DaoGenerator->createDao("table_name", array("col1", "col2"), array("col1"));
		$this->assertTrue(stristr($result, "function findByKey(\$tableNameDto)"));
    }

    function testOutputFind()
    {
        $result   = $this->DaoGenerator->createDao("table_name", array("col1", "col2"), array("col1"));
		$this->assertTrue(stristr($result, "function find()"));
    }

    function testOutputInsert()
    {
        $result   = $this->DaoGenerator->createDao("table_name", array("col1", "col2"), array("col1"));
		$this->assertTrue(stristr($result, "function insert(\$tableNameDto)"));
    }

    function testOutputUpdate()
    {
        $result   = $this->DaoGenerator->createDao("table_name", array("col1", "col2"), array("col1"));
		$this->assertTrue(stristr($result, "function update(\$tableNameDto)"));
    }

    function testOutputDelete()
    {
        $result   = $this->DaoGenerator->createDao("table_name", array("col1", "col2"), array("col1"));
		$this->assertTrue(stristr($result, "delete(\$tableNameDto)"));
    }

}
// Running the test.
//$suite  = new PHPUnit_TestSuite('DaoGeneratorTest');
//$result = PHPUnit::run($suite);
//echo $result->toHtml();
?>
