<?php

/**
 * DaoGenerator
 *
 * <code>
 * $a = new DaoGenerator("adodb-path", "your dsn definition");
 * $a->createDao(...);
 * </code>
 *
 * @package    peewee.logic
 * @author     rds <tk@rasign.jp>
 * @license    http://www.opensource.org/licenses/bsd-license.php  BSD License
 * @version    Release: 0.0.1
 * @link       http://rasign.jp/peewee/
 */
class DaoGenerator{
    /**
     * @var    String
     * @access private
     */
    var $adodbIncPath = null;

    /**
     * @var    String
     * @access private
     */
    var $dsn = null;

    /**
     * default constructor
     *
     * @param $adodbIncPath Adodb Include Path
     * @param $dsn DataSourceName
     * @access public
     */
    function DaoGenerator($adodbIncPath, $dsn){
        $this->adodbIncPath = $adodbIncPath;
        $this->dsn = $dsn;
    }

    /**
     * generate data access object class
     *
     * @param  String $tableName tablename
     * @return String daosourcecode
     * @access public
     */
    function createDao($tableName, $columnList, $primaryKey, $baseClassName = null){
        $stringUtility = new StringUtility();
        $tableClassName = $stringUtility->getClassName($tableName);
        $tableVariableName = $stringUtility->getVariableName($tableName);

        if(!empty($baseClassName)){
            $extends = "extends " . $baseClassName;
            $requireBase = "require_once \"./BaseDao.php\";";
        }

        $whereUnique = $primaryKey . " = {\$" . $primaryKey . "}";
        $whereDtoUnique = "\"" . $primaryKey . " = \" . \$" . $tableVariableName . "Dto->" . $primaryKey;
		$primaryKeyParameter = "\$" . $primaryKey;

        $selectBase = "select " . join(", ", $columnList) . " from {$tableName}";
        $select .= $selectBase . " where ";
        $select .= $whereUnique;
        $update = "update from $table set " . join(" =?,  ", $columnList) . " =? ";

        $connectionMethodAlgorithm = null;
        if (USE_BASE_CLASS) {
            $connectionMethodAlgorithm = "parent::getConnection();";
        } else {
            $connectionMethodAlgorithm = "ADONewConnection(\"{$this->dsn}\");";
        }

        $dao = null;

$dao= <<< DAO_END

require_once "{$this->adodbIncPath}";
require_once "{$tableClassName}Dto.php";
{$requireBase}

/**
 * {$tableName} DAO Class
 *
 * @package
 * @author
 * @license
 * @version
 */
class {$tableClassName}Dao {$extends}{
    /**
     * default constructor
     *
     * @access public
     */
    function {$tableClassName}Dao(){}


    /**
     * get database connection
     *
     * @access public
     */
    function getConnection(){
        return {$connectionMethodAlgorithm}
    }

    /**
     * get data by primary key
     *
     * @param Mix \$shopareaDto
     * @return  finddata
     * @access public
     */
    function getNextId(){
        \$connection = \$this->getConnection();
        \$recordSet = \$connection->Execute("select max({$primaryKey}) as maxid from {$tableName}");
        if(\$recordSet){
            return (\$recordSet->fields{"maxid"} + 1);
        }else{
            return 1;
        }
	}

    /**
     * get data by primary key
     *
     * @param Mix \${$tableVariableName}Dto
     * @return $result finddata
     * @access public
     */
    function findByKey({$primaryKeyParameter}){
        \$connection = \$this->getConnection();
		if(is_array({$primaryKeyParameter})){
			\$recordSet = \$connection->Execute("{$selectBase} where {$primaryKey} in (" . join(", ", {$primaryKeyParameter}) . ")");
		}else{
	        \$recordSet = \$connection->Execute("{$select}");
		}

        if(!\$recordSet){
            return null;
        }else{
            \$resultArray = array();
            while(!\$recordSet->EOF){
@recordset_to_dao@
                \$recordSet->MoveNext();
                \$resultArray[] = \${$tableVariableName}Dto;
            }
            return \$resultArray;
        }
    }

    /**
     * get all data
     *
     * @return $result finddata
     * @access public
     */
    function find(){
        \$connection = \$this->getConnection();
        \$recordSet = \$connection->Execute("{$selectBase}");
        if(!\$recordSet){
            return null;
        }else{
            \$resultArray = array();
            while(!\$recordSet->EOF){
                \${$tableVariableName}Dto = new {$tableClassName}Dto();
@recordset_to_dao@
                \$recordSet->MoveNext();
                \$resultArray[] = \${$tableVariableName}Dto;
            }
            return \$resultArray;
        }
    }

    /**
     * insert new records
     *
     * @param Mix \${$tableVariableName}Dto
     * @return result
     * @access public
     */
    function insert(\${$tableVariableName}Dto){
        \$connection = \$this->getConnection();
@insert_parameter@
        \$insertSQL = \$connection->AutoExecute({$tableName}, \$record, "INSERT"); 
        return \$insertSQL;
    }

    /**
     * update records
     *
     * @param Mix \${$tableVariableName}Dto
     * @return result
     * @return result rowcount
     * @access public
     */
    function update(\${$tableVariableName}Dto){
        \$connection = \$this->getConnection();
@update_parameter@
        \$insertSQL = \$connection->AutoExecute({$tableName}, \$record, "UPDATE", {$whereDtoUnique});
        return \$insertSQL;
    }

    /**
     * delete records
     *
     * @param Mix \${$tableVariableName}Dto
     * @return result rowcount
     * @access public
     */
    function delete({$primaryKeyParameter}){
        \$connection = \$this->getConnection();

		if(is_array({$primaryKeyParameter})){
			\$recordSet = \$connection->Execute("delete from {$tableName} where {$primaryKey} in (" . join(", ", {$primaryKeyParameter}) . ")");
		}else{
	        \$recordSet = \$connection->Execute("delete from {$tableName} where {$whereUnique}");
		}

        return \$connection->Affected_Rows();
    }
}
DAO_END;

        $updateParameter = "";
        foreach($columnList as $column){
            $updateParameter .= "        \$record[\"{$column}\"] = \${$tableVariableName}Dto->{$column};\n";
        }
        $insertParameter = "";
        foreach($columnList as $column){
			if($column == $primaryKey){
				$insertParameter .= "        if(empty(\${$tableVariableName}Dto->{$column})){\n";
	            $insertParameter .= "        	\$record[\"{$column}\"] = \$this->getNextId();\n";
				$insertParameter .= "        }else{\n";
	            $insertParameter .= "        	\$record[\"{$column}\"] = \${$tableVariableName}Dto->{$column};\n";
				$insertParameter .= "        }\n";
			}else{
	            $insertParameter .= "        \$record[\"{$column}\"] = \${$tableVariableName}Dto->{$column};\n";
			}
        }

        $dao = str_replace("@insert_parameter@", $insertParameter, $dao);
        $dao = str_replace("@update_parameter@", $updateParameter, $dao);

        $set = null;
        foreach($columnList as $column){
            $set .= "                \${$tableVariableName}Dto->{$column} = \$recordSet->fields{\"$column\"};\n";
        }
        $dao = str_replace("@recordset_to_dao@", $set, $dao);
        return $dao;
    }
}
?>