<?php
require_once ROOT_DIR . "util/StringUtility.php";

/**
 * DtoGenerator
 *
 * <code>
 * $a = new DtoGenerator();
 * $a->createDto(...);
 * </code>
 *
 * @package    peewee.logic
 * @author     rds <tk@rasign.jp>
 * @license    http://www.opensource.org/licenses/bsd-license.php  BSD License
 * @version    Release: 0.0.1
 * @link       http://rasign.jp/peewee/
 */
class DtoGenerator{
    /**
     * generate data transfer object class
     *
     * @param  String $tableName tablename
     * @return String dtosourcecode
     * @access public
     */
    function createDto($tableName, $columnList){
        $stringUtility = new StringUtility();
        $tableClassName = $stringUtility->getClassName($tableName);
        $columnArray = $columnList;

$dto= <<< DTO_END
/**
 * {$tableName} DTO Class
 *
 * @package
 * @author
 * @license
 * @version
 */
class {$tableClassName}Dto {$extends}{
    /**
     * default constructor
     *
     * @access public
     */
    function {$tableClassName}Dto(){}

@dto_variables@
}

DTO_END;
            $set = null;
            foreach($columnArray as $column){
                $set .= "    /**\n";
                $set .= "    * @var String\n";
                $set .= "    * @access public\n";
                $set .= "    */\n";
                $set .= "    var \${$column} = null;\n\n";
            }

            $dto = str_replace("@dto_variables@", $set, $dto);
            return $dto;
    }
}
?>