<?php
/**
 * PHPUnit test case for DtoGenerator
 * 
 * The method skeletons below need to be filled in with 
 * real data so that the tests will run correctly. Replace 
 * all EXPECTED_VAL and PARAM strings with real data. 
 * 
 * Created with PHPUnit_Skeleton on 2006-05-29
 */
require_once 'PHPUnit.php';
class DtoGeneratorTest extends PHPUnit_TestCase {

    var $DtoGenerator;

    function DtoGeneratorTest($name = false)
    {
        $this->PHPUnit_TestCase($name);
    }

    function setUp()
    {
        require_once '../peewee.config.php';
        require_once 'DtoGenerator.php';
        $this->DtoGenerator =& new DtoGenerator();
    }

    function tearDown()
    {
        unset($this->DtoGenerator);
    }

    function testcreateDto()
    {
        $result   = $this->DtoGenerator->createDto("table_name", array("col1", "col2"));
		$this->assertFalse(stristr($result, "<?"));
		$this->assertFalse(stristr($result, "?>"));
    }

    function testOutputClassDefinition()
    {
        $result   = $this->DtoGenerator->createDto("table_name", array("col1", "col2"));
		$this->assertTrue(stristr($result, "class TableNameDto"));
    }

    function testOutputConstructor()
    {
        $result   = $this->DtoGenerator->createDto("table_name", array("col1", "col2"));
		$this->assertTrue(stristr($result, "function TableNameDto(){}"));
    }

    function testOutputCol1()
    {
        $result   = $this->DtoGenerator->createDto("table_name", array("col1", "col2"));
		$this->assertTrue(stristr($result, "var \$col1 = null"));
    }

    function testOutputCol2()
    {
        $result   = $this->DtoGenerator->createDto("table_name", array("col1", "col2"));
		$this->assertTrue(stristr($result, "var \$col2 = null"));
    }
}
// Running the test.
//$suite  = new PHPUnit_TestSuite('DtoGeneratorTest');
//$result = PHPUnit::run($suite);
//echo $result->toHtml();
?>
