<?php
require_once ROOT_DIR . "util/StringUtility.php";

/**
 * GenerationGapDaoGenerator
 *
 * <code>
 * $a = new GenerationGapDaoGenerator("adodb-path", "your dsn definition");
 * $a->createGenerationGapDao(...);
 * </code>
 *
 * @package    peewee.logic
 * @author     rds <tk@rasign.jp>
 * @license    http://www.opensource.org/licenses/bsd-license.php  BSD License
 * @version    Release: 0.0.1
 * @link       http://rasign.jp/peewee/
 */
class GenerationGapDaoGenerator{
    /**
     * generate DAO Inheritance  class
     *
     * @param  String $tableName tablename
     * @return String gg dao sourcecode
     * @access public
     */
    function createGenerationGapDao($tableName, $generationGapSuffix){
        $stringUtility = new StringUtility();
        $tableClassName = $stringUtility->getClassName($tableName);
        if(empty($generationGapSuffix)){
            print "error";
            return;
        }
$dao= <<< DAO_END
require_once "{$tableClassName}Dao.php";

/**
 * {$tableName} DAO Inheritance  Class
 *
 * @package
 * @author
 * @license
 * @version
 */
class {$tableClassName}Dao{$generationGapSuffix} extends {$tableClassName}Dao{
    /**
     * default constructor
     *
     * @access public
     */
    function {$tableClassName}Dao{$generationGapSuffix}(){
        parent::{$tableClassName}Dao();
    }
}
DAO_END;
            return $dao;
    }
}
?>